/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESEnchantments;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.Comparator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ThrownBoomerang
extends AbstractArrow {
    private static final String TAG_DEALT_DAMAGE = "dealt_damage";
    private boolean dealtDamage;

    public ThrownBoomerang(EntityType<? extends ThrownBoomerang> type, Level level) {
        super(type, level);
    }

    public ThrownBoomerang(EntityType<? extends ThrownBoomerang> type, Level level, @Nullable LivingEntity owner, double x, double y, double z, ItemStack pickupItemStack) {
        super(type, x, y, z, level, pickupItemStack, pickupItemStack);
        this.setOwner((Entity)owner);
    }

    public void tick() {
        Entity owner = this.getOwner();
        if (this.inGroundTime > 4 || owner == null && this.tickCount > 40 || owner != null && this.distanceTo(owner) > 15.0f + owner.getBbWidth() / 2.0f) {
            this.dealtDamage = true;
        }
        if (!this.level().isClientSide && !this.dealtDamage) {
            float homing = 0.0f;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getWeaponItem() != null) {
                    homing = ESEnchantments.modifyBoomerangHomingStrength(serverLevel, this.getWeaponItem(), homing);
                }
            }
            homing = Mth.clamp((float)homing, (float)0.0f, (float)1.0f);
            Vec3 homingTarget = null;
            for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0)).stream().sorted(Comparator.comparingDouble(i -> i.distanceTo((Entity)this))).toList()) {
                if (!ESEntityUtil.shouldHarm(owner, (Entity)livingEntity)) continue;
                homingTarget = livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0);
                break;
            }
            if (homingTarget != null && homing > 0.0f && this.getDeltaMovement().normalize().dot(homingTarget.subtract(this.position()).normalize()) > 0.5) {
                this.setDeltaMovement(this.getDeltaMovement().normalize().scale((double)(1.0f - homing)).add(homingTarget.subtract(this.position()).normalize().scale((double)homing)).normalize().scale(this.getDeltaMovement().length()));
            }
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            float pickupRadius = 0.0f;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getWeaponItem() != null) {
                    pickupRadius = ESEnchantments.modifyBoomerangPickupRadius(serverLevel, this.getWeaponItem(), pickupRadius);
                }
            }
            if (pickupRadius > 0.0f) {
                for (ItemEntity itemEntity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)pickupRadius))) {
                    itemEntity.playerTouch(player);
                }
            }
        }
        if ((this.dealtDamage || this.isNoPhysics()) && owner != null) {
            this.inGround = false;
            if (!(owner instanceof Player) && !this.level().isClientSide) {
                this.discard();
            }
            if (!this.isAcceptableReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 diff = owner.getEyePosition().subtract(this.position());
                double speed = Math.max(this.getDeltaMovement().length(), 1.5);
                if (speed > diff.length()) {
                    speed = diff.length();
                }
                this.setDeltaMovement(diff.normalize().scale(speed));
            }
        }
        super.tick();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 vec3, Vec3 vec32) {
        return this.dealtDamage ? null : super.findHitEntity(vec3, vec32);
    }

    private double getItemDamage(double baseValue) {
        ItemStack weapon = this.getWeaponItem();
        if (weapon == null) {
            return baseValue;
        }
        double result = baseValue;
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)weapon.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (entry.attribute() != Attributes.ATTACK_DAMAGE) continue;
            double amount = entry.modifier().amount();
            result += (switch (entry.modifier().operation()) {
                case AttributeModifier.Operation.ADD_VALUE -> amount;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> amount * baseValue;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> amount * result;
                default -> throw new MatchException(null, null);
            });
        }
        return result;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        ServerLevel serverLevel;
        LivingEntity living;
        Entity entity = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        float damage = (float)this.getItemDamage(owner instanceof LivingEntity && (living = (LivingEntity)owner).getAttribute(Attributes.ATTACK_DAMAGE) != null ? (float)living.getAttributeBaseValue(Attributes.ATTACK_DAMAGE) : 1.0f);
        DamageSource damageSource = this.damageSources().thrown((Entity)this, this.getOwner());
        float critChance = 0.0f;
        boolean critSuccess = false;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.getWeaponItem() != null) {
                damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)damage);
                critChance = ESEnchantments.modifyBoomerangCritChance(serverLevel, this.getWeaponItem(), entity, damageSource, critChance);
            }
        }
        if (this.getRandom().nextFloat() < critChance) {
            damage *= 1.5f;
            critSuccess = true;
        }
        this.dealtDamage = true;
        if (entity.hurt(damageSource, damage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                DamageSource damageSource2;
                serverLevel = (ServerLevel)level;
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    damageSource2 = this.damageSources().playerAttack(player);
                } else {
                    entity2 = this.getOwner();
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity living2 = (LivingEntity)entity2;
                        damageSource2 = this.damageSources().mobAttack(living2);
                    } else {
                        damageSource2 = damageSource;
                    }
                }
                DamageSource directSource = damageSource2;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)directSource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
            }
            if (critSuccess && (level = this.getOwner()) instanceof Player) {
                Player player = (Player)level;
                player.crit(entity);
            }
        }
        this.playSound(SoundEvents.PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.PLAYER_ATTACK_CRIT;
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.dealtDamage = compoundTag.getBoolean(TAG_DEALT_DAMAGE);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_DEALT_DAMAGE, this.dealtDamage);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double d, double e, double f) {
        return true;
    }
}

