/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.entity.DuskLightReceptor;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDuskLightBlockEntity
extends class_2586
implements DuskLightReceptor {
    private static final String TAG_LENGTH = "length";
    private static final String TAG_LIT = "lit";
    public static final float MAX_LENGTH = 30.0f;
    protected int ticksLeft = 0;
    private boolean lit = false;
    private final Object2FloatMap<class_2350> lengths = new Object2FloatArrayMap();
    private final Object2FloatMap<class_2350> beamProgresses = new Object2FloatArrayMap();
    private final Object2FloatMap<class_2350> oldBeamProgresses = new Object2FloatArrayMap();
    protected boolean alwaysActivated = false;

    public AbstractDuskLightBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState) {
        super(type, blockPos, blockState);
    }

    public boolean isLit() {
        return this.lit;
    }

    public Object2FloatMap<class_2350> getBeamProgresses() {
        return this.beamProgresses;
    }

    public Object2FloatMap<class_2350> getOldBeamProgresses() {
        return this.oldBeamProgresses;
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        for (class_2350 direction : class_2350.values()) {
            compoundTag.method_10548("length_" + direction.method_10151(), this.lengths.getOrDefault((Object)direction, 0.0f));
        }
        compoundTag.method_10556(TAG_LIT, this.lit);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        for (class_2350 direction : class_2350.values()) {
            this.lengths.put((Object)direction, compoundTag.method_10583("length_" + direction.method_10151()));
        }
        this.lit = compoundTag.method_10577(TAG_LIT);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    protected abstract boolean isFaceActivated(class_2680 var1, class_2350 var2);

    @Override
    public void lightUp(class_1937 level, class_2338 pos, class_2350 sourceDir) {
        this.ticksLeft = 5;
    }

    public static boolean canPassThrough(class_2680 state) {
        if (state.method_26164(ESTags.Blocks.DUSK_LIGHT_ALWAYS_PASSABLE)) {
            return true;
        }
        if (state.method_26164(ESTags.Blocks.DUSK_LIGHT_ALWAYS_UNPASSABLE)) {
            return false;
        }
        return state.method_26204() instanceof class_2373;
    }

    public static boolean canDestroy(class_2680 state) {
        return state.method_26164(ESTags.Blocks.DUSK_LIGHT_DESTROYABLES);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AbstractDuskLightBlockEntity entity) {
        if (level.field_9236) {
            entity.oldBeamProgresses.clear();
            entity.oldBeamProgresses.putAll(entity.beamProgresses);
            for (class_2350 direction : class_2350.values()) {
                if (!entity.beamProgresses.containsKey((Object)direction)) {
                    entity.beamProgresses.put((Object)direction, 0.0f);
                }
                if (entity.isFaceActivated(state, direction) && entity.lit) {
                    entity.beamProgresses.put((Object)direction, class_3532.method_15363((float)(entity.beamProgresses.getFloat((Object)direction) + 0.3f), (float)0.0f, (float)(entity.lengths.getOrDefault((Object)direction, 0.0f) / 30.0f)));
                    EternalStarlight.getClientHelper().spawnManaCrystalItemParticles(ManaType.BLAZE, pos.method_46558().method_1019(new class_243((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165()).method_1021((double)entity.lengths.getOrDefault((Object)direction, 0.0f) + 0.5)));
                    continue;
                }
                entity.beamProgresses.put((Object)direction, class_3532.method_15363((float)(entity.beamProgresses.getFloat((Object)direction) - 0.3f), (float)0.0f, (float)1.0f));
            }
        } else {
            Object2FloatArrayMap oldLengths = new Object2FloatArrayMap(entity.lengths);
            boolean oldLit = entity.lit;
            if (entity.lit) {
                for (class_2350 direction : class_2350.values()) {
                    class_243 toPos;
                    if (!entity.isFaceActivated(state, direction)) continue;
                    class_243 fromPos = pos.method_46558().method_1019(new class_243((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165()).method_1021(0.51));
                    class_3965 result = level.method_17742(new class_3959(fromPos, toPos = fromPos.method_1019(new class_243((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165()).method_1021(30.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()){

                        public class_265 method_17748(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
                            return AbstractDuskLightBlockEntity.canPassThrough(blockState) ? class_259.method_1073() : super.method_17748(blockState, blockGetter, blockPos);
                        }
                    });
                    if (result.method_17783() != class_239.class_240.field_1333) {
                        entity.lengths.put((Object)direction, (float)result.method_17784().method_1020(fromPos).method_1033());
                        class_2586 class_25862 = level.method_8321(result.method_17777());
                        if (class_25862 instanceof DuskLightReceptor) {
                            DuskLightReceptor receptor = (DuskLightReceptor)class_25862;
                            receptor.lightUp(level, result.method_17777(), direction.method_10153());
                        }
                        if (AbstractDuskLightBlockEntity.canDestroy(level.method_8320(result.method_17777()))) {
                            level.method_22352(result.method_17777(), true);
                        }
                    } else {
                        entity.lengths.put((Object)direction, 30.0f);
                    }
                    List entities = level.method_18467(class_1297.class, new class_238(fromPos.method_1023(direction.method_10166() == class_2350.class_2351.field_11048 ? 0.0 : 0.25, direction.method_10166() == class_2350.class_2351.field_11052 ? 0.0 : 0.25, direction.method_10166() == class_2350.class_2351.field_11051 ? 0.0 : 0.25), fromPos.method_43206(direction, (double)entity.lengths.getOrDefault((Object)direction, 0.0f)).method_1031(direction.method_10166() == class_2350.class_2351.field_11048 ? 0.0 : 0.25, direction.method_10166() == class_2350.class_2351.field_11052 ? 0.0 : 0.25, direction.method_10166() == class_2350.class_2351.field_11051 ? 0.0 : 0.25)));
                    for (class_1297 e : entities) {
                        if (e instanceof class_1542) continue;
                        e.method_20803(Math.max(e.method_20802(), 100));
                    }
                }
            }
            if (entity.alwaysActivated) {
                entity.ticksLeft = 5;
            }
            --entity.ticksLeft;
            if (entity.ticksLeft < 0) {
                entity.ticksLeft = 0;
            }
            entity.lit = entity.ticksLeft > 0;
            boolean lengthsChanged = false;
            for (class_2350 direction : class_2350.values()) {
                if (!((double)Math.abs(entity.lengths.getOrDefault((Object)direction, 0.0f) - oldLengths.getOrDefault((Object)direction, 0.0f)) > 0.01)) continue;
                lengthsChanged = true;
                break;
            }
            if (lengthsChanged || oldLit != entity.lit) {
                entity.markUpdated();
            }
        }
    }

    public void markUpdated() {
        if (this.method_10997() != null) {
            this.method_5431();
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }
}

