/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book;

import cn.leolezury.eternalstarlight.common.client.book.component.ConfiguredBookComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public record BookDefinition(List<List<ConfiguredBookComponent<?, ?>>> components, int width, int height, int frameWidth, Buttons buttons, Scrollbar scrollbar, Textures textures) {
    public static final Codec<BookDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredBookComponent.CODEC.listOf().listOf().fieldOf("components").forGetter(BookDefinition::components), (App)Codec.INT.fieldOf("width").forGetter(BookDefinition::width), (App)Codec.INT.fieldOf("height").forGetter(BookDefinition::height), (App)Codec.INT.fieldOf("frame_width").forGetter(BookDefinition::frameWidth), (App)Buttons.CODEC.fieldOf("buttons").forGetter(BookDefinition::buttons), (App)Scrollbar.CODEC.fieldOf("scrollbar").forGetter(BookDefinition::scrollbar), (App)Textures.CODEC.fieldOf("textures").forGetter(BookDefinition::textures)).apply((Applicative)instance, BookDefinition::new));

    public Optional<ConfiguredBookComponent<?, ?>> getComponent(class_2960 id) {
        for (ConfiguredBookComponent component : this.components().stream().flatMap(Collection::stream).toList()) {
            if (!component.config().id().equals((Object)id)) continue;
            return Optional.of(component);
        }
        return Optional.empty();
    }

    public record Buttons(int upDownButtonWidth, int upDownButtonHeight, int upButtonOffset, int downButtonOffset, int upDownButtonDistanceFromRight, int leftRightButtonWidth, int leftRightButtonHeight, int leftButtonOffset, int rightButtonOffset, int leftRightButtonDistanceFromTop) {
        public static final Codec<Buttons> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("up_down_button_width").forGetter(Buttons::upDownButtonWidth), (App)Codec.INT.fieldOf("up_down_button_height").forGetter(Buttons::upDownButtonHeight), (App)Codec.INT.fieldOf("up_button_offset").forGetter(Buttons::upButtonOffset), (App)Codec.INT.fieldOf("down_button_offset").forGetter(Buttons::downButtonOffset), (App)Codec.INT.fieldOf("up_down_button_distance_from_right").forGetter(Buttons::upDownButtonDistanceFromRight), (App)Codec.INT.fieldOf("left_right_button_width").forGetter(Buttons::leftRightButtonWidth), (App)Codec.INT.fieldOf("left_right_button_height").forGetter(Buttons::leftRightButtonHeight), (App)Codec.INT.fieldOf("left_button_offset").forGetter(Buttons::leftButtonOffset), (App)Codec.INT.fieldOf("right_button_offset").forGetter(Buttons::rightButtonOffset), (App)Codec.INT.fieldOf("left_right_button_distance_from_top").forGetter(Buttons::leftRightButtonDistanceFromTop)).apply((Applicative)instance, Buttons::new));
    }

    public record Scrollbar(int scrollbarWidth, int scrollbarHeight, int scrollbarXOffset, int scrollbarYOffset, int scrollButtonWidth, int scrollButtonColor) {
        public static final Codec<Scrollbar> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("scrollbar_width").forGetter(Scrollbar::scrollbarWidth), (App)Codec.INT.fieldOf("scrollbar_height").forGetter(Scrollbar::scrollbarHeight), (App)Codec.INT.fieldOf("scrollbar_x_offset").forGetter(Scrollbar::scrollbarXOffset), (App)Codec.INT.fieldOf("scrollbar_y_offset").forGetter(Scrollbar::scrollbarYOffset), (App)Codec.INT.fieldOf("scroll_button_width").forGetter(Scrollbar::scrollButtonWidth), (App)Codec.INT.fieldOf("scroll_button_color").forGetter(Scrollbar::scrollButtonColor)).apply((Applicative)instance, Scrollbar::new));
    }

    public record Textures(class_2960 background, class_2960 overlay, class_2960 upButton, class_2960 downButton, class_2960 leftButton, class_2960 rightButton) {
        public static final Codec<Textures> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("background").forGetter(Textures::background), (App)class_2960.field_25139.fieldOf("overlay").forGetter(Textures::overlay), (App)class_2960.field_25139.fieldOf("up_button").forGetter(Textures::upButton), (App)class_2960.field_25139.fieldOf("down_button").forGetter(Textures::downButton), (App)class_2960.field_25139.fieldOf("left_button").forGetter(Textures::leftButton), (App)class_2960.field_25139.fieldOf("right_button").forGetter(Textures::rightButton)).apply((Applicative)instance, Textures::new));
    }
}

