/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import cn.leolezury.eternalstarlight.common.block.entity.StarfireBirdNestBlockEntity;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.entity.living.goal.RandomFlyGoal;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESPoiTypes;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_14;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4153;
import net.minecraft.class_4215;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class StarfireBird
extends class_1429
implements class_1432 {
    public static final String TAG_SPECIAL_VARIANT = "special_variant";
    private static final String TAG_NEST_POS = "nest_pos";
    private static final String TAG_STAY_OUT_OF_NEST_TICKS = "stay_out_of_nest_ticks";
    private static final String TAG_HAS_EGG = "has_egg";
    private static final String TAG_TRUSTED_PLAYERS = "trusted_players";
    private static final String TAG_GIFT_COUNT = "gift_count";
    private static final String TAG_GIFT_COOLDOWN = "gift_cooldown";
    protected static final class_2940<Boolean> SPECIAL_VARIANT = class_2945.method_12791(StarfireBird.class, (class_2941)class_2943.field_13323);
    private class_2338 nestPos = null;
    private int nestDestroyedTicks;
    private int stayOutOfNestTicks;
    private boolean hasEgg = false;
    private final List<UUID> trustedPlayers = Lists.newArrayList();
    private int giftCount;
    private int giftCooldown;
    private float oldFlapScale;
    private float flapScale;
    private boolean flying = true;
    private int flyingTicks;
    private int walkingTicks;
    public class_7094 idleAnimationState = new class_7094();
    public class_7094 nestIdleAnimationState = new class_7094();
    public class_7094 flapAnimationState = new class_7094();

    public boolean isSpecialVariant() {
        return (Boolean)this.method_5841().method_12789(SPECIAL_VARIANT);
    }

    public void setSpecialVariant(boolean specialVariant) {
        this.method_5841().method_12778(SPECIAL_VARIANT, (Object)specialVariant);
    }

    public void setNestPos(class_2338 nestPos) {
        this.nestPos = nestPos;
    }

    public boolean hasNest() {
        return this.nestPos != null;
    }

    public void setStayOutOfNestTicks(int stayOutOfNestTicks) {
        this.stayOutOfNestTicks = stayOutOfNestTicks;
    }

    public void setHasEgg(boolean hasEgg) {
        this.hasEgg = hasEgg;
    }

    public void addTrustedPlayer(UUID uuid) {
        if (uuid != null) {
            this.trustedPlayers.add(uuid);
        }
    }

    public void addGiftCount() {
        ++this.giftCount;
    }

    public float getFlapScale(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.oldFlapScale, (float)this.flapScale);
    }

    public StarfireBird(class_1299<? extends StarfireBird> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, -1.0f);
        this.switchMoveType(true);
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 pathNavigation = new class_1407(this, (class_1308)this, level){

            public boolean method_6333(class_2338 blockPos) {
                return this.field_6677.method_8320(blockPos).method_26215();
            }
        };
        pathNavigation.method_6332(false);
        pathNavigation.method_6354(true);
        pathNavigation.method_6331(true);
        return pathNavigation;
    }

    private void switchMoveType(boolean fly) {
        this.flyingTicks = 0;
        this.walkingTicks = 0;
        this.flying = fly;
        this.method_5875(fly);
        this.method_55695();
        if (fly) {
            this.field_6207 = new class_1331((class_1308)this, 20, true);
            this.field_6189 = this.method_5965(this.method_37908());
        } else {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = super.method_5965(this.method_37908());
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPECIAL_VARIANT, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new StarfireBirdBreedGoal());
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.0, stack -> stack.method_31573(ESTags.Items.STARFIRE_BIRD_FOOD), false));
        this.field_6201.method_6277(3, (class_1352)new StarfireBirdEnterNestGoal());
        this.field_6201.method_6277(4, (class_1352)new StarfireBirdGoToNestGoal());
        this.field_6201.method_6277(5, (class_1352)new StarfireBirdLandGoal());
        this.field_6201.method_6277(6, (class_1352)new StarfireBirdTakeOffGoal());
        this.field_6201.method_6277(7, (class_1352)new StarfireBirdGiftGoal());
        this.field_6201.method_6277(8, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(9, (class_1352)new RandomFlyGoal((class_1314)this){

            @Override
            public boolean method_6264() {
                return super.method_6264() && StarfireBird.this.flying;
            }

            @Override
            public boolean method_6266() {
                return super.method_6266() && StarfireBird.this.flying;
            }
        });
        this.field_6201.method_6277(10, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f){

            public boolean method_6264() {
                return super.method_6264() && !StarfireBird.this.flying;
            }

            public boolean method_6266() {
                return super.method_6266() && !StarfireBird.this.flying;
            }
        });
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.starfireBird.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.starfireBird.armor()).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23720, 0.75);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            class_3218 serverLevel;
            class_4153 poiManager;
            List<class_2338> availableNests;
            class_1937 class_19372;
            if (this.flying) {
                ++this.flyingTicks;
                this.walkingTicks = 0;
            } else {
                ++this.walkingTicks;
                this.flyingTicks = 0;
            }
            --this.giftCooldown;
            if (this.giftCooldown < 0) {
                this.giftCooldown = 0;
            }
            this.nestDestroyedTicks = !this.isNestValid() ? ++this.nestDestroyedTicks : 0;
            if (this.nestDestroyedTicks > 600) {
                this.nestPos = null;
            }
            if (this.nestPos == null && this.field_6012 % 20 == 0 && !this.method_6109() && (class_19372 = this.method_37908()) instanceof class_3218 && !(availableNests = (poiManager = (serverLevel = (class_3218)class_19372).method_19494()).method_30957(poi -> poi.method_40225(ESPoiTypes.STARFIRE_BIRD_NEST.getResourceKey()), this::canBeSeenAsNewNest, this.method_24515(), 48, class_4153.class_4155.field_18489).limit(5L).map(Pair::getSecond).toList()).isEmpty()) {
                this.nestPos = availableNests.get(this.method_59922().method_43048(availableNests.size()));
                this.nestDestroyedTicks = 0;
                for (int i = 0; i < 5; ++i) {
                    double d = this.method_59922().method_43059() * 0.02;
                    double e = this.method_59922().method_43059() * 0.02;
                    double f = this.method_59922().method_43059() * 0.02;
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f));
                }
            }
        } else {
            this.idleAnimationState.method_41324(this.field_6012);
            this.flapAnimationState.method_41324(this.field_6012);
            this.oldFlapScale = this.flapScale;
            this.flapScale = this.method_24828() ? (this.flapScale -= 0.1f) : (this.flapScale += 0.3f);
            this.flapScale = class_3532.method_15363((float)this.flapScale, (float)0.0f, (float)1.0f);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        boolean success = super.method_5643(source, amount);
        if (success && (class_12972 = source.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.trustedPlayers.remove(player.method_5667());
        }
        return success;
    }

    private boolean wantsToEnterNest() {
        return this.stayOutOfNestTicks <= 0 && !this.method_6479();
    }

    private boolean isNestValid() {
        return this.nestPos != null && this.method_37908().method_8320(this.nestPos).method_26164(ESTags.Blocks.STARFIRE_BIRD_NESTS) && this.method_37908().method_8321(this.nestPos) instanceof StarfireBirdNestBlockEntity;
    }

    private boolean canBeSeenAsNewNest(class_2338 pos) {
        StarfireBirdNestBlockEntity entity;
        class_2586 class_25862;
        class_2680 state = this.method_37908().method_8320(pos);
        return state.method_26164(ESTags.Blocks.STARFIRE_BIRD_NESTS) && (class_25862 = this.method_37908().method_8321(pos)) instanceof StarfireBirdNestBlockEntity && !(entity = (StarfireBirdNestBlockEntity)class_25862).isFullForAdults() && entity.getItems().stream().anyMatch(stack -> !stack.method_7960());
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
    }

    public class_1315 method_5943(class_5425 level, class_1266 instance, class_3730 spawnType, @Nullable class_1315 data) {
        if (this.field_5974.method_43048(20) == 0) {
            this.setSpecialVariant(true);
        }
        return super.method_5943(level, instance, spawnType, data);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setSpecialVariant(compoundTag.method_10577(TAG_SPECIAL_VARIANT));
        class_2512.method_10691((class_2487)compoundTag, (String)TAG_NEST_POS).ifPresent(pos -> {
            this.nestPos = pos;
        });
        this.stayOutOfNestTicks = compoundTag.method_10550(TAG_STAY_OUT_OF_NEST_TICKS);
        this.hasEgg = compoundTag.method_10577(TAG_HAS_EGG);
        this.trustedPlayers.clear();
        if (compoundTag.method_10573(TAG_TRUSTED_PLAYERS, 9)) {
            class_2499 listTag = compoundTag.method_10554(TAG_TRUSTED_PLAYERS, 11);
            for (class_2520 tag : listTag) {
                if (tag == null || tag.method_23258() != class_2495.field_21036 || ((class_2495)tag).method_10588().length != 4) continue;
                this.trustedPlayers.add(class_2512.method_25930((class_2520)tag));
            }
        }
        this.giftCount = compoundTag.method_10550(TAG_GIFT_COUNT);
        this.giftCooldown = compoundTag.method_10550(TAG_GIFT_COOLDOWN);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556(TAG_SPECIAL_VARIANT, this.isSpecialVariant());
        if (this.hasNest()) {
            compoundTag.method_10566(TAG_NEST_POS, class_2512.method_10692((class_2338)this.nestPos));
        }
        compoundTag.method_10569(TAG_STAY_OUT_OF_NEST_TICKS, this.stayOutOfNestTicks);
        compoundTag.method_10556(TAG_HAS_EGG, this.hasEgg);
        class_2499 listTag = new class_2499();
        for (UUID uuid : this.trustedPlayers) {
            if (uuid == null) continue;
            listTag.add((Object)class_2512.method_25929((UUID)uuid));
        }
        compoundTag.method_10566(TAG_TRUSTED_PLAYERS, (class_2520)listTag);
        compoundTag.method_10569(TAG_GIFT_COUNT, this.giftCount);
        compoundTag.method_10569(TAG_GIFT_COOLDOWN, this.giftCooldown);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(ESTags.Items.STARFIRE_BIRD_FOOD);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)ESEntities.STARFIRE_BIRD.get().method_5883((class_1937)level);
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected void method_5619() {
        super.method_5619();
        this.method_18382();
    }

    public void method_5614(int age) {
        super.method_5614(age);
        if (this.method_6109()) {
            this.switchMoveType(false);
        }
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.method_6109() ? super.method_55694(pose).method_18383(0.75f) : super.method_55694(pose);
    }

    @Nullable
    protected class_3414 method_5994() {
        return ESSoundEvents.STARFIRE_BIRD_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.STARFIRE_BIRD_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return ESSoundEvents.STARFIRE_BIRD_DEATH.get();
    }

    public static boolean checkStarfireBirdSpawnRules(class_1299<? extends StarfireBird> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(class_3481.field_29822) && ESConfig.INSTANCE.mobsConfig.starfireBird.canSpawn();
    }

    private class StarfireBirdBreedGoal
    extends class_1341 {
        public StarfireBirdBreedGoal() {
            super((class_1429)StarfireBird.this, 1.0);
        }

        protected void method_6249() {
            class_3222 loveCause = this.field_6404.method_6478();
            if (loveCause == null && this.field_6406 != null && this.field_6406.method_6478() != null) {
                loveCause = this.field_6406.method_6478();
            }
            if (loveCause != null && this.field_6406 != null) {
                loveCause.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(loveCause, this.field_6404, this.field_6406, null);
                StarfireBird.this.addTrustedPlayer(loveCause.method_5667());
                class_1429 class_14292 = this.field_6406;
                if (class_14292 instanceof StarfireBird) {
                    StarfireBird bird = (StarfireBird)class_14292;
                    bird.addTrustedPlayer(loveCause.method_5667());
                }
            }
            StarfireBird.this.setHasEgg(true);
            this.field_6404.method_5614(6000);
            this.field_6406.method_5614(6000);
            this.field_6404.method_6477();
            this.field_6406.method_6477();
            class_5819 random = this.field_6404.method_59922();
            if (this.field_6405.method_8450().method_8355(class_1928.field_19391)) {
                this.field_6405.method_8649((class_1297)new class_1303(this.field_6405, this.field_6404.method_23317(), this.field_6404.method_23318(), this.field_6404.method_23321(), random.method_43048(7) + 1));
            }
            StarfireBird.this.stayOutOfNestTicks = 0;
        }
    }

    private class StarfireBirdEnterNestGoal
    extends class_1352 {
        private StarfireBirdEnterNestGoal() {
        }

        public boolean method_6264() {
            class_2586 blockEntity;
            if (StarfireBird.this.hasNest() && StarfireBird.this.wantsToEnterNest() && StarfireBird.this.nestPos.method_19769((class_2374)StarfireBird.this.method_19538(), 2.0) && (blockEntity = StarfireBird.this.method_37908().method_8321(StarfireBird.this.nestPos)) instanceof StarfireBirdNestBlockEntity) {
                StarfireBirdNestBlockEntity nest = (StarfireBirdNestBlockEntity)blockEntity;
                return !nest.isFullForAdults();
            }
            return false;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            class_2586 blockEntity;
            if (StarfireBird.this.hasNest() && (blockEntity = StarfireBird.this.method_37908().method_8321(StarfireBird.this.nestPos)) instanceof StarfireBirdNestBlockEntity) {
                class_2680 nestState;
                int eggs;
                StarfireBirdNestBlockEntity nest = (StarfireBirdNestBlockEntity)blockEntity;
                if (StarfireBird.this.hasEgg && (eggs = ((Integer)(nestState = StarfireBird.this.method_37908().method_8320(StarfireBird.this.nestPos)).method_11654((class_2769)StarfireBirdNestBlock.EGGS)).intValue()) < 3) {
                    StarfireBird.this.method_37908().method_8501(StarfireBird.this.nestPos, (class_2680)nestState.method_11657((class_2769)StarfireBirdNestBlock.EGGS, (Comparable)Integer.valueOf(eggs + 1)));
                    StarfireBird.this.setHasEgg(false);
                }
                nest.addAdultOccupant((class_1297)StarfireBird.this);
            }
        }
    }

    private class StarfireBirdGoToNestGoal
    extends class_1352 {
        private int tryTicks = 0;

        public StarfireBirdGoToNestGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6264() {
            return StarfireBird.this.method_59922().method_43048(StarfireBirdGoToNestGoal.method_38848((int)120)) == 0 && this.canUseGoal();
        }

        public boolean method_6266() {
            return this.canUseGoal();
        }

        private boolean canUseGoal() {
            StarfireBirdNestBlockEntity nest;
            class_2586 class_25862;
            return StarfireBird.this.nestPos != null && StarfireBird.this.wantsToEnterNest() && this.tryTicks < 300 && !StarfireBird.this.nestPos.method_19769((class_2374)StarfireBird.this.method_19538(), 2.0) && StarfireBird.this.isNestValid() && (class_25862 = StarfireBird.this.method_37908().method_8321(StarfireBird.this.nestPos)) instanceof StarfireBirdNestBlockEntity && !(nest = (StarfireBirdNestBlockEntity)class_25862).isFullForAdults();
        }

        public void method_6269() {
            this.tryTicks = 0;
        }

        public void method_6270() {
            this.tryTicks = 0;
            StarfireBird.this.field_6189.method_6340();
        }

        public void method_6268() {
            class_2338 target = StarfireBird.this.nestPos;
            if (target != null) {
                StarfireBird.this.method_5988().method_6230((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5, 10.0f, (float)StarfireBird.this.method_5978());
                StarfireBird.this.method_5942().method_6337((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5, 1.0);
            }
            ++this.tryTicks;
        }
    }

    private class StarfireBirdLandGoal
    extends class_1352 {
        private int tryTicks = 0;
        private class_243 target;

        public StarfireBirdLandGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6264() {
            if (this.canUseGoal()) {
                this.target = class_5534.method_31527((class_1314)StarfireBird.this, (int)15, (int)20);
                return this.validTarget();
            }
            return false;
        }

        public boolean method_6266() {
            return this.canUseGoal() && this.validTarget();
        }

        private boolean canUseGoal() {
            return StarfireBird.this.flying && StarfireBird.this.flyingTicks >= 300 && this.tryTicks < 300;
        }

        private boolean validTarget() {
            return this.target != null && StarfireBird.this.method_37908().method_8320(class_2338.method_49638((class_2374)this.target)).method_26215() && StarfireBird.this.method_37908().method_8320(class_2338.method_49638((class_2374)this.target).method_10074()).method_26169((class_1922)StarfireBird.this.method_37908(), class_2338.method_49638((class_2374)this.target).method_10074(), (class_1297)StarfireBird.this, class_2350.field_11036) && StarfireBird.this.method_5944(class_14.method_57625((class_1308)StarfireBird.this, (class_2338)class_2338.method_49638((class_2374)this.target))) == 0.0f;
        }

        public boolean method_6267() {
            return false;
        }

        public void method_6269() {
            this.tryTicks = 0;
        }

        public void method_6270() {
            this.tryTicks = 0;
            StarfireBird.this.field_6189.method_6340();
        }

        public void method_6268() {
            if (this.target != null) {
                StarfireBird.this.method_5988().method_6230(this.target.field_1352, this.target.field_1351, this.target.field_1350, 10.0f, (float)StarfireBird.this.method_5978());
                StarfireBird.this.method_5942().method_6337(this.target.field_1352, this.target.field_1351, this.target.field_1350, 1.0);
                if (StarfireBird.this.method_24828() || class_2338.method_49638((class_2374)StarfireBird.this.method_19538()).equals((Object)class_2338.method_49638((class_2374)this.target)) || class_2338.method_49638((class_2374)StarfireBird.this.method_19538()).method_10074().equals((Object)class_2338.method_49638((class_2374)this.target))) {
                    StarfireBird.this.switchMoveType(false);
                    StarfireBird.this.field_6189.method_6340();
                    this.target = null;
                }
            }
            ++this.tryTicks;
        }
    }

    private class StarfireBirdTakeOffGoal
    extends class_1352 {
        private StarfireBirdTakeOffGoal() {
        }

        public boolean method_6264() {
            if (!StarfireBird.this.flying && !StarfireBird.this.method_6109()) {
                StarfireBirdNestBlockEntity nest;
                class_2586 class_25862;
                List entities = StarfireBird.this.method_37908().method_18466(class_1309.class, class_4051.method_36625(), (class_1309)StarfireBird.this, StarfireBird.this.method_5829().method_1014(5.0));
                return StarfireBird.this.walkingTicks > 300 || StarfireBird.this.method_6065() != null || StarfireBird.this.wantsToEnterNest() && StarfireBird.this.isNestValid() && (class_25862 = StarfireBird.this.method_37908().method_8321(StarfireBird.this.nestPos)) instanceof StarfireBirdNestBlockEntity && !(nest = (StarfireBirdNestBlockEntity)class_25862).isFullForAdults() || entities.stream().anyMatch(e -> e.method_5864().method_20210(ESTags.EntityTypes.STARFIRE_BIRD_AFRAID_OF) && !StarfireBird.this.trustedPlayers.contains(e.method_5667()));
            }
            return false;
        }

        public boolean method_6266() {
            return false;
        }

        public boolean method_6267() {
            return false;
        }

        public void method_6269() {
            StarfireBird.this.switchMoveType(true);
            class_243 pos = StarfireBird.this.method_19538();
            StarfireBird.this.method_5942().method_6337(pos.field_1352, pos.field_1351 + 3.0, pos.field_1350, 1.0);
        }
    }

    private class StarfireBirdGiftGoal
    extends class_1352 {
        private class_1657 giftTarget = null;
        private int tryTicks = 0;

        public StarfireBirdGiftGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6264() {
            return StarfireBird.this.method_59922().method_43048(StarfireBirdGiftGoal.method_38848((int)120)) == 0 && this.canUseGoal();
        }

        public boolean method_6266() {
            return this.canUseGoal();
        }

        private boolean canUseGoal() {
            if (StarfireBird.this.giftCooldown > 0 || StarfireBird.this.giftCount <= 0) {
                return false;
            }
            if (!(this.giftTarget != null && this.giftTarget.method_5805() || StarfireBird.this.trustedPlayers.isEmpty())) {
                UUID playerId = StarfireBird.this.trustedPlayers.get(StarfireBird.this.method_59922().method_43048(StarfireBird.this.trustedPlayers.size()));
                this.giftTarget = StarfireBird.this.method_37908().method_18470(playerId);
            }
            return this.tryTicks < 300 && this.giftTarget != null && this.giftTarget.method_5805() && !StarfireBird.this.method_6109();
        }

        public void method_6269() {
            this.tryTicks = 0;
        }

        public void method_6270() {
            this.tryTicks = 0;
            StarfireBird.this.field_6189.method_6340();
        }

        public void method_6268() {
            if (this.giftTarget != null) {
                class_1937 class_19372;
                StarfireBird.this.method_5988().method_6226((class_1297)this.giftTarget, 10.0f, (float)StarfireBird.this.method_5978());
                StarfireBird.this.method_5942().method_6335((class_1297)this.giftTarget, 1.0);
                if (StarfireBird.this.method_5739((class_1297)this.giftTarget) < 3.0f && (class_19372 = StarfireBird.this.method_37908()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(ESLootTables.GAMEPLAY_STARFIRE_BIRD_GIFT);
                    ObjectArrayList items = lootTable.method_51878(new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)StarfireBird.this.method_19538()).method_51874(class_181.field_1226, (Object)StarfireBird.this).method_51875(class_173.field_16235));
                    for (class_1799 item : items) {
                        class_4215.method_19949((class_1309)StarfireBird.this, (class_1799)item, (class_243)this.giftTarget.method_19538().method_1031(0.0, (double)(this.giftTarget.method_17682() / 2.0f), 0.0));
                    }
                    this.giftTarget = null;
                    StarfireBird.this.giftCooldown = 600;
                    --StarfireBird.this.giftCount;
                }
            }
            ++this.tryTicks;
        }
    }
}

