/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;

public class StarlightGolemSmashPhase
extends BehaviorPhase<StarlightGolem> {
    public static final int ID = 3;
    private float pitch;
    private float yaw;
    private final List<class_2338> visited = new ArrayList<class_2338>();
    private final List<class_2338> lavaVisited = new ArrayList<class_2338>();

    public StarlightGolemSmashPhase() {
        super(3, 2, 70, 250);
    }

    @Override
    public boolean canStart(StarlightGolem entity, boolean cooldownOver) {
        return cooldownOver && entity.method_5968() != null && entity.getAttackEnergy() >= 0;
    }

    @Override
    public void onStart(StarlightGolem entity) {
        entity.setAttackEnergy(Math.max(entity.getAttackEnergy() - 16, 0));
        this.visited.clear();
        this.lavaVisited.clear();
    }

    @Override
    public void tick(StarlightGolem entity) {
        class_1937 class_19372;
        if (entity.getBehaviorTicks() == 30) {
            this.pitch = entity.method_5968() != null ? ESMathUtil.positionToPitch(entity.method_19538(), entity.method_5968().method_19538()) : 0.0f;
            this.yaw = entity.method_5791() + 90.0f;
        }
        if (entity.getBehaviorTicks() == 40 && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ScreenShakeVfx.createInstance((class_5321<class_1937>)entity.method_37908().method_27983(), entity.method_19538(), 40.0f, 50, 0.24f, 0.5f, 3.0f, 5.5f).send(serverLevel);
        }
        if (entity.getBehaviorTicks() >= 30) {
            int radius = (int)(((float)entity.getBehaviorTicks() - 30.0f) / 3.5f);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        class_2338 pos = entity.method_24515().method_10069(x, y, z);
                        if (entity.method_37908().method_8320(pos).method_26227().method_39360((class_3611)class_3612.field_15908)) {
                            if (this.lavaVisited.contains(pos)) continue;
                            this.lavaVisited.add(pos);
                            if (entity.method_59922().method_43048(25) != 0) continue;
                            entity.method_37908().method_8501(pos, class_2246.field_10092.method_9564());
                            if (entity.method_37908().field_9236) continue;
                            ((class_3218)entity.method_37908()).method_14199((class_2394)ESExplosionParticleOptions.LAVA, pos.method_46558().field_1352, pos.method_46558().field_1351 + 0.6, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        float blockPitch = ESMathUtil.positionToPitch(entity.method_19538(), pos.method_46558());
                        float blockYaw = ESMathUtil.positionToYaw(entity.method_19538(), pos.method_46558());
                        if (this.visited.contains(pos) || entity.method_37908().method_8320(pos).method_26215() || !(Math.abs(class_3532.method_15393((float)(this.pitch - blockPitch))) < 75.0f) || !(Math.abs(class_3532.method_15393((float)(this.yaw - blockYaw))) < 30.0f) || !(pos.method_46558().method_1022(entity.method_19538()) <= (double)radius) || !(pos.method_46558().method_1022(entity.method_19538()) >= (double)(radius - 1))) continue;
                        boolean above = entity.method_37908().method_8320(pos.method_10084()).method_26215();
                        boolean below = entity.method_37908().method_8320(pos.method_10074()).method_26215();
                        if (!above && !below) continue;
                        this.visited.add(pos);
                        boolean flag = true;
                        if (!above) {
                            boolean bl = flag = entity.method_59922().method_43048(6) == 0;
                        }
                        if (!flag) continue;
                        ESFallingBlock fallingBlock = new ESFallingBlock(entity.method_37908(), (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f, entity.method_37908().method_8320(pos), 100);
                        fallingBlock.method_5762(0.0, (double)(above ? 1 : -1) * entity.method_59922().method_43058() / 6.0 + 0.25, 0.0);
                        entity.method_37908().method_8649((class_1297)fallingBlock);
                        for (class_1309 living : entity.method_37908().method_18467(class_1309.class, new class_238(pos).method_1014(1.0))) {
                            if (living == entity) continue;
                            living.method_5643(ESDamageTypes.getDamageSource(entity.method_37908(), ESDamageTypes.GROUND_SMASH), 4.0f);
                        }
                        if (entity.method_37908().field_9236) continue;
                        ((class_3218)entity.method_37908()).method_14199((class_2394)ESExplosionParticleOptions.ENERGY, pos.method_46558().field_1352, pos.method_46558().field_1351, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                        if (entity.method_59922().method_43048(5) != 0) continue;
                        ((class_3218)entity.method_37908()).method_14199((class_2394)class_2398.field_17430, pos.method_46558().field_1352, pos.method_46558().field_1351 + 0.5, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(StarlightGolem entity) {
        return true;
    }

    @Override
    public void onStop(StarlightGolem entity) {
    }
}

