/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.phase;

import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_8152;

public abstract class BehaviorPhase<T extends class_1309> {
    private final int id;
    private final int priority;
    private final int duration;
    private final int cooldown;
    private final int turnsInto;

    public BehaviorPhase(int id, int priority, int duration, int cooldown) {
        this(id, priority, duration, cooldown, 0);
    }

    public BehaviorPhase(int id, int priority, int duration, int cooldown, int turnsInto) {
        this.id = id;
        this.priority = priority;
        this.duration = duration;
        this.cooldown = cooldown;
        this.turnsInto = turnsInto;
    }

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public abstract boolean canStart(T var1, boolean var2);

    public abstract void onStart(T var1);

    public abstract void tick(T var1);

    public abstract boolean canContinue(T var1);

    public abstract void onStop(T var1);

    public void start(T entity) {
        ((MultiBehaviorUser)entity).setBehaviorState(this.getId());
        ((MultiBehaviorUser)entity).setBehaviorTicks(0);
        this.onStart(entity);
    }

    public void stop(T entity, List<BehaviorPhase<T>> phaseList) {
        if (this.turnsInto == 0) {
            ((MultiBehaviorUser)entity).setBehaviorState(this.turnsInto);
            ((MultiBehaviorUser)entity).setBehaviorTicks(0);
        } else {
            phaseList.stream().filter(p -> this.turnsInto == p.getId()).findFirst().ifPresent(p -> p.start(entity));
        }
        this.onStop(entity);
    }

    public boolean canReachTarget(T entity, double range) {
        if (entity instanceof class_8152) {
            class_8152 targeting = (class_8152)entity;
            class_1309 target = targeting.method_5968();
            if (target == null) {
                return false;
            }
            return (double)entity.method_5739((class_1297)target) <= range + (double)(entity.method_17681() / 2.0f) + (double)(target.method_17681() / 2.0f);
        }
        return false;
    }

    public boolean isFacingTarget(T entity, float maxDiff) {
        return this.isFacingTarget(entity, maxDiff, entity.method_36454() + 90.0f);
    }

    public boolean isFacingTarget(T entity, float maxDiff, float yAngle) {
        if (entity instanceof class_8152) {
            class_8152 targeting = (class_8152)entity;
            class_1309 target = targeting.method_5968();
            if (target == null) {
                return false;
            }
            float angle = ESMathUtil.positionToYaw(entity.method_19538(), target.method_19538());
            return class_3532.method_15356((float)angle, (float)yAngle) <= maxDiff;
        }
        return false;
    }

    public boolean performMeleeAttack(T entity, double range) {
        if (entity instanceof class_8152) {
            class_8152 targeting = (class_8152)entity;
            class_1309 target = targeting.method_5968();
            if (target == null) {
                return false;
            }
            for (class_1309 livingEntity : entity.method_37908().method_18466(class_1309.class, class_4051.field_18092, entity, entity.method_5829().method_1014(range))) {
                if (livingEntity != target || !this.canReachTarget(entity, range)) continue;
                return entity.method_6121((class_1297)livingEntity);
            }
        }
        return false;
    }
}

