/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record BiomeData(class_6880<class_1959> biome, class_6880<class_2248> fluidBlock, List<Temperature> temperatures, int height, int variance, boolean hasBeaches, boolean hasRivers, boolean isOcean) {
    public static final Codec<BiomeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1959.field_24677.fieldOf("biome").forGetter(BiomeData::biome), (App)class_7923.field_41175.method_40294().fieldOf("fluid").forGetter(BiomeData::fluidBlock), (App)Temperature.CODEC.listOf().fieldOf("temperatures").forGetter(BiomeData::temperatures), (App)Codec.INT.fieldOf("height").forGetter(BiomeData::height), (App)Codec.INT.fieldOf("variance").forGetter(BiomeData::variance), (App)Codec.BOOL.fieldOf("has_beaches").forGetter(BiomeData::hasBeaches), (App)Codec.BOOL.fieldOf("has_rivers").forGetter(BiomeData::hasRivers), (App)Codec.BOOL.fieldOf("is_ocean").forGetter(BiomeData::isOcean)).apply((Applicative)instance, BiomeData::new));

    public boolean canHaveBeaches() {
        return !this.isOcean && this.hasBeaches;
    }

    public boolean canHaveRivers() {
        return !this.isOcean && this.hasRivers;
    }

    public static enum Temperature implements class_3542
    {
        COLD_EXTREME("cold_extreme"),
        COLD("cold"),
        NEUTRAL("neutral"),
        HOT("hot"),
        HOT_EXTREME("hot_extreme");

        public static final Codec<Temperature> CODEC;
        private final String name;

        private Temperature(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Temperature::values);
        }
    }

    public static class Builder {
        private final class_6880<class_1959> biome;
        private class_6880<class_2248> fluidBlock = class_2246.field_10382.method_40142();
        private final List<Temperature> temperatures = new ArrayList<Temperature>();
        private final int height;
        private final int variance;
        private boolean hasBeaches = true;
        private boolean hasRivers = true;
        private boolean isOcean = false;

        public Builder(class_6880<class_1959> biome, int height, int variance) {
            this.biome = biome;
            this.height = height;
            this.variance = variance;
        }

        public Builder withFluid(class_6880<class_2248> fluid) {
            this.fluidBlock = fluid;
            return this;
        }

        public Builder withTemperatures(Temperature ... temperatures) {
            this.temperatures.addAll(List.of(temperatures));
            return this;
        }

        public Builder fullRangeTemperatures() {
            return this.withTemperatures(Temperature.COLD_EXTREME, Temperature.COLD, Temperature.NEUTRAL, Temperature.HOT, Temperature.HOT_EXTREME);
        }

        public Builder hasBeaches(boolean hasBeaches) {
            this.hasBeaches = hasBeaches;
            return this;
        }

        public Builder hasRivers(boolean hasRivers) {
            this.hasRivers = hasRivers;
            return this;
        }

        public Builder isOcean(boolean isOcean) {
            this.isOcean = isOcean;
            return this;
        }

        public BiomeData build() {
            return new BiomeData(this.biome, this.fluidBlock, this.temperatures, this.height, this.variance, this.hasBeaches, this.hasRivers, this.isOcean);
        }
    }
}

