/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.fabric.network;

import cn.leolezury.eternalstarlight.common.handler.CommonSetupHandlers;
import cn.leolezury.eternalstarlight.common.network.ESPackets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class FabricNetworkHandler {
    public static void registerPackets() {
        CommonSetupHandlers.registerPackets(new CommonSetupHandlers.NetworkRegisterStrategy(){

            @Override
            public <T extends class_8710> void register(ESPackets.PacketInfo<T> packetInfo) {
                PayloadTypeRegistry.playC2S().register(packetInfo.type(), packetInfo.streamCodec());
                PayloadTypeRegistry.playS2C().register(packetInfo.type(), packetInfo.streamCodec());
            }
        });
    }

    public static void registerPacketReceivers() {
        CommonSetupHandlers.registerPackets(new CommonSetupHandlers.NetworkRegisterStrategy(){

            @Override
            public <T extends class_8710> void register(ESPackets.PacketInfo<T> packetInfo) {
                ServerPlayNetworking.registerGlobalReceiver(packetInfo.type(), (payload, context) -> packetInfo.handler().handle(payload, (class_1657)context.player()));
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientPacketReceivers() {
        CommonSetupHandlers.registerPackets(new CommonSetupHandlers.NetworkRegisterStrategy(){

            @Override
            public <T extends class_8710> void register(ESPackets.PacketInfo<T> packetInfo) {
                ClientPlayNetworking.registerGlobalReceiver(packetInfo.type(), (payload, context) -> packetInfo.handler().handle(payload, (class_1657)context.player()));
            }
        });
    }

    public static void sendToClient(class_3222 serverPlayer, class_8710 packet) {
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
    }

    public static void sendToServer(class_8710 packet) {
        ClientPlayNetworking.send((class_8710)packet);
    }
}

