/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.WeatheringGolemSteelFullBlock;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WeatheringGolemSteelJetBlock
extends WeatheringGolemSteelFullBlock {
    public static final MapCodec<WeatheringGolemSteelJetBlock> CODEC = WeatheringGolemSteelJetBlock.simpleCodec(WeatheringGolemSteelJetBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public WeatheringGolemSteelJetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<WeatheringGolemSteelJetBlock> codec() {
        return CODEC;
    }

    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        if ((Integer)blockState.getValue((Property)POWER) > 0) {
            if (!level.isClientSide && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 particlePos = pos.getCenter().add(0.0, 0.5, 0.0);
                RandomSource random = entity.getRandom();
                for (int i = 0; i < 15; ++i) {
                    ParticlePacket packet = new ParticlePacket((ParticleOptions)ParticleTypes.WHITE_SMOKE, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.2 + (double)random.nextFloat() / 1.5, 0.0);
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, packet);
                }
            }
            entity.hurtMarked = true;
            entity.addDeltaMovement(new Vec3(0.0, Math.sqrt((double)((Integer)blockState.getValue((Property)POWER)).intValue() * 0.21) * (this.isOxidized() ? 0.9 : 1.0), 0.0));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.currentImpulseImpactPos = pos.getCenter().add(0.0, 0.5, 0.0);
                player.setIgnoreFallDamageFromCurrentImpulse(true);
            }
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide && ((Integer)state.getValue((Property)POWER)).intValue() != level.getBestNeighborSignal(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(level.getBestNeighborSignal(pos))));
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && ((Integer)state.getValue((Property)POWER)).intValue() != level.getBestNeighborSignal(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(level.getBestNeighborSignal(pos))));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER});
    }
}

