/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.handler.ClientSetupHandlers;
import cn.leolezury.eternalstarlight.common.client.resource.BookLoader;
import cn.leolezury.eternalstarlight.common.client.shader.ESShaders;
import cn.leolezury.eternalstarlight.common.client.sound.BossMusicSoundInstance;
import cn.leolezury.eternalstarlight.common.client.visual.DelayedMultiBufferSource;
import cn.leolezury.eternalstarlight.common.client.visual.ScreenShake;
import cn.leolezury.eternalstarlight.common.client.visual.WorldVisualEffect;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESFluids;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESGuiUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandlers {
    public static BookLoader books;
    public static final Set<Mob> BOSSES;
    public static final List<WorldVisualEffect> VISUAL_EFFECTS;
    public static final List<ScreenShake> SCREEN_SHAKES;
    private static final ResourceLocation[] BAR_BACKGROUND_SPRITES;
    private static final ResourceLocation[] BAR_PROGRESS_SPRITES;
    private static final ResourceLocation[] OVERLAY_BACKGROUND_SPRITES;
    private static final ResourceLocation[] OVERLAY_PROGRESS_SPRITES;
    private static final ResourceLocation ETHER_EROSION_OVERLAY;
    private static final ResourceLocation ETHER_ARMOR_EMPTY;
    private static final ResourceLocation ETHER_ARMOR_HALF;
    private static final ResourceLocation ETHER_ARMOR_FULL;
    private static final ResourceLocation ORB_OF_PROPHECY_USE;
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE;
    private static final ResourceLocation LUNARIS_CACTUS_BLUR_LOCATION;
    public static final ResourceLocation WIP_LOCATION;
    private static final Map<ResourceKey<Crest>, GuiCrest> GUI_CRESTS;
    private static final List<DreamCatcherText> DREAM_CATCHER_TEXTS;
    public static int clientTickCount;
    public static BossMusicSoundInstance bossMusicInstance;
    private static float oldPortalTicks;
    private static float portalTicks;
    private static float oldAuroraIntensity;
    private static float auroraIntensity;
    public static int resetCameraIn;
    public static float fogStartDecrement;
    public static float fogEndDecrement;
    public static float oldAbyssalFogModifier;
    public static float abyssalFogModifier;
    public static boolean oldTearyEffect;
    public static boolean tearyEffect;
    public static int oldSeedsLauncherAnimTicks;
    public static int seedsLauncherAnimTicks;
    public static final MultiBufferSource.BufferSource DELAYED_BUFFER_SOURCE;
    private static Matrix4f modelViewMatrix;
    public static boolean isHalloween;

    public static void onClientTick() {
        if (Minecraft.getInstance().level == null) {
            ClientHandlers.clearWorldSpecificVars();
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientWeatherState.tickRainLevel();
        ArrayList<WorldVisualEffect> effectsToRemove = new ArrayList<WorldVisualEffect>();
        ArrayList<ScreenShake> screenShakesToRemove = new ArrayList<ScreenShake>();
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()) {
            if (!Minecraft.getInstance().isPaused()) {
                if (++clientTickCount % 1000 == 5) {
                    Calendar calendar = Calendar.getInstance();
                    isHalloween = calendar.get(2) == 10 && calendar.get(5) == 1;
                }
                oldSeedsLauncherAnimTicks = seedsLauncherAnimTicks;
                if (seedsLauncherAnimTicks > 0) {
                    --seedsLauncherAnimTicks;
                }
            }
            for (WorldVisualEffect worldVisualEffect : VISUAL_EFFECTS) {
                if (worldVisualEffect.shouldRemove()) {
                    effectsToRemove.add(worldVisualEffect);
                    continue;
                }
                if (Minecraft.getInstance().isPaused()) continue;
                worldVisualEffect.worldTick();
            }
            for (WorldVisualEffect worldVisualEffect : effectsToRemove) {
                VISUAL_EFFECTS.remove(worldVisualEffect);
            }
            for (ScreenShake screenShake : SCREEN_SHAKES) {
                if (screenShake.shouldRemove()) {
                    screenShakesToRemove.add(screenShake);
                    continue;
                }
                if (Minecraft.getInstance().isPaused()) continue;
                screenShake.tick();
            }
            for (ScreenShake screenShake : screenShakesToRemove) {
                SCREEN_SHAKES.remove(screenShake);
            }
            if (!Minecraft.getInstance().isPaused() && ClientWeatherState.weather != null && Minecraft.getInstance().level.dimension().location().equals((Object)ESDimensions.STARLIGHT_KEY.location())) {
                ClientWeatherState.weather.clientTick();
            }
            if (player != null) {
                if (player.tickCount % 20 == 0) {
                    if (bossMusicInstance == null) {
                        List<ESBoss> bosses = Minecraft.getInstance().level.getEntitiesOfClass(ESBoss.class, player.getBoundingBox().inflate(50.0));
                        bosses.sort(Comparator.comparingDouble(b -> b.distanceTo((Entity)player)));
                        bosses = bosses.stream().filter(ESBoss::shouldPlayBossMusic).filter(b -> b.tickCount > 20 && player.hasLineOfSight((Entity)b)).toList();
                        if (!bosses.isEmpty()) {
                            ESBoss eSBoss = bosses.getFirst();
                            bossMusicInstance = new BossMusicSoundInstance(eSBoss.getBossMusic(), eSBoss);
                        }
                    } else if (bossMusicInstance.shouldStopMusic(player)) {
                        Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
                        bossMusicInstance.stopMusic();
                        bossMusicInstance = null;
                    }
                    if (bossMusicInstance != null && !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)bossMusicInstance)) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)bossMusicInstance);
                    }
                }
            } else if (bossMusicInstance != null) {
                Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
                bossMusicInstance.stopMusic();
                bossMusicInstance = null;
            }
        }
        if (Minecraft.getInstance().level != null) {
            for (ClientSetupHandlers.WorldVisualEffectSpawnFunction worldVisualEffectSpawnFunction : ClientSetupHandlers.VISUAL_EFFECT_SPAWN_FUNCTIONS) {
                worldVisualEffectSpawnFunction.clientTick(Minecraft.getInstance().level, VISUAL_EFFECTS);
            }
        }
        if (player != null) {
            Registry registry;
            Optional key;
            oldPortalTicks = portalTicks;
            if (player.portalProcess != null && player.portalProcess.isSamePortal((Portal)ESBlocks.STARLIGHT_PORTAL.get()) && player.portalProcess.isInsidePortalThisTick()) {
                portalTicks += 1.0f;
                player.portalProcess.setAsInsidePortalThisTick(false);
            } else {
                portalTicks -= 2.0f;
            }
            portalTicks = Mth.clamp((float)portalTicks, (float)0.0f, (float)80.0f);
            oldAuroraIntensity = auroraIntensity;
            if (player.level().dimension() == ESDimensions.STARLIGHT_KEY) {
                auroraIntensity = ClientWeatherState.weather == ESWeathers.AURORA.get() ? (auroraIntensity += 0.05f) : (auroraIntensity -= 0.05f);
            } else {
                oldAuroraIntensity = 0.0f;
                auroraIntensity = 0.0f;
            }
            auroraIntensity = Mth.clamp((float)auroraIntensity, (float)0.0f, (float)1.0f);
            ArrayList<ResourceKey<Crest>> crestsToRemove = new ArrayList<ResourceKey<Crest>>();
            for (ResourceKey<Crest> resourceKey : GUI_CRESTS.keySet()) {
                GuiCrest crest = GUI_CRESTS.get(resourceKey);
                if (!((double)Math.abs(crest.angle + 135.0f) < 0.1) || crest.shouldShow) continue;
                crestsToRemove.add(resourceKey);
            }
            for (ResourceKey resourceKey : crestsToRemove) {
                GUI_CRESTS.remove(resourceKey);
            }
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().tick();
            }
            ItemStack itemStack = player.getMainHandItem();
            ItemStack itemStack2 = player.getOffhandItem();
            Holder component = null;
            if (itemStack.has(ESDataComponents.CURRENT_CREST.get())) {
                component = (Holder)itemStack.get(ESDataComponents.CURRENT_CREST.get());
            } else if (itemStack2.has(ESDataComponents.CURRENT_CREST.get())) {
                component = (Holder)itemStack2.get(ESDataComponents.CURRENT_CREST.get());
            }
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().shouldShow = false;
            }
            if (component != null && component.isBound() && (key = (registry = player.registryAccess().registryOrThrow(ESRegistries.CREST)).getResourceKey((Object)((Crest)component.value()))).isPresent()) {
                if (!GUI_CRESTS.containsKey(key.get())) {
                    GUI_CRESTS.put((ResourceKey<Crest>)((ResourceKey)key.get()), new GuiCrest());
                }
                ClientHandlers.GUI_CRESTS.get(key.get()).shouldShow = true;
            }
            if (ClientSetupHandlers.KEY_MAPPINGS.get(EternalStarlight.id("switch_crest")).consumeClick()) {
                ESPlatform.INSTANCE.sendToServer(new NoParametersPacket("switch_crest"));
            }
            if (resetCameraIn > 0) {
                Minecraft.getInstance().options.hideGui = true;
                if (--resetCameraIn <= 0) {
                    Minecraft.getInstance().setCameraEntity((Entity)player);
                    Minecraft.getInstance().options.hideGui = false;
                    resetCameraIn = 0;
                }
            } else if (Minecraft.getInstance().getCameraEntity() instanceof SoulitSpectator) {
                Minecraft.getInstance().setCameraEntity((Entity)player);
                Minecraft.getInstance().options.hideGui = false;
            }
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            fogStartDecrement -= 0.5f;
            fogEndDecrement -= 0.5f;
            Holder biomeHolder = player.level().getBiome(player.blockPosition());
            if (camera.getFluidInCamera() == FogType.NONE && player.level().getBlockState(camera.getBlockPosition()).getFluidState().isEmpty() && biomeHolder.is(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                fogStartDecrement += 1.25f;
                fogEndDecrement += 1.0f;
                fogEndDecrement = Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)80.0f);
            }
            fogStartDecrement = Mth.clamp((float)fogStartDecrement, (float)0.0f, (float)100.0f);
            fogEndDecrement = Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)100.0f);
            oldAbyssalFogModifier = abyssalFogModifier;
            abyssalFogModifier = biomeHolder.is(ESBiomes.THE_ABYSS) ? (abyssalFogModifier -= 0.02f) : (abyssalFogModifier += 0.02f);
            abyssalFogModifier = Mth.clamp((float)abyssalFogModifier, (float)0.0f, (float)1.0f);
            oldTearyEffect = tearyEffect;
            tearyEffect = player.hasEffect(ESMobEffects.TEARY.asHolder());
            if (player.hasEffect(ESMobEffects.DREAM_CATCHER.asHolder())) {
                ArrayList<DreamCatcherText> textsToRemove = new ArrayList<DreamCatcherText>();
                for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                    text.updatePosition();
                    int width = Minecraft.getInstance().font.width((FormattedText)text.getText());
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    int height = 9;
                    if (text.getX() - width / 2 <= Minecraft.getInstance().getWindow().getGuiScaledWidth() && text.getY() - height / 2 <= Minecraft.getInstance().getWindow().getGuiScaledHeight()) continue;
                    textsToRemove.add(text);
                }
                for (DreamCatcherText text : textsToRemove) {
                    DREAM_CATCHER_TEXTS.remove(text);
                }
                if (player.getRandom().nextInt(40) == 0 && DREAM_CATCHER_TEXTS.size() < 20) {
                    MutableComponent dreamCatcherText = Component.translatable((String)("message.eternal_starlight.dream_catcher_" + player.getRandom().nextInt(7)));
                    DREAM_CATCHER_TEXTS.add(new DreamCatcherText((Component)dreamCatcherText, (int)(player.getRandom().nextFloat() * 5.0f + 1.0f), -Minecraft.getInstance().font.width((FormattedText)dreamCatcherText) / 2, player.getRandom().nextInt(Minecraft.getInstance().getWindow().getGuiScaledHeight())));
                }
            } else {
                DREAM_CATCHER_TEXTS.clear();
            }
        } else {
            DREAM_CATCHER_TEXTS.clear();
            tearyEffect = false;
        }
        if (oldTearyEffect != tearyEffect) {
            Minecraft.getInstance().gameRenderer.checkEntityPostEffect(Minecraft.getInstance().cameraEntity);
        }
    }

    private static void clearWorldSpecificVars() {
        BOSSES.clear();
        VISUAL_EFFECTS.clear();
        SCREEN_SHAKES.clear();
        GUI_CRESTS.clear();
        DREAM_CATCHER_TEXTS.clear();
        if (bossMusicInstance != null) {
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusicInstance);
            bossMusicInstance.stopMusic();
            bossMusicInstance = null;
        }
        oldPortalTicks = 0.0f;
        portalTicks = 0.0f;
        oldAuroraIntensity = 0.0f;
        auroraIntensity = 0.0f;
        resetCameraIn = 0;
        fogStartDecrement = 0.0f;
        fogEndDecrement = 0.0f;
        oldAbyssalFogModifier = 1.0f;
        abyssalFogModifier = 1.0f;
        oldTearyEffect = false;
        tearyEffect = false;
        oldSeedsLauncherAnimTicks = 0;
        seedsLauncherAnimTicks = 0;
    }

    public static float getScreenShakeYawOffset() {
        if (!ESConfig.INSTANCE.enableScreenShake) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getYawOffset();
        }
        return sum;
    }

    public static float getScreenShakePitchOffset() {
        if (!ESConfig.INSTANCE.enableScreenShake) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getPitchOffset();
        }
        return sum;
    }

    public static void onAfterRenderEntities(MultiBufferSource source, PoseStack stack, float partialTicks) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        stack.pushPose();
        stack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        for (WorldVisualEffect effect : VISUAL_EFFECTS) {
            if (effect.shouldRemove()) continue;
            effect.render(source, stack, partialTicks);
        }
        stack.popPose();
    }

    public static void onAfterRenderParticles() {
        modelViewMatrix = RenderSystem.getModelViewMatrix();
    }

    public static void onAfterRenderWeather(float partialTicks) {
        float aurora;
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        if (Minecraft.useShaderTransparency()) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
        DELAYED_BUFFER_SOURCE.endBatch();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)matrix4f);
        if (Minecraft.useShaderTransparency() && Minecraft.getInstance().levelRenderer.getCloudsTarget() != null) {
            Minecraft.getInstance().levelRenderer.getCloudsTarget().bindWrite(false);
        }
        if ((aurora = Mth.lerp((float)partialTicks, (float)oldAuroraIntensity, (float)auroraIntensity)) > 0.0f && Minecraft.getInstance().level != null) {
            ClientHandlers.renderSkyShader(ESShaders.getAurora(), aurora);
        }
    }

    private static void renderSkyShader(ShaderInstance shader, float intensity) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float scale = 2048.0f * (Minecraft.getInstance().gameRenderer.getRenderDistance() / 32.0f);
        Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        float height = (float)(pos.y() + 128.0);
        float cloud = Minecraft.getInstance().level.effects().getCloudHeight() + 64.0f;
        float y = (float)((double)Math.max(height, cloud) - pos.y());
        buffer.addVertex(-scale, y, scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(-scale, y, -scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(scale, y, -scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(scale, y, scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)intensity);
        ShaderInstance last = RenderSystem.getShader();
        RenderSystem.setShader(() -> shader);
        shader.apply();
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        shader.clear();
        RenderSystem.setShader(() -> last);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static Vec3 computeCameraAngles(Vec3 angles) {
        return angles.add(Mth.clamp((double)ClientHandlers.getScreenShakePitchOffset(), (double)-0.5, (double)0.5), Mth.clamp((double)ClientHandlers.getScreenShakeYawOffset(), (double)-0.5, (double)0.5), 0.0);
    }

    public static OptionalDouble modifyFov(float original) {
        float portal;
        ItemStack itemStack;
        float modified = original;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isUsingItem() && ((itemStack = player.getUseItem()).is(ESItems.STARFALL_LONGBOW.get()) || itemStack.is(ESItems.FLOWGLAZE_BOW.get()) || itemStack.is(ESItems.MOONRING_BOW.get()) || itemStack.is(ESItems.BOW_OF_BLOOD.get()))) {
            float f = (float)player.getTicksUsingItem() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            modified = (float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)(modified * (1.0f - f * 0.15f)));
        }
        if ((portal = Mth.lerp((float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), (float)oldPortalTicks, (float)portalTicks) / 80.0f) > 0.0f) {
            modified = (float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)(modified * (1.0f - portal)));
        }
        return modified == original ? OptionalDouble.empty() : OptionalDouble.of(modified);
    }

    public static void onRenderFog(Camera camera, FogRenderer.FogMode fogMode) {
        FluidState fluidState;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (ESPlatform.INSTANCE.getLoader() == ESPlatform.Loader.FABRIC && ((fluidState = camera.getEntity().level().getFluidState(camera.getBlockPosition())).is((Fluid)ESFluids.ETHER_STILL.get()) || fluidState.is((Fluid)ESFluids.ETHER_FLOWING.get())) && camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + fluidState.getHeight((BlockGetter)camera.getEntity().level(), camera.getBlockPosition()))) {
            RenderSystem.setShaderFogStart((float)0.0f);
            RenderSystem.setShaderFogEnd((float)3.0f);
            RenderSystem.setShaderFogColor((float)0.9098039f, (float)1.0f, (float)0.87058824f);
            RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        }
        if (player.level().dimension() == ESDimensions.STARLIGHT_KEY && camera.getFluidInCamera() == FogType.NONE && player.level().getBlockState(camera.getBlockPosition()).getFluidState().isEmpty() && fogMode == FogRenderer.FogMode.FOG_TERRAIN) {
            RenderSystem.setShaderFogStart((float)(RenderSystem.getShaderFogStart() - Mth.clamp((float)fogStartDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogStart() + 5.0f))));
            RenderSystem.setShaderFogEnd((float)(RenderSystem.getShaderFogEnd() - Mth.clamp((float)fogEndDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogEnd() - 50.0f))));
            Holder biomeHolder = player.level().getBiome(player.blockPosition());
            if (biomeHolder.is(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }
        }
    }

    public static boolean renderBossBar(GuiGraphics guiGraphics, LerpingBossEvent bossEvent, int x, int y) {
        ResourceLocation barLocation;
        Mob boss = null;
        if (BOSSES.isEmpty()) {
            return false;
        }
        for (Mob mob : BOSSES) {
            if (!mob.getUUID().equals(bossEvent.getId())) continue;
            boss = mob;
            break;
        }
        Iterator<Mob> iterator = boss;
        int mob = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TheGatekeeper.class, StarlightGolem.class, LunarMonstrosity.class}, iterator, mob)) {
            case 0: {
                TheGatekeeper theGatekeeper = (TheGatekeeper)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)"textures/gui/bars/the_gatekeeper.png");
                break;
            }
            case 1: {
                StarlightGolem starlightGolem = (StarlightGolem)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)"textures/gui/bars/starlight_golem.png");
                break;
            }
            case 2: {
                LunarMonstrosity lunarMonstrosity = (LunarMonstrosity)((Object)iterator);
                barLocation = ResourceLocation.fromNamespaceAndPath((String)"eternal_starlight", (String)("textures/gui/bars/lunar_monstrosity" + (lunarMonstrosity.getPhase() > 0 ? "_soul.png" : ".png")));
                break;
            }
            default: {
                return false;
            }
        }
        ClientHandlers.drawBar(guiGraphics, x, y, (BossEvent)bossEvent, barLocation);
        Component component = bossEvent.getName();
        int textWidth = Minecraft.getInstance().font.width((FormattedText)component);
        int textX = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - textWidth / 2;
        int textY = y - 9;
        guiGraphics.drawString(Minecraft.getInstance().font, component, textX, textY, 0xFFFFFF);
        return true;
    }

    public static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent event, ResourceLocation barLocation) {
        ClientHandlers.drawBar(guiGraphics, x, y, event, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
        int k = Mth.lerpDiscrete((float)event.getProgress(), (int)0, (int)182);
        if (k > 0) {
            ClientHandlers.drawBar(guiGraphics, x, y, event, k, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
        }
        guiGraphics.blit(barLocation, x - 1, y - 5, 0.0f, 0.0f, 184, 16, 184, 16);
    }

    private static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent bossEvent, int progress, ResourceLocation[] bars, ResourceLocation[] overlays) {
        guiGraphics.blitSprite(bars[bossEvent.getColor().ordinal()], 182, 5, 0, 0, x, y, progress, 5);
        if (bossEvent.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(overlays[bossEvent.getOverlay().ordinal() - 1], 182, 5, 0, 0, x, y, progress, 5);
            RenderSystem.disableBlend();
        }
    }

    public static void renderTextureOverlay(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float f) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, f);
        guiGraphics.blit(resourceLocation, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderPortalOverlay(GuiGraphics guiGraphics) {
        float alpha = Mth.lerp((float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), (float)oldPortalTicks, (float)portalTicks) / 120.0f;
        if (alpha <= 0.0f) {
            return;
        }
        if (alpha < 1.0f) {
            alpha *= alpha;
            alpha *= alpha;
            alpha = alpha * 0.8f + 0.2f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        TextureAtlasSprite textureatlassprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(ESBlocks.STARLIGHT_PORTAL.get().defaultBlockState());
        guiGraphics.blit(0, 0, -90, guiGraphics.guiWidth(), guiGraphics.guiHeight(), textureatlassprite);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderSpellCrosshair(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        LocalPlayer player;
        Options options = Minecraft.getInstance().options;
        if (options.getCameraType().isFirstPerson() && (player = Minecraft.getInstance().player) instanceof SpellCaster && ESDataAttachments.SPELL_CAST_DATA.getData((Entity)player).hasSpell()) {
            SpellCastData data = ESDataAttachments.SPELL_CAST_DATA.getData((Entity)player);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (Minecraft.getInstance().options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR) {
                float f = Math.min(1.0f, (float)data.castTicks() / (float)data.spell().spellProperties().preparationTicks());
                if (data.castTicks() > data.spell().spellProperties().preparationTicks()) {
                    f = Math.max(0.0f, 1.0f - (float)(data.castTicks() - data.spell().spellProperties().preparationTicks()) / (float)data.spell().spellProperties().spellTicks());
                }
                int j = screenHeight / 2 - 7 + 16;
                int k = screenWidth / 2 - 8;
                int l = (int)(f * 17.0f);
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, k, j, 16, 4);
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, k, j, l, 4);
            }
            RenderSystem.defaultBlendFunc();
        }
    }

    public static void renderEtherErosion(GuiGraphics guiGraphics) {
        float erosionProgress = (float)ESDataAttachments.IN_ETHER_TICKS.getData((Entity)Minecraft.getInstance().player).intValue() / 140.0f;
        if (erosionProgress > 0.0f) {
            ClientHandlers.renderTextureOverlay(guiGraphics, ETHER_EROSION_OVERLAY, erosionProgress);
        }
    }

    public static void renderEtherArmor(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.getInstance();
        if (ESBlockUtil.isEntityInBlock((Entity)minecraft.player, (Block)ESBlocks.ETHER.get())) {
            minecraft.getProfiler().push("armor");
            int initialX = screenWidth / 2 - 91;
            int initialY = screenHeight - 39;
            float maxHealth = (float)Math.max(minecraft.player.getAttributeValue(Attributes.MAX_HEALTH), (double)Mth.ceil((float)minecraft.player.getHealth()));
            int absorptionAmount = Mth.ceil((float)minecraft.player.getAbsorptionAmount());
            int q = Mth.ceil((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
            int r = Math.max(10 - (q - 2), 3);
            int armorValue = minecraft.player.getArmorValue();
            int y = initialY - (q - 1) * r - 10;
            for (int i = 0; i < 10; ++i) {
                if (armorValue <= 0) continue;
                int x = initialX + i * 8;
                if (i * 2 + 1 < armorValue) {
                    guiGraphics.blit(ETHER_ARMOR_FULL, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 == armorValue) {
                    guiGraphics.blit(ETHER_ARMOR_HALF, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 <= armorValue) continue;
                guiGraphics.blit(ETHER_ARMOR_EMPTY, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            }
        }
    }

    public static void renderOrbOfProphecyUse(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isUsingItem() && player.getUseItem().is(ESItems.ORB_OF_PROPHECY.get()) && !player.getUseItem().has(ESDataComponents.CURRENT_CREST.get())) {
            int usingTicks = player.getTicksUsingItem();
            float ticks = Math.min((float)usingTicks + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), 150.0f);
            float progress = Math.min(ticks, 150.0f) / 150.0f;
            if (usingTicks < 150) {
                ClientHandlers.renderTextureOverlay(guiGraphics, ORB_OF_PROPHECY_USE, progress);
            }
        }
    }

    public static void renderCurrentCrest(GuiGraphics guiGraphics) {
        if (Minecraft.getInstance().player != null) {
            Registry registry = Minecraft.getInstance().player.registryAccess().registryOrThrow(ESRegistries.CREST);
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
            for (Map.Entry<ResourceKey<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                GuiCrest guiCrest = entry.getValue();
                Crest crest = (Crest)registry.get(entry.getKey());
                if (crest == null) continue;
                ESGuiUtil.blitFloat(guiGraphics, crest.texture(), guiCrest.getX(partialTicks), guiCrest.getY(partialTicks), 72.0f, 72.0f, 72.0f, 72.0f);
            }
        }
    }

    public static void renderCarvedLunarisCactusFruitBlur(GuiGraphics guiGraphics) {
        ItemStack itemStack;
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && Minecraft.getInstance().player != null && (itemStack = Minecraft.getInstance().player.getInventory().getArmor(3)).is(ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get().asItem())) {
            ClientHandlers.renderTextureOverlay(guiGraphics, LUNARIS_CACTUS_BLUR_LOCATION, 1.0f);
        }
    }

    public static void renderDreamCatcher(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.hasEffect(ESMobEffects.DREAM_CATCHER.asHolder())) {
            for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, text.getText(), text.getX(), text.getY(), 5343172);
            }
        }
    }

    public static void setAirBubbleColor() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.level().getBiome(player.blockPosition()).is(ESBiomes.THE_ABYSS)) {
            RenderSystem.setShaderColor((float)1.0f, (float)((float)Mth.clamp((double)(1.0 + player.getY() / 64.0), (double)0.0, (double)1.0)), (float)1.0f, (float)1.0f);
        }
    }

    public static int getAirBubbleYOffset() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.level().getBiome(player.blockPosition()).is(ESBiomes.THE_ABYSS) && player.getY() < 0.0) {
            return player.getRandom().nextInt(2);
        }
        return 0;
    }

    static {
        BOSSES = Collections.newSetFromMap(new WeakHashMap());
        VISUAL_EFFECTS = new ArrayList<WorldVisualEffect>();
        SCREEN_SHAKES = new ArrayList<ScreenShake>();
        BAR_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background")};
        BAR_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/pink_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/blue_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/red_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/green_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/purple_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress")};
        OVERLAY_BACKGROUND_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_background"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_background")};
        OVERLAY_PROGRESS_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_10_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_progress"), ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_20_progress")};
        ETHER_EROSION_OVERLAY = EternalStarlight.id("textures/misc/ether_erosion.png");
        ETHER_ARMOR_EMPTY = EternalStarlight.id("textures/gui/hud/ether_armor_empty.png");
        ETHER_ARMOR_HALF = EternalStarlight.id("textures/gui/hud/ether_armor_half.png");
        ETHER_ARMOR_FULL = EternalStarlight.id("textures/gui/hud/ether_armor_full.png");
        ORB_OF_PROPHECY_USE = EternalStarlight.id("textures/misc/orb_of_prophecy_use.png");
        CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_background");
        CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_progress");
        LUNARIS_CACTUS_BLUR_LOCATION = EternalStarlight.id("textures/misc/lunaris_cactus_blur.png");
        WIP_LOCATION = EternalStarlight.id("textures/gui/wip.png");
        GUI_CRESTS = new HashMap<ResourceKey<Crest>, GuiCrest>();
        DREAM_CATCHER_TEXTS = new ArrayList<DreamCatcherText>();
        clientTickCount = 0;
        bossMusicInstance = null;
        oldAbyssalFogModifier = 1.0f;
        abyssalFogModifier = 1.0f;
        DELAYED_BUFFER_SOURCE = new DelayedMultiBufferSource(new ByteBufferBuilder(1536));
        modelViewMatrix = new Matrix4f();
    }

    private static class GuiCrest {
        private boolean shouldShow = false;
        private float prevAngle = -135.0f;
        private float angle = -135.0f;

        private GuiCrest() {
        }

        public void tick() {
            this.prevAngle = this.angle;
            this.angle = Mth.approachDegrees((float)this.angle, (float)(this.shouldShow ? 45.0f : -135.0f), (float)15.0f);
        }

        public float getX(float partialTicks) {
            return (float)Math.cos(Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * Mth.SQRT_OF_TWO - 36.0f;
        }

        public float getY(float partialTicks) {
            return (float)Math.sin(Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * Mth.SQRT_OF_TWO - 36.0f;
        }
    }

    private static class DreamCatcherText {
        private final Component text;
        private final int speed;
        private int x;
        private final int y;

        public DreamCatcherText(Component component, int speed, int x, int y) {
            this.text = component;
            this.speed = speed;
            this.x = x;
            this.y = y;
        }

        public Component getText() {
            return this.text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void updatePosition() {
            this.x += this.speed;
        }
    }
}

