/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ModelUtils;
import cn.leolezury.eternalstarlight.common.client.model.entity.LunarMonstrosityModel;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LunarMonstrosityRenderer<T extends LunarMonstrosity>
extends MobRenderer<T, LunarMonstrosityModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/lunar_monstrosity.png");

    public LunarMonstrosityRenderer(EntityRendererProvider.Context context) {
        super(context, new LunarMonstrosityModel(context.bakeLayer(LunarMonstrosityModel.LAYER_LOCATION)), 0.5f);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        super.render(entity, yaw, partialTicks, poseStack, bufferSource, light);
        ((LunarMonstrosity)entity).headPos = ModelUtils.getModelPosition(entity, ((LunarMonstrosity)entity).yBodyRot, List.of(((LunarMonstrosityModel)this.getModel()).root(), ((LunarMonstrosityModel)this.getModel()).stemAll, ((LunarMonstrosityModel)this.getModel()).stemMiddle, ((LunarMonstrosityModel)this.getModel()).stemTop, ((LunarMonstrosityModel)this.getModel()).head));
    }

    protected float getFlipDegrees(T livingEntity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ENTITY_TEXTURE;
    }
}

