/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PermafrostCloud
extends Entity
implements TraceableEntity {
    private static final String TAG_OWNER = "owner";
    private static final String TAG_SMALL = "small";
    protected static final EntityDataAccessor<Boolean> SMALL = SynchedEntityData.defineId(PermafrostCloud.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerId;

    public boolean isSmall() {
        return (Boolean)this.getEntityData().get(SMALL);
    }

    public void setSmall(boolean small) {
        this.getEntityData().set(SMALL, (Object)small);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.ownerId = owner.getUUID();
        this.owner = owner;
    }

    public PermafrostCloud(EntityType<? extends PermafrostCloud> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SMALL, (Object)false);
    }

    public void tick() {
        block9: {
            block8: {
                super.tick();
                if (this.tickCount > 200) {
                    this.discard();
                }
                if (this.tickCount % 3 == 0) {
                    this.refreshDimensions();
                }
                if (this.level().isClientSide) break block8;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.owner == null && this.ownerId != null) {
                        Entity entity = serverLevel.getEntity(this.ownerId);
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity;
                            this.owner = livingEntity = (LivingEntity)entity;
                        }
                        if (this.owner == null) {
                            this.ownerId = null;
                        }
                    }
                }
                if (this.getOwner() == null) break block9;
                for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
                    if (!ESEntityUtil.shouldHarm((Entity)this.getOwner(), (Entity)livingEntity)) continue;
                    livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.FREEZE, this, (Entity)this.getOwner()), 4.0f);
                    if (!livingEntity.canFreeze()) continue;
                    livingEntity.setTicksFrozen(Math.min(livingEntity.getTicksFrozen() + 8, 300));
                }
                break block9;
            }
            int count = Mth.ceil((double)(Math.PI * (double)(this.getBbWidth() / 2.0f) * (double)(this.getBbWidth() / 2.0f)));
            float offset = this.getBbWidth();
            for (int i = 0; i < count; ++i) {
                float angle = this.random.nextFloat() * ((float)Math.PI * 2);
                float scale = Mth.sqrt((float)this.random.nextFloat()) * offset;
                double x = this.getX() + (double)(Mth.cos((float)angle) * scale);
                double y = this.getY();
                double z = this.getZ() + (double)(Mth.sin((float)angle) * scale);
                this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.isSmall() ? super.getDimensions(pose).scale(0.5f, 1.0f) : super.getDimensions(pose);
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.discard();
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.hasUUID(TAG_OWNER)) {
            this.ownerId = tag.getUUID(TAG_OWNER);
        }
        this.setSmall(tag.getBoolean(TAG_SMALL));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.owner != null) {
            tag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
        tag.putBoolean(TAG_SMALL, this.isSmall());
    }
}

