/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.entity.projectile.EnergySpark;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StarlightGolemSmashPhase
extends BehaviorPhase<StarlightGolem> {
    public static final int ID = 3;
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{15, 20, 25, 30, 35, 40}));
    private BlockPos shockwavePos = BlockPos.ZERO;
    private float pitch;
    private float yaw;
    private final List<BlockPos> visited = new ArrayList<BlockPos>();
    private final List<BlockPos> lavaVisited = new ArrayList<BlockPos>();

    public StarlightGolemSmashPhase() {
        super(3, 2, 70, 250);
    }

    @Override
    public boolean canStart(StarlightGolem entity, boolean cooldownOver) {
        return (cooldownOver || entity.getPhase() == 1 && entity.onGround() && entity.getBehaviorManager().getCooldowns().getOrDefault(3, 0) < 150) && entity.getTarget() != null && (entity.getPhase() == 1 || entity.getAttackEnergy() >= 0);
    }

    @Override
    public void onStart(StarlightGolem entity) {
        entity.setAttackEnergy(Math.max(entity.getAttackEnergy() - 16, 0));
        this.visited.clear();
        this.lavaVisited.clear();
    }

    @Override
    public void tick(StarlightGolem entity) {
        Level i3;
        LivingEntity target = entity.getTarget();
        if (entity.getBehaviorTicks() == 30) {
            this.pitch = target != null ? ESMathUtil.positionToPitch(entity.position(), target.position()) : 0.0f;
            this.yaw = entity.getYHeadRot() + 90.0f;
            if (target != null) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    EnergySpark spark = new EnergySpark(entity.level(), (LivingEntity)entity);
                    spark.setPos(entity.position().add(0.0, (double)(entity.getBbHeight() / 3.0f), 0.0));
                    spark.setTarget(target);
                    Vec3 movement = ESMathUtil.rotationToPosition(1.0f, this.pitch, this.yaw - 30.0f + (float)(15 * i2));
                    spark.shoot(movement.x, movement.y, movement.z, 0.1f, 0.0f);
                    entity.level().addFreshEntity((Entity)spark);
                }
            }
            this.shockwavePos = entity.blockPosition();
        }
        if (entity.getBehaviorTicks() == 37 && entity.getPhase() == 1 && target != null) {
            Iterator i2 = Util.shuffledCopy(ALLOWED_ANGLES, (RandomSource)entity.getRandom()).iterator();
            while (i2.hasNext()) {
                int i3 = (Integer)i2.next();
                Optional optional = LongJumpUtil.calculateJumpVectorForAngle((Mob)entity, (Vec3)ESMathUtil.rotationToPosition(entity.position(), 1.0f, this.pitch, this.yaw), (float)0.75f, (int)i3, (boolean)false);
                if (!optional.isPresent()) continue;
                entity.hurtMarked = true;
                entity.addDeltaMovement((Vec3)optional.get());
            }
        }
        if (entity.getBehaviorTicks() == 40 && (i3 = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)i3;
            ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 40.0f, 50, 0.24f, 0.5f, 3.0f, 5.5f).send(serverLevel);
        }
        if (entity.getBehaviorTicks() >= 30) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, ESMathUtil.rotationToPosition(entity.position(), entity.getBbWidth() * 10.0f, this.pitch, this.yaw));
        }
        if (entity.getBehaviorTicks() >= 40) {
            int radius = (int)(((float)entity.getBehaviorTicks() - 30.0f) / 3.0f);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        BlockPos pos = this.shockwavePos.offset(x, y, z);
                        if (entity.level().getBlockState(pos).is(Blocks.LAVA)) {
                            if (this.lavaVisited.contains(pos)) continue;
                            this.lavaVisited.add(pos);
                            if (entity.getRandom().nextInt(25) != 0 || !ESPlatform.INSTANCE.postEntityDestroyBlockEvent(entity.level(), pos, (Entity)entity)) continue;
                            entity.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                            if (entity.level().isClientSide) continue;
                            ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ESExplosionParticleOptions.LAVA, pos.getCenter().x, pos.getCenter().y + 0.6, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        float blockPitch = ESMathUtil.positionToPitch(this.shockwavePos.getBottomCenter(), pos.getCenter());
                        float blockYaw = ESMathUtil.positionToYaw(this.shockwavePos.getBottomCenter(), pos.getCenter());
                        if (this.visited.contains(pos) || entity.level().getBlockState(pos).isAir() || !(Math.abs(Mth.wrapDegrees((float)(this.pitch - blockPitch))) < 75.0f) || !(Math.abs(Mth.wrapDegrees((float)(this.yaw - blockYaw))) < 30.0f) || !(pos.getCenter().distanceTo(this.shockwavePos.getBottomCenter()) <= (double)radius) || !(pos.getCenter().distanceTo(this.shockwavePos.getBottomCenter()) >= (double)(radius - 1))) continue;
                        boolean above = entity.level().getBlockState(pos.above()).isAir();
                        boolean below = entity.level().getBlockState(pos.below()).isAir();
                        if (!above && !below) continue;
                        this.visited.add(pos);
                        boolean flag = true;
                        if (!above) {
                            boolean bl = flag = entity.getRandom().nextInt(6) == 0;
                        }
                        if (!flag) continue;
                        ESFallingBlock fallingBlock = new ESFallingBlock(entity.level(), (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, entity.level().getBlockState(pos), 100);
                        fallingBlock.push(0.0, (double)(above ? 1 : -1) * entity.getRandom().nextDouble() / 6.0 + 0.25, 0.0);
                        entity.level().addFreshEntity((Entity)fallingBlock);
                        for (LivingEntity living : entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0))) {
                            if (living == entity) continue;
                            living.hurt(ESDamageTypes.getDamageSource(entity.level(), ESDamageTypes.GROUND_SMASH), 4.0f);
                        }
                        if (entity.level().isClientSide) continue;
                        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ESExplosionParticleOptions.ENERGY, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                        if (entity.getRandom().nextInt(5) != 0) continue;
                        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.getCenter().x, pos.getCenter().y + 0.5, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(StarlightGolem entity) {
        return true;
    }

    @Override
    public void onStop(StarlightGolem entity) {
    }
}

