/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.data.ESPaintingVariants;
import cn.leolezury.eternalstarlight.common.entity.attack.CrystalCluster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.entity.projectile.EnergySpark;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownStarfire;
import cn.leolezury.eternalstarlight.common.entity.projectile.WiltedPetal;
import cn.leolezury.eternalstarlight.common.item.armor.GlaciteArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.combat.HammerItem;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherAmmoType;
import cn.leolezury.eternalstarlight.common.item.component.Accessory;
import cn.leolezury.eternalstarlight.common.item.interfaces.TickableArmor;
import cn.leolezury.eternalstarlight.common.item.misc.ManaCrystalItem;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWeatherPacket;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.resource.gatekeeper.TheGatekeeperNameManager;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESAccessoryUtil;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESSpellUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import cn.leolezury.eternalstarlight.common.weather.Weathers;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CommonHandlers {
    public static final String STARFIRE_ARROW = "eternal_starlight:starfire";
    public static final String FLOWGLAZE_ARROW = "eternal_starlight:flowglaze";
    public static final String CRYSTAL_ARROW = "eternal_starlight:crystal";
    public static final String MECHANICAL_ARROW = "eternal_starlight:mechanical";
    public static final String STARFALL_ARROW = "eternal_starlight:starfall";
    public static final String WILTED_ARROW = "eternal_starlight:wilted";
    public static TheGatekeeperNameManager gatekeeperNames;
    private static Weathers starlightWeathers;
    private static AbstractWeather lastWeather;
    private static int ticksSinceLastUpdate;
    private static final AttributeModifier AMARAMBER_BONUS;

    public static String getGatekeeperName() {
        return gatekeeperNames.getTheGatekeeperName();
    }

    public static Optional<WeatherInstance> getActiveWeather() {
        if (starlightWeathers == null) {
            return Optional.empty();
        }
        return starlightWeathers.getActiveWeather();
    }

    public static void onServerTick(MinecraftServer server) {
        if (++ticksSinceLastUpdate >= 20) {
            for (ServerLevel level : server.getAllLevels()) {
                BiomeSource biomeSource = level.getChunkSource().getGenerator().getBiomeSource();
                if (!(biomeSource instanceof ESBiomeSource)) continue;
                ESBiomeSource source = (ESBiomeSource)biomeSource;
                source.setCacheSize(level.players().size() * 8);
            }
            ticksSinceLastUpdate = 0;
        }
    }

    public static void onLevelLoad(ServerLevel serverLevel) {
        if (serverLevel.dimension() == ESDimensions.STARLIGHT_KEY) {
            starlightWeathers = ESWeatherUtil.getOrCreateWeathers(serverLevel);
        }
    }

    public static void onLevelTick(ServerLevel serverLevel) {
        if (serverLevel.dimension() == ESDimensions.STARLIGHT_KEY && starlightWeathers != null) {
            starlightWeathers.tick();
            long gameTime = serverLevel.getGameTime();
            starlightWeathers.getActiveWeather().ifPresentOrElse(weatherInstance -> {
                if (weatherInstance.getWeather() != lastWeather || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new UpdateWeatherPacket(weatherInstance.getWeather()));
                    lastWeather = weatherInstance.getWeather();
                }
                if (gameTime % 80L == 0L) {
                    for (ServerPlayer player : serverLevel.players()) {
                        if (!serverLevel.canSeeSky(BlockPos.containing((Position)player.getEyePosition()))) continue;
                        ESCriteriaTriggers.WITNESS_WEATHER.get().trigger(player);
                    }
                }
            }, () -> {
                if (lastWeather != null || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new NoParametersPacket("cancel_weather"));
                    lastWeather = null;
                }
            });
        }
    }

    public static void onItemTooltip(Player player, TooltipFlag flags, ItemStack itemStack, List<Component> tooltip, Item.TooltipContext context) {
        int accessorySlotCount;
        List accessories;
        HolderLookup.Provider lookup = context.registries();
        Accessory accessory = (Accessory)itemStack.get(ESDataComponents.ACCESSORY.get());
        if (accessory != null) {
            if (accessory.attributeModifiers().showInTooltip() && !accessory.attributeModifiers().modifiers().isEmpty() || !accessory.extraDescription().isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
                tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.accessory_combined").withStyle(ChatFormatting.GRAY));
            }
            if (accessory.attributeModifiers().showInTooltip()) {
                for (EquipmentSlotGroup slotGroup : EquipmentSlotGroup.values()) {
                    accessory.attributeModifiers().forEach(slotGroup, (holder, modifier) -> itemStack.addModifierTooltip(tooltip::add, player, holder, modifier));
                }
            }
            for (Component desc : accessory.extraDescription()) {
                tooltip.add((Component)Component.literal((String)" ").append(desc));
            }
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.accessory_combination_target").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.literal((String)" ").append(accessory.combinationTargetDescription()));
        }
        if (itemStack.has(ESDataComponents.ACCESSORIES.get()) && !(accessories = (List)itemStack.getOrDefault(ESDataComponents.ACCESSORIES.get(), new ArrayList())).isEmpty()) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.accessories").withStyle(ChatFormatting.GRAY));
            accessories.forEach(accessoryStack -> {
                Accessory data = (Accessory)accessoryStack.get(ESDataComponents.ACCESSORY.get());
                MutableComponent name = Component.literal((String)" ").append(accessoryStack.getHoverName());
                if (data != null && data.nameStyle().isPresent()) {
                    name.withStyle(data.nameStyle().get());
                }
                tooltip.add((Component)name);
                if (data != null) {
                    for (Component desc : data.extraDescription()) {
                        tooltip.add((Component)Component.literal((String)" ").append(desc));
                    }
                }
            });
        }
        if ((accessorySlotCount = ((Integer)itemStack.getOrDefault(ESDataComponents.ACCESSORY_SLOT_COUNT.get(), (Object)1)).intValue()) > 1) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.accessory_slot_count", (Object[])new Object[]{accessorySlotCount}).withStyle(ChatFormatting.BLUE));
        }
        if (itemStack.is(ESTags.Items.FLOWGLAZE_WEAPONS)) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.flowglaze_weapon").withColor(9361072));
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.flowglaze_tool").withColor(9361072));
        }
        if (itemStack.is(ESItems.FLOWGLAZE_BOW.get())) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.flowglaze_bow").withColor(9361072));
        }
        if (itemStack.is(ESItems.FLOWGLAZE_SHIELD.get())) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.flowglaze_shield").withColor(9361072));
        }
        if (player != null && lookup != null && itemStack.is(ESTags.Items.SEEDS_LAUNCHER_AMMO) && player.getInventory().contains(stack -> stack.getItem() == ESItems.SEEDS_LAUNCHER.get())) {
            String speed;
            tooltip.add(CommonComponents.EMPTY);
            SeedsLauncherAmmoType type = (SeedsLauncherAmmoType)SeedsLauncherAmmoType.getAmmoType(lookup, itemStack.getItem()).value();
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.seeds_launcher.ammo").withStyle(ChatFormatting.GRAY));
            String damage = Math.round((type.damageMultiplier() - 1.0f) * 100.0f) + "%";
            if (!damage.startsWith("-")) {
                damage = "+" + damage;
            }
            if (!(speed = Math.round((type.speedMultiplier() - 1.0f) * 100.0f) + "%").startsWith("-")) {
                speed = "+" + speed;
            }
            if (!damage.equals("+0%")) {
                tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.eternal_starlight.seeds_launcher.damage_multiplier", (Object[])new Object[]{damage}).withStyle(damage.startsWith("-") ? ChatFormatting.RED : ChatFormatting.BLUE)));
            }
            if (!speed.equals("+0%")) {
                tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.eternal_starlight.seeds_launcher.speed_multiplier", (Object[])new Object[]{speed}).withStyle(speed.startsWith("-") ? ChatFormatting.RED : ChatFormatting.BLUE)));
            }
            tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.eternal_starlight.seeds_launcher.cooldown", (Object[])new Object[]{Float.valueOf(type.cooldown())}).withStyle(ChatFormatting.DARK_GREEN)));
        }
        if (itemStack.is(ESItems.UNDERMINER.get())) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.eternal_starlight.underminer").withColor(4697540));
        }
    }

    public static float onModifyLivingActualHurtDamage(LivingEntity entity, DamageSource source, float amount) {
        float modified = amount;
        Set<Item> activeAccessories = ESAccessoryUtil.getActiveAccessoriesOnArmors(entity);
        if (activeAccessories.contains(ESItems.CRESCENT_PENDANT.get()) && !source.is(ESTags.DamageTypes.BYPASSES_CRESCENT_PENDANT) && modified > entity.getMaxHealth() * 0.75f) {
            modified = entity.getMaxHealth() * 0.75f;
        }
        if (entity.hasEffect(ESMobEffects.NUMBNESS.asHolder())) {
            ESDataAttachments.NUMBNESS_DAMAGE.setData((Entity)entity, Float.valueOf(ESDataAttachments.NUMBNESS_DAMAGE.getData((Entity)entity).floatValue() + modified * 0.75f));
            modified *= 0.25f;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return Math.max(amount, modified);
        }
        return modified;
    }

    public static float onModifyLivingHurtDamage(LivingEntity entity, DamageSource source, float amount) {
        LivingEntity attacker;
        Entity entity2;
        float modified = amount;
        Entity sourceEntity = source.getEntity();
        if (sourceEntity != null) {
            if (sourceEntity.getType() == ESEntities.THE_GATEKEEPER.get()) {
                modified *= 1.0f + (float)Mth.clamp((int)ESDataAttachments.GATEKEEPER_CHALLENGE_COUNT.getData((Entity)entity), (int)0, (int)40) * 0.05f;
            }
            if (sourceEntity.getType() == ESEntities.STARLIGHT_GOLEM.get()) {
                modified *= (float)ESConfig.INSTANCE.mobsConfig.starlightGolem.attackDamageScale();
            }
            if (sourceEntity.getType() == ESEntities.LUNAR_MONSTROSITY.get()) {
                modified *= (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale();
            }
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            AttributeInstance resistance;
            MobEffectInstance instance;
            if (entity.hasEffect(ESMobEffects.FLAMMABLE.asHolder()) && (instance = entity.getEffect(ESMobEffects.FLAMMABLE.asHolder())) != null) {
                modified *= (float)(instance.getAmplifier() + 2);
            }
            if ((resistance = entity.getAttribute(ESAttributes.FIRE_RESISTANCE.asHolder())) != null) {
                modified *= 1.0f - (float)resistance.getValue();
            }
        }
        if ((entity2 = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity2).getWeaponItem().is(ESTags.Items.FLOWGLAZE_WEAPONS) && entity == ESDataAttachments.CONCENTRATED_TARGET.getData((Entity)attacker) && attacker.getWeaponItem() == ESDataAttachments.CONCENTRATED_WEAPON.getData((Entity)attacker) && ESDataAttachments.CONCENTRATION_LEVEL.getData((Entity)attacker) >= 4) {
            modified *= 1.25f;
        }
        if ((entity2 = source.getDirectEntity()) instanceof LivingEntity && ESAccessoryUtil.getAccessories((attacker = (LivingEntity)entity2).getWeaponItem()).contains(ESItems.WARHAMMER_PENDANT.get())) {
            modified *= Math.min(1.0f + (float)ESDataAttachments.MOVEMENT.getData((Entity)attacker).length() * 1.5f, 2.0f);
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return Math.max(amount, modified);
        }
        return modified;
    }

    public static void onPostLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        Entity inEtherTicks;
        Player player;
        Entity inEtherTicks22;
        int inEtherTicks22;
        Entity living3;
        LivingEntity attacker;
        Object serverLevel;
        LivingEntity livingEntity;
        Entity entity2;
        AttributeInstance meteorChance;
        Object serverLevel2;
        LivingEntity attacker2;
        LivingEntity livingEntity2;
        Entity entity3;
        if ((entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ThermalSpringstoneArmorItem || entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ThermalSpringstoneArmorItem) && (entity3 = source.getDirectEntity()) instanceof LivingEntity) {
            livingEntity2 = (LivingEntity)entity3;
            livingEntity2.setRemainingFireTicks(livingEntity2.getRemainingFireTicks() + 200);
        }
        if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker2 = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.THERMAL_SPRINGSTONE_WEAPONS)) {
            entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 200);
        }
        if ((entity.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof GlaciteArmorItem || entity.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof GlaciteArmorItem) && (entity3 = source.getDirectEntity()) instanceof LivingEntity) {
            livingEntity2 = (LivingEntity)entity3;
            livingEntity2.setTicksFrozen(Math.min(livingEntity2.getTicksFrozen() + 80, 300));
        }
        if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker2 = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.GLACITE_WEAPONS) && entity.canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 80, 300));
        }
        if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker2 = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.MALARITE_WEAPONS)) {
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
        }
        if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker2 = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.PUNGENCY_FRUIT_WEAPONS)) {
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 120));
        }
        if ((entity3 = source.getDirectEntity()) instanceof LivingEntity && (attacker2 = (LivingEntity)entity3).getWeaponItem().is(ESTags.Items.STARFIRE_WEAPONS)) {
            entity.addEffect(new MobEffectInstance(ESMobEffects.STARFIRE.asHolder(), 60));
            Level level = attacker2.level();
            if (level instanceof ServerLevel) {
                serverLevel2 = (ServerLevel)level;
                ThrownStarfire.createExplosionParticles((ServerLevel)serverLevel2, entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0), 5, 0.25);
            }
            attacker2.level().playSound(null, attacker2.blockPosition(), ESSoundEvents.STARFIRE_WHOOSH.get(), attacker2.getSoundSource());
        }
        if ((serverLevel2 = source.getDirectEntity()) instanceof LivingEntity && !((attacker2 = (LivingEntity)serverLevel2) instanceof Player)) {
            CommonHandlers.handleFlowglazeWeaponAttack(attacker2, entity);
        }
        if ((meteorChance = entity.getAttribute(ESAttributes.METEOR_COUNTERATTACK_CHANCE.asHolder())) != null && entity.getRandom().nextDouble() < meteorChance.getValue() && (entity2 = source.getEntity()) instanceof LivingEntity && (entity2 = (livingEntity = (LivingEntity)entity2).level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)entity2;
            Vec3 location = livingEntity.position();
            AethersentMeteor.createMeteorShower((Level)serverLevel, entity, livingEntity, location.x, location.y, location.z, 30.0);
        }
        if ((serverLevel = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)serverLevel).getWeaponItem().is(ESItems.PETAL_SCYTHE.get())) {
            Level living22;
            for (Level living22 : entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(2.5))) {
                if (living22 == attacker) continue;
                living22.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1));
            }
            living22 = attacker.level();
            if (living22 instanceof ServerLevel) {
                serverLevel = (ServerLevel)living22;
                Vec3 vec3 = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
                serverLevel.sendParticles((ParticleOptions)ESSmokeParticleOptions.LUNAR_ATTACK, vec3.x, vec3.y, vec3.z, 10, 1.5 * ((double)serverLevel.getRandom().nextFloat() - 0.5), 1.5 * ((double)serverLevel.getRandom().nextFloat() - 0.5), 1.5 * ((double)serverLevel.getRandom().nextFloat() - 0.5), 0.1 * ((double)serverLevel.getRandom().nextFloat() - 0.5));
            }
        }
        if (entity.hasEffect(ESMobEffects.STARFIRE.asHolder()) && !source.is(ESDamageTypes.STARFIRE)) {
            serverLevel = entity.level();
            if (serverLevel instanceof ServerLevel) {
                serverLevel2 = (ServerLevel)serverLevel;
                ThrownStarfire.createExplosionParticles((ServerLevel)serverLevel2, entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0), 6, 0.75);
            }
            for (Entity living3 : entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(3.0))) {
                if (!ESEntityUtil.shouldHarm(source.getEntity(), living3)) continue;
                living3.hurt(ESDamageTypes.getIndirectEntityDamageSource(entity.level(), ESDamageTypes.STARFIRE, source.getDirectEntity(), source.getEntity()), amount / 3.0f);
            }
        }
        if (ESAccessoryUtil.getActiveAccessoriesOnArmors(entity).contains(ESItems.BUTTERFLY_WINGS_AMULET.get()) && (living3 = source.getEntity()) instanceof LivingEntity && (inEtherTicks22 = ESDataAttachments.IN_ETHER_TICKS.getData((Entity)(attacker = (LivingEntity)living3)).intValue()) < 600) {
            ESDataAttachments.IN_ETHER_TICKS.setData((Entity)attacker, Math.min(inEtherTicks22 + 200, 600));
        }
        if ((inEtherTicks22 = source.getEntity()) instanceof LivingEntity && ESAccessoryUtil.getActiveAccessoriesOnArmors(attacker = (LivingEntity)inEtherTicks22).contains(ESItems.BUTTERFLY_WINGS_AMULET.get()) && (inEtherTicks = ESDataAttachments.IN_ETHER_TICKS.getData((Entity)entity).intValue()) < 600) {
            ESDataAttachments.IN_ETHER_TICKS.setData((Entity)entity, Math.min(inEtherTicks + 200, 600));
        }
        if (entity instanceof Player && (player = (Player)entity).level().getBiome(player.blockPosition()).is(ESBiomes.THE_ABYSS) && player.isEyeInFluid(FluidTags.WATER) && player.getAirSupply() > 0) {
            player.setAirSupply(Math.max(player.getAirSupply() - 30, 0));
        }
        if ((inEtherTicks = source.getDirectEntity()) instanceof Player && (player = (Player)inEtherTicks).getRandom().nextInt(15) == 0) {
            Inventory inventory = player.getInventory();
            boolean hasCrystals = false;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (!inventory.getItem(i).is(ESTags.Items.MANA_CRYSTALS)) continue;
                hasCrystals = true;
            }
            if (hasCrystals) {
                ItemEntity itemEntity = new ItemEntity(player.level(), entity.getX(), entity.getY(), entity.getZ(), ESItems.MANA_CRYSTAL_SHARD.get().getDefaultInstance());
                player.level().addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static float onLivingHeal(LivingEntity entity, float amount) {
        float modified = amount;
        AttributeInstance healMultiplier = entity.getAttribute(ESAttributes.HEAL_MULTIPLIER.asHolder());
        if (healMultiplier != null) {
            modified *= (float)healMultiplier.getValue();
        }
        return modified;
    }

    public static void handleFlowglazeWeaponAttack(LivingEntity attacker, LivingEntity entity) {
        if (attacker.getWeaponItem().is(ESTags.Items.FLOWGLAZE_WEAPONS)) {
            ItemStack stack = attacker.getWeaponItem();
            if (entity == ESDataAttachments.CONCENTRATED_TARGET.getData((Entity)attacker) && stack == ESDataAttachments.CONCENTRATED_WEAPON.getData((Entity)attacker)) {
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.setData((Entity)attacker, attacker.tickCount);
                ESDataAttachments.CONCENTRATION_LEVEL.setData((Entity)attacker, Math.min(ESDataAttachments.CONCENTRATION_LEVEL.getData((Entity)attacker) + 1, 4));
            } else {
                ESDataAttachments.CONCENTRATED_TARGET.setData((Entity)attacker, entity);
                ESDataAttachments.CONCENTRATED_WEAPON.setData((Entity)attacker, stack);
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.setData((Entity)attacker, attacker.tickCount);
                ESDataAttachments.CONCENTRATION_LEVEL.setData((Entity)attacker, 0);
            }
        }
    }

    public static boolean onAllowLivingDeath(LivingEntity entity, DamageSource source) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Entity entity2 = source.getEntity();
            if (entity2 instanceof TheGatekeeper) {
                TheGatekeeper gatekeeper = (TheGatekeeper)entity2;
                gatekeeper.abortFight();
                player.setHealth(Math.max(player.getHealth(), player.getMaxHealth() * 0.1f));
                player.invulnerableTime = 200;
                Level level = entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    RandomSource random = serverLevel.getRandom();
                    for (int i = 0; i <= 25; ++i) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.DEATH, player.getX() + (double)((random.nextFloat() - 0.5f) * player.getBbWidth() * 3.0f), player.getY(), player.getZ() + (double)((random.nextFloat() - 0.5f) * player.getBbWidth() * 3.0f), 0.0, 1.0, 0.0));
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static void onLivingDeath(LivingEntity entity, DamageSource source) {
        Entity entity2;
        if (entity.hasEffect(ESMobEffects.STARFIRE.asHolder())) {
            for (LivingEntity living : entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(3.0))) {
                MobEffectInstance instance;
                if (living == entity || living == source.getDirectEntity() || (instance = entity.getEffect(ESMobEffects.STARFIRE.asHolder())) == null) continue;
                living.addEffect(new MobEffectInstance(ESMobEffects.STARFIRE.asHolder(), Math.max(instance.getDuration() / 2, 20)));
            }
        }
        if ((entity2 = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            ESBookUtil.unlock(player, BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).withPrefix("entity_killed_"));
        }
    }

    public static LivingEntity onLivingChangeTarget(LivingEntity entity, LivingEntity newTarget) {
        int tearyTicks;
        if (newTarget != null && entity.hasEffect(ESMobEffects.TEARY.asHolder()) && (tearyTicks = ESDataAttachments.TEARY_TICKS.getData((Entity)entity).intValue()) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
            return null;
        }
        return newTarget;
    }

    public static int onLivingDecreaseAirSupply(LivingEntity entity) {
        if (entity.getItemBySlot(EquipmentSlot.HEAD).is(ESItems.AIR_SAC_MASK.asHolder())) {
            if (entity.isSwimming()) {
                return entity.getRandom().nextBoolean() ? -1 : 0;
            }
            if (ESDataAttachments.MOVEMENT.getData((Entity)entity).multiply(1.0, 0.0, 1.0).length() < 0.01) {
                return 1;
            }
        }
        return 0;
    }

    public static void onEntityTick(Entity entity) {
        int inAbyssalFireTicks;
        ItemStack copy;
        Level level = entity.level();
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (!level.isClientSide) {
                if (item.tickCount % 100 == 0 && ESBlockUtil.isEntityInBlock((Entity)item, (Block)ESBlocks.ETHER.get())) {
                    ItemStack content = item.getItem();
                    if (content.is(ConventionalTags.Items.MUSIC_DISCS) && !content.is(ESItems.MUSIC_DISC_SPIRIT.get())) {
                        item.setItem(ESItems.MUSIC_DISC_SPIRIT.get().getDefaultInstance());
                        item.addDeltaMovement(new Vec3(0.0, 0.75, 0.0));
                        level.playSound(null, item.blockPosition(), ESSoundEvents.ETHER_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (content.is(ESItems.STARLIT_PAINTING.get())) {
                        data = (CustomData)content.get(DataComponents.ENTITY_DATA);
                        if (data != null) {
                            Holder variant = (Holder)data.read((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapDecoder)Painting.VARIANT_MAP_CODEC).getOrThrow();
                            CustomData newData = null;
                            if (variant.is(ESPaintingVariants.ENERGIZED)) {
                                newData = (CustomData)data.update((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapEncoder)Painting.VARIANT_MAP_CODEC, (Object)level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getHolderOrThrow(ESPaintingVariants.ENERGIZED_SPECIAL)).getOrThrow();
                            } else if (variant.is(ESPaintingVariants.MONSTROUS)) {
                                newData = (CustomData)data.update((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapEncoder)Painting.VARIANT_MAP_CODEC, (Object)level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getHolderOrThrow(ESPaintingVariants.MONSTROUS_SPECIAL)).getOrThrow();
                            }
                            if (newData != null) {
                                copy = content.copy();
                                copy.set(DataComponents.ENTITY_DATA, newData);
                                item.setItem(copy);
                                item.addDeltaMovement(new Vec3(0.0, 0.75, 0.0));
                            }
                        }
                        level.playSound(null, item.blockPosition(), ESSoundEvents.ETHER_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (content.is(ESTags.Items.ACCESSORIES)) {
                        item.setItem(ESItems.BUTTERFLY_WINGS_AMULET.get().getDefaultInstance());
                        item.addDeltaMovement(new Vec3(0.0, 0.75, 0.0));
                        level.playSound(null, item.blockPosition(), ESSoundEvents.ETHER_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else if (item.getItem().is(ESTags.Items.MANA_CRYSTALS) || item.getItem().getItem() == ESItems.MANA_CRYSTAL_SHARD.get()) {
                ManaType manaType;
                ClientHelper clientHelper = EternalStarlight.getClientHelper();
                data = item.getItem().getItem();
                if (data instanceof ManaCrystalItem) {
                    ManaCrystalItem crystalItem = (ManaCrystalItem)((Object)data);
                    manaType = crystalItem.getManaType();
                } else {
                    manaType = ManaType.LUNAR;
                }
                clientHelper.spawnManaCrystalItemParticles(manaType, item.position().add(0.0, (double)(item.getBbHeight() / 2.0f), 0.0));
            }
        }
        if (!level.isClientSide && (inAbyssalFireTicks = ESDataAttachments.IN_ABYSSAL_FIRE_TICKS.getData(entity).intValue()) > 0) {
            ESDataAttachments.IN_ABYSSAL_FIRE_TICKS.setData(entity, inAbyssalFireTicks - 1);
        }
        if (!level.isClientSide && entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.getPickupItemStackOrigin().has(ESDataComponents.QUIVER_ARROW.get())) {
                arrow.getPickupItemStackOrigin().remove(ESDataComponents.QUIVER_ARROW.get());
            }
            if (!arrow.inGround) {
                float previousExtra;
                if (ESDataAttachments.ARROW_TYPE.getData((Entity)arrow).equals(FLOWGLAZE_ARROW) && (previousExtra = ESDataAttachments.FLOWGLAZE_ARROW_EXTRA_BASE_DAMAGE.getData((Entity)arrow).floatValue()) < 3.0f) {
                    arrow.setBaseDamage(arrow.getBaseDamage() + 0.1);
                    ESDataAttachments.FLOWGLAZE_ARROW_EXTRA_BASE_DAMAGE.setData((Entity)arrow, Float.valueOf(previousExtra + 0.1f));
                }
                if (ESDataAttachments.ARROW_TYPE.getData((Entity)arrow).equals(WILTED_ARROW)) {
                    List affected = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(5.0));
                    affected.removeIf(e -> !ESEntityUtil.shouldHarm(arrow.getOwner(), (Entity)e));
                    for (LivingEntity living : affected) {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80));
                        living.addEffect(new MobEffectInstance(MobEffects.WITHER, entity.isInWater() ? 300 : 160));
                    }
                    if (arrow.tickCount % 4 == 0) {
                        for (int i = 0; i < 3; ++i) {
                            WiltedPetal wiltedPetal;
                            copy = arrow.getOwner();
                            if (copy instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)copy;
                                wiltedPetal = new WiltedPetal(level, living);
                            } else {
                                wiltedPetal = new WiltedPetal(ESEntities.WILTED_PETAL.get(), level);
                            }
                            WiltedPetal petal = wiltedPetal;
                            petal.setPos(entity.position());
                            Vec3 movement = new Vec3((double)entity.getRandom().nextFloat() - 0.5, (double)entity.getRandom().nextFloat() - 0.5, (double)entity.getRandom().nextFloat() - 0.5);
                            if (affected.size() > i) {
                                LivingEntity target = (LivingEntity)affected.get(i);
                                movement = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(entity.position());
                            }
                            petal.shoot(movement.x, movement.y, movement.z, 0.8f, 0.2f);
                            level.addFreshEntity((Entity)petal);
                        }
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)96, (int)9437243)), entity.getX(), entity.getY(), entity.getZ(), 6, 2.0, 2.0, 2.0, 0.2);
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            Item serverLevel;
            LivingEntity livingEntity = (LivingEntity)entity;
            ESSpellUtil.tickSpells(livingEntity);
            SpecialItemCooldown.tick((Entity)livingEntity);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!level.isClientSide) {
                    ESCrestUtil.tickCrests(player);
                    if (level.getBiome(player.blockPosition()).is(ESBiomes.THE_ABYSS) && player.isEyeInFluid(FluidTags.WATER) && player.getY() < 0.0) {
                        int maxAir = Math.max((int)Math.round(((double)player.getMaxAirSupply() + player.getY() * 3.0) / 30.0) * 30 - 15, 0);
                        if (player.getAirSupply() > maxAir) {
                            player.setAirSupply(maxAir);
                        }
                    }
                    if (ESAccessoryUtil.getActiveAccessoriesOnArmors((LivingEntity)player).contains(ESItems.PEARL_NECKLACE.get()) && !player.isEyeInFluid(FluidTags.WATER)) {
                        player.setAirSupply(player.getMaxAirSupply());
                    }
                    Inventory inventory = player.getInventory();
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        if (!inventory.getItem(i).has(ESDataComponents.QUIVER_ARROW.get())) continue;
                        inventory.getItem(i).remove(ESDataComponents.QUIVER_ARROW.get());
                    }
                    if (player.getMainHandItem().is(ESItems.GRAVITY_PICKAXE.get()) || player.getOffhandItem().is(ESItems.GRAVITY_PICKAXE.get())) {
                        for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(5.0))) {
                            itemEntity.playerTouch(player);
                        }
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (player.tickCount % 200 == 0) {
                            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                                ItemStack inventoryItem = inventory.getItem(i);
                                if (inventoryItem.isEmpty()) continue;
                                ESBookUtil.unlock(serverPlayer, BuiltInRegistries.ITEM.getKey((Object)inventoryItem.getItem()).withPrefix("item_"));
                            }
                        }
                        ServerPlayerGameMode gameMode = serverPlayer.gameMode;
                        serverLevel = serverPlayer.serverLevel();
                        if (gameMode.isDestroyingBlock && serverPlayer.getMainHandItem().is(ESTags.Items.FLOWGLAZE_WEAPONS)) {
                            BlockPos oldTarget = ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.getData((Entity)serverPlayer);
                            if (oldTarget != null && !oldTarget.equals((Object)gameMode.destroyPos)) {
                                ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.setData((Entity)serverPlayer, 0);
                            }
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.setData((Entity)serverPlayer, gameMode.destroyPos);
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.setData((Entity)serverPlayer, ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.getData((Entity)serverPlayer) + 1);
                            BlockState destroyState = serverLevel.getBlockState(gameMode.destroyPos);
                            if (ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.getData((Entity)serverPlayer) >= 100 && destroyState.getDestroyProgress((Player)serverPlayer, (BlockGetter)serverLevel, gameMode.destroyPos) > 0.0f && (!destroyState.requiresCorrectToolForDrops() || serverPlayer.getMainHandItem().isCorrectToolForDrops(destroyState))) {
                                int id = Block.getId((BlockState)destroyState);
                                gameMode.destroyBlock(gameMode.destroyPos);
                                for (int i = 0; i < serverLevel.players().size(); ++i) {
                                    ((ServerPlayer)serverLevel.players().get((int)i)).connection.send((Packet)new ClientboundLevelEventPacket(2001, gameMode.destroyPos, id, false));
                                }
                            }
                        } else if (ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.hasData((Entity)serverPlayer) || ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.hasData((Entity)serverPlayer)) {
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.removeData((Entity)serverPlayer);
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.removeData((Entity)serverPlayer);
                        }
                    }
                }
            }
            if (ESDataAttachments.CONCENTRATION_LEVEL.getData((Entity)livingEntity) > 0 && (livingEntity.tickCount - ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.getData((Entity)livingEntity) > 100 || livingEntity.getWeaponItem() != ESDataAttachments.CONCENTRATED_WEAPON.getData((Entity)livingEntity))) {
                ESDataAttachments.CONCENTRATED_TARGET.removeData((Entity)livingEntity);
                ESDataAttachments.CONCENTRATED_WEAPON.removeData((Entity)livingEntity);
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.removeData((Entity)livingEntity);
                ESDataAttachments.CONCENTRATION_LEVEL.removeData((Entity)livingEntity);
            }
            List<ItemStack> armors = List.of(livingEntity.getItemBySlot(EquipmentSlot.HEAD), livingEntity.getItemBySlot(EquipmentSlot.CHEST), livingEntity.getItemBySlot(EquipmentSlot.LEGS), livingEntity.getItemBySlot(EquipmentSlot.FEET));
            for (ItemStack armor : armors) {
                serverLevel = armor.getItem();
                if (!(serverLevel instanceof TickableArmor)) continue;
                TickableArmor tickableArmor = (TickableArmor)serverLevel;
                tickableArmor.tick(level, livingEntity, armor);
            }
            AttributeInstance armorAttribute = livingEntity.getAttributes().getInstance(Attributes.ARMOR);
            if (armorAttribute != null) {
                if (livingEntity.getItemBySlot(EquipmentSlot.HEAD).is(ESItems.AMARAMBER_MASK.get()) && livingEntity.getItemBySlot(EquipmentSlot.CHEST).is(ESItems.AMARAMBER_CHESTPLATE.get()) && livingEntity.getItemBySlot(EquipmentSlot.LEGS).isEmpty() && livingEntity.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                    if (!armorAttribute.hasModifier(AMARAMBER_BONUS.id())) {
                        armorAttribute.addPermanentModifier(AMARAMBER_BONUS);
                    }
                } else if (armorAttribute.hasModifier(AMARAMBER_BONUS.id())) {
                    armorAttribute.removeModifier(AMARAMBER_BONUS.id());
                }
            }
            int inEtherTicks = ESDataAttachments.IN_ETHER_TICKS.getData(entity);
            AttributeInstance armorInstance = livingEntity.getAttributes().getInstance(Attributes.ARMOR);
            boolean inEther = ESDataAttachments.IN_ETHER.getData(entity);
            if (!level.isClientSide) {
                int tearyTicks;
                int hireCooldown;
                int meteorCooldown = ESDataAttachments.METEOR_COOLDOWN.getData(entity);
                if (meteorCooldown > 0) {
                    ESDataAttachments.METEOR_COOLDOWN.setData(entity, meteorCooldown - 1);
                }
                if ((hireCooldown = ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.getData(entity).intValue()) > 0) {
                    ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.setData(entity, hireCooldown - 1);
                }
                if (livingEntity.hasEffect(ESMobEffects.TEARY.asHolder()) && level instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level;
                    serverLevel2.sendParticles((ParticleOptions)ParticleTypes.FALLING_WATER, livingEntity.getX() + (double)livingEntity.getBbWidth() * ((double)livingEntity.getRandom().nextFloat() - 0.5), livingEntity.getEyeY(), livingEntity.getZ() + (double)livingEntity.getBbWidth() * ((double)livingEntity.getRandom().nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
                }
                if (!livingEntity.getType().is(ESTags.EntityTypes.TEARY_IMMUNE) && livingEntity.hasEffect(ESMobEffects.TEARY.asHolder()) && (tearyTicks = ESDataAttachments.TEARY_TICKS.getData(entity).intValue()) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
                    Mob mob;
                    if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).getTarget() != null) {
                        mob.setTarget(null);
                        mob.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                        mob.getNavigation().stop();
                        mob.setLastHurtByMob(null);
                    }
                    ESDataAttachments.TEARY_TICKS.setData(entity, tearyTicks + 1);
                }
                if (inEther) {
                    float factor = 0.0f;
                    AttributeInstance resistance = livingEntity.getAttribute(ESAttributes.ETHER_RESISTANCE.asHolder());
                    if (resistance != null) {
                        factor = 1.0f - (float)resistance.getValue();
                    }
                    if (armorInstance != null && armorInstance.getValue() <= 0.0 && entity.hurt(ESDamageTypes.getDamageSource(level, ESDamageTypes.ETHER), 0.3f + 0.6f * factor) && level instanceof ServerLevel) {
                        ServerLevel serverLevel3 = (ServerLevel)level;
                        for (int i = 0; i < 5; ++i) {
                            serverLevel3.sendParticles((ParticleOptions)ESParticles.STARLIGHT.get(), entity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + (double)entity.getBbHeight() / 2.0 + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbHeight(), entity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), 20, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                    if ((armorInstance == null || armorInstance.getValue() > 0.0 || inEtherTicks < 140) && livingEntity.getRandom().nextFloat() <= factor) {
                        ESDataAttachments.IN_ETHER_TICKS.setData(entity, inEtherTicks + 1);
                    }
                    ESDataAttachments.IN_ETHER.setData(entity, false);
                }
                if (!inEther && inEtherTicks > 0) {
                    ESDataAttachments.IN_ETHER_TICKS.setData(entity, inEtherTicks - 1);
                }
                if (inEtherTicks <= 0 && armorInstance != null) {
                    armorInstance.removeModifier(EtherFluid.ARMOR_MODIFIER_ID);
                }
                if (livingEntity.tickCount % 20 == 0 && inEtherTicks > 0 && armorInstance != null) {
                    armorInstance.removeModifier(EtherFluid.ARMOR_MODIFIER_ID);
                    armorInstance.addPermanentModifier(EtherFluid.armorModifier((float)(-inEtherTicks) / 100.0f));
                }
            }
        }
    }

    public static void onCriticalHit(Player player, Entity target, float attackStrength) {
        Item item;
        if (player.getWeaponItem().is(ESTags.Items.HAMMERS) && (item = player.getWeaponItem().getItem()) instanceof HammerItem) {
            HammerItem hammerItem = (HammerItem)item;
            if (attackStrength > 0.9f) {
                hammerItem.performCriticalAttack(player, target);
            }
        }
    }

    public static void onBlockBroken(Player player, BlockPos pos, BlockState state) {
        if (state.is(BlockTags.LEAVES) && player.level().dimension() == ESDimensions.STARLIGHT_KEY) {
            float chance;
            float f = player.getName().getString().toLowerCase(Locale.ROOT).contains("nuttar") ? (ESDataAttachments.OBTAINED_BLOSSOM_OF_STARS.getData((Entity)player).booleanValue() ? 2.5f : 25.0f) : (chance = 0.0025f);
            if (player.getRandom().nextFloat() < chance / 100.0f) {
                ESDataAttachments.OBTAINED_BLOSSOM_OF_STARS.setData((Entity)player, true);
                if (!player.getInventory().add(ESItems.BLOSSOM_OF_STARS.get().getDefaultInstance())) {
                    player.spawnAtLocation((ItemLike)ESItems.BLOSSOM_OF_STARS.get());
                }
            }
        }
    }

    public static float onBlockBreakSpeed(Player player, BlockState state, float speed) {
        if (player.getMainHandItem().is(ESItems.UNDERMINER.get())) {
            int min = player.level().getMinBuildHeight();
            int max = player.level().getMaxBuildHeight();
            double y = Mth.clamp((double)player.getY(), (double)min, (double)max);
            float modifier = (float)(2.0 - 1.75 * (y - (double)min) / (double)(max - min));
            return speed * modifier;
        }
        return speed;
    }

    public static void onShieldBlock(LivingEntity blocker, DamageSource source) {
        LivingEntity entity;
        Entity entity2;
        if (blocker.getUseItem().is(ESItems.GLACITE_SHIELD.get()) && (entity2 = source.getDirectEntity()) instanceof LivingEntity && (entity = (LivingEntity)entity2).canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 100, 300));
        }
    }

    public static void onProjectileImpact(Projectile projectile, HitResult result) {
        Level level = projectile.level();
        if (level instanceof ServerLevel) {
            EntityHitResult entityHitResult;
            Entity level22;
            Entity living2;
            ServerLevel serverLevel = (ServerLevel)level;
            if (ESDataAttachments.ARROW_TYPE.getData((Entity)projectile).equals(STARFIRE_ARROW)) {
                if (result.getType() == HitResult.Type.BLOCK) {
                    ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "");
                }
                ThrownStarfire.createExplosionParticles(serverLevel, projectile.position(), 10, 0.25);
                for (Entity living2 : projectile.level().getEntitiesOfClass(LivingEntity.class, projectile.getBoundingBox().inflate(3.0))) {
                    if (!ESEntityUtil.shouldHarm(projectile.getOwner(), living2)) continue;
                    living2.addEffect(new MobEffectInstance(ESMobEffects.STARFIRE.asHolder(), 200));
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((Entity)projectile).equals(CRYSTAL_ARROW)) {
                EntityHitResult entityHitResult2;
                BlockPos startPos;
                if (result.getType() == HitResult.Type.BLOCK) {
                    ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "");
                }
                for (int i = 0; i < 5; ++i) {
                    BlockHitResult toGround;
                    Vec3 pos = projectile.position().offsetRandom(projectile.getRandom(), 4.0f);
                    startPos = BlockPos.containing((Position)pos);
                    for (int currentDiff = 0; !serverLevel.getBlockState(startPos).isAir() && currentDiff < 40; ++currentDiff) {
                        startPos = startPos.above();
                    }
                    if (!serverLevel.getBlockState(startPos).isAir() || (toGround = serverLevel.clip(new ClipContext(startPos.getCenter(), startPos.getCenter().subtract(0.0, 128.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)projectile))).getType() == HitResult.Type.MISS) continue;
                    CrystalCluster cluster = new CrystalCluster(ESEntities.CRYSTAL_CLUSTER.get(), (Level)serverLevel);
                    cluster.setPos(toGround.getLocation());
                    Entity entity = projectile.getOwner();
                    if (entity instanceof LivingEntity) {
                        LivingEntity owner = (LivingEntity)entity;
                        cluster.setOwner(owner);
                    }
                    cluster.setYRot(Mth.wrapDegrees((float)(projectile.getRandom().nextFloat() * 360.0f)));
                    serverLevel.addFreshEntity((Entity)cluster);
                }
                if (result.getType() == HitResult.Type.ENTITY && result instanceof EntityHitResult && (startPos = (entityHitResult2 = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                    MobEffectInstance instance;
                    living2 = (LivingEntity)startPos;
                    int level22 = 0;
                    if (living2.hasEffect(ESMobEffects.CRYSTAL_INFECTION.asHolder()) && (instance = living2.getEffect(ESMobEffects.CRYSTAL_INFECTION.asHolder())) != null) {
                        level22 = Math.min(instance.getAmplifier() + 1, 4);
                    }
                    living2.addEffect(new MobEffectInstance(ESMobEffects.CRYSTAL_INFECTION.asHolder(), 200, level22));
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((Entity)projectile).equals(MECHANICAL_ARROW) && result.getType() == HitResult.Type.ENTITY && result instanceof EntityHitResult && (level22 = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                living2 = (LivingEntity)level22;
                ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "");
                Entity owner = projectile.getOwner();
                ItemStack weapon = projectile.getWeaponItem();
                if (owner instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)owner;
                    if (weapon != null && !SpecialItemCooldown.isOnCooldown(owner, weapon.getItem())) {
                        for (int i = 0; i < owner.getRandom().nextInt(5, 8); ++i) {
                            EnergySpark spark = new EnergySpark((Level)serverLevel, attacker);
                            spark.setPos(living2.position().add(0.0, (double)(living2.getBbHeight() / 2.0f), 0.0));
                            spark.setTarget((LivingEntity)living2);
                            Vec3 movement = new Vec3((double)owner.getRandom().nextFloat() - 0.5, (double)owner.getRandom().nextFloat() - 0.5, (double)owner.getRandom().nextFloat() - 0.5);
                            spark.shoot(movement.x, movement.y, movement.z, 0.1f, 0.2f);
                            serverLevel.addFreshEntity((Entity)spark);
                        }
                        SpecialItemCooldown.setCooldown(owner, weapon.getItem(), 75);
                    }
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((Entity)projectile).equals(STARFALL_ARROW) && (living2 = projectile.getOwner()) instanceof LivingEntity) {
                LivingEntity livingEntity;
                EntityHitResult entityHitResult3;
                Entity entity;
                LivingEntity owner = (LivingEntity)living2;
                ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "");
                Vec3 location = result.getLocation();
                AethersentMeteor.createMeteorShower((Level)serverLevel, owner, result instanceof EntityHitResult && (entity = (entityHitResult3 = (EntityHitResult)result).getEntity()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null, location.x, location.y, location.z, 30.0);
            }
        }
    }

    public static void onPlayerNaturalWake(ServerPlayer serverPlayer, BlockPos pos) {
    }

    public static void onCompleteAdvancement(Player player, AdvancementHolder advancement) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ESBookUtil.unlock(serverPlayer, advancement.id().withPrefix("advancement_"));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void onC2sNoParamPacket(ServerPlayer player, String id) {
        var2_2 = id;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 1570723308: {
                if (!var2_2.equals("switch_crest")) break;
                var3_3 = 0;
            }
        }
        switch (var3_3) {
            case 0: {
                crests = ESCrestUtil.getOwnedCrests((Player)player);
                mainHand = player.getMainHandItem();
                offHand = player.getOffhandItem();
                component = null;
                nextCrest = null;
                if (mainHand.has(ESDataComponents.CURRENT_CREST.get())) {
                    component = (Holder)mainHand.get(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = mainHand;
                } else if (offHand.has(ESDataComponents.CURRENT_CREST.get())) {
                    component = (Holder)offHand.get(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = offHand;
                } else {
                    spellItem /* !! */  = mainHand.is(ESItems.ORB_OF_PROPHECY.get()) != false ? mainHand : (offHand.is(ESItems.ORB_OF_PROPHECY.get()) != false ? offHand : null);
                }
                if (component == null) ** GOTO lbl32
                for (i = 0; i < crests.size(); ++i) {
                    if (!crests.get(i).crest().is(component) || i >= crests.size() - 1) continue;
                    for (j = i + 1; j < crests.size(); ++j) {
                        if (!((Crest)crests.get(j).crest().value()).getSpell().isPresent()) continue;
                        nextCrest = crests.get(j).crest();
                        ** GOTO lbl36
                    }
                }
                ** GOTO lbl36
lbl32:
                // 2 sources

                for (Crest.Instance instance : crests) {
                    if (!((Crest)instance.crest().value()).getSpell().isPresent()) continue;
                    nextCrest = instance.crest();
                    break;
                }
lbl36:
                // 4 sources

                if (spellItem /* !! */  == null) break;
                if (nextCrest != null && nextCrest.isBound()) {
                    spellItem /* !! */ .applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.CURRENT_CREST.get(), nextCrest).build());
                    break;
                }
                spellItem /* !! */ .remove(ESDataComponents.CURRENT_CREST.get());
            }
        }
    }

    static {
        ticksSinceLastUpdate = 0;
        AMARAMBER_BONUS = new AttributeModifier(EternalStarlight.id("armor.amaramber_bonus"), 7.0, AttributeModifier.Operation.ADD_VALUE);
    }
}

