/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.attack.LunarThorn;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MoonringBowItem
extends BowItem {
    public MoonringBowItem(Item.Properties properties) {
        super(properties);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Projectile projectile = super.createProjectile(level, shooter, weapon, ammo, isCrit);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.setBaseDamage(arrow.getBaseDamage() + 0.75);
        }
        return projectile;
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int n) {
        super.releaseUsing(itemStack, level, livingEntity, n);
        int k = this.getUseDuration(itemStack, livingEntity) - n;
        float powerForTime = MoonringBowItem.getPowerForTime((int)k);
        if (!level.isClientSide && livingEntity instanceof Player && (double)powerForTime == 1.0) {
            float x = -Mth.sin((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float z = Mth.cos((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ScreenShakeVfx.createInstance((ResourceKey<Level>)livingEntity.level().dimension(), livingEntity.position(), 30.0f, 30, 0.15f, 0.24f, 4.0f, 5.0f).send(serverLevel);
            }
            for (int i = 0; i < 16; ++i) {
                MoonringBowItem.createThorn(level, livingEntity, livingEntity.getX() + (double)(x * (float)i) * 1.5, livingEntity.getY(), livingEntity.getZ() + (double)(z * (float)i) * 1.5, Mth.wrapDegrees((float)(-livingEntity.getYRot())), 40.0, i * 5);
            }
        }
    }

    public static void createThorn(Level level, LivingEntity owner, double x, double y, double z, float yRot, double maxDiff, int delay) {
        BlockPos startPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean successful = false;
        double finalY = y;
        if (level.getBlockState(startPos).isAir()) {
            BlockHitResult result = level.clip(new ClipContext(startPos.getCenter(), startPos.getCenter().add(0.0, -maxDiff, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner));
            if (result.getType() != HitResult.Type.MISS) {
                finalY = result.getLocation().y;
                successful = true;
            }
        } else {
            BlockHitResult result;
            int currentDiff = 0;
            while (!level.getBlockState(startPos).isAir() && (double)currentDiff < maxDiff) {
                startPos = startPos.above();
                ++currentDiff;
            }
            if (level.getBlockState(startPos).isAir() && (result = level.clip(new ClipContext(startPos.getCenter(), startPos.getCenter().add(0.0, -maxDiff, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner))).getType() != HitResult.Type.MISS) {
                finalY = result.getLocation().y;
                successful = true;
            }
        }
        if (successful) {
            LunarThorn thorn = new LunarThorn(ESEntities.LUNAR_THORN.get(), level);
            thorn.setPos(x, finalY, z);
            thorn.setOwner(owner);
            thorn.setSpawnedTicks(-delay);
            thorn.setYRot(yRot);
            level.addFreshEntity((Entity)thorn);
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(ESItems.TENACIOUS_PETAL.get()) || repairCandidate.is(ESItems.TENACIOUS_VINE.get()) || super.isValidRepairItem(stack, repairCandidate);
    }
}

