/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.LunarSpore;
import cn.leolezury.eternalstarlight.common.item.combat.ScytheItem;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PetalScytheItem
extends ScytheItem
implements Swingable {
    public PetalScytheItem(Tier tier, boolean canTill, Item.Properties properties) {
        super(tier, canTill, properties);
    }

    private void performSpecialAttack(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide && !SpecialItemCooldown.isOnCooldown((Entity)entity, (Item)this)) {
            Vec3 shootPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            for (int i = -2; i <= 2; ++i) {
                LunarSpore spore = new LunarSpore(level, entity, shootPos.x, shootPos.y, shootPos.z);
                spore.setNoGravity(true);
                spore.setDeltaMovement(ESMathUtil.rotationToPosition(0.9f, -entity.getViewXRot(0.0f) + 5.0f, entity.getViewYRot(0.0f) + 90.0f + (float)(i * 8)));
                level.addFreshEntity((Entity)spore);
            }
            SpecialItemCooldown.setCooldown((Entity)entity, (Item)this, 100);
        }
    }

    @Override
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        this.performSpecialAttack(attacker);
    }

    @Override
    public void swing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        this.performSpecialAttack(entity);
    }
}

