/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.ShotSeeds;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherAmmoType;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SeedsLauncherItem
extends ProjectileWeaponItem {
    public SeedsLauncherItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack projectile = player.getProjectile(stack);
        boolean success = this.performShooting(level, (LivingEntity)player, projectile, hand);
        if (success) {
            SeedsLauncherAmmoType type = (SeedsLauncherAmmoType)SeedsLauncherAmmoType.getAmmoType((HolderLookup.Provider)level.registryAccess(), projectile.getItem()).value();
            player.getCooldowns().addCooldown((Item)this, type.cooldownAsTicks());
        }
        return success ? InteractionResultHolder.consume((Object)stack) : super.use(level, player, hand);
    }

    public boolean performShooting(Level level, LivingEntity living, ItemStack projectile, InteractionHand hand) {
        List<ItemStack> list;
        ItemStack stack = living.getItemInHand(hand);
        if (!projectile.isEmpty() && !(list = SeedsLauncherItem.draw(stack, projectile, living)).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shoot(serverLevel, living, living.getUsedItemHand(), stack, list, 0.75f, 7.5f, true, null);
                Vec3 particlePos = ESMathUtil.rotationToPosition(living.position().add(0.0, (double)(3.0f * living.getBbHeight() / 4.0f), 0.0), 1.0f, -living.getXRot(), living.getYHeadRot() + 90.0f);
                serverLevel.sendParticles((ParticleOptions)ESParticles.PUNGENCY_FRUIT_SMOKE.get(), particlePos.x(), particlePos.y(), particlePos.z(), 20, 0.1, 0.1, 0.1, 0.025);
                stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)living.getUsedItemHand()));
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected static List<ItemStack> draw(ItemStack weapon, ItemStack ammo, LivingEntity shooter) {
        int n;
        if (ammo.isEmpty()) {
            return List.of();
        }
        Level level = shooter.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            n = EnchantmentHelper.processProjectileCount((ServerLevel)serverlevel, (ItemStack)weapon, (Entity)shooter, (int)6);
        } else {
            n = 6;
        }
        int count = n;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(count);
        ItemStack ammoCopy = ammo.copy();
        for (int i = 0; i < count; ++i) {
            ItemStack itemstack = SeedsLauncherItem.useAmmo((ItemStack)weapon, (ItemStack)(i == 0 ? ammo : ammoCopy), (LivingEntity)shooter, (i > 0 ? 1 : 0) != 0);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
        }
        return list;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.is(ESTags.Items.SEEDS_LAUNCHER_AMMO);
    }

    public int getDefaultProjectileRange() {
        return 5;
    }

    protected int getDurabilityUse(ItemStack itemStack) {
        return 0;
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        return new ShotSeeds(level, shooter, ammo, weapon);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f direction;
        if (target != null) {
            double xDiff = target.getX() - shooter.getX();
            double zDiff = target.getZ() - shooter.getZ();
            double dist = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double yDiff = target.getY(0.3333333333333333) - projectile.getY() + dist * (double)0.2f;
            direction = SeedsLauncherItem.getProjectileShotVector(shooter, new Vec3(xDiff, yDiff, zDiff), angle);
        } else {
            Vec3 upVector = shooter.getUpVector(1.0f);
            Quaternionf rotation = new Quaternionf().setAngleAxis((double)angle * (Math.PI / 180), upVector.x, upVector.y, upVector.z);
            Vec3 viewVector = shooter.getViewVector(1.0f);
            direction = viewVector.toVector3f().rotate((Quaternionfc)rotation);
        }
        float speedMultiplier = 1.0f;
        if (projectile instanceof ShotSeeds) {
            ShotSeeds seeds = (ShotSeeds)projectile;
            SeedsLauncherAmmoType type = (SeedsLauncherAmmoType)SeedsLauncherAmmoType.getAmmoType((HolderLookup.Provider)shooter.level().registryAccess(), seeds.getItem().getItem()).value();
            speedMultiplier *= type.speedMultiplier();
        }
        projectile.shoot((double)direction.x(), (double)direction.y(), (double)direction.z(), velocity * speedMultiplier, inaccuracy);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), ESSoundEvents.SEEDS_LAUNCHER_SHOOT.get(), shooter.getSoundSource(), 1.0f, 1.0f);
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f direction = distance.toVector3f().normalize();
        Vector3f vec = new Vector3f((Vector3fc)direction).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vec.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vec = new Vector3f((Vector3fc)direction).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f rotated = new Vector3f((Vector3fc)direction).rotateAxis(1.5707964f, vec.x, vec.y, vec.z);
        return new Vector3f((Vector3fc)direction).rotateAxis(angle * ((float)Math.PI / 180), rotated.x, rotated.y, rotated.z);
    }
}

