/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.menu;

import cn.leolezury.eternalstarlight.common.registry.ESMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrateMenu
extends AbstractContainerMenu {
    private final Container container;

    public CrateMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(36));
    }

    public CrateMenu(int containerId, Inventory inventory, Container container) {
        super(ESMenuTypes.CRATE.get(), containerId);
        int x;
        int y;
        CrateMenu.checkContainerSize((Container)container, (int)36);
        this.container = container;
        container.startOpen(inventory.player);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot((Slot)new ShulkerBoxSlot(container, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 103 + y * 18));
            }
        }
        for (y = 0; y < 9; ++y) {
            this.addSlot(new Slot((Container)inventory, y, 8 + y * 18, 161));
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemStack = slotItem.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(slotItem, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotItem, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }
}

