/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public int tickCount;
    @Unique
    private boolean feetInWater = false;

    @Shadow
    public abstract boolean isInWater();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract AABB getBoundingBox();

    @Inject(method={"isStateClimbable(Lnet/minecraft/world/level/block/state/BlockState;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isStateClimbable(BlockState blockState, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(ESMobEffects.STICKY.asHolder())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        LivingEntity living;
        this.feetInWater = this.isInWater() && this.level().getFluidState(BlockPos.containing((Position)this.getBoundingBox().getBottomCenter())).is(FluidTags.WATER);
        Entity entity = (Entity)this;
        if (this.level().isClientSide && this.feetInWater && entity instanceof LivingEntity && (living = (LivingEntity)entity).getDeltaMovement().length() > 0.01 && living.getItemBySlot(EquipmentSlot.FEET).is(ESItems.AIR_SAC_BOOTS.get())) {
            Vec3 pos = living.getBoundingBox().getBottomCenter().offsetRandom(living.getRandom(), living.getBbWidth());
            Vec3 speed = living.getDeltaMovement().normalize().offsetRandom(living.getRandom(), 0.3f).scale(-0.2);
            this.level().addParticle((ParticleOptions)ESParticles.ROOKFISH_INK.get(), pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
    }

    @Inject(method={"getGravity()D"}, at={@At(value="RETURN")}, cancellable=true)
    private void getGravity(CallbackInfoReturnable<Double> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.feetInWater && living.getItemBySlot(EquipmentSlot.FEET).is(ESItems.AIR_SAC_BOOTS.get())) {
                cir.setReturnValue((Object)0.0);
            }
        }
    }

    @Inject(method={"checkInsideBlocks()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;entityInside(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V")})
    private void checkInsideBlocks(CallbackInfo ci, @Local(ordinal=0) BlockState state) {
        if (state.getFluidState().is(ESTags.Fluids.ETHER)) {
            ESDataAttachments.IN_ETHER.setData((Entity)this, true);
        }
    }

    @Inject(method={"deflection(Lnet/minecraft/world/entity/projectile/Projectile;)Lnet/minecraft/world/entity/projectile/ProjectileDeflection;"}, at={@At(value="RETURN")}, cancellable=true)
    private void deflection(Projectile projectile, CallbackInfoReturnable<ProjectileDeflection> cir) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).isBlocking() && living.getUseItem().is(ESItems.FLOWGLAZE_SHIELD.get())) {
            Vec3 viewVector = living.calculateViewVector(0.0f, living.getYHeadRot());
            Vec3 offset = projectile.position().vectorTo(living.position());
            offset = new Vec3(offset.x, 0.0, offset.z).normalize();
            if (offset.dot(viewVector) < 0.0) {
                cir.setReturnValue((Object)ProjectileDeflection.AIM_DEFLECT);
            }
        }
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPos(DDD)V", ordinal=1)})
    private void move(MoverType moverType, Vec3 vec3, CallbackInfo ci, @Local(ordinal=1) Vec3 movement) {
        Entity entity = (Entity)this;
        int lastUpdate = ESDataAttachments.LAST_MOVEMENT_UPDATE.getData(entity);
        if (lastUpdate != this.tickCount) {
            ESDataAttachments.MOVEMENT.setData(entity, movement);
            ESDataAttachments.LAST_MOVEMENT_UPDATE.setData(entity, this.tickCount);
        } else {
            ESDataAttachments.MOVEMENT.setData(entity, ESDataAttachments.MOVEMENT.getData(entity).add(movement));
        }
    }
}

