/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.client.model.entity.DarkSwampWitchModel;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.WitchRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Witch;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={WitchRenderer.class})
public abstract class WitchRendererMixin {
    @Unique
    private WitchModel<Witch> vanillaModel;
    @Unique
    private WitchModel<Witch> darkSwampModel;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V"}, at={@At(value="TAIL")})
    private void init(EntityRendererProvider.Context context, CallbackInfo ci) {
        this.vanillaModel = (WitchModel)((WitchRenderer)this).getModel();
        this.darkSwampModel = new WitchModel(context.bakeLayer(DarkSwampWitchModel.LAYER_LOCATION));
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/monster/Witch;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void render(Witch witch, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (Objects.equals(ESDataAttachments.WITCH_TYPE.getData((Entity)witch), "dark_swamp")) {
            WitchRenderer renderer = (WitchRenderer)this;
            renderer.model = this.darkSwampModel;
        }
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/monster/Witch;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void renderReturn(Witch witch, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        WitchRenderer renderer = (WitchRenderer)this;
        if (renderer.getModel() != this.vanillaModel) {
            renderer.model = this.vanillaModel;
        }
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/monster/Witch;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getTextureLocation(Witch witch, CallbackInfoReturnable<ResourceLocation> cir) {
        if (Objects.equals(ESDataAttachments.WITCH_TYPE.getData((Entity)witch), "dark_swamp")) {
            cir.setReturnValue((Object)DarkSwampWitchModel.ENTITY_TEXTURE);
        }
    }
}

