/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.client.event;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.gui.tooltip.ClientGalacticQuiverTooltip;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.handler.ClientSetupHandlers;
import cn.leolezury.eternalstarlight.common.client.model.armor.AlchemistArmorModel;
import cn.leolezury.eternalstarlight.common.client.model.armor.StarlitDiamondArmorModel;
import cn.leolezury.eternalstarlight.common.client.model.armor.ThermalSpringStoneArmorModel;
import cn.leolezury.eternalstarlight.common.item.tooltip.GalacticQuiverTooltipComponent;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.neoforge.client.renderer.ForgeItemStackRenderer;
import cn.leolezury.eternalstarlight.neoforge.registry.ESFluidTypes;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="eternal_starlight", value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientSetupHandlers::clientSetup);
    }

    @SubscribeEvent
    private static void onRegisterDimEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(EternalStarlight.id("special_effect"), ESPlatform.INSTANCE.getDimEffect());
    }

    @SubscribeEvent
    private static void onRegisterBlockColor(RegisterColorHandlersEvent.Block event) {
        ClientSetupHandlers.registerBlockColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterItemColor(RegisterColorHandlersEvent.Item event) {
        ClientSetupHandlers.registerItemColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(ForgeItemStackRenderer.CLIENT_ITEM_EXTENSION, new Item[]{ESItems.GLACITE_SHIELD.get()});
        event.registerItem(ForgeItemStackRenderer.CLIENT_ITEM_EXTENSION, new Item[]{ESItems.FLOWGLAZE_SHIELD.get()});
        IClientItemExtensions alchemistArmor = new IClientItemExtensions(){
            private AlchemistArmorModel<LivingEntity> model;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.model == null) {
                    this.model = new AlchemistArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(AlchemistArmorModel.LAYER_LOCATION));
                }
                return this.model;
            }
        };
        event.registerItem(alchemistArmor, new Item[]{ESItems.ALCHEMIST_MASK.get()});
        event.registerItem(alchemistArmor, new Item[]{ESItems.ALCHEMIST_ROBE.get()});
        IClientItemExtensions thermalSpringstoneArmor = new IClientItemExtensions(){
            private ThermalSpringStoneArmorModel<LivingEntity> innerModel;
            private ThermalSpringStoneArmorModel<LivingEntity> outerModel;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.innerModel == null || this.outerModel == null) {
                    this.innerModel = new ThermalSpringStoneArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(ThermalSpringStoneArmorModel.INNER_LOCATION));
                    this.outerModel = new ThermalSpringStoneArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(ThermalSpringStoneArmorModel.OUTER_LOCATION));
                }
                if (itemStack.is(ESItems.THERMAL_SPRINGSTONE_HELMET.get()) || itemStack.is(ESItems.THERMAL_SPRINGSTONE_CHESTPLATE.get()) || itemStack.is(ESItems.THERMAL_SPRINGSTONE_BOOTS.get())) {
                    return this.outerModel;
                }
                if (itemStack.is(ESItems.THERMAL_SPRINGSTONE_LEGGINGS.get())) {
                    return this.innerModel;
                }
                return super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        };
        event.registerItem(thermalSpringstoneArmor, new Item[]{ESItems.THERMAL_SPRINGSTONE_HELMET.get()});
        event.registerItem(thermalSpringstoneArmor, new Item[]{ESItems.THERMAL_SPRINGSTONE_CHESTPLATE.get()});
        event.registerItem(thermalSpringstoneArmor, new Item[]{ESItems.THERMAL_SPRINGSTONE_LEGGINGS.get()});
        event.registerItem(thermalSpringstoneArmor, new Item[]{ESItems.THERMAL_SPRINGSTONE_BOOTS.get()});
        IClientItemExtensions starlitDiamondArmor = new IClientItemExtensions(){
            private StarlitDiamondArmorModel<LivingEntity> innerModel;
            private StarlitDiamondArmorModel<LivingEntity> outerModel;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.innerModel == null || this.outerModel == null) {
                    this.innerModel = new StarlitDiamondArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(StarlitDiamondArmorModel.INNER_LOCATION));
                    this.outerModel = new StarlitDiamondArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(StarlitDiamondArmorModel.OUTER_LOCATION));
                }
                if (itemStack.is(ESItems.STARLIT_DIAMOND_HELMET.get()) || itemStack.is(ESItems.STARLIT_DIAMOND_CHESTPLATE.get()) || itemStack.is(ESItems.STARLIT_DIAMOND_BOOTS.get())) {
                    return this.outerModel;
                }
                if (itemStack.is(ESItems.STARLIT_DIAMOND_LEGGINGS.get())) {
                    return this.innerModel;
                }
                return super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        };
        event.registerItem(starlitDiamondArmor, new Item[]{ESItems.STARLIT_DIAMOND_HELMET.get()});
        event.registerItem(starlitDiamondArmor, new Item[]{ESItems.STARLIT_DIAMOND_CHESTPLATE.get()});
        event.registerItem(starlitDiamondArmor, new Item[]{ESItems.STARLIT_DIAMOND_LEGGINGS.get()});
        event.registerItem(starlitDiamondArmor, new Item[]{ESItems.STARLIT_DIAMOND_BOOTS.get()});
        event.registerItem(ForgeItemStackRenderer.CLIENT_ITEM_EXTENSION, new Item[]{ESItems.MALARITE_SPEAR.get()});
        event.registerItem(ForgeItemStackRenderer.CLIENT_ITEM_EXTENSION, new Item[]{ESItems.PUNGENCY_FRUIT_SPEAR.get()});
        event.registerItem(ForgeItemStackRenderer.CLIENT_ITEM_EXTENSION, new Item[]{ESItems.CRESCENT_SPEAR.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return EternalStarlight.id("block/ether");
            }

            public ResourceLocation getFlowingTexture() {
                return EternalStarlight.id("block/ether_flow");
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.9098039f, 1.0f, 0.87058824f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)3.0f);
            }
        }, new FluidType[]{ESFluidTypes.ETHER.get()});
    }

    @SubscribeEvent
    private static void onBakingCompleted(ModelEvent.ModifyBakingResult event) {
        Map models = event.getModels();
        ClientSetupHandlers.modifiedBakedModels = false;
        ClientSetupHandlers.modifyBakingResult(models);
    }

    @SubscribeEvent
    private static void onRegisterExtraModels(ModelEvent.RegisterAdditional event) {
        ClientSetupHandlers.registerExtraBakedModels(l -> {
            ModelResourceLocation forged = ModelResourceLocation.standalone((ResourceLocation)l.id().withPrefix("item/"));
            event.register(forged);
        });
    }

    @SubscribeEvent
    private static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        ClientSetupHandlers.registerParticleProviders((arg_0, arg_1) -> ((RegisterParticleProvidersEvent)event).registerSpriteSet(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientSetupHandlers.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        ClientSetupHandlers.registerSkullModels((arg_0, arg_1) -> ((EntityRenderersEvent.CreateSkullModels)event).registerSkullModel(arg_0, arg_1), event.getEntityModelSet());
    }

    @SubscribeEvent
    private static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClientSetupHandlers.registerLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        ClientSetupHandlers.registerMenuScreens((arg_0, arg_1) -> ((RegisterMenuScreensEvent)event).register(arg_0, arg_1));
    }

    @SubscribeEvent
    private static void onRegisterMenuScreens(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer livingEntityRenderer;
        EntityRenderer entityRenderer;
        for (EntityType entityType : event.getEntityTypes()) {
            entityRenderer = event.getRenderer(entityType);
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            ClientSetupHandlers.onRenderLayerAttachment(entityType, livingEntityRenderer, event.getContext());
        }
        for (PlayerSkin.Model model : event.getSkins()) {
            entityRenderer = event.getSkin(model);
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            ClientSetupHandlers.onRenderLayerAttachment(EntityType.PLAYER, livingEntityRenderer, event.getContext());
        }
    }

    @SubscribeEvent
    private static void onRegisterShader(RegisterShadersEvent event) {
        ClientSetupHandlers.registerShaders((location, format, loaded) -> {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), location, format), loaded);
            }
            catch (IOException e) {
                EternalStarlight.LOGGER.error("Cannot register shader: {}", (Object)location);
            }
        });
    }

    @SubscribeEvent
    private static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("spell_crosshair"), (graphics, partialTicks) -> ClientHandlers.renderSpellCrosshair(graphics, graphics.guiWidth(), graphics.guiHeight()));
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("ether_erosion"), (graphics, partialTicks) -> ClientHandlers.renderEtherErosion(graphics));
        event.registerAbove(VanillaGuiLayers.ARMOR_LEVEL, EternalStarlight.id("ether_armor"), (graphics, partialTicks) -> {
            if (Minecraft.getInstance().gameMode != null && Minecraft.getInstance().gameMode.canHurtPlayer()) {
                ClientHandlers.renderEtherArmor(graphics, graphics.guiWidth(), graphics.guiHeight());
            }
        });
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("orb_of_prophecy_use"), (graphics, partialTicks) -> ClientHandlers.renderOrbOfProphecyUse(graphics));
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("dream_catcher"), (graphics, partialTicks) -> ClientHandlers.renderDreamCatcher(graphics));
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("current_crest"), (graphics, partialTicks) -> ClientHandlers.renderCurrentCrest(graphics));
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("carved_lunaris_cactus_fruit_blur"), (graphics, partialTicks) -> ClientHandlers.renderCarvedLunarisCactusFruitBlur(graphics));
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, EternalStarlight.id("portal"), (graphics, partialTicks) -> ClientHandlers.renderPortalOverlay(graphics));
    }

    @SubscribeEvent
    private static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        for (Map.Entry<ResourceLocation, KeyMapping> mapping : ClientSetupHandlers.KEY_MAPPINGS.entrySet()) {
            event.register(mapping.getValue());
        }
    }

    @SubscribeEvent
    private static void onAddReloadListener(RegisterClientReloadListenersEvent event) {
        ClientSetupHandlers.addClientReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
    }

    @SubscribeEvent
    private static void onRegisterClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(GalacticQuiverTooltipComponent.class, component -> new ClientGalacticQuiverTooltip(component.contents()));
    }
}

