/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.datagen.provider;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.item.recipe.AccessoryCombinationRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.GeyserSmokingRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.ManaCrystalRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.ToolModificationRecipe;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class ESRecipeProvider
extends RecipeProvider {
    public ESRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        int i;
        this.addWoodRecipes(recipeOutput);
        this.addStoneRecipes(recipeOutput);
        this.addStarcoreRecipes(recipeOutput);
        this.addAethersentRecipes(recipeOutput);
        this.addThermalSpringstoneRecipes(recipeOutput);
        this.addGlaciteRecipes(recipeOutput);
        this.addStarlitDiamondRecipes(recipeOutput);
        this.addDeepsilverRecipes(recipeOutput);
        this.addMalariteRecipes(recipeOutput);
        this.addPungencyFruitRecipes(recipeOutput);
        this.addStarfireRecipes(recipeOutput);
        this.addSaltpeterRecipes(recipeOutput);
        this.addAmaramberRecipes(recipeOutput);
        this.addThioquartzRecipes(recipeOutput);
        ESRecipeProvider.smithingTrims().forEach(template -> ESRecipeProvider.trimSmithing((RecipeOutput)recipeOutput, (Item)template.template(), (ResourceLocation)template.id()));
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.KEEPER_ARMOR_TRIM_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.GRIMSTONE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.FORGE_ARMOR_TRIM_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.VOIDSTONE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.BLOOMING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.GRIMSTONE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.TWINING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.GRIMSTONE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        SpecialRecipeBuilder.special(category -> new ToolModificationRecipe((CraftingBookCategory)category, Items.SHEARS, ESItems.TWINING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), new ItemStack((ItemLike)ESItems.BLOOMING_ARMOR_TRIM_SMITHING_TEMPLATE.get()))).save(recipeOutput, EternalStarlight.id("blooming_trim_from_twining_trim"));
        List<Item> dyeList = List.of(Items.BLACK_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.CYAN_DYE, Items.GRAY_DYE, Items.GREEN_DYE, Items.LIGHT_BLUE_DYE, Items.LIGHT_GRAY_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.PURPLE_DYE, Items.RED_DYE, Items.YELLOW_DYE, Items.WHITE_DYE);
        List<Item> bedList = List.of(Items.BLACK_BED, Items.BLUE_BED, Items.BROWN_BED, Items.CYAN_BED, Items.GRAY_BED, Items.GREEN_BED, Items.LIGHT_BLUE_BED, Items.LIGHT_GRAY_BED, Items.LIME_BED, Items.MAGENTA_BED, Items.ORANGE_BED, Items.PINK_BED, Items.PURPLE_BED, Items.RED_BED, Items.YELLOW_BED, Items.WHITE_BED);
        List<Item> furList = List.of(ESItems.BLACK_YETI_FUR.get(), ESItems.BLUE_YETI_FUR.get(), ESItems.BROWN_YETI_FUR.get(), ESItems.CYAN_YETI_FUR.get(), ESItems.GRAY_YETI_FUR.get(), ESItems.GREEN_YETI_FUR.get(), ESItems.LIGHT_BLUE_YETI_FUR.get(), ESItems.LIGHT_GRAY_YETI_FUR.get(), ESItems.LIME_YETI_FUR.get(), ESItems.MAGENTA_YETI_FUR.get(), ESItems.ORANGE_YETI_FUR.get(), ESItems.PINK_YETI_FUR.get(), ESItems.PURPLE_YETI_FUR.get(), ESItems.RED_YETI_FUR.get(), ESItems.YELLOW_YETI_FUR.get(), ESItems.WHITE_YETI_FUR.get());
        this.colorWithDye(recipeOutput, dyeList, furList, "yeti_fur");
        List<Item> carpetList = List.of(ESItems.BLACK_YETI_FUR_CARPET.get(), ESItems.BLUE_YETI_FUR_CARPET.get(), ESItems.BROWN_YETI_FUR_CARPET.get(), ESItems.CYAN_YETI_FUR_CARPET.get(), ESItems.GRAY_YETI_FUR_CARPET.get(), ESItems.GREEN_YETI_FUR_CARPET.get(), ESItems.LIGHT_BLUE_YETI_FUR_CARPET.get(), ESItems.LIGHT_GRAY_YETI_FUR_CARPET.get(), ESItems.LIME_YETI_FUR_CARPET.get(), ESItems.MAGENTA_YETI_FUR_CARPET.get(), ESItems.ORANGE_YETI_FUR_CARPET.get(), ESItems.PINK_YETI_FUR_CARPET.get(), ESItems.PURPLE_YETI_FUR_CARPET.get(), ESItems.RED_YETI_FUR_CARPET.get(), ESItems.YELLOW_YETI_FUR_CARPET.get(), ESItems.WHITE_YETI_FUR_CARPET.get());
        this.colorWithDye(recipeOutput, dyeList, carpetList, "yeti_fur_carpet");
        for (i = 0; i < furList.size(); ++i) {
            this.customCarpet(recipeOutput, (ItemLike)carpetList.get(i), (ItemLike)furList.get(i));
        }
        for (i = 0; i < furList.size(); ++i) {
            this.bed(recipeOutput, (ItemLike)bedList.get(i), (ItemLike)furList.get(i));
        }
        this.addSingleConversion(recipeOutput, Items.BLUE_DYE, ESItems.STARLIGHT_FLOWER.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.AUREATE_FLOWER.get());
        this.addSingleConversion(recipeOutput, Items.BROWN_DYE, ESItems.CONEBLOOM.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.NIGHTFAN.get());
        this.addSingleConversion(recipeOutput, Items.PINK_DYE, ESItems.PINK_ROSE.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.STARLIGHT_TORCHFLOWER.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.NIGHTFAN_BUSH.get());
        this.addSingleConversion(recipeOutput, Items.PINK_DYE, ESItems.PINK_ROSE_BUSH.get());
        this.addSingleConversion(recipeOutput, Items.GREEN_DYE, ESItems.SWAMP_ROSE.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.MAUVE_FERN.get());
        this.addSingleConversion(recipeOutput, Items.PINK_DYE, ESItems.WHISPERBLOOM.get());
        this.addSingleConversion(recipeOutput, Items.ORANGE_DYE, ESItems.WITHERED_STARLIGHT_FLOWER.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.AMARAMBER_GRASS.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.AMARAMBER_GRASS_BUSH.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.DESERT_AMETHYSIA.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.WITHERED_DESERT_AMETHYSIA.get());
        this.addSingleConversion(recipeOutput, Items.ORANGE_DYE, ESItems.SUNSET_THORNBLOOM.get());
        this.addSingleConversion(recipeOutput, Items.PURPLE_DYE, ESItems.AMETHYSIA_GRASS.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.GLADESPIKE.get());
        this.addSingleConversion(recipeOutput, Items.RED_DYE, ESItems.VIVIDSTALK.get());
        this.addSingleConversion(recipeOutput, Items.YELLOW_DYE, ESItems.TALL_GLADESPIKE.get());
        this.addCookingRecipes(recipeOutput, "smoking", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
        this.addCookingRecipes(recipeOutput, "campfire_cooking", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.LUNARIS_CACTUS_FRUIT.get(), (ItemLike)ESItems.LUNARIS_CACTUS_GEL.get(), (ItemLike)ESItems.LUNARIS_CACTUS_FRUIT.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.SPIRAL_KELP.get(), (ItemLike)Items.DRIED_KELP, (ItemLike)ESItems.SPIRAL_KELP.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.ROOKFISH.get(), (ItemLike)ESItems.COOKED_ROOKFISH.get(), (ItemLike)ESItems.ROOKFISH.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.LUMINOFISH.get(), (ItemLike)ESItems.COOKED_LUMINOFISH.get(), (ItemLike)ESItems.LUMINOFISH.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.LUMINARIS.get(), (ItemLike)ESItems.COOKED_LUMINARIS.get(), (ItemLike)ESItems.LUMINARIS.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.AURORA_DEER_STEAK.get(), (ItemLike)ESItems.COOKED_AURORA_DEER_STEAK.get(), (ItemLike)ESItems.AURORA_DEER_STEAK.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.RATLIN_MEAT.get(), (ItemLike)ESItems.COOKED_RATLIN_MEAT.get(), (ItemLike)ESItems.RATLIN_MEAT.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.SHADOW_SNAIL_MEAT.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.GRIMSTONE_REDSTONE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.GRIMSTONE_REDSTONE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.VOIDSTONE_REDSTONE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.VOIDSTONE_REDSTONE_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.ETERNAL_ICE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.ETERNAL_ICE_REDSTONE_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.ETERNAL_ICE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.ETERNAL_ICE_REDSTONE_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.HAZE_ICE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.HAZE_ICE_REDSTONE_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.HAZE_ICE_REDSTONE_ORE.get(), (ItemLike)Items.REDSTONE, (ItemLike)ESItems.HAZE_ICE_REDSTONE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get(), (ItemLike)ESItems.GOLEM_STEEL_INGOT.get(), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get(), (ItemLike)ESItems.GOLEM_STEEL_INGOT.get(), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get());
        this.addSmelt(recipeOutput, 30, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_NUGGET.get(), (ItemLike)ESItems.GOLEM_STEEL_NUGGET.get(), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_NUGGET.get());
        this.addBlast(recipeOutput, 15, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_NUGGET.get(), (ItemLike)ESItems.GOLEM_STEEL_NUGGET.get(), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_NUGGET.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.ORB_OF_PROPHECY.get())).pattern("GCG").pattern("CCC").pattern("GCG").define(Character.valueOf('C'), (ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('G'), (ItemLike)Items.GLASS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get(), (ItemLike)ESItems.MANA_CRYSTAL.get(), 1, (ItemLike)ESItems.TERRA_CRYSTAL.get(), (ItemLike)ESItems.WIND_CRYSTAL.get(), (ItemLike)ESItems.WATER_CRYSTAL.get(), (ItemLike)ESItems.LUNAR_CRYSTAL.get(), (ItemLike)ESItems.BLAZE_CRYSTAL.get(), (ItemLike)ESItems.LIGHT_CRYSTAL.get());
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.TERRA, ESItems.TERRA_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("terra_crystal_special"));
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.WIND, ESItems.WIND_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("wind_crystal_special"));
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.WATER, ESItems.WATER_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("water_crystal_special"));
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.LUNAR, ESItems.LUNAR_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("lunar_crystal_special"));
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.BLAZE, ESItems.BLAZE_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("blaze_crystal_special"));
        SpecialRecipeBuilder.special(category -> new ManaCrystalRecipe((CraftingBookCategory)category, ManaType.LIGHT, ESItems.LIGHT_CRYSTAL.get())).save(recipeOutput, EternalStarlight.id("light_crystal_special"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.TERRA_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.TERRA_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.WIND_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.WIND_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.WATER_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.WATER_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.LUNAR_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.LUNAR_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.BLAZE_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.BLAZE_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.LIGHT_CRYSTAL.get())).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), ESTags.Items.LIGHT_CRYSTAL_INGREDIENTS).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, (ItemLike)ESItems.STARLIGHT_MANGROVE_ROOTS.get(), (ItemLike)ESItems.MUDDY_STARLIGHT_MANGROVE_ROOTS.get(), 1, (ItemLike)ESItems.STARLIGHT_MANGROVE_ROOTS.get(), (ItemLike)ESItems.NIGHTFALL_MUD.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.FROZEN_BOMB.get()), (int)12).pattern("SG ").pattern("GAG").pattern(" G ").define(Character.valueOf('A'), ESConventionalTags.Items.GEMS_STARCORE).define(Character.valueOf('G'), ESConventionalTags.Items.GEMS_GLACITE).define(Character.valueOf('S'), (ItemLike)ESItems.ASHEN_SNOWBALL.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.ASHEN_SNOWBALL.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, (ItemLike)ESItems.NIGHTFALL_MUD.get(), (ItemLike)ESItems.PACKED_NIGHTFALL_MUD.get(), 1, (ItemLike)ESItems.NIGHTFALL_MUD.get(), (ItemLike)ESItems.CRINOA.get());
        this.addShapeless(recipeOutput, RecipeCategory.FOOD, (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.CRINOA_BALL.get(), 1, (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.LUNAR_BERRIES.get());
        this.addShapeless(recipeOutput, RecipeCategory.FOOD, (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.CRINOA_PORRIDGE.get(), 1, new ItemLike[]{(ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.CRINOA.get(), Items.BOWL});
        this.customCarpet(recipeOutput, (ItemLike)ESBlocks.CAVE_MOSS_CARPET.get(), (ItemLike)ESBlocks.CAVE_MOSS_BLOCK.get());
        this.addShapeless(recipeOutput, (ItemLike)ESItems.BOULDERSHROOM.get(), (ItemLike)ESItems.BOULDERSHROOM_STEW.get(), 1, new ItemLike[]{(ItemLike)ESItems.BOULDERSHROOM.get(), (ItemLike)ESItems.GLOWING_MUSHROOM.get(), Items.BOWL});
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.LUNARIS_CACTUS_GEL.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.LUNARIS_CACTUS_GEL_BLOCK.get(), "lunaris_cactus_gel_block_from_lunaris_cactus_gel", "lunaris_cactus_gel");
        this.addShapeless(recipeOutput, (ItemLike)ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get(), (ItemLike)ESBlocks.LUNARIS_CACTUS_FRUIT_LANTERN.get(), 1, (ItemLike)ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get(), (ItemLike)ESBlocks.AMARAMBER_CANDLE.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.ARROW, (int)4).pattern("T").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)ESItems.SPIRAL_KELP.get()).define(Character.valueOf('T'), (ItemLike)Items.FLINT).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.SPIRAL_KELP.get()))).save(recipeOutput, EternalStarlight.id("arrow_from_spiral_kelp"));
        this.addShapeless(recipeOutput, (ItemLike)ESItems.VELVETUMOSS_BALL.get(), (ItemLike)Items.SLIME_BALL, 2, (ItemLike)ESItems.VELVETUMOSS_BALL.get());
        this.customCarpet(recipeOutput, (ItemLike)ESBlocks.RED_CRYSTAL_MOSS_CARPET.get(), (ItemLike)ESBlocks.RED_CRYSTAL_MOSS_BLOCK.get());
        this.customCarpet(recipeOutput, (ItemLike)ESBlocks.BLUE_CRYSTAL_MOSS_CARPET.get(), (ItemLike)ESBlocks.BLUE_CRYSTAL_MOSS_BLOCK.get());
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.CRINOA.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.CRINOA_BALE.get(), "crinoa_from_crinoa_bale", "crinoa_bale");
        this.addShapeless(recipeOutput, (ItemLike)ESItems.COOKED_ROOKFISH.get(), (ItemLike)ESItems.ROOKFISH_SKEWER.get(), 3, new ItemLike[]{(ItemLike)ESItems.COOKED_ROOKFISH.get(), Items.STICK, Items.STICK, Items.STICK});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AIR_SAC_ARROW.get()), (int)4).pattern("D").pattern("S").pattern("T").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('D'), (ItemLike)ESItems.DUSTED_SHARD.get()).define(Character.valueOf('T'), (ItemLike)ESItems.ROOKFISH_AIR_SAC.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.ROOKFISH_AIR_SAC.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AIR_SAC_MASK.get())).pattern("LLL").pattern("LML").pattern("SBS").define(Character.valueOf('L'), (ItemLike)ESItems.JINGLESTEM_LOG.get()).define(Character.valueOf('S'), (ItemLike)ESItems.ROOKFISH_AIR_SAC.get()).define(Character.valueOf('M'), (ItemLike)ESItems.AMARAMBER_MASK.get()).define(Character.valueOf('B'), (ItemLike)ESItems.VELVETUMOSS_BALL.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.ROOKFISH_AIR_SAC.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AIR_SAC_BOOTS.get())).pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)ESItems.ROOKFISH_AIR_SAC.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.ROOKFISH_AIR_SAC.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, (ItemLike)ESItems.SHADOW_SNAIL_SHELL.get(), (ItemLike)ESItems.SHADOW_SNAIL_SHELL_POWDER.get(), 4, (ItemLike)ESItems.SHADOW_SNAIL_SHELL.get());
        this.addSingleConversion(recipeOutput, Items.BLACK_DYE, ESItems.SHADOW_SNAIL_SHELL_POWDER.get());
        this.addShapeless(recipeOutput, (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.SHADOW_SNAIL_PIE.get(), 1, (ItemLike)ESItems.RAW_AMARAMBER.get(), (ItemLike)ESItems.CRINOA.get(), (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get());
        this.addShapeless(recipeOutput, (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.SHADOW_ESCARGOT.get(), 1, (ItemLike)ESItems.VELVETUMOSS_BALL.get(), (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.SHADOW_SNAIL_SHELL.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.STARLIT_PAINTING.get())).pattern("SSS").pattern("SFS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.YETI_FUR).unlockedBy("has_item", ESRecipeProvider.has(ESTags.Items.YETI_FUR)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.SONAR_BOMB.get()), (int)12).pattern(" N ").pattern("NGN").pattern(" N ").define(Character.valueOf('N'), ESConventionalTags.Items.NUGGETS_DEEPSILVER).define(Character.valueOf('G'), (ItemLike)ESItems.SHIVERING_GEL.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.SHIVERING_GEL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.TINTED_GLASS, (int)2).pattern(" E ").pattern("EGE").pattern(" E ").define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('E'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("tinted_glass_from_nightfall_spider_eye"));
        this.addSword(recipeOutput, (ItemLike)ESItems.DAGGER_OF_HUNGER.get(), (ItemLike)ESItems.TOOTH_OF_HUNGER.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.VORACIOUS_ARROW.get()), (int)4).pattern("T").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('T'), (ItemLike)ESItems.TOOTH_OF_HUNGER.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TOOTH_OF_HUNGER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ESItems.SEEKING_EYE.get()), (int)16).pattern("FFF").pattern("FPF").pattern("FFF").define(Character.valueOf('P'), ConventionalTags.Items.ENDER_PEARLS).define(Character.valueOf('F'), (ItemLike)ESItems.STARLIGHT_FLOWER.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.STARLIGHT_FLOWER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.GOLEM_STEEL_GREATSWORD.get())).pattern("  G").pattern(" GG").pattern("SG ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('G'), ESConventionalTags.Items.INGOTS_GOLEM_STEEL).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_GOLEM_STEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.CRYSTAL_CROSSBOW.get())).pattern("BGB").pattern("STS").pattern(" R ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('T'), (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('G'), ESConventionalTags.Items.INGOTS_GOLEM_STEEL).define(Character.valueOf('B'), (ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('R'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_GOLEM_STEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.MECHANICAL_CROSSBOW.get())).pattern("#&#").pattern("~$~").pattern(" # ").define(Character.valueOf('~'), (ItemLike)Items.STRING).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('&'), ESConventionalTags.Items.INGOTS_GOLEM_STEEL).define(Character.valueOf('$'), (ItemLike)Items.TRIPWIRE_HOOK).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_GOLEM_STEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.ENERGY_BOOMERANG.get())).pattern(" GG").pattern("G  ").pattern("GG ").define(Character.valueOf('G'), ESConventionalTags.Items.INGOTS_GOLEM_STEEL).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_GOLEM_STEEL)).save(recipeOutput);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.UNDERMINER.get(), ESConventionalTags.Items.INGOTS_GOLEM_STEEL);
        this.addShapeless(recipeOutput, (ItemLike)ESItems.TRAPPED_SOUL.get(), (ItemLike)ESItems.SOULIT_SPECTATOR.get(), 1, (ItemLike)ESItems.TRAPPED_SOUL.get(), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.WILTED_CROSSBOW.get())).pattern("#&#").pattern("~$~").pattern(" # ").define(Character.valueOf('~'), (ItemLike)ESItems.TENACIOUS_VINE.get()).define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('&'), ESConventionalTags.Items.INGOTS_GOLEM_STEEL).define(Character.valueOf('$'), (ItemLike)ESItems.RED_VELVETUMOSS_FLOWER.get()).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_GOLEM_STEEL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.MOONRING_GREATSWORD.get())).pattern("  P").pattern(" VP").pattern("VS ").define(Character.valueOf('S'), (ItemLike)ESItems.TRAPPED_SOUL.get()).define(Character.valueOf('P'), (ItemLike)ESItems.TENACIOUS_PETAL.get()).define(Character.valueOf('V'), (ItemLike)ESItems.TENACIOUS_VINE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TENACIOUS_PETAL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.PETAL_SCYTHE.get())).pattern("PPP").pattern(" VP").pattern("V  ").define(Character.valueOf('P'), (ItemLike)ESItems.TENACIOUS_PETAL.get()).define(Character.valueOf('V'), (ItemLike)ESItems.TENACIOUS_VINE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TENACIOUS_PETAL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.CHAIN_OF_SOULS.get())).pattern("SP").pattern(" V").pattern(" V").define(Character.valueOf('S'), (ItemLike)ESItems.TRAPPED_SOUL.get()).define(Character.valueOf('P'), (ItemLike)ESItems.TENACIOUS_PETAL.get()).define(Character.valueOf('V'), (ItemLike)ESItems.TENACIOUS_VINE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TENACIOUS_PETAL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.CRESCENT_SPEAR.get())).pattern("S S").pattern("PSP").pattern(" V ").define(Character.valueOf('S'), ESConventionalTags.Items.INGOTS_DEEPSILVER).define(Character.valueOf('P'), (ItemLike)ESItems.TENACIOUS_PETAL.get()).define(Character.valueOf('V'), (ItemLike)ESItems.TENACIOUS_VINE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TENACIOUS_PETAL.get()))).save(recipeOutput);
        SpecialRecipeBuilder.special(AccessoryCombinationRecipe::new).save(recipeOutput, EternalStarlight.id("accessory_combination"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.DISPENSER, (int)4).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).define(Character.valueOf('X'), (ItemLike)Items.BOW).pattern("###").pattern("#X#").pattern("#R#").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("dispenser_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.DROPPER, (int)4).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern("###").pattern("# #").pattern("#R#").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("dropper_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.LEVER, (int)4).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("X").pattern("#").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("lever_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.OBSERVER, (int)4).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern("###").pattern("RRQ").pattern("###").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("observer_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.PISTON, (int)4).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).define(Character.valueOf('T'), ItemTags.PLANKS).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).pattern("TTT").pattern("#X#").pattern("#R#").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("piston_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.COMPARATOR, (int)3).define(Character.valueOf('#'), (ItemLike)Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)Items.QUARTZ).define(Character.valueOf('I'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern(" # ").pattern("#X#").pattern("III").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("comparator_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.REPEATER, (int)3).define(Character.valueOf('#'), (ItemLike)Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)Items.REDSTONE).define(Character.valueOf('I'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern("#X#").pattern("III").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("repeater_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.BLAST_FURNACE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).pattern("III").pattern("IXI").pattern("###").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).save(recipeOutput, EternalStarlight.id("blast_furnace_from_cinder_brick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.DAYLIGHT_DETECTOR).define(Character.valueOf('Q'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('W'), Ingredient.of((TagKey)ItemTags.WOODEN_SLABS)).pattern("GGG").pattern("QQQ").pattern("WWW").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("daylight_detector_from_nightfall_spider_eye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.OBSERVER).define(Character.valueOf('Q'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)Blocks.COBBLESTONE).pattern("###").pattern("RRQ").pattern("###").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("observer_from_nightfall_spider_eye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.OBSERVER, (int)4).define(Character.valueOf('Q'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('#'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern("###").pattern("RRQ").pattern("###").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("observer_from_cinder_brick_and_nightfall_spider_eye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.COMPARATOR).define(Character.valueOf('#'), (ItemLike)Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).define(Character.valueOf('I'), (ItemLike)Blocks.STONE).pattern(" # ").pattern("#X#").pattern("III").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("comparator_from_nightfall_spider_eye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.COMPARATOR, (int)3).define(Character.valueOf('#'), (ItemLike)Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), (ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()).define(Character.valueOf('I'), (ItemLike)ESItems.CINDER_BRICK.get()).pattern(" # ").pattern("#X#").pattern("III").unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CINDER_BRICK.get()))).unlockedBy(ESRecipeProvider.getHasName((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get())), ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.NIGHTFALL_SPIDER_EYE.get()))).save(recipeOutput, EternalStarlight.id("comparator_from_cinder_brick_and_nightfall_spider_eye"));
        SpecialRecipeBuilder.special(category -> new GeyserSmokingRecipe(Items.SKELETON_SKULL, 1, Items.WITHER_SKELETON_SKULL.getDefaultInstance())).save(recipeOutput, EternalStarlight.id("geyser_smoking/wither_skeleton_skull_from_skeleton_skull"));
        SpecialRecipeBuilder.special(category -> new GeyserSmokingRecipe(Items.WHITE_DYE, 1, Items.BLACK_DYE.getDefaultInstance())).save(recipeOutput, EternalStarlight.id("geyser_smoking/back_dye_from_white_dye"));
        SpecialRecipeBuilder.special(category -> new GeyserSmokingRecipe(ESItems.GRIMSTONE.get(), 3, new ItemStack((ItemLike)ESItems.VOIDSTONE.get(), 2))).save(recipeOutput, EternalStarlight.id("geyser_smoking/voidstone_from_grimstone"));
        SpecialRecipeBuilder.special(category -> new DryingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), ESItems.ROTTEN_FLESH_JERKY.get().getDefaultInstance(), 600, true)).save(recipeOutput, EternalStarlight.id("drying/rotten_flesh_jerky"));
        SpecialRecipeBuilder.special(category -> new DryingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Items.LEATHER.getDefaultInstance(), 2400, false)).save(recipeOutput, EternalStarlight.id("drying/leather_from_rotten_flesh"));
        SpecialRecipeBuilder.special(category -> new DryingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.WET_SPONGE}), Items.SPONGE.getDefaultInstance(), 100, true)).save(recipeOutput, EternalStarlight.id("drying/sponge"));
        SpecialRecipeBuilder.special(category -> new DryingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Items.DRIED_KELP.getDefaultInstance(), 100, true)).save(recipeOutput, EternalStarlight.id("drying/dried_kelp"));
        SpecialRecipeBuilder.special(category -> new DryingRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY_BALL}), Items.BRICK.getDefaultInstance(), 150, true)).save(recipeOutput, EternalStarlight.id("drying/brick"));
    }

    private <T extends AbstractCookingRecipe> void addCookingRecipes(RecipeOutput recipeOutput, String name, RecipeSerializer<T> recipeSerializer, AbstractCookingRecipe.Factory<T> factory, int time) {
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.SPIRAL_KELP.get(), (ItemLike)Items.DRIED_KELP, 0.1f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.ROOKFISH.get(), (ItemLike)ESItems.COOKED_ROOKFISH.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.LUMINOFISH.get(), (ItemLike)ESItems.COOKED_LUMINOFISH.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.LUMINARIS.get(), (ItemLike)ESItems.COOKED_LUMINARIS.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.AURORA_DEER_STEAK.get(), (ItemLike)ESItems.COOKED_AURORA_DEER_STEAK.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.RATLIN_MEAT.get(), (ItemLike)ESItems.COOKED_RATLIN_MEAT.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.SHADOW_SNAIL_MEAT.get(), (ItemLike)ESItems.COOKED_SHADOW_SNAIL_MEAT.get(), 0.35f);
        this.simpleCooking(recipeOutput, name, recipeSerializer, factory, time, (ItemLike)ESItems.LUNARIS_CACTUS_FRUIT.get(), (ItemLike)ESItems.LUNARIS_CACTUS_GEL.get(), 0.35f);
    }

    private void addWoodRecipes(RecipeOutput recipeOutput) {
        this.addButton(recipeOutput, (Block)ESBlocks.LUNAR_BUTTON.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.LUNAR_DOOR.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.LUNAR_FENCE.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.LUNAR_FENCE_GATE.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.LUNAR_PLANKS.get(), ESTags.Items.LUNAR_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.LUNAR_WOOD.get(), (Block)ESBlocks.LUNAR_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_LUNAR_WOOD.get(), (Block)ESBlocks.STRIPPED_LUNAR_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.LUNAR_PRESSURE_PLATE.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.LUNAR_SLAB.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.LUNAR_STAIRS.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.LUNAR_TRAPDOOR.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.LUNAR_SIGN.get(), ESBlocks.LUNAR_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.LUNAR_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_LUNAR_LOG.get()));
        this.addBoat(recipeOutput, ESItems.LUNAR_BOAT.get(), ESItems.LUNAR_CHEST_BOAT.get(), ESBlocks.LUNAR_PLANKS.get());
        this.addButton(recipeOutput, (Block)ESBlocks.NORTHLAND_BUTTON.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.NORTHLAND_DOOR.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.NORTHLAND_FENCE.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.NORTHLAND_FENCE_GATE.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.NORTHLAND_PLANKS.get(), ESTags.Items.NORTHLAND_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.NORTHLAND_WOOD.get(), (Block)ESBlocks.NORTHLAND_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_NORTHLAND_WOOD.get(), (Block)ESBlocks.STRIPPED_NORTHLAND_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.NORTHLAND_PRESSURE_PLATE.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.NORTHLAND_SLAB.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.NORTHLAND_STAIRS.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.NORTHLAND_TRAPDOOR.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.NORTHLAND_SIGN.get(), ESBlocks.NORTHLAND_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.NORTHLAND_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_NORTHLAND_LOG.get()));
        this.addBoat(recipeOutput, ESItems.NORTHLAND_BOAT.get(), ESItems.NORTHLAND_CHEST_BOAT.get(), ESBlocks.NORTHLAND_PLANKS.get());
        this.addButton(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_BUTTON.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_DOOR.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_FENCE.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_FENCE_GATE.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.STARLIGHT_MANGROVE_PLANKS.get(), ESTags.Items.STARLIGHT_MANGROVE_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_WOOD.get(), (Block)ESBlocks.STARLIGHT_MANGROVE_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_STARLIGHT_MANGROVE_WOOD.get(), (Block)ESBlocks.STRIPPED_STARLIGHT_MANGROVE_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_PRESSURE_PLATE.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_SLAB.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_STAIRS.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.STARLIGHT_MANGROVE_TRAPDOOR.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.STARLIGHT_MANGROVE_SIGN.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.STARLIGHT_MANGROVE_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_STARLIGHT_MANGROVE_LOG.get()));
        this.addBoat(recipeOutput, ESItems.STARLIGHT_MANGROVE_BOAT.get(), ESItems.STARLIGHT_MANGROVE_CHEST_BOAT.get(), ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addButton(recipeOutput, (Block)ESBlocks.SCARLET_BUTTON.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.SCARLET_DOOR.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.SCARLET_FENCE.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.SCARLET_FENCE_GATE.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.SCARLET_PLANKS.get(), ESTags.Items.SCARLET_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.SCARLET_WOOD.get(), (Block)ESBlocks.SCARLET_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_SCARLET_WOOD.get(), (Block)ESBlocks.STRIPPED_SCARLET_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.SCARLET_PRESSURE_PLATE.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.SCARLET_SLAB.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.SCARLET_STAIRS.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.SCARLET_TRAPDOOR.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.SCARLET_SIGN.get(), ESBlocks.SCARLET_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.SCARLET_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_SCARLET_LOG.get()));
        this.addBoat(recipeOutput, ESItems.SCARLET_BOAT.get(), ESItems.SCARLET_CHEST_BOAT.get(), ESBlocks.SCARLET_PLANKS.get());
        this.addButton(recipeOutput, (Block)ESBlocks.TORREYA_BUTTON.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.TORREYA_DOOR.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.TORREYA_FENCE.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.TORREYA_FENCE_GATE.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.TORREYA_PLANKS.get(), ESTags.Items.TORREYA_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.TORREYA_WOOD.get(), (Block)ESBlocks.TORREYA_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_TORREYA_WOOD.get(), (Block)ESBlocks.STRIPPED_TORREYA_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.TORREYA_PRESSURE_PLATE.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.TORREYA_SLAB.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.TORREYA_STAIRS.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.TORREYA_TRAPDOOR.get(), ESBlocks.TORREYA_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.TORREYA_SIGN.get(), ESBlocks.TORREYA_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.TORREYA_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_TORREYA_LOG.get()));
        this.addBoat(recipeOutput, ESItems.TORREYA_BOAT.get(), ESItems.TORREYA_CHEST_BOAT.get(), ESBlocks.TORREYA_PLANKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.TORREYA_CAMPFIRE.get())).pattern(" S ").pattern("SAS").pattern("LLL").define(Character.valueOf('L'), ESTags.Items.TORREYA_LOGS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('A'), ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER).unlockedBy("has_stick", ESRecipeProvider.has((TagKey)Tags.Items.RODS_WOODEN)).unlockedBy("has_fuel", ESRecipeProvider.has(ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER)).save(recipeOutput);
        this.addButton(recipeOutput, (Block)ESBlocks.JINGLESTEM_BUTTON.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.JINGLESTEM_DOOR.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.JINGLESTEM_FENCE.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.JINGLESTEM_FENCE_GATE.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.JINGLESTEM_PLANKS.get(), ESTags.Items.JINGLESTEM_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.JINGLESTEM_WOOD.get(), (Block)ESBlocks.JINGLESTEM_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_JINGLESTEM_WOOD.get(), (Block)ESBlocks.STRIPPED_JINGLESTEM_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.JINGLESTEM_PRESSURE_PLATE.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.JINGLESTEM_SLAB.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.JINGLESTEM_STAIRS.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.JINGLESTEM_TRAPDOOR.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.JINGLESTEM_SIGN.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.JINGLESTEM_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_JINGLESTEM_LOG.get()));
        this.addBoat(recipeOutput, ESItems.JINGLESTEM_RAFT.get(), ESItems.JINGLESTEM_CHEST_RAFT.get(), ESBlocks.JINGLESTEM_PLANKS.get());
        this.addButton(recipeOutput, (Block)ESBlocks.CRADLEWOOD_BUTTON.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addDoor(recipeOutput, (Block)ESBlocks.CRADLEWOOD_DOOR.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addFence(recipeOutput, (Block)ESBlocks.CRADLEWOOD_FENCE.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.CRADLEWOOD_FENCE_GATE.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addPlanks(recipeOutput, ESBlocks.CRADLEWOOD_PLANKS.get(), ESTags.Items.CRADLEWOOD_LOGS);
        this.addWood(recipeOutput, (Block)ESBlocks.CRADLEWOOD_WOOD.get(), (Block)ESBlocks.CRADLEWOOD_LOG.get());
        this.addStrippedWood(recipeOutput, (Block)ESBlocks.STRIPPED_CRADLEWOOD_WOOD.get(), (Block)ESBlocks.STRIPPED_CRADLEWOOD_LOG.get());
        this.addPressurePlate(recipeOutput, (Block)ESBlocks.CRADLEWOOD_PRESSURE_PLATE.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.CRADLEWOOD_SLAB.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.CRADLEWOOD_STAIRS.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addTrapdoor(recipeOutput, (Block)ESBlocks.CRADLEWOOD_TRAPDOOR.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        this.addSign(recipeOutput, (ItemLike)ESItems.CRADLEWOOD_SIGN.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
        ESRecipeProvider.hangingSign((RecipeOutput)recipeOutput, (ItemLike)((ItemLike)ESItems.CRADLEWOOD_HANGING_SIGN.get()), (ItemLike)((ItemLike)ESBlocks.STRIPPED_CRADLEWOOD_LOG.get()));
        this.addBoat(recipeOutput, ESItems.CRADLEWOOD_BOAT.get(), ESItems.CRADLEWOOD_CHEST_BOAT.get(), ESBlocks.CRADLEWOOD_PLANKS.get());
    }

    private void stonecuttingSet(RecipeOutput recipeOutput, ItemLike slab, ItemLike stairs, ItemLike wall, ItemLike source) {
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, slab, source, 2);
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, stairs, source);
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, wall, source);
    }

    private void addStoneRecipes(RecipeOutput recipeOutput) {
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get(), (ItemLike)ESBlocks.GRIMSTONE.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.CRACKED_GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.CRACKED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_GRIMSTONE.get(), ESBlocks.GRIMSTONE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.GRIMSTONE_BRICKS.get(), ESBlocks.POLISHED_GRIMSTONE.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_GRIMSTONE.get()), (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_BRICK_SLAB.get()));
        this.addStoneCompress(recipeOutput, ESBlocks.GRIMSTONE_TILES.get(), ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_WALL.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GRIMSTONE.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GRIMSTONE.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GRIMSTONE.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GRIMSTONE.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.GRIMSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.GRIMSTONE_STAIRS.get(), ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.GRIMSTONE_SLAB.get(), ESBlocks.GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.COBBLED_GRIMSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.COBBLED_GRIMSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_GRIMSTONE_WALL.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.COBBLED_GRIMSTONE_STAIRS.get(), ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_GRIMSTONE_STAIRS.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.COBBLED_GRIMSTONE_SLAB.get(), ESBlocks.COBBLED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_GRIMSTONE_SLAB.get(), (ItemLike)ESBlocks.COBBLED_GRIMSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.GRIMSTONE_BRICK_STAIRS.get(), ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.GRIMSTONE_BRICK_SLAB.get(), ESBlocks.GRIMSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_GRIMSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_GRIMSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_WALL.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_GRIMSTONE_STAIRS.get(), ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_GRIMSTONE_SLAB.get(), ESBlocks.POLISHED_GRIMSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.GRIMSTONE_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), ESBlocks.GRIMSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.GRIMSTONE_TILE_SLAB.get(), ESBlocks.GRIMSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.GRIMSTONE_TILES.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), ESBlocks.POLISHED_GRIMSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), ESBlocks.POLISHED_GRIMSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_GRIMSTONE_TILES.get(), 2);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get(), (ItemLike)ESBlocks.VOIDSTONE.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get(), (ItemLike)ESBlocks.CRACKED_VOIDSTONE_BRICKS.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.CRACKED_VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.VOIDSTONE_TILES.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_VOIDSTONE.get(), ESBlocks.VOIDSTONE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.VOIDSTONE_BRICKS.get(), ESBlocks.POLISHED_VOIDSTONE.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_VOIDSTONE.get()), (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_BRICK_SLAB.get()));
        this.addStoneCompress(recipeOutput, ESBlocks.VOIDSTONE_TILES.get(), ESBlocks.VOIDSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_VOIDSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE_WALL.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_VOIDSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.VOIDSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_VOIDSTONE.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_VOIDSTONE.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_VOIDSTONE.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_VOIDSTONE.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.VOIDSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.VOIDSTONE_STAIRS.get(), ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.VOIDSTONE_SLAB.get(), ESBlocks.VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.COBBLED_VOIDSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.COBBLED_VOIDSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_VOIDSTONE_WALL.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.COBBLED_VOIDSTONE_STAIRS.get(), ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_VOIDSTONE_STAIRS.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.COBBLED_VOIDSTONE_SLAB.get(), ESBlocks.COBBLED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_VOIDSTONE_SLAB.get(), (ItemLike)ESBlocks.COBBLED_VOIDSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.VOIDSTONE_BRICK_STAIRS.get(), ESBlocks.VOIDSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.VOIDSTONE_BRICK_SLAB.get(), ESBlocks.VOIDSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_VOIDSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_VOIDSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_VOIDSTONE_WALL.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_VOIDSTONE_STAIRS.get(), ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_VOIDSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_VOIDSTONE_SLAB.get(), ESBlocks.POLISHED_VOIDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_VOIDSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_VOIDSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.VOIDSTONE_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILE_WALL.get(), (ItemLike)ESBlocks.VOIDSTONE_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), ESBlocks.VOIDSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILE_STAIRS.get(), (ItemLike)ESBlocks.VOIDSTONE_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.VOIDSTONE_TILE_SLAB.get(), ESBlocks.VOIDSTONE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.VOIDSTONE_TILE_SLAB.get(), (ItemLike)ESBlocks.VOIDSTONE_TILES.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.ETERNAL_ICE_BRICKS.get(), ESBlocks.ETERNAL_ICE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.ETERNAL_ICE_BRICKS.get(), (ItemLike)ESBlocks.ETERNAL_ICE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_SLAB.get(), (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_WALL.get(), (ItemLike)ESBlocks.ETERNAL_ICE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.ETERNAL_ICE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.ETERNAL_ICE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_WALL.get(), (ItemLike)ESBlocks.ETERNAL_ICE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.ETERNAL_ICE_BRICK_STAIRS.get(), ESBlocks.ETERNAL_ICE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.ETERNAL_ICE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.ETERNAL_ICE_BRICK_SLAB.get(), ESBlocks.ETERNAL_ICE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.ETERNAL_ICE_BRICK_SLAB.get(), (ItemLike)ESBlocks.ETERNAL_ICE_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.ETERNAL_ICE_LANTERN.get())).pattern(" I ").pattern("ITI").pattern(" I ").define(Character.valueOf('I'), (ItemLike)ESBlocks.ETERNAL_ICE.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESBlocks.ETERNAL_ICE.get()))).save(recipeOutput);
        this.addStoneCompress(recipeOutput, ESBlocks.HAZE_ICE_BRICKS.get(), ESBlocks.HAZE_ICE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.HAZE_ICE_BRICKS.get(), (ItemLike)ESBlocks.HAZE_ICE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.HAZE_ICE_BRICK_SLAB.get(), (ItemLike)ESBlocks.HAZE_ICE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.HAZE_ICE_BRICK_WALL.get(), (ItemLike)ESBlocks.HAZE_ICE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.HAZE_ICE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.HAZE_ICE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.HAZE_ICE_BRICK_WALL.get(), (ItemLike)ESBlocks.HAZE_ICE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.HAZE_ICE_BRICK_STAIRS.get(), ESBlocks.HAZE_ICE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.HAZE_ICE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.HAZE_ICE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.HAZE_ICE_BRICK_SLAB.get(), ESBlocks.HAZE_ICE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.HAZE_ICE_BRICK_SLAB.get(), (ItemLike)ESBlocks.HAZE_ICE_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.HAZE_ICE_LANTERN.get())).pattern(" I ").pattern("ITI").pattern(" I ").define(Character.valueOf('I'), (ItemLike)ESBlocks.HAZE_ICE.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESBlocks.HAZE_ICE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.REINFORCED_ICE.get()), (int)8).pattern("GIG").pattern("III").pattern("GIG").define(Character.valueOf('G'), ESConventionalTags.Items.GEMS_GLACITE).define(Character.valueOf('I'), (ItemLike)Blocks.ICE).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_GLACITE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.REINFORCED_ICE_PANE.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESBlocks.REINFORCED_ICE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESBlocks.REINFORCED_ICE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.NEBULAITE.get()), (int)4).pattern("$#").pattern("#$").define(Character.valueOf('#'), (ItemLike)ESItems.RAW_AETHERSENT.get()).define(Character.valueOf('$'), (ItemLike)Blocks.DEEPSLATE).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RAW_AETHERSENT.get()))).save(recipeOutput);
        this.addStoneCompress(recipeOutput, ESBlocks.NEBULAITE_BRICKS.get(), ESBlocks.NEBULAITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NEBULAITE_BRICKS.get(), (ItemLike)ESBlocks.NEBULAITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.NEBULAITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.NEBULAITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.NEBULAITE_BRICK_WALL.get(), (ItemLike)ESBlocks.NEBULAITE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.NEBULAITE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.NEBULAITE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NEBULAITE_BRICK_WALL.get(), (ItemLike)ESBlocks.NEBULAITE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.NEBULAITE_BRICK_STAIRS.get(), ESBlocks.NEBULAITE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NEBULAITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.NEBULAITE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.NEBULAITE_BRICK_SLAB.get(), ESBlocks.NEBULAITE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NEBULAITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.NEBULAITE_BRICKS.get(), 2);
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_NEBULAITE_BRICKS.get()), (ItemLike)((ItemLike)ESBlocks.NEBULAITE_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_NEBULAITE_BRICKS.get(), (ItemLike)ESBlocks.NEBULAITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_NEBULAITE_BRICKS.get(), (ItemLike)ESBlocks.NEBULAITE_BRICKS.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESBlocks.COBBLED_RADIANITE.get(), (ItemLike)ESBlocks.RADIANITE.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_RADIANITE.get(), ESBlocks.RADIANITE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.RADIANITE_BRICKS.get(), ESBlocks.POLISHED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_RADIANITE.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_RADIANITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE_WALL.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_RADIANITE.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_RADIANITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE_WALL.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICKS.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.RADIANITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_WALL.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICKS.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.RADIANITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_WALL.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.RADIANITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.RADIANITE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_RADIANITE.get()), (ItemLike)((ItemLike)ESBlocks.RADIANITE_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_RADIANITE.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_RADIANITE.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_RADIANITE.get(), (ItemLike)ESBlocks.RADIANITE_BRICKS.get());
        this.addPillar(recipeOutput, (Block)ESBlocks.RADIANITE_PILLAR.get(), ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_PILLAR.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_PILLAR.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.RADIANITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.RADIANITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_WALL.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.RADIANITE_STAIRS.get(), ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_STAIRS.get(), (ItemLike)ESBlocks.RADIANITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.RADIANITE_SLAB.get(), ESBlocks.RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_SLAB.get(), (ItemLike)ESBlocks.RADIANITE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.COBBLED_RADIANITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.COBBLED_RADIANITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_RADIANITE_WALL.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.COBBLED_RADIANITE_STAIRS.get(), ESBlocks.COBBLED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_RADIANITE_STAIRS.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.COBBLED_RADIANITE_SLAB.get(), ESBlocks.COBBLED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.COBBLED_RADIANITE_SLAB.get(), (ItemLike)ESBlocks.COBBLED_RADIANITE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_RADIANITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_RADIANITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_RADIANITE_WALL.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_RADIANITE_STAIRS.get(), ESBlocks.POLISHED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_RADIANITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_RADIANITE_SLAB.get(), ESBlocks.POLISHED_RADIANITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_RADIANITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_RADIANITE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.RADIANITE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.RADIANITE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICK_WALL.get(), (ItemLike)ESBlocks.RADIANITE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.RADIANITE_BRICK_STAIRS.get(), ESBlocks.RADIANITE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.RADIANITE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.RADIANITE_BRICK_SLAB.get(), ESBlocks.RADIANITE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.RADIANITE_BRICK_SLAB.get(), (ItemLike)ESBlocks.RADIANITE_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.FLARE_BRICKS.get())).pattern("##").pattern("##").unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.FLARE_BRICK.get()))).define(Character.valueOf('#'), (ItemLike)ESItems.FLARE_BRICK.get()).save(recipeOutput);
        this.addStoneCompress(recipeOutput, ESBlocks.FLARE_TILES.get(), ESBlocks.FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_TILES.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.FLARE_TILE_SLAB.get(), (ItemLike)ESBlocks.FLARE_TILE_STAIRS.get(), (ItemLike)ESBlocks.FLARE_TILE_WALL.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.FLARE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.FLARE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_BRICK_WALL.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.FLARE_BRICK_STAIRS.get(), ESBlocks.FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.FLARE_BRICK_SLAB.get(), ESBlocks.FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_BRICK_SLAB.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get(), 2);
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_BRICKS.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.CUT_FLARE_BRICK_SLAB.get(), (ItemLike)ESBlocks.CUT_FLARE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.CUT_FLARE_BRICK_WALL.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CUT_FLARE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.CUT_FLARE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_BRICK_WALL.get(), (ItemLike)ESBlocks.CUT_FLARE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.CUT_FLARE_BRICK_STAIRS.get(), ESBlocks.CUT_FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.CUT_FLARE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.CUT_FLARE_BRICK_SLAB.get(), ESBlocks.CUT_FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_BRICK_SLAB.get(), (ItemLike)ESBlocks.CUT_FLARE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.FLARE_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.FLARE_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_TILE_WALL.get(), (ItemLike)ESBlocks.FLARE_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.FLARE_TILE_STAIRS.get(), ESBlocks.FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_TILE_STAIRS.get(), (ItemLike)ESBlocks.FLARE_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.FLARE_TILE_SLAB.get(), ESBlocks.FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLARE_TILE_SLAB.get(), (ItemLike)ESBlocks.FLARE_TILES.get(), 2);
        this.addPillar(recipeOutput, (Block)ESBlocks.CHISELED_FLARE_PILLAR.get(), ESBlocks.FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_FLARE_PILLAR.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_FLARE_PILLAR.get(), (ItemLike)ESBlocks.FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_TILES.get(), (ItemLike)ESBlocks.FLARE_TILES.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.CUT_FLARE_TILE_SLAB.get(), (ItemLike)ESBlocks.CUT_FLARE_TILE_STAIRS.get(), (ItemLike)ESBlocks.CUT_FLARE_TILE_WALL.get(), (ItemLike)ESBlocks.FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_TILES.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.CUT_FLARE_TILE_SLAB.get(), (ItemLike)ESBlocks.CUT_FLARE_TILE_STAIRS.get(), (ItemLike)ESBlocks.CUT_FLARE_TILE_WALL.get(), (ItemLike)ESBlocks.FLARE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CUT_FLARE_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.CUT_FLARE_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_TILE_WALL.get(), (ItemLike)ESBlocks.CUT_FLARE_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.CUT_FLARE_TILE_STAIRS.get(), ESBlocks.CUT_FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_TILE_STAIRS.get(), (ItemLike)ESBlocks.CUT_FLARE_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.CUT_FLARE_TILE_SLAB.get(), ESBlocks.CUT_FLARE_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_FLARE_TILE_SLAB.get(), (ItemLike)ESBlocks.CUT_FLARE_TILES.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_STELLAGMITE.get(), ESBlocks.STELLAGMITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_STELLAGMITE.get(), (ItemLike)ESBlocks.STELLAGMITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_STELLAGMITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_STELLAGMITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_STELLAGMITE_WALL.get(), (ItemLike)ESBlocks.STELLAGMITE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.STELLAGMITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.STELLAGMITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.STELLAGMITE_WALL.get(), (ItemLike)ESBlocks.STELLAGMITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.STELLAGMITE_STAIRS.get(), ESBlocks.STELLAGMITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.STELLAGMITE_STAIRS.get(), (ItemLike)ESBlocks.STELLAGMITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.STELLAGMITE_SLAB.get(), ESBlocks.STELLAGMITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.STELLAGMITE_SLAB.get(), (ItemLike)ESBlocks.STELLAGMITE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_STELLAGMITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_STELLAGMITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_STELLAGMITE_WALL.get(), (ItemLike)ESBlocks.POLISHED_STELLAGMITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_STELLAGMITE_STAIRS.get(), ESBlocks.POLISHED_STELLAGMITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_STELLAGMITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_STELLAGMITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_STELLAGMITE_SLAB.get(), ESBlocks.POLISHED_STELLAGMITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_STELLAGMITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_STELLAGMITE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_ABYSSLATE.get(), ESBlocks.ABYSSLATE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_ABYSSLATE_BRICKS.get(), ESBlocks.POLISHED_ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_ABYSSLATE.get(), (ItemLike)ESBlocks.ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_ABYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_ABYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_POLISHED_ABYSSLATE.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get(), (ItemLike)ESBlocks.ABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_WALL.get(), (ItemLike)ESBlocks.ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.ABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_ABYSSLATE_BRICK_STAIRS.get(), ESBlocks.POLISHED_ABYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_ABYSSLATE_BRICK_SLAB.get(), ESBlocks.POLISHED_ABYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_ABYSSLATE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_ABYSSLATE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_WALL.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_ABYSSLATE_STAIRS.get(), ESBlocks.POLISHED_ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_ABYSSLATE_SLAB.get(), ESBlocks.POLISHED_ABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_ABYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_ABYSSLATE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_THERMABYSSLATE.get(), ESBlocks.THERMABYSSLATE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get(), ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_THERMABYSSLATE.get(), (ItemLike)ESBlocks.THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_THERMABYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_THERMABYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_POLISHED_THERMABYSSLATE.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get(), (ItemLike)ESBlocks.THERMABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_WALL.get(), (ItemLike)ESBlocks.THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.THERMABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_STAIRS.get(), ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_SLAB.get(), ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_WALL.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_THERMABYSSLATE_STAIRS.get(), ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_THERMABYSSLATE_SLAB.get(), ESBlocks.POLISHED_THERMABYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_THERMABYSSLATE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_CRYOBYSSLATE.get(), ESBlocks.CRYOBYSSLATE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get(), ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_CRYOBYSSLATE.get(), (ItemLike)ESBlocks.CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_CRYOBYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_CRYOBYSSLATE.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_POLISHED_CRYOBYSSLATE.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get(), (ItemLike)ESBlocks.CRYOBYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_WALL.get(), (ItemLike)ESBlocks.CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.CRYOBYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_STAIRS.get(), ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_SLAB.get(), ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_WALL.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_CRYOBYSSLATE_STAIRS.get(), ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_CRYOBYSSLATE_SLAB.get(), ESBlocks.POLISHED_CRYOBYSSLATE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_CRYOBYSSLATE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.NIGHTFALL_MUD_BRICKS.get(), ESBlocks.PACKED_NIGHTFALL_MUD.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.NIGHTFALL_MUD_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.NIGHTFALL_MUD_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICK_WALL.get(), (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.NIGHTFALL_MUD_BRICK_STAIRS.get(), ESBlocks.NIGHTFALL_MUD_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICK_STAIRS.get(), (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.NIGHTFALL_MUD_BRICK_SLAB.get(), ESBlocks.NIGHTFALL_MUD_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICK_SLAB.get(), (ItemLike)ESBlocks.NIGHTFALL_MUD_BRICKS.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.TWILIGHT_SANDSTONE.get(), (Block)ESBlocks.TWILIGHT_SAND.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_TWILIGHT_SANDSTONE.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.TWILIGHT_SANDSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TWILIGHT_SANDSTONE_WALL.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.TWILIGHT_SANDSTONE_STAIRS.get(), ESBlocks.TWILIGHT_SANDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TWILIGHT_SANDSTONE_STAIRS.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.TWILIGHT_SANDSTONE_SLAB.get(), ESBlocks.TWILIGHT_SANDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TWILIGHT_SANDSTONE_SLAB.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.CUT_TWILIGHT_SANDSTONE.get(), ESBlocks.TWILIGHT_SANDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_SLAB.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_STAIRS.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_WALL.get(), (ItemLike)ESBlocks.TWILIGHT_SANDSTONE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_WALL.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.CUT_TWILIGHT_SANDSTONE_STAIRS.get(), ESBlocks.CUT_TWILIGHT_SANDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_STAIRS.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.CUT_TWILIGHT_SANDSTONE_SLAB.get(), ESBlocks.CUT_TWILIGHT_SANDSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_SLAB.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get(), 2);
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_TWILIGHT_SANDSTONE.get()), (ItemLike)((ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_TWILIGHT_SANDSTONE.get(), (ItemLike)ESBlocks.CUT_TWILIGHT_SANDSTONE.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESItems.DUSTED_BRICKS.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESItems.DUSTED_SHARD.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.DUSTED_SHARD.get()))).save(recipeOutput);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.DUSTED_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.DUSTED_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DUSTED_BRICK_WALL.get(), (ItemLike)ESBlocks.DUSTED_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.DUSTED_BRICK_STAIRS.get(), ESBlocks.DUSTED_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DUSTED_BRICK_STAIRS.get(), (ItemLike)ESBlocks.DUSTED_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.DUSTED_BRICK_SLAB.get(), ESBlocks.DUSTED_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DUSTED_BRICK_SLAB.get(), (ItemLike)ESBlocks.DUSTED_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_LANTERN.get())).pattern(" S ").pattern("STS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_LANTERN.get())).pattern(" S ").pattern("STS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get()))).save(recipeOutput);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.SPRINGSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.SPRINGSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_WALL.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.SPRINGSTONE_STAIRS.get(), ESBlocks.SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_STAIRS.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.SPRINGSTONE_SLAB.get(), ESBlocks.SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_SLAB.get(), (ItemLike)ESBlocks.SPRINGSTONE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_SPRINGSTONE.get(), ESBlocks.SPRINGSTONE.get());
        this.addStoneCompress(recipeOutput, ESBlocks.SPRINGSTONE_BRICKS.get(), ESBlocks.POLISHED_SPRINGSTONE.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_SPRINGSTONE.get()), (ItemLike)((ItemLike)ESBlocks.SPRINGSTONE_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_SPRINGSTONE.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_SPRINGSTONE.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_SPRINGSTONE.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_WALL.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.SPRINGSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.SPRINGSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.SPRINGSTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.SPRINGSTONE_BRICK_STAIRS.get(), ESBlocks.SPRINGSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.SPRINGSTONE_BRICK_SLAB.get(), ESBlocks.SPRINGSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.SPRINGSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.SPRINGSTONE_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_SPRINGSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_WALL.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_SPRINGSTONE_STAIRS.get(), ESBlocks.POLISHED_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_SPRINGSTONE_SLAB.get(), ESBlocks.POLISHED_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_SPRINGSTONE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_SPRINGSTONE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.THERMAL_SPRINGSTONE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_WALL.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.THERMAL_SPRINGSTONE_STAIRS.get(), ESBlocks.THERMAL_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_STAIRS.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.THERMAL_SPRINGSTONE_SLAB.get(), ESBlocks.THERMAL_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_SLAB.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get(), ESBlocks.THERMAL_SPRINGSTONE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_WALL.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.THERMAL_SPRINGSTONE_BRICK_STAIRS.get(), ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.THERMAL_SPRINGSTONE_BRICK_SLAB.get(), ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICK_SLAB.get(), (ItemLike)ESBlocks.THERMAL_SPRINGSTONE_BRICKS.get(), 2);
        ESRecipeProvider.grate((RecipeOutput)recipeOutput, (Block)((Block)ESBlocks.DEEPSILVER_GRATE.get()), (Block)ESBlocks.DEEPSILVER_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DEEPSILVER_GRATE.get(), (ItemLike)ESBlocks.DEEPSILVER_BLOCK.get(), 4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.DEEPSILVER_BARS.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESItems.DEEPSILVER_INGOT.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.DEEPSILVER_INGOT.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLOWGLAZE.get(), (ItemLike)ESBlocks.FLOWGLAZE_BRICKS.get(), 8, (ItemLike)ESBlocks.FLOWGLAZE.get(), (ItemLike)ESBlocks.FLOWGLAZE.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get(), (ItemLike)ESBlocks.GRIMSTONE_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.FLOWGLAZE_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.FLOWGLAZE_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLOWGLAZE_BRICK_WALL.get(), (ItemLike)ESBlocks.FLOWGLAZE_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.FLOWGLAZE_BRICK_STAIRS.get(), ESBlocks.FLOWGLAZE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLOWGLAZE_BRICK_STAIRS.get(), (ItemLike)ESBlocks.FLOWGLAZE_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.FLOWGLAZE_BRICK_SLAB.get(), ESBlocks.FLOWGLAZE_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.FLOWGLAZE_BRICK_SLAB.get(), (ItemLike)ESBlocks.FLOWGLAZE_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.AMARAMBER_BRICKS.get()), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ESItems.AMARAMBER_INGOT.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.AMARAMBER_INGOT.get()))).save(recipeOutput);
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.AMARAMBER_BRICKS.get(), (ItemLike)ESBlocks.RAW_AMARAMBER_BLOCK.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.AMARAMBER_BRICK_SLAB.get(), (ItemLike)ESBlocks.AMARAMBER_BRICK_STAIRS.get(), (ItemLike)ESBlocks.AMARAMBER_BRICK_WALL.get(), (ItemLike)ESBlocks.RAW_AMARAMBER_BLOCK.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.AMARAMBER_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.AMARAMBER_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.AMARAMBER_BRICK_WALL.get(), (ItemLike)ESBlocks.AMARAMBER_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.AMARAMBER_BRICK_STAIRS.get(), ESBlocks.AMARAMBER_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.AMARAMBER_BRICK_STAIRS.get(), (ItemLike)ESBlocks.AMARAMBER_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.AMARAMBER_BRICK_SLAB.get(), ESBlocks.AMARAMBER_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.AMARAMBER_BRICK_SLAB.get(), (ItemLike)ESBlocks.AMARAMBER_BRICKS.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESItems.TORREYA_TILES.get()), (int)32).pattern("IL").pattern("LI").define(Character.valueOf('I'), ESConventionalTags.Items.INGOTS_AMARAMBER).define(Character.valueOf('L'), ESTags.Items.TORREYA_LOGS).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AMARAMBER)).save(recipeOutput);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.TORREYA_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.TORREYA_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TORREYA_TILE_WALL.get(), (ItemLike)ESBlocks.TORREYA_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.TORREYA_TILE_STAIRS.get(), ESBlocks.TORREYA_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TORREYA_TILE_STAIRS.get(), (ItemLike)ESBlocks.TORREYA_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.TORREYA_TILE_SLAB.get(), ESBlocks.TORREYA_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TORREYA_TILE_SLAB.get(), (ItemLike)ESBlocks.TORREYA_TILES.get(), 2);
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_TOXITE.get(), ESBlocks.TOXITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_TOXITE.get(), (ItemLike)ESBlocks.TOXITE.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_TOXITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_TOXITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_TOXITE_WALL.get(), (ItemLike)ESBlocks.TOXITE.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.TOXITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.TOXITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOXITE_WALL.get(), (ItemLike)ESBlocks.TOXITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.TOXITE_STAIRS.get(), ESBlocks.TOXITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOXITE_STAIRS.get(), (ItemLike)ESBlocks.TOXITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.TOXITE_SLAB.get(), ESBlocks.TOXITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOXITE_SLAB.get(), (ItemLike)ESBlocks.TOXITE.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_TOXITE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_TOXITE.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_TOXITE_WALL.get(), (ItemLike)ESBlocks.POLISHED_TOXITE.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_TOXITE_STAIRS.get(), ESBlocks.POLISHED_TOXITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_TOXITE_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_TOXITE.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_TOXITE_SLAB.get(), ESBlocks.POLISHED_TOXITE.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_TOXITE_SLAB.get(), (ItemLike)ESBlocks.POLISHED_TOXITE.get(), 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get())).pattern("##").pattern("##").unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TOOTH_OF_HUNGER.get()))).define(Character.valueOf('#'), (ItemLike)ESItems.TOOTH_OF_HUNGER.get()).save(recipeOutput);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILE_WALL.get(), (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.TOOTH_OF_HUNGER_TILE_STAIRS.get(), ESBlocks.TOOTH_OF_HUNGER_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILE_STAIRS.get(), (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.TOOTH_OF_HUNGER_TILE_SLAB.get(), ESBlocks.TOOTH_OF_HUNGER_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILE_SLAB.get(), (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get(), 2);
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_TOOTH_OF_HUNGER_TILES.get()), (ItemLike)((ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILE_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_TOOTH_OF_HUNGER_TILES.get(), (ItemLike)ESBlocks.TOOTH_OF_HUNGER_TILES.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ESBlocks.CRYSTALBORN_CATALYST.get())).pattern("BTB").pattern("TRT").pattern("BTB").unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TOOTH_OF_HUNGER.get()))).define(Character.valueOf('T'), (ItemLike)ESItems.TOOTH_OF_HUNGER.get()).define(Character.valueOf('B'), (ItemLike)ESItems.CINDER_BRICK.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).save(recipeOutput);
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.GOLEM_STEEL_INGOT.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.GOLEM_STEEL_BLOCK.get(), "golem_steel_ingot_from_golem_steel_block", "golem_steel_ingot");
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_BLOCK.get(), "oxidized_golem_steel_ingot_from_oxidized_golem_steel_block", "oxidized_golem_steel_ingot");
        this.nineBlockStorageCustomPacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.GOLEM_STEEL_NUGGET.get(), RecipeCategory.MISC, (ItemLike)ESItems.GOLEM_STEEL_INGOT.get(), "golem_steel_ingot_from_nuggets", "golem_steel_ingot");
        this.nineBlockStorageCustomPacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_NUGGET.get(), RecipeCategory.MISC, (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get(), "oxidized_golem_steel_ingot_from_nuggets", "oxidized_golem_steel_ingot");
        this.addStoneCompress(recipeOutput, ESBlocks.GOLEM_STEEL_TILES.get(), ESBlocks.GOLEM_STEEL_BLOCK.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get()), (ItemLike)((ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.GOLEM_STEEL_STAIRS.get(), ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_STAIRS.get(), (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.GOLEM_STEEL_SLAB.get(), ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get(), (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), 2);
        this.addStairs(recipeOutput, (Block)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), ESBlocks.GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESBlocks.GOLEM_STEEL_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), ESBlocks.GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESBlocks.GOLEM_STEEL_TILES.get(), 2);
        ESRecipeProvider.grate((RecipeOutput)recipeOutput, (Block)((Block)ESBlocks.GOLEM_STEEL_GRATE.get()), (Block)ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_GRATE.get(), (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), 4);
        this.addPillar(recipeOutput, (Block)ESBlocks.GOLEM_STEEL_PILLAR.get(), ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_PILLAR.get(), (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get());
        this.addStoneCompress(recipeOutput, ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.OXIDIZED_CHISELED_GOLEM_STEEL_BLOCK.get()), (ItemLike)((ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_STAIRS.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_STAIRS.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_SLAB.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_SLAB.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get(), 2);
        this.addStairs(recipeOutput, (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_STAIRS.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_SLAB.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get(), 2);
        ESRecipeProvider.grate((RecipeOutput)recipeOutput, (Block)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_GRATE.get()), (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_GRATE.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get(), 4);
        this.addPillar(recipeOutput, (Block)ESBlocks.OXIDIZED_GOLEM_STEEL_PILLAR.get(), ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_PILLAR.get(), (ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get());
        this.addStoneCompress(recipeOutput, ESBlocks.WAXED_GOLEM_STEEL_TILES.get(), ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get()), (ItemLike)((ItemLike)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get(), ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get(), ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get(), 2);
        this.addStairs(recipeOutput, (Block)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get(), ESBlocks.WAXED_GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get(), ESBlocks.WAXED_GOLEM_STEEL_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILES.get(), 2);
        ESRecipeProvider.grate((RecipeOutput)recipeOutput, (Block)((Block)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get()), (Block)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get(), 4);
        this.addPillar(recipeOutput, (Block)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get(), ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_STAIRS.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_TILES.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILES.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_TILES.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_GRATE.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_GRATE.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_PILLAR.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_PILLAR.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_BARS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BARS.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_BARS.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.GOLEM_STEEL_JET.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_JET.get(), 1, new ItemLike[]{(ItemLike)ESBlocks.GOLEM_STEEL_JET.get(), Items.HONEYCOMB});
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_BLOCK.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_SLAB.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_STAIRS.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_TILES.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILES.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_TILES.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_SLAB.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_GRATE.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_GRATE.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_PILLAR.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_PILLAR.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_BARS.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_BARS.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_BARS.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get(), 1, (ItemLike)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, "_from_raw_amaramber", (ItemLike)ESBlocks.GOLEM_STEEL_JET.get(), (ItemLike)ESBlocks.WAXED_GOLEM_STEEL_JET.get(), 1, (ItemLike)ESBlocks.GOLEM_STEEL_JET.get(), (ItemLike)ESItems.RAW_AMARAMBER.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.GOLEM_STEEL_BARS.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESItems.GOLEM_STEEL_INGOT.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.GOLEM_STEEL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.OXIDIZED_GOLEM_STEEL_BARS.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.GOLEM_STEEL_CRATE.get())).pattern("SGS").pattern("SCS").pattern("SGS").define(Character.valueOf('G'), (ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get()).define(Character.valueOf('S'), (ItemLike)ESItems.DEEPSILVER_INGOT.get()).define(Character.valueOf('C'), (ItemLike)Items.CHEST).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.OXIDIZED_GOLEM_STEEL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.LUNAR_MOSAIC.get()), (int)12).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ESItems.TENACIOUS_PETAL.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.TENACIOUS_PETAL.get()))).save(recipeOutput);
        this.addStairs(recipeOutput, (Block)ESBlocks.LUNAR_MOSAIC_STAIRS.get(), ESBlocks.LUNAR_MOSAIC.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.LUNAR_MOSAIC_STAIRS.get(), (ItemLike)ESBlocks.LUNAR_MOSAIC.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.LUNAR_MOSAIC_SLAB.get(), ESBlocks.LUNAR_MOSAIC.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.LUNAR_MOSAIC_SLAB.get(), (ItemLike)ESBlocks.LUNAR_MOSAIC.get(), 2);
        this.addFence(recipeOutput, (Block)ESBlocks.LUNAR_MOSAIC_FENCE.get(), ESBlocks.LUNAR_MOSAIC.get());
        this.addFenceGate(recipeOutput, (Block)ESBlocks.LUNAR_MOSAIC_FENCE_GATE.get(), ESBlocks.LUNAR_MOSAIC.get());
        this.customCarpet(recipeOutput, (ItemLike)ESBlocks.LUNAR_MAT.get(), (ItemLike)ESBlocks.LUNAR_MOSAIC.get());
        this.addStoneCompress(recipeOutput, ESBlocks.POLISHED_DOOMEDEN_BRICKS.get(), ESBlocks.DOOMEDEN_BRICKS.get());
        this.addStoneCompress(recipeOutput, ESBlocks.DOOMEDEN_TILES.get(), ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        ESRecipeProvider.chiseled((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.CHISELED_POLISHED_DOOMEDEN_BRICKS.get()), (ItemLike)((ItemLike)ESBlocks.DOOMEDEN_BRICK_SLAB.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_DOOMEDEN_BRICKS.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.CHISELED_POLISHED_DOOMEDEN_BRICKS.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_WALL.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_TILES.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.DOOMEDEN_TILE_SLAB.get(), (ItemLike)ESBlocks.DOOMEDEN_TILE_STAIRS.get(), (ItemLike)ESBlocks.DOOMEDEN_TILE_WALL.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_TILES.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.stonecuttingSet(recipeOutput, (ItemLike)ESBlocks.DOOMEDEN_TILE_SLAB.get(), (ItemLike)ESBlocks.DOOMEDEN_TILE_STAIRS.get(), (ItemLike)ESBlocks.DOOMEDEN_TILE_WALL.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.DOOMEDEN_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.DOOMEDEN_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_BRICK_WALL.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.DOOMEDEN_BRICK_STAIRS.get(), ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_BRICK_STAIRS.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.DOOMEDEN_BRICK_SLAB.get(), ESBlocks.DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_BRICK_SLAB.get(), (ItemLike)ESBlocks.DOOMEDEN_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_WALL.get()), (ItemLike)((ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_WALL.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.POLISHED_DOOMEDEN_BRICK_STAIRS.get(), ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_STAIRS.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.POLISHED_DOOMEDEN_BRICK_SLAB.get(), ESBlocks.POLISHED_DOOMEDEN_BRICKS.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICK_SLAB.get(), (ItemLike)ESBlocks.POLISHED_DOOMEDEN_BRICKS.get(), 2);
        ESRecipeProvider.wall((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.DOOMEDEN_TILE_WALL.get()), (ItemLike)((ItemLike)ESBlocks.DOOMEDEN_TILES.get()));
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_TILE_WALL.get(), (ItemLike)ESBlocks.DOOMEDEN_TILES.get());
        this.addStairs(recipeOutput, (Block)ESBlocks.DOOMEDEN_TILE_STAIRS.get(), ESBlocks.DOOMEDEN_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_TILE_STAIRS.get(), (ItemLike)ESBlocks.DOOMEDEN_TILES.get());
        this.addSlab(recipeOutput, (Block)ESBlocks.DOOMEDEN_TILE_SLAB.get(), ESBlocks.DOOMEDEN_TILES.get());
        this.stonecutting(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMEDEN_TILE_SLAB.get(), (ItemLike)ESBlocks.DOOMEDEN_TILES.get(), 2);
        this.addShapeless(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESBlocks.DOOMED_TORCH.get(), (ItemLike)ESBlocks.CHARGED_CHISELED_POLISHED_DOOMEDEN_BRICKS.get(), 1, (ItemLike)ESBlocks.DOOMED_TORCH.get(), (ItemLike)ESBlocks.CHISELED_POLISHED_DOOMEDEN_BRICKS.get());
    }

    private void addThioquartzRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ESBlocks.THIOQUARTZ_BLOCK.get()), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ESItems.THIOQUARTZ_SHARD.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.THIOQUARTZ_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.THIOQUARTZ_ARROW.get()), (int)4).pattern("T").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('T'), ESConventionalTags.Items.GEMS_THIOQUARTZ).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_THIOQUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.ALCHEMIST_MASK.get())).pattern("###").pattern("S S").define(Character.valueOf('#'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), ESConventionalTags.Items.GEMS_THIOQUARTZ).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_THIOQUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.ALCHEMIST_ROBE.get())).pattern("S S").pattern("#S#").pattern("#S#").define(Character.valueOf('#'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), ESConventionalTags.Items.GEMS_THIOQUARTZ).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_THIOQUARTZ)).save(recipeOutput);
    }

    private void addAethersentRecipes(RecipeOutput recipeOutput) {
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.RAW_AETHERSENT.get(), (ItemLike)ESItems.AETHERSENT_INGOT.get(), (ItemLike)ESItems.RAW_AETHERSENT.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.RAW_AETHERSENT.get(), (ItemLike)ESItems.AETHERSENT_INGOT.get(), (ItemLike)ESItems.RAW_AETHERSENT.get());
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.RAW_AETHERSENT.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.RAW_AETHERSENT_BLOCK.get(), "raw_aethersent_from_raw_aethersent_block", "raw_aethersent");
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.AETHERSENT_INGOT.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.AETHERSENT_BLOCK.get(), "aethersent_ingot_from_aethersent_block", "aethersent_ingot");
        this.nineBlockStorageCustomPacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.AETHERSENT_NUGGET.get(), RecipeCategory.MISC, (ItemLike)ESItems.AETHERSENT_INGOT.get(), "aethersent_ingot_from_nuggets", "aethersent_ingot");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AETHERSENT_ARROW.get()), (int)4).pattern("A").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('A'), ESConventionalTags.Items.NUGGETS_AETHERSENT).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.NUGGETS_AETHERSENT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AETHERSENT_HOOD.get())).pattern("HAH").pattern("A A").define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).define(Character.valueOf('A'), ESConventionalTags.Items.INGOTS_AETHERSENT).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AETHERSENT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AETHERSENT_CAPE.get())).pattern("A A").pattern("HAH").pattern("HHH").define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).define(Character.valueOf('A'), ESConventionalTags.Items.INGOTS_AETHERSENT).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AETHERSENT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AETHERSENT_BOTTOMS.get())).pattern("HHH").pattern("A A").pattern("H H").define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).define(Character.valueOf('A'), ESConventionalTags.Items.INGOTS_AETHERSENT).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AETHERSENT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AETHERSENT_BOOTS.get())).pattern("A A").pattern("H H").define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).define(Character.valueOf('A'), ESConventionalTags.Items.INGOTS_AETHERSENT).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AETHERSENT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.STARFALL_LONGBOW.get())).pattern(" AS").pattern("H S").pattern(" AS").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('A'), ESConventionalTags.Items.INGOTS_AETHERSENT).define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_AETHERSENT)).save(recipeOutput);
        this.addSword(recipeOutput, (ItemLike)ESItems.RAGE_OF_STARS.get(), ESConventionalTags.Items.INGOTS_AETHERSENT);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.GALACTIC_QUIVER.get())).pattern("H H").pattern(" H ").define(Character.valueOf('H'), (ItemLike)ESItems.CRETEOR_HIDE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.CRETEOR_HIDE.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.CRETEOR_HIDE.get(), (ItemLike)ESItems.AETHERSTRIKE_ROCKET.get(), 1, new ItemLike[]{(ItemLike)ESItems.CRETEOR_HIDE.get(), (ItemLike)ESItems.STARCORE.get(), Items.PAPER});
    }

    private void addDeepsilverRecipes(RecipeOutput recipeOutput) {
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.GRIMSTONE_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.GRIMSTONE_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.VOIDSTONE_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.VOIDSTONE_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.ETERNAL_ICE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.ETERNAL_ICE_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.ETERNAL_ICE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.ETERNAL_ICE_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.HAZE_ICE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.HAZE_ICE_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.HAZE_ICE_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.HAZE_ICE_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.NIGHTFALL_MUD_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.NIGHTFALL_MUD_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.NIGHTFALL_MUD_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.NIGHTFALL_MUD_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_DEEPSILVER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_DEEPSILVER_ORE.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_DEEPSILVER_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.RAW_DEEPSILVER.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.RAW_DEEPSILVER.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.RAW_DEEPSILVER.get(), (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.RAW_DEEPSILVER.get());
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.RAW_DEEPSILVER.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.RAW_DEEPSILVER_BLOCK.get(), "raw_deepsilver_from_raw_deepsilver_block", "raw_deepsilver");
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.DEEPSILVER_INGOT.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.DEEPSILVER_BLOCK.get(), "deepsilver_ingot_from_deepsilver_block", "deepsilver_ingot");
        this.nineBlockStorageCustomPacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.DEEPSILVER_NUGGET.get(), RecipeCategory.MISC, (ItemLike)ESItems.DEEPSILVER_INGOT.get(), "deepsilver_ingot_from_nuggets", "deepsilver_ingot");
        this.addAxe(recipeOutput, (ItemLike)ESItems.DEEPSILVER_AXE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addHoe(recipeOutput, (ItemLike)ESItems.DEEPSILVER_HOE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addShovel(recipeOutput, (ItemLike)ESItems.DEEPSILVER_SHOVEL.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.DEEPSILVER_PICKAXE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addSickle(recipeOutput, (ItemLike)ESItems.DEEPSILVER_SICKLE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addSword(recipeOutput, (ItemLike)ESItems.DEEPSILVER_SWORD.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addHelmet(recipeOutput, (ItemLike)ESItems.DEEPSILVER_HELMET.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addChestplate(recipeOutput, (ItemLike)ESItems.DEEPSILVER_CHESTPLATE.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addLeggings(recipeOutput, (ItemLike)ESItems.DEEPSILVER_LEGGINGS.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        this.addBoots(recipeOutput, (ItemLike)ESItems.DEEPSILVER_BOOTS.get(), ESConventionalTags.Items.INGOTS_DEEPSILVER);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ESItems.DEEPSILVER_BRUSH.get())).pattern("X").pattern("#").pattern("I").define(Character.valueOf('X'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).define(Character.valueOf('I'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_DEEPSILVER)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.SHIELD).pattern("P#P").pattern("PPP").pattern(" P ").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_DEEPSILVER)).save(recipeOutput, EternalStarlight.id("shield_from_deepsilver_ingot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.SHEARS).pattern("# ").pattern(" #").define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_DEEPSILVER)).save(recipeOutput, EternalStarlight.id("shears_from_deepsilver_ingot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BUCKET).pattern("# #").pattern(" # ").define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_DEEPSILVER)).save(recipeOutput, EternalStarlight.id("bucket_from_deepsilver_ingot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)Blocks.CAULDRON).pattern("# #").pattern("# #").pattern("###").define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).unlockedBy("has_water_bucket", ESRecipeProvider.has((ItemLike)Items.WATER_BUCKET)).save(recipeOutput, EternalStarlight.id("cauldron_from_deepsilver_ingot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TRIPWIRE_HOOK).pattern("#").pattern("S").pattern("P").define(Character.valueOf('#'), ESConventionalTags.Items.INGOTS_DEEPSILVER).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.INGOTS_DEEPSILVER)).save(recipeOutput, EternalStarlight.id("tripwire_hook_from_deepsilver_ingot"));
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.DEEPSILVER_NUGGET.get(), (ItemLike)ESItems.DEEPSILVER_PICKAXE.get(), (ItemLike)ESItems.DEEPSILVER_AXE.get(), (ItemLike)ESItems.DEEPSILVER_HOE.get(), (ItemLike)ESItems.DEEPSILVER_SHOVEL.get(), (ItemLike)ESItems.DEEPSILVER_SICKLE.get(), (ItemLike)ESItems.DEEPSILVER_SWORD.get(), (ItemLike)ESItems.DEEPSILVER_HELMET.get(), (ItemLike)ESItems.DEEPSILVER_CHESTPLATE.get(), (ItemLike)ESItems.DEEPSILVER_LEGGINGS.get(), (ItemLike)ESItems.DEEPSILVER_BOOTS.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.DEEPSILVER_INGOT.get(), (ItemLike)ESItems.DEEPSILVER_NUGGET.get(), (ItemLike)ESItems.DEEPSILVER_PICKAXE.get(), (ItemLike)ESItems.DEEPSILVER_AXE.get(), (ItemLike)ESItems.DEEPSILVER_HOE.get(), (ItemLike)ESItems.DEEPSILVER_SHOVEL.get(), (ItemLike)ESItems.DEEPSILVER_SICKLE.get(), (ItemLike)ESItems.DEEPSILVER_SWORD.get(), (ItemLike)ESItems.DEEPSILVER_HELMET.get(), (ItemLike)ESItems.DEEPSILVER_CHESTPLATE.get(), (ItemLike)ESItems.DEEPSILVER_LEGGINGS.get(), (ItemLike)ESItems.DEEPSILVER_BOOTS.get());
    }

    private void addMalariteRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.MALARITE.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.MALARITE_BLOCK.get(), "malarite_from_malarite_block", "malarite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.MALARITE_ARROW.get()), (int)4).pattern("A").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('A'), ESConventionalTags.Items.GEMS_MALARITE).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_MALARITE)).save(recipeOutput);
        this.addAxe(recipeOutput, (ItemLike)ESItems.MALARITE_AXE.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addHoe(recipeOutput, (ItemLike)ESItems.MALARITE_HOE.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addShovel(recipeOutput, (ItemLike)ESItems.MALARITE_SHOVEL.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.MALARITE_PICKAXE.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addSickle(recipeOutput, (ItemLike)ESItems.MALARITE_SICKLE.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addSword(recipeOutput, (ItemLike)ESItems.MALARITE_SWORD.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addSpear(recipeOutput, (ItemLike)ESItems.MALARITE_SPEAR.get(), ESConventionalTags.Items.GEMS_MALARITE);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.GRIMSTONE_MALARITE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.GRIMSTONE_MALARITE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.VOIDSTONE_MALARITE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.VOIDSTONE_MALARITE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.NIGHTFALL_MUD_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.NIGHTFALL_MUD_MALARITE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.NIGHTFALL_MUD_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.NIGHTFALL_MUD_MALARITE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_MALARITE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_MALARITE_ORE.get(), (ItemLike)ESItems.MALARITE.get(), (ItemLike)ESItems.PACKED_NIGHTFALL_MUD_MALARITE_ORE.get());
    }

    private void addPungencyFruitRecipes(RecipeOutput recipeOutput) {
        this.addShapeless(recipeOutput, RecipeCategory.FOOD, (ItemLike)ESItems.PUNGENCY_FRUIT.get(), (ItemLike)ESItems.PUNGENCY_STEW.get(), 1, new ItemLike[]{(ItemLike)ESItems.PUNGENCY_FRUIT.get(), Items.ROTTEN_FLESH, Items.BOWL});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ESItems.SILVER_PUNGENCY_FRUIT.get())).pattern("SSS").pattern("SFS").pattern("SSS").define(Character.valueOf('F'), (ItemLike)ESItems.PUNGENCY_FRUIT.get()).define(Character.valueOf('S'), (ItemLike)ESItems.DEEPSILVER_INGOT.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.PUNGENCY_FRUIT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ESItems.TEAR_BOMB.get())).pattern("FGF").pattern("GMG").pattern("FGF").define(Character.valueOf('G'), Tags.Items.GUNPOWDERS).define(Character.valueOf('F'), (ItemLike)ESItems.PUNGENCY_FRUIT.get()).define(Character.valueOf('M'), ESConventionalTags.Items.GEMS_MALARITE).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.PUNGENCY_FRUIT.get()))).save(recipeOutput);
        this.addShapeless(recipeOutput, RecipeCategory.TRANSPORTATION, (ItemLike)ESItems.TEAR_BOMB.get(), (ItemLike)ESItems.TEAR_BOMB_MINECART.get(), 1, new ItemLike[]{(ItemLike)ESItems.TEAR_BOMB.get(), Items.MINECART});
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.PUNGENCY_FRUIT_UPGRADE_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.NIGHTFALL_MUD_BRICKS.get(), ESConventionalTags.Items.GEMS_MALARITE);
        ESRecipeProvider.pungencyFruitSmithing(recipeOutput, ESItems.MALARITE_AXE.get(), RecipeCategory.TOOLS, ESItems.PUNGENCY_FRUIT_AXE.get());
        ESRecipeProvider.pungencyFruitSmithing(recipeOutput, ESItems.MALARITE_SPEAR.get(), RecipeCategory.COMBAT, ESItems.PUNGENCY_FRUIT_SPEAR.get());
    }

    protected static void pungencyFruitSmithing(RecipeOutput recipeOutput, Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.PUNGENCY_FRUIT_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.PUNGENCY_FRUIT.get()}), (RecipeCategory)category, (Item)resultItem).unlocks("has_pungency_fruit", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.PUNGENCY_FRUIT.get()))).save(recipeOutput, EternalStarlight.id(ESRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing"));
    }

    private void addStarfireRecipes(RecipeOutput recipeOutput) {
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.OAK_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.OAK_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.SPRUCE_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.SPRUCE_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.BIRCH_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.BIRCH_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.ACACIA_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.ACACIA_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.CHERRY_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.CHERRY_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.JUNGLE_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.JUNGLE_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.DARK_OAK_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.DARK_OAK_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.CRIMSON_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.CRIMSON_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.WARPED_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.WARPED_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.MANGROVE_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.MANGROVE_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.BAMBOO_STARFIRE_BIRD_AVIARY.get(), (ItemLike)Blocks.BAMBOO_PLANKS);
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.LUNAR_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.LUNAR_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.NORTHLAND_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.NORTHLAND_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.STARLIGHT_MANGROVE_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.STARLIGHT_MANGROVE_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.SCARLET_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.SCARLET_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.TORREYA_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.TORREYA_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.JINGLESTEM_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.JINGLESTEM_PLANKS.get());
        this.addStarfireBirdAviary(recipeOutput, (ItemLike)ESBlocks.CRADLEWOOD_STARFIRE_BIRD_AVIARY.get(), (ItemLike)ESBlocks.CRADLEWOOD_PLANKS.get());
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.STARFIRE_UPGRADE_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.STARCORE_BLOCK.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_SWORD.get(), RecipeCategory.COMBAT, ESItems.STARFIRE_SWORD.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_PICKAXE.get(), RecipeCategory.TOOLS, ESItems.STARFIRE_PICKAXE.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_AXE.get(), RecipeCategory.TOOLS, ESItems.STARFIRE_AXE.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_HOE.get(), RecipeCategory.TOOLS, ESItems.STARFIRE_HOE.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_SHOVEL.get(), RecipeCategory.TOOLS, ESItems.STARFIRE_SHOVEL.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_SCYTHE.get(), RecipeCategory.COMBAT, ESItems.STARFIRE_SCYTHE.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, ESItems.THERMAL_SPRINGSTONE_HAMMER.get(), RecipeCategory.COMBAT, ESItems.STARFIRE_HAMMER.get());
        ESRecipeProvider.starfireSmithing(recipeOutput, Items.CROSSBOW, RecipeCategory.COMBAT, ESItems.STARFIRE_CROSSBOW.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.RAW_FLOWGLAZE.get(), (ItemLike)ESItems.FLOWGLAZE.get(), (ItemLike)ESItems.RAW_FLOWGLAZE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.RAW_FLOWGLAZE.get(), (ItemLike)ESItems.FLOWGLAZE.get(), (ItemLike)ESItems.RAW_FLOWGLAZE.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESBlocks.FLOWGLAZE_PANE.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ESBlocks.FLOWGLAZE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESBlocks.FLOWGLAZE.get()))).save(recipeOutput);
        ESRecipeProvider.copySmithingTemplate(recipeOutput, (ItemLike)ESItems.FLOWGLAZE_UPGRADE_SMITHING_TEMPLATE.get(), (ItemLike)ESItems.ETERNAL_ICE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_SWORD.get(), RecipeCategory.COMBAT, ESItems.FLOWGLAZE_SWORD.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_PICKAXE.get(), RecipeCategory.TOOLS, ESItems.FLOWGLAZE_PICKAXE.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_AXE.get(), RecipeCategory.TOOLS, ESItems.FLOWGLAZE_AXE.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_HOE.get(), RecipeCategory.TOOLS, ESItems.FLOWGLAZE_HOE.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_SHOVEL.get(), RecipeCategory.TOOLS, ESItems.FLOWGLAZE_SHOVEL.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_SCYTHE.get(), RecipeCategory.COMBAT, ESItems.FLOWGLAZE_SCYTHE.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, ESItems.GLACITE_SHIELD.get(), RecipeCategory.COMBAT, ESItems.FLOWGLAZE_SHIELD.get());
        ESRecipeProvider.flowglazeSmithing(recipeOutput, Items.BOW, RecipeCategory.COMBAT, ESItems.FLOWGLAZE_BOW.get());
    }

    protected final void addStarfireBirdAviary(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output).pattern("###").pattern("SSS").pattern("###").define(Character.valueOf('#'), input).define(Character.valueOf('S'), (ItemLike)ESItems.STARFIRE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.STARFIRE.get()))).save(recipeOutput);
    }

    protected static void starfireSmithing(RecipeOutput recipeOutput, Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.STARFIRE_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.STARFIRE.get()}), (RecipeCategory)category, (Item)resultItem).unlocks("has_starfire", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.STARFIRE.get()))).save(recipeOutput, EternalStarlight.id(ESRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing"));
    }

    protected static void flowglazeSmithing(RecipeOutput recipeOutput, Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.FLOWGLAZE_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ESItems.FLOWGLAZE.get()}), (RecipeCategory)category, (Item)resultItem).unlocks("has_flowglaze", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.FLOWGLAZE.get()))).save(recipeOutput, EternalStarlight.id(ESRecipeProvider.getItemName((ItemLike)resultItem) + "_smithing"));
    }

    private void addThermalSpringstoneRecipes(RecipeOutput recipeOutput) {
        this.addAxe(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_AXE.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addHoe(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_HOE.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addShovel(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_SHOVEL.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_PICKAXE.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addScythe(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_SCYTHE.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addSword(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_SWORD.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addHammer(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_HAMMER.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addHelmet(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_HELMET.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addChestplate(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_CHESTPLATE.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addLeggings(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_LEGGINGS.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addBoots(recipeOutput, (ItemLike)ESItems.THERMAL_SPRINGSTONE_BOOTS.get(), ESConventionalTags.Items.INGOTS_THERMAL_SPRINGSTONE);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.THERMAL_SPRINGSTONE.get(), (ItemLike)ESItems.THERMAL_SPRINGSTONE_INGOT.get(), (ItemLike)ESItems.THERMAL_SPRINGSTONE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.THERMAL_SPRINGSTONE.get(), (ItemLike)ESItems.THERMAL_SPRINGSTONE_INGOT.get(), (ItemLike)ESItems.THERMAL_SPRINGSTONE.get());
    }

    private void addGlaciteRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.GLACITE_SHARD.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.GLACITE_BLOCK.get(), "glacite_shard_from_glacite_block", "glacite_shard");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.GLACITE_ARROW.get()), (int)4).pattern("G").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('G'), ESConventionalTags.Items.GEMS_GLACITE).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_GLACITE)).save(recipeOutput);
        this.addAxe(recipeOutput, (ItemLike)ESItems.GLACITE_AXE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addHoe(recipeOutput, (ItemLike)ESItems.GLACITE_HOE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addShovel(recipeOutput, (ItemLike)ESItems.GLACITE_SHOVEL.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.GLACITE_PICKAXE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addScythe(recipeOutput, (ItemLike)ESItems.GLACITE_SCYTHE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addSword(recipeOutput, (ItemLike)ESItems.GLACITE_SWORD.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addHelmet(recipeOutput, (ItemLike)ESItems.GLACITE_HELMET.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addChestplate(recipeOutput, (ItemLike)ESItems.GLACITE_CHESTPLATE.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addLeggings(recipeOutput, (ItemLike)ESItems.GLACITE_LEGGINGS.get(), ESConventionalTags.Items.GEMS_GLACITE);
        this.addBoots(recipeOutput, (ItemLike)ESItems.GLACITE_BOOTS.get(), ESConventionalTags.Items.GEMS_GLACITE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.GLACITE_SHIELD.get())).pattern("PSP").pattern("PPP").pattern(" P ").define(Character.valueOf('S'), ESConventionalTags.Items.GEMS_GLACITE).define(Character.valueOf('P'), Ingredient.of((TagKey)ItemTags.PLANKS)).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_GLACITE)).save(recipeOutput);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GLACITE.get(), (ItemLike)ESItems.GLACITE_SHARD.get(), (ItemLike)ESItems.GLACITE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GLACITE.get(), (ItemLike)ESItems.GLACITE_SHARD.get(), (ItemLike)ESItems.GLACITE.get());
    }

    private void addStarlitDiamondRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.STARLIT_DIAMOND.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.STARLIT_DIAMOND_BLOCK.get(), "starlit_diamond_from_starlit_diamond_block", "starlit_diamond");
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.GRIMSTONE_STARLIT_DIAMOND_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.GRIMSTONE_STARLIT_DIAMOND_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.VOIDSTONE_STARLIT_DIAMOND_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.VOIDSTONE_STARLIT_DIAMOND_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.ETERNAL_ICE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.ETERNAL_ICE_STARLIT_DIAMOND_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.ETERNAL_ICE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.ETERNAL_ICE_STARLIT_DIAMOND_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.HAZE_ICE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.HAZE_ICE_STARLIT_DIAMOND_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.HAZE_ICE_STARLIT_DIAMOND_ORE.get(), (ItemLike)ESItems.STARLIT_DIAMOND.get(), (ItemLike)ESItems.HAZE_ICE_STARLIT_DIAMOND_ORE.get());
        this.addAxe(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_AXE.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addHoe(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_HOE.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addShovel(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_SHOVEL.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_PICKAXE.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addSword(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_SWORD.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addHelmet(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_HELMET.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addChestplate(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_CHESTPLATE.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addLeggings(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_LEGGINGS.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        this.addBoots(recipeOutput, (ItemLike)ESItems.STARLIT_DIAMOND_BOOTS.get(), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.JUKEBOX).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), ESConventionalTags.Items.GEMS_STARLIT_DIAMOND).unlockedBy("has_starlit_diamond", ESRecipeProvider.has(ESConventionalTags.Items.GEMS_STARLIT_DIAMOND)).save(recipeOutput, EternalStarlight.id("jukebox_from_starlit_diamond"));
    }

    private void addStarcoreRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.STARCORE.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.STARCORE_BLOCK.get(), "starcore_from_starcore_block", "starcore");
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.GRIMSTONE_STARCORE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.GRIMSTONE_STARCORE_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.VOIDSTONE_STARCORE_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.VOIDSTONE_STARCORE_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.ETERNAL_ICE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.ETERNAL_ICE_STARCORE_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.ETERNAL_ICE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.ETERNAL_ICE_STARCORE_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.HAZE_ICE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.HAZE_ICE_STARCORE_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.HAZE_ICE_STARCORE_ORE.get(), (ItemLike)ESItems.STARCORE.get(), (ItemLike)ESItems.HAZE_ICE_STARCORE_ORE.get());
        this.addShapeless(recipeOutput, RecipeCategory.MISC, ESConventionalTags.Items.GEMS_STARCORE, (ItemLike)ESItems.CINDER_BRICK.get(), 8, List.of(), List.of(Tags.Items.BUCKETS_LAVA, ESConventionalTags.Items.GEMS_STARCORE, ESConventionalTags.Items.GEMS_STARCORE, Tags.Items.GRAVELS, Tags.Items.GRAVELS, Tags.Items.GRAVELS, Tags.Items.GRAVELS));
    }

    private void addSaltpeterRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.SALTPETER_POWDER.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.SALTPETER_BLOCK.get(), "saltpeter_powder_from_saltpeter_block", "saltpeter_powder");
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.GRIMSTONE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.GRIMSTONE_SALTPETER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.GRIMSTONE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.GRIMSTONE_SALTPETER_ORE.get());
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.VOIDSTONE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.VOIDSTONE_SALTPETER_ORE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.VOIDSTONE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.VOIDSTONE_SALTPETER_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.ETERNAL_ICE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.ETERNAL_ICE_SALTPETER_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.ETERNAL_ICE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.ETERNAL_ICE_SALTPETER_ORE.get());
        this.addSmelt(recipeOutput, 300, (ItemLike)ESItems.HAZE_ICE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.HAZE_ICE_SALTPETER_ORE.get());
        this.addBlast(recipeOutput, 150, (ItemLike)ESItems.HAZE_ICE_SALTPETER_ORE.get(), (ItemLike)ESItems.SALTPETER_POWDER.get(), (ItemLike)ESItems.HAZE_ICE_SALTPETER_ORE.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ESItems.SALTPETER_MATCHBOX.get())).pattern("SSS").pattern("PPP").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('P'), ESConventionalTags.Items.DUSTS_SALTPETER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.DUSTS_SALTPETER)).save(recipeOutput);
        SpecialRecipeBuilder.special(category -> new ToolModificationRecipe((CraftingBookCategory)category, ESItems.SALTPETER_MATCHBOX.get(), Items.STICK, new ItemStack((ItemLike)Items.TORCH, 4))).save(recipeOutput, EternalStarlight.id("torch_from_saltpeter_matchbox"));
    }

    private void addAmaramberRecipes(RecipeOutput recipeOutput) {
        this.nineBlockStorageCustomUnpacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.RAW_AMARAMBER.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)ESItems.RAW_AMARAMBER_BLOCK.get(), "raw_amaramber_from_raw_amaramber_block", "raw_amaramber");
        this.nineBlockStorageCustomPacking(recipeOutput, RecipeCategory.MISC, (ItemLike)ESItems.AMARAMBER_NUGGET.get(), RecipeCategory.MISC, (ItemLike)ESItems.AMARAMBER_INGOT.get(), "amaramber_ingot_from_nuggets", "amaramber_ingot");
        this.addShapeless(recipeOutput, RecipeCategory.MISC, ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER, (ItemLike)ESItems.AMARAMBER_INGOT.get(), 2, List.of(Items.DEEPSLATE), List.of(ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.AMARAMBER_CANDLE.get())).pattern("S").pattern("A").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('A'), ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.RAW_MATERIALS_AMARAMBER)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.AMARAMBER_LANTERN.get())).pattern("NNN").pattern("NAN").pattern("NNN").define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('A'), (ItemLike)ESItems.AMARAMBER_CANDLE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.AMARAMBER_CANDLE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ESItems.AMARAMBER_LANTERN.get())).pattern("NNN").pattern("NAN").pattern("NNN").define(Character.valueOf('N'), ESConventionalTags.Items.NUGGETS_DEEPSILVER).define(Character.valueOf('A'), (ItemLike)ESItems.AMARAMBER_CANDLE.get()).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)((ItemLike)ESItems.AMARAMBER_CANDLE.get()))).save(recipeOutput, EternalStarlight.id("amaramber_lantern_from_deepsilver_nuggets"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.TORCH, (int)6).pattern("N").pattern("S").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('N'), ESConventionalTags.Items.NUGGETS_AMARAMBER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.NUGGETS_AMARAMBER)).save(recipeOutput, EternalStarlight.id("torch_from_amaramber_nugget"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ESItems.AMARAMBER_ARROW.get()), (int)4).pattern("A").pattern("S").pattern("F").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), ESTags.Items.ARROW_FEATHERS).define(Character.valueOf('A'), ESConventionalTags.Items.NUGGETS_AMARAMBER).unlockedBy("has_item", ESRecipeProvider.has(ESConventionalTags.Items.NUGGETS_AMARAMBER)).save(recipeOutput);
        this.addSword(recipeOutput, (ItemLike)ESItems.AMARAMBER_SWORD.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addPickaxe(recipeOutput, (ItemLike)ESItems.AMARAMBER_PICKAXE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addAxe(recipeOutput, (ItemLike)ESItems.AMARAMBER_AXE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addHoe(recipeOutput, (ItemLike)ESItems.AMARAMBER_HOE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addShovel(recipeOutput, (ItemLike)ESItems.AMARAMBER_SHOVEL.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addSickle(recipeOutput, (ItemLike)ESItems.AMARAMBER_SICKLE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addHelmet(recipeOutput, (ItemLike)ESItems.AMARAMBER_MASK.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addChestplate(recipeOutput, (ItemLike)ESItems.AMARAMBER_CHESTPLATE.get(), ESConventionalTags.Items.INGOTS_AMARAMBER);
        this.addSmelt(recipeOutput, 200, (ItemLike)ESItems.AMARAMBER_INGOT.get(), (ItemLike)ESItems.AMARAMBER_NUGGET.get(), (ItemLike)ESItems.AMARAMBER_SWORD.get(), (ItemLike)ESItems.AMARAMBER_PICKAXE.get(), (ItemLike)ESItems.AMARAMBER_AXE.get(), (ItemLike)ESItems.AMARAMBER_HOE.get(), (ItemLike)ESItems.AMARAMBER_SHOVEL.get(), (ItemLike)ESItems.AMARAMBER_SICKLE.get(), (ItemLike)ESItems.AMARAMBER_MASK.get(), (ItemLike)ESItems.AMARAMBER_CHESTPLATE.get());
        this.addBlast(recipeOutput, 100, (ItemLike)ESItems.AMARAMBER_INGOT.get(), (ItemLike)ESItems.AMARAMBER_NUGGET.get(), (ItemLike)ESItems.AMARAMBER_SWORD.get(), (ItemLike)ESItems.AMARAMBER_PICKAXE.get(), (ItemLike)ESItems.AMARAMBER_AXE.get(), (ItemLike)ESItems.AMARAMBER_HOE.get(), (ItemLike)ESItems.AMARAMBER_SHOVEL.get(), (ItemLike)ESItems.AMARAMBER_SICKLE.get(), (ItemLike)ESItems.AMARAMBER_MASK.get(), (ItemLike)ESItems.AMARAMBER_CHESTPLATE.get());
    }

    protected final void addSmelt(RecipeOutput recipeOutput, int time, ItemLike criteria, ItemLike output, ItemLike ... input) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)1.0f, (int)time).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)criteria)).save(recipeOutput, EternalStarlight.id(this.name(output) + "_smelting_from_" + this.name(criteria)));
    }

    protected final void addBlast(RecipeOutput recipeOutput, int time, ItemLike criteria, ItemLike output, ItemLike ... input) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)1.0f, (int)time).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)criteria)).save(recipeOutput, EternalStarlight.id(this.name(output) + "_blasting_from_" + this.name(criteria)));
    }

    protected final void addSingleConversion(RecipeOutput recipeOutput, Item to, Item from) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)to).requires((ItemLike)from).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)from)).save(recipeOutput, EternalStarlight.id("shapeless/" + this.name((ItemLike)to) + "_from_" + this.name((ItemLike)from)));
    }

    protected final void addShapeless(RecipeOutput recipeOutput, ItemLike criteria, ItemLike output, int num, ItemLike ... ingredients) {
        this.addShapeless(recipeOutput, RecipeCategory.MISC, criteria, output, num, ingredients);
    }

    protected final void addShapeless(RecipeOutput recipeOutput, RecipeCategory category, ItemLike criteria, ItemLike output, int num, ItemLike ... ingredients) {
        this.addShapeless(recipeOutput, category, "", criteria, output, num, ingredients);
    }

    protected final void addShapeless(RecipeOutput recipeOutput, RecipeCategory category, String nameSuffix, ItemLike criteria, ItemLike output, int num, ItemLike ... ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output, (int)num);
        for (ItemLike item : ingredients) {
            builder.requires(item);
        }
        builder.unlockedBy("has_item", ESRecipeProvider.has((ItemLike)criteria)).save(recipeOutput, EternalStarlight.id("shapeless/" + this.name(output) + nameSuffix));
    }

    protected final void addShapeless(RecipeOutput recipeOutput, RecipeCategory category, TagKey<Item> criteria, ItemLike output, int num, List<ItemLike> ingredients, List<TagKey<Item>> tags) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output, (int)num);
        for (ItemLike itemLike : ingredients) {
            builder.requires(itemLike);
        }
        for (TagKey tagKey : tags) {
            builder.requires(tagKey);
        }
        builder.unlockedBy("has_item", ESRecipeProvider.has(criteria)).save(recipeOutput, EternalStarlight.id("shapeless/" + this.name(output)));
    }

    protected final void addHelmet(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("###").pattern("# #").define(Character.valueOf('#'), input).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addChestplate(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), input).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addLeggings(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), input).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addBoots(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("# #").pattern("# #").define(Character.valueOf('#'), input).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addScythe(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("###").pattern("  H").pattern("  H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addSickle(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("##").pattern(" #").pattern(" H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addHoe(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("##").pattern(" H").pattern(" H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addShovel(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("#").pattern("H").pattern("H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addPickaxe(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("###").pattern(" H ").pattern(" H ").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addSword(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("#").pattern("#").pattern("H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addSword(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("#").pattern("#").pattern("H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addAxe(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("##").pattern("#H").pattern(" H").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addHammer(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output).pattern("###").pattern("#H#").pattern(" H ").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addSpear(RecipeOutput recipeOutput, ItemLike output, TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).pattern("  #").pattern(" H ").pattern("H  ").define(Character.valueOf('#'), input).define(Character.valueOf('H'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addPlanks(RecipeOutput recipeOutput, Block output, TagKey<Item> input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).requires(input).unlockedBy("has_item", ESRecipeProvider.has(input)).save(recipeOutput);
    }

    protected final void addWood(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addStrippedWood(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addButton(RecipeOutput recipeOutput, Block output, Block input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).requires((ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addDoor(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addFence(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).pattern("#S#").pattern("#S#").define(Character.valueOf('#'), (ItemLike)input).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addFenceGate(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern("S#S").pattern("S#S").define(Character.valueOf('#'), (ItemLike)input).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addPressurePlate(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output).pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addSlab(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addStairs(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addPillar(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addTrapdoor(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)2).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addSign(RecipeOutput recipeOutput, ItemLike output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)3).pattern("###").pattern("###").pattern(" S ").define(Character.valueOf('#'), (ItemLike)input).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected final void addBoat(RecipeOutput recipeOutput, Item boat, Item chestBoat, Block planks) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)boat).pattern("P P").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planks).group("boat").unlockedBy("in_water", ESRecipeProvider.insideOf((Block)Blocks.WATER)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)chestBoat).requires((ItemLike)boat).requires((ItemLike)Items.CHEST).group("chest_boat").unlockedBy("has_boat", ESRecipeProvider.has((TagKey)ItemTags.BOATS)).save(recipeOutput);
    }

    protected final void addStoneCompress(RecipeOutput recipeOutput, Block output, Block input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)input).unlockedBy("has_item", ESRecipeProvider.has((ItemLike)input)).save(recipeOutput);
    }

    protected void stonecutting(RecipeOutput recipeOutput, RecipeCategory category, ItemLike output, ItemLike input) {
        this.stonecutting(recipeOutput, category, output, input, 1);
    }

    protected void stonecutting(RecipeOutput recipeOutput, RecipeCategory category, ItemLike output, ItemLike input, int count) {
        SingleItemRecipeBuilder builder = SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output, (int)count).unlockedBy(ESRecipeProvider.getHasName((ItemLike)input), ESRecipeProvider.has((ItemLike)input));
        String name = ESRecipeProvider.getConversionRecipeName((ItemLike)output, (ItemLike)input);
        builder.save(recipeOutput, EternalStarlight.id(name + "_stonecutting"));
    }

    protected void nineBlockStorageCustomPacking(RecipeOutput recipeOutput, RecipeCategory unpackCategory, ItemLike unpacked, RecipeCategory packCategory, ItemLike packed, String packName, String packGroup) {
        this.nineBlockStorage(recipeOutput, unpackCategory, unpacked, packCategory, packed, packName, packGroup, ESRecipeProvider.getSimpleRecipeName((ItemLike)unpacked), null);
    }

    protected void nineBlockStorageCustomUnpacking(RecipeOutput recipeOutput, RecipeCategory unpackCategory, ItemLike unpacked, RecipeCategory packCategory, ItemLike packed, String unpackName, String unpackGroup) {
        this.nineBlockStorage(recipeOutput, unpackCategory, unpacked, packCategory, packed, ESRecipeProvider.getSimpleRecipeName((ItemLike)packed), null, unpackName, unpackGroup);
    }

    protected void nineBlockStorage(RecipeOutput recipeOutput, RecipeCategory unpackCategory, ItemLike unpacked, RecipeCategory packCategory, ItemLike packed, String packName, String packGroup, String unpackName, String unpackGroup) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)unpackCategory, (ItemLike)unpacked, (int)9).requires(packed).group(unpackGroup).unlockedBy(ESRecipeProvider.getHasName((ItemLike)packed), ESRecipeProvider.has((ItemLike)packed)).save(recipeOutput, EternalStarlight.id(unpackName));
        ShapedRecipeBuilder.shaped((RecipeCategory)packCategory, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").group(packGroup).unlockedBy(ESRecipeProvider.getHasName((ItemLike)unpacked), ESRecipeProvider.has((ItemLike)unpacked)).save(recipeOutput, EternalStarlight.id(packName));
    }

    protected void colorWithDye(RecipeOutput recipeOutput, List<Item> dyes, List<Item> toDye, String name) {
        for (int i = 0; i < dyes.size(); ++i) {
            Item item = dyes.get(i);
            Item item1 = toDye.get(i);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item1).requires((ItemLike)item).requires(Ingredient.of(toDye.stream().filter(argx -> !argx.equals(item1)).map(ItemStack::new))).group(name).unlockedBy("has_needed_dye", ESRecipeProvider.has((ItemLike)item)).save(recipeOutput, EternalStarlight.id("dye_" + ESRecipeProvider.getItemName((ItemLike)item1)));
        }
    }

    protected void customCarpet(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)3).define(Character.valueOf('#'), input).pattern("##").group("carpet").unlockedBy(ESRecipeProvider.getHasName((ItemLike)input), ESRecipeProvider.has((ItemLike)input)).save(recipeOutput, EternalStarlight.id(this.name(output)));
    }

    protected void bed(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output).define(Character.valueOf('#'), input).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("###").pattern("XXX").group("bed").unlockedBy(ESRecipeProvider.getHasName((ItemLike)input), ESRecipeProvider.has((ItemLike)input)).save(recipeOutput, EternalStarlight.id(this.name(output)));
    }

    protected <T extends AbstractCookingRecipe> void simpleCooking(RecipeOutput recipeOutput, String fromName, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, int time, ItemLike input, ItemLike output, float xp) {
        SimpleCookingRecipeBuilder builder = SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)xp, (int)time, serializer, factory).unlockedBy(ESRecipeProvider.getHasName((ItemLike)input), ESRecipeProvider.has((ItemLike)input));
        String itemName = ESRecipeProvider.getItemName((ItemLike)output);
        builder.save(recipeOutput, EternalStarlight.id(itemName + "_from_" + fromName));
    }

    protected static void copySmithingTemplate(RecipeOutput recipeOutput, ItemLike template, ItemLike ingredient, TagKey<Item> ingotIngredient) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)template, (int)2).define(Character.valueOf('#'), ingotIngredient).define(Character.valueOf('C'), ingredient).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(ESRecipeProvider.getHasName((ItemLike)template), ESRecipeProvider.has((ItemLike)template)).save(recipeOutput);
    }

    public static Stream<VanillaRecipeProvider.TrimTemplate> smithingTrims() {
        return Stream.of(ESItems.KEEPER_ARMOR_TRIM_SMITHING_TEMPLATE.get(), ESItems.FORGE_ARMOR_TRIM_SMITHING_TEMPLATE.get(), ESItems.BLOOMING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), ESItems.TWINING_ARMOR_TRIM_SMITHING_TEMPLATE.get()).map(item -> new VanillaRecipeProvider.TrimTemplate(item, EternalStarlight.id(ESRecipeProvider.getItemName((ItemLike)item) + "_smithing_trim")));
    }

    protected final String name(ItemLike item) {
        return this.key(item).getPath();
    }

    protected final ResourceLocation key(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
    }
}

