/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.ESPortalBlockEntity;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.ESTeleporter;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5558;
import net.minecraft.class_9797;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ESPortalBlock
extends class_2237
implements class_9797 {
    public static final MapCodec<ESPortalBlock> CODEC = ESPortalBlock.method_54094(ESPortalBlock::new);
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    public static final class_2746 CENTER = class_2746.method_11825((String)"center");
    public static final class_2758 SIZE = class_2758.method_11867((String)"size", (int)0, (int)20);
    protected static final class_265 X_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final class_265 Z_AABB = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public ESPortalBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048)).method_11657((class_2769)CENTER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(2)));
    }

    protected MapCodec<ESPortalBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new ESPortalBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return ESPortalBlock.method_31618(blockEntityType, ESBlockEntities.STARLIGHT_PORTAL.get(), ESPortalBlockEntity::tick);
    }

    public class_2464 method_9604(class_2680 blockState) {
        return ESConfig.INSTANCE.enablePortalShader ? class_2464.field_11456 : class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            case class_2350.class_2351.field_11051 -> Z_AABB;
            default -> X_AABB;
        };
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2350 rightDir;
        class_2350 leftDir;
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        if (axis == class_2350.class_2351.field_11048) {
            leftDir = class_2350.field_11034;
            rightDir = class_2350.field_11039;
        } else {
            leftDir = class_2350.field_11043;
            rightDir = class_2350.field_11035;
        }
        List<class_2350> directions = List.of(leftDir, rightDir, class_2350.field_11036, class_2350.field_11033);
        for (class_2350 direction : directions) {
            if (level.method_8320(currentPos.method_10093(direction)).method_26164(ESTags.Blocks.PORTAL_FRAME_BLOCKS) || level.method_8320(currentPos.method_10093(direction)).method_27852((class_2248)this) && level.method_8320(currentPos.method_10093(direction)).method_11654(AXIS) == axis) continue;
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity.method_5822(false)) {
            entity.method_60697((class_9797)this, pos);
        }
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return switch (rot) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                    case field_11048: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, CENTER, SIZE});
    }

    public static boolean validateAndPlacePortal(class_1936 level, class_2338 framePos) {
        Validator validator = new Validator(level, framePos, class_2350.class_2351.field_11048);
        if (!validator.isValid()) {
            validator = new Validator(level, framePos, class_2350.class_2351.field_11051);
            if (validator.isValid()) {
                validator.fillPortal();
                return true;
            }
        } else {
            validator.fillPortal();
            return true;
        }
        return false;
    }

    public static boolean placePortal(class_1936 level, class_2338 bottomPos, class_2350.class_2351 axis, int size) {
        class_2350 rightDir;
        class_2350 leftDir;
        ArrayList<class_2338> framePositions = new ArrayList<class_2338>();
        ArrayList<class_2338> hollowPositions = new ArrayList<class_2338>();
        if (axis == class_2350.class_2351.field_11048) {
            leftDir = class_2350.field_11034;
            rightDir = class_2350.field_11039;
        } else {
            leftDir = class_2350.field_11043;
            rightDir = class_2350.field_11035;
        }
        for (int height = -size; height <= size; ++height) {
            int hollowWidth = size - Math.abs(height);
            framePositions.add(new class_2338(0, height + size, 0).method_10079(leftDir, hollowWidth));
            framePositions.add(new class_2338(0, height + size, 0).method_10079(rightDir, hollowWidth));
            if (hollowWidth < 1) continue;
            for (int i = 0; i < hollowWidth; ++i) {
                hollowPositions.add(new class_2338(0, height + size, 0).method_10079(leftDir, i));
                hollowPositions.add(new class_2338(0, height + size, 0).method_10079(rightDir, i));
            }
        }
        class_2784 border = level.method_8621();
        class_2338 center = bottomPos.method_10086(size);
        for (class_2338 blockPos : framePositions) {
            if (level.method_22347(blockPos.method_10081((class_2382)bottomPos)) && border.method_11952(blockPos.method_10081((class_2382)bottomPos))) continue;
            return false;
        }
        for (class_2338 blockPos : hollowPositions) {
            if (level.method_22347(blockPos.method_10081((class_2382)bottomPos)) && border.method_11952(blockPos.method_10081((class_2382)bottomPos))) continue;
            return false;
        }
        for (class_2338 blockPos : framePositions) {
            level.method_8652(blockPos.method_10081((class_2382)bottomPos), ESBlocks.CHISELED_VOIDSTONE.get().method_9564(), 3);
        }
        for (class_2338 blockPos : hollowPositions) {
            level.method_8652(blockPos.method_10081((class_2382)bottomPos), ESBlocks.CHISELED_VOIDSTONE.get().method_9564(), 3);
        }
        for (class_2338 blockPos : hollowPositions) {
            level.method_8652(blockPos.method_10081((class_2382)bottomPos), (class_2680)((class_2680)((class_2680)ESBlocks.STARLIGHT_PORTAL.get().method_9564().method_11657(AXIS, (Comparable)axis)).method_11657((class_2769)CENTER, (Comparable)Boolean.valueOf(blockPos.method_10081((class_2382)bottomPos).equals((Object)center)))).method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(size)), 3);
        }
        return true;
    }

    @Nullable
    public class_5454 method_60770(class_3218 serverLevel, class_1297 entity, class_2338 blockPos) {
        class_3218 destinationLevel;
        class_5321<class_1937> destination;
        class_1937 entityLevel = entity.method_37908();
        MinecraftServer server = entityLevel.method_8503();
        class_5321<class_1937> class_53212 = destination = entity.method_37908().method_27983() == ESDimensions.STARLIGHT_KEY ? class_1937.field_25179 : ESDimensions.STARLIGHT_KEY;
        if (server != null && (destinationLevel = server.method_3847(destination)) != null && ESPlatform.INSTANCE.postTravelToDimensionEvent(entity, destination)) {
            return ESTeleporter.getPortalInfo(entity, blockPos, destinationLevel);
        }
        return null;
    }

    public int method_60772(class_3218 level, class_1297 entity) {
        int n;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            n = player.method_31549().field_7480 ? 1 : 80;
        } else {
            n = 0;
        }
        return n;
    }

    public static class Validator {
        private static final int MAX_SIZE = 10;
        private static final int MIN_SIZE = 2;
        private final class_1936 level;
        private final class_2350.class_2351 axis;
        private final List<class_2338> frames = new ArrayList<class_2338>();
        private final List<class_2338> hollows = new ArrayList<class_2338>();
        private final class_2338 center;
        private final int portalSize;

        public Validator(class_1936 level, class_2338 framePos, class_2350.class_2351 axis) {
            class_2350 rightDir;
            class_2350 leftDir;
            this.level = level;
            this.axis = axis;
            if (axis == class_2350.class_2351.field_11048) {
                leftDir = class_2350.field_11034;
                rightDir = class_2350.field_11039;
            } else {
                leftDir = class_2350.field_11043;
                rightDir = class_2350.field_11035;
            }
            for (int size = 2; size <= 10; ++size) {
                ArrayList<class_2338> framePositions = new ArrayList<class_2338>();
                ArrayList<class_2338> hollowPositions = new ArrayList<class_2338>();
                for (int height = -size; height <= size; ++height) {
                    int hollowWidth = size - Math.abs(height);
                    framePositions.add(new class_2338(0, height, 0).method_10079(leftDir, hollowWidth));
                    framePositions.add(new class_2338(0, height, 0).method_10079(rightDir, hollowWidth));
                    if (hollowWidth < 1) continue;
                    for (int i = 0; i < hollowWidth; ++i) {
                        hollowPositions.add(new class_2338(0, height, 0).method_10079(leftDir, i));
                        hollowPositions.add(new class_2338(0, height, 0).method_10079(rightDir, i));
                    }
                }
                for (class_2338 blockPos : framePositions) {
                    class_2338 offset = framePos.method_10059((class_2382)blockPos);
                    List<class_2338> offsetFrames = framePositions.stream().map(pos -> pos.method_10081((class_2382)offset)).toList();
                    List<class_2338> offsetHollows = hollowPositions.stream().map(pos -> pos.method_10081((class_2382)offset)).toList();
                    boolean correctFrames = this.validateBlocks(offsetFrames, pos -> !level.method_8320(pos).method_26164(ESTags.Blocks.PORTAL_FRAME_BLOCKS));
                    boolean correctHollows = this.validateBlocks(offsetHollows, pos -> !level.method_8320(pos).method_27852((class_2248)ESBlocks.STARLIGHT_PORTAL.get()) && !level.method_8320(pos).method_26215());
                    if (!correctFrames || !correctHollows) continue;
                    this.frames.addAll(offsetFrames);
                    this.hollows.addAll(offsetHollows);
                    this.center = offset;
                    this.portalSize = size;
                    return;
                }
            }
            this.center = class_2338.field_10980;
            this.portalSize = 0;
        }

        private boolean validateBlocks(List<class_2338> positions, Function<class_2338, Boolean> function) {
            for (class_2338 offsetFrame : positions) {
                if (!function.apply(offsetFrame).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isValid() {
            return !this.frames.isEmpty() && !this.hollows.isEmpty();
        }

        public void fillPortal() {
            for (class_2338 blockPos : this.frames) {
                this.level.method_8652(blockPos, ESBlocks.CHISELED_VOIDSTONE.get().method_9564(), 3);
            }
            for (class_2338 blockPos : this.hollows) {
                this.level.method_8652(blockPos, ESBlocks.CHISELED_VOIDSTONE.get().method_9564(), 3);
            }
            for (class_2338 blockPos : this.hollows) {
                this.level.method_8652(blockPos, (class_2680)((class_2680)((class_2680)ESBlocks.STARLIGHT_PORTAL.get().method_9564().method_11657(AXIS, (Comparable)this.axis)).method_11657((class_2769)CENTER, (Comparable)Boolean.valueOf(blockPos.equals((Object)this.center)))).method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(this.portalSize)), 3);
            }
        }
    }
}

