/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentRegistry;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public record ConfiguredBookComponent<C extends BookComponentConfig, B extends BookComponent<C>>(B component, C config) {
    public static final Codec<ConfiguredBookComponent<?, ?>> CODEC = BookComponentRegistry.BY_NAME_CODEC.dispatch(configured -> configured.component, BookComponent::getConfiguredCodec);

    public boolean isEnabled(Set<class_2960> unlocked) {
        if (this.config().unlockConditions().isEmpty()) {
            return true;
        }
        boolean enabled = false;
        for (HashSet<class_2960> conditions : this.config().unlockConditions()) {
            boolean conditionGroup = true;
            for (class_2960 condition : conditions) {
                conditionGroup = conditionGroup && unlocked.contains(condition);
            }
            enabled = enabled || conditionGroup;
        }
        return enabled;
    }

    public int getTotalHeight(BookContext context) {
        return ((BookComponent)this.component()).getTotalHeight(this.config(), context);
    }

    public void render(BookContext context, class_332 graphics, int x, int y) {
        ((BookComponent)this.component()).render(this.config(), context, graphics, x, y);
    }

    public void renderDelayed(BookContext context, class_332 graphics, int x, int y) {
        ((BookComponent)this.component()).renderDelayed(this.config(), context, graphics, x, y);
    }

    public void tick(BookContext context, int x, int y) {
        ((BookComponent)this.component()).tick(this.config(), context, x, y);
    }

    public void onClick(BookContext context, int x, int y) {
        ((BookComponent)this.component()).onClick(this.config(), context, x, y);
    }
}

