/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.GrapplingOwner;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.handler.CommonHandlers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
implements SpellCaster,
GrapplingOwner {
    @Unique
    private class_1297 grappling;
    @Unique
    private boolean originalEnoughAttackStrength;

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    @Inject(method={"hurtCurrentlyUsedShield"}, at={@At(value="HEAD")})
    private void damageShield(float amount, CallbackInfo callBackInfo) {
        class_1657 player = (class_1657)this;
        class_1799 useItem = player.method_6030();
        if (useItem.method_31573(ESTags.Items.GREATSWORDS)) {
            useItem.method_7970(Math.max((int)(amount / 5.0f), 1), (class_1309)player, player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            player.method_6021();
            player.method_7357().method_7906(useItem.method_7909(), 100);
        }
    }

    @Inject(method={"disableShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableShield(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_1799 useItem = player.method_6030();
        if (useItem.method_31573(ESTags.Items.GREATSWORDS)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/player/Player;)Z")})
    private void attackHurtEnemy(class_1297 entity, CallbackInfo ci) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            CommonHandlers.handleFlowglazeWeaponAttack((class_1309)((class_1657)this), living);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal=0)})
    private void attackCheckHammerStrength(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.HAMMERS)) {
            localRef.set(true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F", opcode=180)})
    private void attackBeforeScytheSweepCheck(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.SCYTHES)) {
            this.originalEnoughAttackStrength = localRef.get();
            localRef.set(true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private void attackAfterScytheSweepCheck(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.SCYTHES)) {
            localRef.set(this.originalEnoughAttackStrength);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void aiStep(CallbackInfo ci) {
        Grappling grappling1;
        class_1297 class_12972;
        class_1657 player = (class_1657)this;
        if (this.grappling != null && (class_12972 = this.grappling) instanceof Grappling && (grappling1 = (Grappling)class_12972).reachedTarget() && grappling1.shouldPull()) {
            player.method_38785();
            if (!player.method_37908().field_9236) {
                float length = grappling1.length();
                double d = this.grappling.method_19538().method_1020(player.method_33571()).method_1033();
                if (d > (double)length) {
                    double e = d / (double)length * 0.1;
                    boolean crouch = player.method_18276();
                    player.method_45319(this.grappling.method_19538().method_1020(player.method_33571()).method_1021(1.0 / d).method_18805(e, e * 1.1, e).method_1021(crouch ? 0.6 : (player.method_24828() ? 1.8 : 1.0)));
                    player.field_6037 = true;
                }
            }
        }
    }

    @Inject(method={"isModelPartShown"}, at={@At(value="RETURN")}, cancellable=true)
    private void isModelPartShown(class_1664 part, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        class_1297 class_12972 = player.method_37908().method_8469(ESDataAttachments.HUSK_OWNER_ID.getData((class_1297)player).intValue());
        if (class_12972 instanceof class_1657) {
            class_1657 huskOwner = (class_1657)class_12972;
            cir.setReturnValue((Object)huskOwner.method_7348(part));
        }
    }

    @Override
    public class_1297 getESGrappling() {
        return this.grappling;
    }

    @Override
    public void setESGrappling(class_1297 grappling) {
        this.grappling = grappling;
    }
}

