/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;

public class CradlewoodFeature
extends class_3031<Configuration> {
    public CradlewoodFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<Configuration> context) {
        List<class_2338> farTop;
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 random = context.method_33654();
        ArrayList<class_2338> trunkPositions = new ArrayList<class_2338>();
        ArrayList<class_2338> leavesPositions = new ArrayList<class_2338>();
        Configuration config = (Configuration)context.method_33656();
        int height = config.height().method_35008(random);
        int horizontalOffset = config.horizontalOffset().method_35008(random);
        int leavesRadius = config.leavesRadius().method_35008(random);
        float angle = (float)random.method_43048(360) * ((float)Math.PI / 180);
        class_2338 targetPos = pos.method_10069((random.method_43056() ? 1 : -1) * (int)Math.round((double)horizontalOffset * Math.sin(angle)), 0, (random.method_43056() ? 1 : -1) * (int)Math.round((double)horizontalOffset * Math.cos(angle)));
        List<int[]> points = ESMathUtil.getBresenham3DPoints(pos.method_10263(), pos.method_10264() - height, pos.method_10260(), targetPos.method_10263(), pos.method_10264() - height, targetPos.method_10260());
        points.sort(Comparator.comparingInt(o -> (o[0] - pos.method_10263()) * (o[0] - pos.method_10263()) + (o[2] - pos.method_10260()) * (o[2] - pos.method_10260())));
        int horizontalLength = points.size();
        List<int[]> ellipsePoints = ESMathUtil.getBresenhamEllipsePoints(horizontalLength / 2, pos.method_10264(), horizontalLength / 2 + 1, height);
        ellipsePoints.removeIf(o -> o[1] > pos.method_10264());
        ellipsePoints.sort(Comparator.comparingInt(o -> o[0]));
        int i = 0;
        while (i < points.size()) {
            int[] point = points.get(i);
            int lineX = i++;
            ellipsePoints.stream().filter(o -> o[0] == lineX).forEach(o -> {
                class_2338 trunkPos = new class_2338(point[0], o[1], point[2]);
                trunkPositions.add(trunkPos);
            });
        }
        List<class_2338> nearTop = trunkPositions.stream().filter(o -> (o.method_10263() - pos.method_10263()) * (o.method_10263() - pos.method_10263()) + (o.method_10260() - pos.method_10260()) * (o.method_10260() - pos.method_10260()) < horizontalOffset / 2 * horizontalOffset / 2).sorted(Comparator.comparingInt(class_2382::method_10264)).toList();
        if (!nearTop.isEmpty() && !points.isEmpty()) {
            int topY;
            for (int i2 = topY = nearTop.getLast().method_10264(); i2 <= pos.method_10264(); ++i2) {
                class_2338 extra = new class_2338(points.getFirst()[0], i2, points.getFirst()[2]);
                if (trunkPositions.contains(extra)) continue;
                trunkPositions.add(extra);
            }
        }
        if (!(farTop = trunkPositions.stream().filter(o -> (o.method_10263() - pos.method_10263()) * (o.method_10263() - pos.method_10263()) + (o.method_10260() - pos.method_10260()) * (o.method_10260() - pos.method_10260()) > horizontalOffset / 2 * horizontalOffset / 2).sorted(Comparator.comparingInt(class_2382::method_10264)).toList()).isEmpty()) {
            class_2338 endPos = farTop.getLast();
            trunkPositions.add(endPos.method_10069(1, 0, 1));
            trunkPositions.add(endPos.method_10069(1, 0, -1));
            trunkPositions.add(endPos.method_10069(-1, 0, 1));
            trunkPositions.add(endPos.method_10069(-1, 0, -1));
            for (int x = 0; x <= leavesRadius; ++x) {
                for (int z = 0; z <= leavesRadius; ++z) {
                    int y = 0;
                    while ((float)y <= (float)leavesRadius / 1.5f) {
                        if (ESMathUtil.isPointInOrOnEllipsoid(x, y, z, leavesRadius, (float)leavesRadius / 1.5f, leavesRadius)) {
                            for (int i3 = -1; i3 <= 1; i3 += 2) {
                                for (int j = -1; j <= 1; j += 2) {
                                    for (int k = -1; k <= 1; k += 2) {
                                        class_2338 leavesPos = endPos.method_10069(i3 * x, j * y, k * z);
                                        leavesPositions.add(leavesPos);
                                        for (class_2350 direction : class_2350.values()) {
                                            if (random.method_43048(5) != 0) continue;
                                            leavesPositions.add(leavesPos.method_10093(direction));
                                        }
                                    }
                                }
                            }
                        }
                        ++y;
                    }
                }
            }
        }
        for (class_2338 trunkPos : trunkPositions) {
            if (level.method_22347(trunkPos) || level.method_8320(trunkPos).method_26164(class_3481.field_44470)) continue;
            return false;
        }
        for (class_2338 leavesPos : leavesPositions) {
            if (level.method_22347(leavesPos) || level.method_8320(leavesPos).method_26164(class_3481.field_44470)) continue;
            return false;
        }
        for (class_2338 leavesPos : leavesPositions) {
            this.method_13153((class_1945)level, leavesPos, ESBlocks.CRADLEWOOD_LEAVES.get().method_9564());
        }
        for (int i4 = 0; i4 < trunkPositions.size(); ++i4) {
            class_2338 trunkPos = (class_2338)trunkPositions.get(i4);
            class_2350.class_2351 axis = class_2350.class_2351.field_11052;
            List<class_2350.class_2351> availableAxes = Arrays.stream(class_2350.class_2351.values()).filter(o -> trunkPositions.contains(trunkPos.method_30513(o, 1)) || trunkPositions.contains(trunkPos.method_30513(o, -1))).toList();
            if (!availableAxes.isEmpty()) {
                axis = availableAxes.get(random.method_43048(availableAxes.size()));
            }
            this.method_13153((class_1945)level, trunkPos, (class_2680)ESBlocks.CRADLEWOOD_LOG.get().method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)axis));
        }
        return true;
    }

    public record Configuration(class_6017 height, class_6017 horizontalOffset, class_6017 leavesRadius) implements class_3037
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6017.field_29946.fieldOf("height").forGetter(Configuration::height), (App)class_6017.field_29946.fieldOf("horizontal_offset").forGetter(Configuration::horizontalOffset), (App)class_6017.field_29946.fieldOf("leaves_radius").forGetter(Configuration::leavesRadius)).apply((Applicative)instance, Configuration::new));
    }
}

