/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class DisplayBookComponent
extends BookComponent<Config> {
    public DisplayBookComponent() {
        super(Config.CODEC);
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        int totalHeight = config.totalHeight();
        for (TextDisplay display : config.textDisplays()) {
            totalHeight = Math.max(totalHeight, display.getLeastComponentHeight(context));
        }
        return totalHeight;
    }

    @Override
    public void render(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        for (ImageDisplay imageDisplay : config.imageDisplays()) {
            graphics.blit(imageDisplay.location(), x + imageDisplay.x(), y + imageDisplay.y(), 0.0f, 0.0f, imageDisplay.width(), imageDisplay.height(), imageDisplay.width(), imageDisplay.height());
        }
        for (EntityDisplay entityDisplay : config.entityDisplays()) {
            LivingEntity entity = entityDisplay.getEntity();
            if (entity == null) continue;
            InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)(x + entityDisplay.x), (float)(y + entityDisplay.y), (float)entityDisplay.scale, (Vector3f)new Vector3f(), (Quaternionf)entityDisplay.rotation, null, (LivingEntity)entity);
        }
        for (ItemDisplay itemDisplay : config.itemDisplays()) {
            ItemStack stack = itemDisplay.getItemStack();
            graphics.renderItem(stack, x + itemDisplay.x, y + itemDisplay.y);
        }
        for (ItemTagDisplay itemTagDisplay : config.itemTagDisplays()) {
            List<Item> items = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(itemTagDisplay.tag()).spliterator(), false).map(Holder::value).toList();
            if (items.isEmpty()) continue;
            ItemStack stack = items.get(Mth.floor((double)((double)context.getTickCount() / 30.0)) % items.size()).getDefaultInstance();
            graphics.renderItem(stack, x + itemTagDisplay.x(), y + itemTagDisplay.y());
        }
        for (CraftingRecipeDisplay craftingRecipeDisplay : config.craftingRecipeDisplays) {
            Ingredient[][] ingredients = craftingRecipeDisplay.getIngredients();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Ingredient ingredient = ingredients[i][j];
                    if (ingredient == null) continue;
                    ItemStack[] items = ingredient.getItems();
                    ItemStack stack = items.length == 0 ? ItemStack.EMPTY : items[Mth.floor((double)((double)context.getTickCount() / 30.0)) % items.length];
                    graphics.renderItem(stack, x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2, y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2);
                }
            }
        }
        for (TextDisplay textDisplay : config.textDisplays()) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)(x + textDisplay.x), (float)(y + textDisplay.y), 0.0f);
            List<FormattedCharSequence> lines = textDisplay.getLines(context);
            graphics.pose().scale(textDisplay.scale, textDisplay.scale, 1.0f);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence text = lines.get(i);
                graphics.drawString(context.getFont(), text, textDisplay.centered ? -context.getFont().width(text) / 2 : 0, i * textDisplay.lineHeight, 0, true);
            }
            graphics.pose().popPose();
        }
    }

    @Override
    public void renderDelayed(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        for (ItemDisplay itemDisplay : config.itemDisplays()) {
            ItemStack stack = itemDisplay.getItemStack();
            if (context.getMouseX() < x + itemDisplay.x || context.getMouseX() > x + itemDisplay.x + 16 || context.getMouseY() < Math.max(y + itemDisplay.y, context.getContentY()) || context.getMouseY() > Math.min(y + itemDisplay.y + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 790.0);
            graphics.renderTooltip(context.getFont(), Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), stack.getTooltipImage(), context.getMouseX(), context.getMouseY());
            graphics.pose().popPose();
        }
        for (ItemTagDisplay itemTagDisplay : config.itemTagDisplays()) {
            List<Item> items = StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(itemTagDisplay.tag()).spliterator(), false).map(Holder::value).toList();
            if (items.isEmpty()) continue;
            ItemStack stack = items.get(Mth.floor((double)((double)context.getTickCount() / 30.0)) % items.size()).getDefaultInstance();
            if (context.getMouseX() < x + itemTagDisplay.x() || context.getMouseX() > x + itemTagDisplay.x() + 16 || context.getMouseY() < Math.max(y + itemTagDisplay.y(), context.getContentY()) || context.getMouseY() > Math.min(y + itemTagDisplay.y() + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 790.0);
            graphics.renderTooltip(context.getFont(), Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), stack.getTooltipImage(), context.getMouseX(), context.getMouseY());
            graphics.pose().popPose();
        }
        for (CraftingRecipeDisplay craftingRecipeDisplay : config.craftingRecipeDisplays) {
            Ingredient[][] ingredients = craftingRecipeDisplay.getIngredients();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack stack;
                    Ingredient ingredient = ingredients[i][j];
                    if (ingredient == null) continue;
                    ItemStack[] items = ingredient.getItems();
                    ItemStack itemStack = stack = items.length == 0 ? ItemStack.EMPTY : items[Mth.floor((double)((double)context.getTickCount() / 30.0)) % items.length];
                    if (stack.isEmpty() || context.getMouseX() <= x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2 || context.getMouseX() >= x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2 + 16 || context.getMouseY() <= Math.max(y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2, context.getContentY()) || context.getMouseY() >= Math.min(y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2 + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0, 0.0, 790.0);
                    graphics.renderTooltip(context.getFont(), Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack), stack.getTooltipImage(), context.getMouseX(), context.getMouseY());
                    graphics.pose().popPose();
                }
            }
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        for (TextDisplay display : config.textDisplays()) {
            ClickEvent event;
            Style style;
            int trueLineHeight = (int)((float)display.lineHeight * display.scale);
            List<FormattedCharSequence> list = display.getLines(context);
            int line = (context.getMouseY() - (y + display.y)) / trueLineHeight;
            if (context.getMouseY() < y + display.y || line < 0 || line >= list.size()) continue;
            FormattedCharSequence charSequence = list.get(line);
            int width = (int)((float)context.getFont().width(charSequence) * display.scale);
            int startX = x + display.x - (display.centered ? width / 2 : 0);
            int endX = x + display.x + (display.centered ? width / 2 : width);
            if (context.getMouseX() < startX || context.getMouseX() > endX || (style = context.getFont().getSplitter().componentStyleAtWidth(charSequence, (int)((float)(context.getMouseX() - startX) / display.scale))) == null || (event = style.getClickEvent()) == null || event.getAction() != ClickEvent.Action.CHANGE_PAGE) continue;
            context.jumpToComponent(ResourceLocation.parse((String)event.getValue()));
        }
    }

    public record Config(ResourceLocation id, HashSet<HashSet<ResourceLocation>> unlockConditions, int totalHeight, List<TextDisplay> textDisplays, List<EntityDisplay> entityDisplays, List<ItemDisplay> itemDisplays, List<ItemTagDisplay> itemTagDisplays, List<CraftingRecipeDisplay> craftingRecipeDisplays, List<ImageDisplay> imageDisplays) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Config::id), (App)ResourceLocation.CODEC.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)Codec.INT.fieldOf("total_height").forGetter(Config::totalHeight), (App)TextDisplay.CODEC.listOf().fieldOf("text_displays").forGetter(Config::textDisplays), (App)EntityDisplay.CODEC.listOf().fieldOf("entity_displays").forGetter(Config::entityDisplays), (App)ItemDisplay.CODEC.listOf().fieldOf("item_displays").forGetter(Config::itemDisplays), (App)ItemTagDisplay.CODEC.listOf().fieldOf("item_tag_displays").forGetter(Config::itemTagDisplays), (App)CraftingRecipeDisplay.CODEC.listOf().fieldOf("crafting_recipe_displays").forGetter(Config::craftingRecipeDisplays), (App)ImageDisplay.CODEC.listOf().fieldOf("image_displays").forGetter(Config::imageDisplays)).apply((Applicative)instance, Config::new));

        public Config(ResourceLocation id, HashSet<HashSet<ResourceLocation>> unlockConditions, int totalHeight) {
            this(id, unlockConditions, totalHeight, new ArrayList<TextDisplay>(), new ArrayList<EntityDisplay>(), new ArrayList<ItemDisplay>(), new ArrayList<ItemTagDisplay>(), new ArrayList<CraftingRecipeDisplay>(), new ArrayList<ImageDisplay>());
        }

        public Config textDisplay(BookContent text, boolean centered, int x, int y, int width, int lineHeight, int minDistanceToBottom, float scale) {
            this.textDisplays.add(new TextDisplay(text, centered, x, y, width, lineHeight, minDistanceToBottom, scale));
            return this;
        }

        public Config entityDisplay(CompoundTag tag, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
            this.entityDisplays.add(new EntityDisplay(tag, x, y, xRot, yRot, scale, rotation));
            return this;
        }

        public Config itemDisplay(CompoundTag tag, int x, int y) {
            this.itemDisplays.add(new ItemDisplay(tag, x, y));
            return this;
        }

        public Config itemTagDisplay(TagKey<Item> tag, int x, int y) {
            this.itemTagDisplays.add(new ItemTagDisplay(tag, x, y));
            return this;
        }

        public Config craftingRecipeDisplay(ResourceLocation recipe, int x, int y, int slotWidth, int slotHeight) {
            this.craftingRecipeDisplays.add(new CraftingRecipeDisplay(recipe, x, y, slotWidth, slotHeight));
            return this;
        }

        public Config imageDisplay(ResourceLocation location, int x, int y, int width, int height) {
            this.imageDisplays.add(new ImageDisplay(location, x, y, width, height));
            return this;
        }
    }

    private static class TextDisplay {
        public static final Codec<TextDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookContent.CODEC.fieldOf("text").forGetter(o -> o.text), (App)Codec.BOOL.fieldOf("centered").forGetter(o -> o.centered), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.INT.fieldOf("width").forGetter(o -> o.width), (App)Codec.INT.fieldOf("line_height").forGetter(o -> o.lineHeight), (App)Codec.INT.fieldOf("min_distance_to_bottom").forGetter(o -> o.minDistanceToBottom), (App)Codec.FLOAT.fieldOf("scale").forGetter(o -> Float.valueOf(o.scale))).apply((Applicative)instance, TextDisplay::new));
        private final BookContent text;
        private final List<FormattedCharSequence> cachedText = new ArrayList<FormattedCharSequence>();
        private final boolean centered;
        private final int x;
        private final int y;
        private final int width;
        private final int lineHeight;
        private final int minDistanceToBottom;
        private final float scale;

        public TextDisplay(BookContent text, boolean centered, int x, int y, int width, int lineHeight, int minDistanceToBottom, float scale) {
            this.text = text;
            this.centered = centered;
            this.x = x;
            this.y = y;
            this.width = width;
            this.lineHeight = lineHeight;
            this.minDistanceToBottom = minDistanceToBottom;
            this.scale = scale;
        }

        public List<FormattedCharSequence> getLines(BookContext context) {
            if (this.cachedText.isEmpty()) {
                this.cachedText.addAll(context.getFont().split((FormattedText)this.text.toComponent(), (int)((float)this.width / this.scale)));
            }
            return this.cachedText;
        }

        public int getLeastComponentHeight(BookContext context) {
            return (int)((float)this.y + (float)(this.getLines(context).size() * this.lineHeight) * this.scale + (float)this.minDistanceToBottom);
        }
    }

    private record ImageDisplay(ResourceLocation location, int x, int y, int width, int height) {
        public static final Codec<ImageDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(ImageDisplay::location), (App)Codec.INT.fieldOf("x").forGetter(ImageDisplay::x), (App)Codec.INT.fieldOf("y").forGetter(ImageDisplay::y), (App)Codec.INT.fieldOf("width").forGetter(ImageDisplay::width), (App)Codec.INT.fieldOf("height").forGetter(ImageDisplay::height)).apply((Applicative)instance, ImageDisplay::new));
    }

    private static class EntityDisplay {
        public static final Codec<EntityDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("entity").forGetter(o -> o.entityTag), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.FLOAT.fieldOf("x_rot").forGetter(o -> Float.valueOf(o.xRot)), (App)Codec.FLOAT.fieldOf("y_rot").forGetter(o -> Float.valueOf(o.yRot)), (App)Codec.FLOAT.fieldOf("scale").forGetter(o -> Float.valueOf(o.scale)), (App)ExtraCodecs.QUATERNIONF.fieldOf("rotation").forGetter(o -> o.rotation)).apply((Applicative)instance, EntityDisplay::new));
        private LivingEntity cachedEntity;
        private final CompoundTag entityTag;
        private final int x;
        private final int y;
        private final float xRot;
        private final float yRot;
        private final float scale;
        private final Quaternionf rotation;

        public EntityDisplay(CompoundTag entity, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
            this.entityTag = entity;
            this.x = x;
            this.y = y;
            this.xRot = xRot;
            this.yRot = yRot;
            this.scale = scale;
            this.rotation = rotation;
        }

        public LivingEntity getEntity() {
            Entity entity;
            if (this.cachedEntity == null && Minecraft.getInstance().level != null && (entity = EntityType.loadEntityRecursive((CompoundTag)this.entityTag, (Level)Minecraft.getInstance().level, e -> e)) instanceof LivingEntity) {
                LivingEntity entity2;
                this.cachedEntity = entity2 = (LivingEntity)entity;
                this.cachedEntity.yBodyRot = this.yRot;
                this.cachedEntity.setXRot(this.xRot);
                this.cachedEntity.setYRot(this.yRot);
                this.cachedEntity.yHeadRot = this.cachedEntity.getYRot();
                this.cachedEntity.yHeadRotO = this.cachedEntity.getYRot();
            }
            return this.cachedEntity;
        }
    }

    private static class ItemDisplay {
        public static final Codec<ItemDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("item").forGetter(o -> o.itemStackTag), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y)).apply((Applicative)instance, ItemDisplay::new));
        private ItemStack cachedStack = null;
        private final CompoundTag itemStackTag;
        private final int x;
        private final int y;

        public ItemDisplay(CompoundTag itemStack, int x, int y) {
            this.itemStackTag = itemStack;
            this.x = x;
            this.y = y;
        }

        public ItemStack getItemStack() {
            if (this.cachedStack == null && Minecraft.getInstance().level != null) {
                this.cachedStack = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)this.itemStackTag);
            }
            return this.cachedStack == null ? ItemStack.EMPTY : this.cachedStack;
        }
    }

    private record ItemTagDisplay(TagKey<Item> tag, int x, int y) {
        public static final Codec<ItemTagDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("item_tag").forGetter(ItemTagDisplay::tag), (App)Codec.INT.fieldOf("x").forGetter(ItemTagDisplay::x), (App)Codec.INT.fieldOf("y").forGetter(ItemTagDisplay::y)).apply((Applicative)instance, ItemTagDisplay::new));
    }

    private static class CraftingRecipeDisplay {
        public static final Codec<CraftingRecipeDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("recipe").forGetter(o -> o.recipeId), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.INT.fieldOf("slot_width").forGetter(o -> o.slotWidth), (App)Codec.INT.fieldOf("slot_height").forGetter(o -> o.slotHeight)).apply((Applicative)instance, CraftingRecipeDisplay::new));
        private final Ingredient[][] ingredients = new Ingredient[3][3];
        private final ResourceLocation recipeId;
        private RecipeHolder<?> recipe;
        private final int x;
        private final int y;
        private final int slotWidth;
        private final int slotHeight;
        private boolean recipePlaced = false;

        public CraftingRecipeDisplay(ResourceLocation recipe, int x, int y, int slotWidth, int slotHeight) {
            this.recipeId = recipe;
            this.x = x;
            this.y = y;
            this.slotWidth = slotWidth;
            this.slotHeight = slotHeight;
        }

        public Ingredient[][] getIngredients() {
            if (this.recipe == null && Minecraft.getInstance().level != null) {
                this.recipe = Minecraft.getInstance().level.getRecipeManager().byKey(this.recipeId).orElse(null);
            }
            if (!this.recipePlaced && this.recipe != null && this.recipe.value().getType() == RecipeType.CRAFTING) {
                this.recipePlaced = true;
                PlaceRecipe placeRecipe = (ingredient, slot, maxAmount, x, y) -> {
                    this.ingredients[x][y] = ingredient;
                };
                placeRecipe.placeRecipe(3, 3, -1, this.recipe, this.recipe.value().getIngredients().iterator(), 0);
            }
            return this.ingredients;
        }
    }
}

