/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen.widget;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ESGuiUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrestButton
extends Button {
    private static final int CREST_WIDTH = 72;
    private static final int CREST_HEIGHT = 72;
    private final boolean orbit;
    private Crest.Instance crest;
    private int prevHoverProgress;
    private int hoverProgress;
    private float prevX;
    private float prevY;
    private float orbitCenterX;
    private float orbitCenterY;
    private float angle;
    private float prevAngle;

    public CrestButton(int x, int y, int width, int height, Component component, Button.OnPress onPress) {
        this(x, y, width, height, false, component, onPress);
    }

    public CrestButton(int x, int y, int width, int height, boolean orbit, Component component, Button.OnPress onPress) {
        super(x, y, width, height, component, onPress, DEFAULT_NARRATION);
        this.orbit = orbit;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public void setOrbitCenter(float orbitCenterX, float orbitCenterY) {
        this.orbitCenterX = orbitCenterX;
        this.orbitCenterY = orbitCenterY;
    }

    public CrestButton setCrest(Crest.Instance crest) {
        if (this.crest != crest && Minecraft.getInstance().level != null) {
            if (crest == null) {
                this.setTooltip(Tooltip.create((Component)Component.empty()));
            } else {
                Registry registry = Minecraft.getInstance().level.registryAccess().registryOrThrow(ESRegistries.CREST);
                MutableComponent nameComponent = Component.translatable((String)Util.makeDescriptionId((String)"crest", (ResourceLocation)registry.getKey((Object)((Crest)crest.crest().value()))));
                MutableComponent levelComponent = Component.translatable((String)("enchantment.level." + crest.level()));
                MutableComponent typeComponent = Component.translatable((String)Util.makeDescriptionId((String)"mana_type", (ResourceLocation)EternalStarlight.id(((Crest)crest.crest().value()).type().getSerializedName()))).withColor(((Crest)crest.crest().value()).type().getColor());
                if (((Crest)crest.crest().value()).getSpell().isPresent()) {
                    AbstractSpell spell = ((Crest)crest.crest().value()).getSpell().get();
                    MutableComponent spellTypeComponent = Component.translatable((String)"tooltip.eternal_starlight.crest_spell_elements").withStyle(ChatFormatting.AQUA);
                    for (ManaType type : spell.spellProperties().types()) {
                        spellTypeComponent.append(" ").append((Component)Component.translatable((String)Util.makeDescriptionId((String)"mana_type", (ResourceLocation)EternalStarlight.id(type.getSerializedName()))).withColor(type.getColor()));
                    }
                    typeComponent.append("\n").append((Component)spellTypeComponent);
                }
                MutableComponent descComponent = Component.translatable((String)(Util.makeDescriptionId((String)"crest", (ResourceLocation)registry.getKey((Object)((Crest)crest.crest().value()))) + ".desc"));
                if (((Crest)crest.crest().value()).attributeModifiers().isEmpty()) {
                    descComponent.append("\n").append((Component)Component.translatable((String)"tooltip.eternal_starlight.unwearable").withStyle(ChatFormatting.BLUE));
                }
                MutableComponent merged = nameComponent.append(" ").append((Component)levelComponent).append("\n").append((Component)typeComponent).append("\n").append((Component)descComponent);
                if (((Crest)crest.crest().value()).attributeModifiers().isPresent()) {
                    for (Crest.LevelBasedAttributeModifier modifier : ((Crest)crest.crest().value()).attributeModifiers().get()) {
                        this.addModifierTooltip(c -> merged.append("\n").append(c), modifier.attribute(), modifier.getModifier(crest.level()));
                    }
                }
                this.setTooltip(Tooltip.create((Component)merged));
            }
        }
        this.crest = crest;
        return this;
    }

    private void addModifierTooltip(Consumer<Component> consumer, Holder<Attribute> holder, AttributeModifier attributeModifier) {
        double d = attributeModifier.amount();
        double e = attributeModifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributeModifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? (holder.is(Attributes.KNOCKBACK_RESISTANCE) ? d * 10.0 : d) : d * 100.0;
        if (d > 0.0) {
            consumer.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributeModifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)holder.value()).getDescriptionId())}).withStyle(((Attribute)holder.value()).getStyle(true)));
        } else if (d < 0.0) {
            consumer.accept((Component)Component.translatable((String)("attribute.modifier.take." + attributeModifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-e), Component.translatable((String)((Attribute)holder.value()).getDescriptionId())}).withStyle(((Attribute)holder.value()).getStyle(false)));
        }
    }

    public Crest.Instance getCrest() {
        return this.crest;
    }

    public boolean isEmpty() {
        return this.crest == null;
    }

    public void tick() {
        this.prevHoverProgress = this.hoverProgress;
        this.prevX = this.getX();
        this.prevY = this.getY();
        this.prevAngle = this.angle;
        if (this.isHovered()) {
            if (this.hoverProgress < 5) {
                ++this.hoverProgress;
            }
        } else if (this.hoverProgress > 0) {
            --this.hoverProgress;
        }
        this.active = this.crest != null;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        float y;
        float x;
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        if (this.orbit) {
            float currentAngle = Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle);
            Vec3 centerPos = ESMathUtil.rotationToPosition(new Vec3((double)this.orbitCenterX, 0.0, (double)this.orbitCenterY), 60.0f, 0.0f, currentAngle);
            x = (float)(centerPos.x - 36.0);
            y = (float)(centerPos.z - 36.0);
            this.setPosition((int)x, (int)y);
        } else {
            x = Mth.lerp((float)partialTicks, (float)this.prevX, (float)this.getX());
            y = Mth.lerp((float)partialTicks, (float)this.prevY, (float)this.getY());
        }
        if (this.crest != null) {
            float progress = Mth.lerp((float)partialTicks, (float)this.prevHoverProgress, (float)this.hoverProgress) / 40.0f + 1.0f;
            float width = 72.0f * progress;
            float height = 72.0f * progress;
            ESGuiUtil.blitFloat(guiGraphics, ((Crest)this.crest.crest().value()).texture(), x - (width - (float)this.getWidth()) / 2.0f, y - (height - (float)this.getHeight()) / 2.0f, width, height, width, height);
        }
    }
}

