/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PermafrostMeleeEndPhase
extends BehaviorPhase<Permafrost> {
    public static final int ID = 3;

    public PermafrostMeleeEndPhase() {
        super(3, 1, 35, 100);
    }

    @Override
    public boolean canStart(Permafrost entity, boolean cooldownOver) {
        return false;
    }

    @Override
    public void onStart(Permafrost entity) {
    }

    @Override
    public void tick(Permafrost entity) {
        BlockHitResult result;
        Level level = entity.level();
        LivingEntity target = entity.getTarget();
        if (target != null) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
        }
        if ((result = level.clip(new ClipContext(entity.position().add(0.0, (double)entity.getBbHeight(), 0.0), entity.position().subtract(0.0, 5.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity))).getType() != HitResult.Type.MISS) {
            entity.setPos(result.getLocation());
        }
        if (entity.getBehaviorTicks() == 3 || entity.getBehaviorTicks() >= 10 && entity.getBehaviorTicks() <= 25) {
            BlockHitResult toGround;
            if (entity.getBehaviorTicks() == 3 && (toGround = level.clip(new ClipContext(entity.position().add(0.0, (double)entity.getBbHeight(), 0.0), entity.position().subtract(0.0, 0.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity))).getType() != HitResult.Type.MISS && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.ENERGY, entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.1, 0.0));
                serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, serverLevel.getBlockState(entity.blockPosition().below())), entity.getX(), entity.getY(), entity.getZ(), 150, 0.5, 0.5, 0.5, 0.15);
                ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 40.0f, 20, 0.2f, 0.3f, 3.0f, 5.5f).send(serverLevel);
            }
            for (LivingEntity livingEntity : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)entity, entity.getBoundingBox().inflate(entity.getBehaviorTicks() == 3 ? 4.5 : 1.5))) {
                Targeting targeting;
                if (livingEntity != target && (!(livingEntity instanceof Targeting) || (targeting = (Targeting)livingEntity).getTarget() != entity)) continue;
                entity.doHurtTarget((Entity)livingEntity);
                livingEntity.hurtMarked = true;
                livingEntity.addDeltaMovement(livingEntity.position().subtract(entity.position()).normalize().multiply(1.25, 0.5, 1.25));
            }
        }
    }

    @Override
    public boolean canContinue(Permafrost entity) {
        return true;
    }

    @Override
    public void onStop(Permafrost entity) {
    }
}

