/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.item.misc.GalacticQuiverItem;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin {
    @Shadow
    @Nullable
    private ItemStack firedFromWeapon;

    @Inject(method={"shotFromCrossbow()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void shotFromCrossbow(CallbackInfoReturnable<Boolean> cir) {
        if (this.firedFromWeapon != null && (this.firedFromWeapon.is(ESItems.STARFIRE_CROSSBOW.get()) || this.firedFromWeapon.is(ESItems.CRYSTAL_CROSSBOW.get()) || this.firedFromWeapon.is(ESItems.MECHANICAL_CROSSBOW.get()) || this.firedFromWeapon.is(ESItems.WILTED_CROSSBOW.get()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getWaterInertia()F"}, at={@At(value="RETURN")}, cancellable=true)
    public void getWaterInertia(CallbackInfoReturnable<Float> cir) {
        if (this.firedFromWeapon != null && this.firedFromWeapon.is(ESItems.WILTED_CROSSBOW.get())) {
            cir.setReturnValue((Object)Float.valueOf(0.99f));
        }
    }

    @WrapOperation(method={"tryPickup(Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean addToInventory(Inventory instance, ItemStack itemStack, Operation<Boolean> original) {
        if (itemStack.is(ItemTags.ARROWS)) {
            boolean arrowSuccess = GalacticQuiverItem.addArrowToInventory(instance, itemStack);
            return arrowSuccess || (Boolean)original.call(new Object[]{instance, itemStack}) != false;
        }
        return (Boolean)original.call(new Object[]{instance, itemStack});
    }
}

