/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.decorator;

import cn.leolezury.eternalstarlight.common.registry.ESTreeDecorators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingPlantDecorator
extends TreeDecorator {
    private final Holder<Block> plantHead;
    private final Holder<Block> plantBody;
    private final boolean leaves;
    private final float chance;
    private final IntProvider length;
    public static final MapCodec<HangingPlantDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("plant_head").forGetter(o -> o.plantHead), (App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("plant_body").forGetter(o -> o.plantBody), (App)Codec.BOOL.fieldOf("leaves").forGetter(o -> o.leaves), (App)Codec.FLOAT.fieldOf("chance").forGetter(o -> Float.valueOf(o.chance)), (App)IntProvider.codec((int)1, (int)16).fieldOf("length").forGetter(o -> o.length)).apply((Applicative)instance, HangingPlantDecorator::new));

    public HangingPlantDecorator(Holder<Block> plantHead, Holder<Block> plantBody, boolean leaves, float chance, IntProvider length) {
        this.plantHead = plantHead;
        this.plantBody = plantBody;
        this.leaves = leaves;
        this.chance = chance;
        this.length = length;
    }

    protected TreeDecoratorType<?> type() {
        return ESTreeDecorators.HANGING_PLANT.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        Block head = (Block)this.plantHead.value();
        Block body = (Block)this.plantBody.value();
        (this.leaves ? context.leaves() : context.logs()).forEach(pos -> {
            if (random.nextFloat() < this.chance) {
                int l = this.length.sample(random);
                for (int i = 1; i <= l; ++i) {
                    if (context.isAir(pos.below(i))) {
                        context.setBlock(pos.below(i), body.defaultBlockState());
                        if (i != l) continue;
                        context.setBlock(pos.below(i), head.defaultBlockState());
                        continue;
                    }
                    if (i == 1) break;
                    context.setBlock(pos.below(i - 1), head.defaultBlockState());
                    break;
                }
            }
        });
    }
}

