/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_9062;

public interface WeatheringGolemSteel {
    public static final Supplier<ImmutableMap<class_2248, class_2248>> TO_OXIDIZED = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)ESBlocks.GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get()).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_SLAB.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_SLAB.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_STAIRS.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_STAIRS.get())).put((Object)ESBlocks.GOLEM_STEEL_TILES.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get()).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_TILE_SLAB.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_SLAB.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_STAIRS.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_GRATE.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_GRATE.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_PILLAR.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_PILLAR.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_BARS.get()), (Object)((class_2248)ESBlocks.OXIDIZED_GOLEM_STEEL_BARS.get())).put((Object)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.OXIDIZED_CHISELED_GOLEM_STEEL_BLOCK.get()).put((Object)ESBlocks.GOLEM_STEEL_JET.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_JET.get()).build());
    public static final Supplier<ImmutableMap<class_2248, class_2248>> TO_WAXED = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)ESBlocks.GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get()).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_SLAB.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_STAIRS.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get())).put((Object)ESBlocks.GOLEM_STEEL_TILES.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_TILES.get()).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_TILE_SLAB.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_GRATE.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_PILLAR.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get())).put((Object)((class_2248)ESBlocks.GOLEM_STEEL_BARS.get()), (Object)((class_2248)ESBlocks.WAXED_GOLEM_STEEL_BARS.get())).put((Object)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get()).put((Object)ESBlocks.GOLEM_STEEL_JET.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_JET.get()).build());

    default public class_9062 use(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        Optional<class_2248> scraped = TO_OXIDIZED.get().entrySet().stream().filter(e -> e.getValue() == state.method_26204()).findFirst().map(Map.Entry::getKey);
        Optional<class_2248> unwaxed = TO_WAXED.get().entrySet().stream().filter(e -> e.getValue() == state.method_26204()).findFirst().map(Map.Entry::getKey);
        if (ESPlatform.INSTANCE.canScrape(stack)) {
            class_2248 result = null;
            boolean waxSound = false;
            if (scraped.isPresent()) {
                result = scraped.get();
            } else if (unwaxed.isPresent()) {
                result = unwaxed.get();
                waxSound = true;
            }
            if (result != null) {
                level.method_8501(pos, result.method_34725(state));
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_29643, (class_6017)class_6019.method_35017((int)3, (int)5));
                player.method_43077(waxSound ? class_3417.field_29542 : class_3417.field_29541);
                stack.method_7970(1, (class_1309)player, player.method_32326(stack));
                return class_9062.method_55644((boolean)level.field_9236);
            }
        }
        Optional<class_2680> waxed = this.getWaxedState(state);
        if ((stack.method_31574(class_1802.field_20414) || stack.method_31574(ESItems.RAW_AMARAMBER.get())) && waxed.isPresent()) {
            level.method_8501(pos, waxed.get());
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)(stack.method_31574(class_1802.field_20414) ? class_2398.field_29642 : (class_2394)ESParticles.AMARAMBER_WAX_ON.get()), (class_6017)class_6019.method_35017((int)3, (int)5));
            player.method_43077(class_3417.field_29543);
            stack.method_57008(1, (class_1309)player);
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return class_9062.field_47731;
    }

    default public boolean isOxidized() {
        WeatheringGolemSteel weatheringGolemSteel = this;
        if (weatheringGolemSteel instanceof class_2248) {
            class_2248 block = (class_2248)weatheringGolemSteel;
            return TO_OXIDIZED.get().containsValue((Object)block);
        }
        return false;
    }

    default public boolean isWaxed() {
        WeatheringGolemSteel weatheringGolemSteel = this;
        if (weatheringGolemSteel instanceof class_2248) {
            class_2248 block = (class_2248)weatheringGolemSteel;
            return TO_WAXED.get().containsValue((Object)block);
        }
        return false;
    }

    default public Optional<class_2680> getOxidizedState(class_2680 blockState) {
        if (TO_OXIDIZED.get().containsKey((Object)blockState.method_26204())) {
            return Optional.ofNullable((class_2248)TO_OXIDIZED.get().get((Object)blockState.method_26204())).map(block -> block.method_34725(blockState));
        }
        return Optional.empty();
    }

    default public Optional<class_2680> getWaxedState(class_2680 blockState) {
        if (TO_WAXED.get().containsKey((Object)blockState.method_26204())) {
            return Optional.ofNullable((class_2248)TO_WAXED.get().get((Object)blockState.method_26204())).map(block -> block.method_34725(blockState));
        }
        return Optional.empty();
    }

    default public void changeOverTime(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (randomSource.method_43057() < 0.05688889f) {
            this.getNextState(blockState, serverLevel, blockPos, randomSource).ifPresent(state -> serverLevel.method_8501(blockPos, state));
        }
    }

    default public Optional<class_2680> getNextState(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        class_2338 pos;
        int distManhattan;
        boolean oxidized = this.isOxidized();
        int lessAffected = 0;
        int moreAffected = 0;
        Iterator iterator = class_2338.method_25996((class_2338)blockPos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (distManhattan = (pos = (class_2338)iterator.next()).method_19455((class_2382)blockPos)) <= 4) {
            class_2248 block;
            if (pos.equals((Object)blockPos) || !((block = serverLevel.method_8320(pos).method_26204()) instanceof WeatheringGolemSteel)) continue;
            WeatheringGolemSteel weatheringGolemSteel = (WeatheringGolemSteel)block;
            boolean otherBlockOxidized = weatheringGolemSteel.isOxidized();
            if (!otherBlockOxidized && oxidized) {
                return Optional.empty();
            }
            if (otherBlockOxidized && !oxidized) {
                ++moreAffected;
                continue;
            }
            ++lessAffected;
        }
        float oxidizeFactor = (float)(moreAffected + 1) / (float)(moreAffected + lessAffected + 1);
        return randomSource.method_43057() < oxidizeFactor * oxidizeFactor * 0.75f ? this.getOxidizedState(blockState) : Optional.empty();
    }
}

