/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.block.CrystalbornCatalystBlock;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.item.menu.CrystalbornCatalystMenu;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_7225;
import net.minecraft.class_8567;

public class CrystalbornCatalystBlockEntity
extends class_2624 {
    private class_2371<class_1799> items = class_2371.method_10213((int)15, (Object)class_1799.field_8037);
    private static final String TAG_CURSOR_COUNT = "cursor_count";
    private static final String TAG_CURSOR = "cursor";
    private static final String TAG_ENERGY_LEFT = "energy_left";
    private int energyLeft = 0;
    private int charge = 0;
    private final List<Cursor> cursors = new ArrayList<Cursor>();
    private final class_5819 random;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return CrystalbornCatalystBlockEntity.this.charge;
        }

        public void method_17391(int index, int value) {
            CrystalbornCatalystBlockEntity.this.charge = value;
        }

        public int method_17389() {
            return 1;
        }
    };

    public CrystalbornCatalystBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ESBlockEntities.CRYSTALBORN_CATALYST.get(), blockPos, blockState);
        this.random = new class_5820(blockPos.method_10063());
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, CrystalbornCatalystBlockEntity entity) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (((Boolean)state.method_11654((class_2769)CrystalbornCatalystBlock.LIT)).booleanValue()) {
                entity.cursors.removeIf(cursor -> cursor.energyLeft <= 0 || cursor.pos.method_10262((class_2382)pos) > (double)(ESConfig.INSTANCE.itemsConfig.crystalbornCatalyst.maxRange() * ESConfig.INSTANCE.itemsConfig.crystalbornCatalyst.maxRange()));
                if (entity.energyLeft > 0 && entity.cursors.size() < 8) {
                    int energy = Math.min(entity.random.method_43051(10, 20), entity.energyLeft);
                    entity.cursors.add(new Cursor(pos, class_2350.method_10162((class_5819)entity.random), energy));
                    entity.energyLeft -= energy;
                }
                for (Cursor cursor2 : entity.cursors) {
                    cursor2.tick(serverLevel, stack -> {
                        int size = entity.method_5439();
                        class_1799 remains = stack;
                        for (int i = 1; i < size && !stack.method_7960(); ++i) {
                            remains = CrystalbornCatalystBlockEntity.tryMoveInItem((class_1263)entity, remains, i);
                        }
                        if (!remains.method_7960()) {
                            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)remains);
                        }
                    });
                }
                entity.charge = CrystalbornCatalystBlockEntity.isFuel((class_1799)entity.items.getFirst()) ? ++entity.charge : --entity.charge;
                entity.charge = Math.clamp((long)entity.charge, 0, 30);
                if (entity.charge == 30) {
                    ((class_1799)entity.items.getFirst()).method_7934(1);
                    entity.energyLeft += ESConfig.INSTANCE.itemsConfig.crystalbornCatalyst.energyPerShard();
                    for (int i = 0; i <= 10; ++i) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.CRYSTAL, pos.method_46558().field_1352 + (double)((entity.random.method_43057() - 0.5f) * 4.0f), pos.method_10264(), pos.method_46558().field_1350 + (double)((entity.random.method_43057() - 0.5f) * 4.0f), 0.0, 1.0, 0.0));
                    }
                    entity.charge = 0;
                    entity.method_5431();
                }
            } else {
                entity.charge = 0;
            }
        }
    }

    private static class_1799 tryMoveInItem(class_1263 destination, class_1799 stack, int slot) {
        class_1799 destItem = destination.method_5438(slot);
        if (destination.method_5437(slot, stack)) {
            boolean changed = false;
            if (destItem.method_7960()) {
                destination.method_5447(slot, stack);
                stack = class_1799.field_8037;
                changed = true;
            } else if (CrystalbornCatalystBlockEntity.canMergeItems(destItem, stack)) {
                int freeCount = stack.method_7914() - destItem.method_7947();
                int diff = Math.min(stack.method_7947(), freeCount);
                stack.method_7934(diff);
                destItem.method_7933(diff);
                boolean bl = changed = diff > 0;
            }
            if (changed) {
                destination.method_5431();
            }
        }
        return stack;
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7947() <= stack1.method_7914() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static boolean isFuel(class_1799 stack) {
        return stack.method_31574(ESItems.RED_STARLIGHT_CRYSTAL_SHARD.get()) || stack.method_31574(ESItems.BLUE_STARLIGHT_CRYSTAL_SHARD.get());
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0 && !CrystalbornCatalystBlockEntity.isFuel(stack)) {
            return false;
        }
        return super.method_5437(index, stack);
    }

    public int method_5439() {
        return 15;
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        int count = compoundTag.method_10550(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            this.cursors.add(Cursor.fromTag(compoundTag.method_10562(TAG_CURSOR + i)));
        }
        this.energyLeft = compoundTag.method_10550(TAG_ENERGY_LEFT);
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10569(TAG_CURSOR_COUNT, this.cursors.size());
        for (int i = 0; i < this.cursors.size(); ++i) {
            compoundTag.method_10566(TAG_CURSOR + i, (class_2520)this.cursors.get(i).toTag());
        }
        compoundTag.method_10569(TAG_ENERGY_LEFT, this.energyLeft);
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.eternal_starlight.crystalborn_catalyst");
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new CrystalbornCatalystMenu(id, player.field_7546.method_31548(), (class_1263)this, this.dataAccess);
    }

    private static class Cursor {
        private static final String TAG_POS_X = "pos_x";
        private static final String TAG_POS_Y = "pos_y";
        private static final String TAG_POS_Z = "pos_z";
        private static final String TAG_DIRECTION = "direction";
        private static final String TAG_ENERGY_LEFT = "energy_left";
        public class_2338 pos;
        public class_2350 direction;
        public int energyLeft;

        public Cursor(class_2338 pos, class_2350 direction, int energy) {
            this.pos = pos;
            this.direction = direction;
            this.energyLeft = energy;
        }

        public void tick(class_3218 level, Consumer<class_1799> dropsConsumer) {
            if (this.energyLeft <= 0) {
                return;
            }
            class_2338 targetPos = this.pos.method_10093(this.direction);
            class_2680 targetState = level.method_8320(targetPos);
            if (targetState.method_27852(ESBlocks.CRYSTALLIZED_SAND.get()) || targetState.method_27852((class_2248)ESBlocks.RED_CRYSTAL_MOSS_BLOCK.get()) || targetState.method_27852((class_2248)ESBlocks.BLUE_CRYSTAL_MOSS_BLOCK.get())) {
                this.pos = targetPos;
                if (level.method_8409().method_43048(3) == 0) {
                    this.direction = class_2350.method_10162((class_5819)level.method_8409());
                }
            } else if (targetState.method_26164(ESTags.Blocks.CRYSTALBORN_CATALYST_REPLACEABLES)) {
                class_8567.class_8568 builder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)targetPos)).method_51874(class_181.field_1229, (Object)class_1802.field_8377.method_7854()).method_51877(class_181.field_1228, targetState.method_31709() ? level.method_8321(targetPos) : null);
                List drops = targetState.method_26189(builder);
                if (level.method_22352(targetPos, false)) {
                    level.method_8501(targetPos, targetState.method_26164(class_3481.field_29822) || targetState.method_27852(class_2246.field_28681) ? ESBlocks.RED_CRYSTAL_MOSS_BLOCK.get().method_9564() : ESBlocks.CRYSTALLIZED_SAND.get().method_9564());
                    drops.forEach(dropsConsumer);
                    this.pos = targetPos;
                    --this.energyLeft;
                    ArrayList<class_2350> preferredDirs = new ArrayList<class_2350>(Arrays.stream(class_2350.values()).toList());
                    preferredDirs.removeIf(dir -> !level.method_8320(this.pos.method_10093(dir)).method_26164(ESTags.Blocks.CRYSTALBORN_CATALYST_PREFERENCES));
                    ArrayList<class_2350> availableDirs = new ArrayList<class_2350>(Arrays.stream(class_2350.values()).toList());
                    availableDirs.removeIf(dir -> !level.method_8320(this.pos.method_10093(dir)).method_26164(ESTags.Blocks.CRYSTALBORN_CATALYST_REPLACEABLES));
                    if (!preferredDirs.isEmpty()) {
                        this.direction = (class_2350)preferredDirs.get(level.method_8409().method_43048(preferredDirs.size()));
                    } else if (!availableDirs.isEmpty()) {
                        this.direction = (class_2350)availableDirs.get(level.method_8409().method_43048(availableDirs.size()));
                    }
                } else {
                    this.direction = class_2350.method_10162((class_5819)level.method_8409());
                }
            } else {
                this.direction = class_2350.method_10162((class_5819)level.method_8409());
            }
        }

        public static Cursor fromTag(class_2487 tag) {
            return new Cursor(new class_2338(tag.method_10550(TAG_POS_X), tag.method_10550(TAG_POS_Y), tag.method_10550(TAG_POS_Z)), class_2350.method_10143((int)tag.method_10550(TAG_DIRECTION)), tag.method_10550("energy_left"));
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10569(TAG_POS_X, this.pos.method_10263());
            tag.method_10569(TAG_POS_Y, this.pos.method_10264());
            tag.method_10569(TAG_POS_Z, this.pos.method_10260());
            tag.method_10569(TAG_DIRECTION, this.direction.method_10146());
            tag.method_10569("energy_left", this.energyLeft);
            return tag;
        }
    }
}

