/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.visual;

import cn.leolezury.eternalstarlight.common.util.Easing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ScreenShake {
    private final class_2960 dimension;
    private final class_243 pos;
    private final float radius;
    private final int duration;
    private final float horizontalPower;
    private final float verticalPower;
    private final float horizontalFreq;
    private final float verticalFreq;
    private Easing fadeEasing = Easing.IN_QUART;
    private int age;

    public ScreenShake(class_2960 dimension, class_243 pos, float radius, int duration, float horizontalPower, float verticalPower, float horizontalFreq, float verticalFreq) {
        this.dimension = dimension;
        this.pos = pos;
        this.radius = radius;
        this.duration = duration;
        this.horizontalPower = horizontalPower;
        this.verticalPower = verticalPower;
        this.horizontalFreq = horizontalFreq;
        this.verticalFreq = verticalFreq;
    }

    public void setFadeEasing(Easing fadeEasing) {
        this.fadeEasing = fadeEasing;
    }

    public void tick() {
        ++this.age;
    }

    public boolean shouldRemove() {
        return this.age > this.duration;
    }

    private float getPowerScale(float partialTicks) {
        float progress = Math.min(((float)this.age + partialTicks) / (float)this.duration, 1.0f);
        return this.fadeEasing.interpolate(progress, 1.0f, 0.0f);
    }

    public float getYawOffset() {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_746 player = class_310.method_1551().field_1724;
        float partialTicks = class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751());
        float time = player != null ? (float)player.field_6012 + partialTicks : 0.0f;
        float distance = (float)this.pos.method_1022(camera.method_19326());
        if (distance > this.radius || player != null && !player.method_37908().method_27983().method_29177().equals((Object)this.dimension)) {
            return 0.0f;
        }
        float powerScale = this.getPowerScale(partialTicks) * (1.0f - distance / this.radius);
        float power = this.horizontalPower * powerScale;
        return (float)(Math.sin(time * this.horizontalFreq) * (double)power);
    }

    public float getPitchOffset() {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_746 player = class_310.method_1551().field_1724;
        float partialTicks = class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751());
        float time = player != null ? (float)player.field_6012 + partialTicks : 0.0f;
        float distance = (float)this.pos.method_1022(camera.method_19326());
        if (distance > this.radius || player != null && !player.method_37908().method_27983().method_29177().equals((Object)this.dimension)) {
            return 0.0f;
        }
        float powerScale = this.getPowerScale(partialTicks) * (1.0f - distance / this.radius);
        float power = this.verticalPower * powerScale;
        return (float)(Math.sin(time * this.verticalFreq) * (double)power);
    }
}

