/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class LargeItemStackList
extends AbstractList<LargeItemStack> {
    private final List<LargeItemStack> list;

    public LargeItemStackList(List<LargeItemStack> list) {
        this.list = list;
    }

    @Override
    public LargeItemStack get(int index) {
        return this.list.get(index);
    }

    @Override
    public LargeItemStack set(int index, LargeItemStack value) {
        return this.list.set(index, value);
    }

    @Override
    public void add(int index, LargeItemStack value) {
        this.list.add(index, value);
    }

    @Override
    public LargeItemStack remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LargeItemStackList) {
            LargeItemStackList stacks = (LargeItemStackList)other;
            if (stacks.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < stacks.size(); ++i) {
                if (class_1799.method_7973((class_1799)stacks.get(i).getItem(), (class_1799)this.get(i).getItem()) && stacks.get(i).getCount() == this.get(i).getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class LargeItemStack {
        private final class_1799 item;
        private int count;
        public static final Codec<LargeItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_49747.fieldOf("item").forGetter(LargeItemStack::getItem), (App)Codec.INT.fieldOf("count").forGetter(LargeItemStack::getCount)).apply((Applicative)instance, LargeItemStack::new));
        public static final class_9139<class_9129, LargeItemStack> STREAM_CODEC = class_9139.method_56435((class_9139)class_1799.field_48349, LargeItemStack::getItem, (class_9139)class_9135.field_49675, LargeItemStack::getCount, LargeItemStack::new);

        public class_1799 getItem() {
            return this.item;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public LargeItemStack(class_1799 stack) {
            this(stack.method_46651(1), stack.method_7947());
        }

        public LargeItemStack(class_1799 item, int count) {
            this.item = item;
            this.count = count;
        }

        public boolean isEmpty() {
            return this.item.method_7960() || this.count == 0;
        }

        public void grow(int amount) {
            this.setCount(this.getCount() + amount);
        }

        public void shrink(int amount) {
            this.grow(-amount);
        }

        public class_1799 split(int splitAmount) {
            int splitCount = Math.min(splitAmount, this.count);
            class_1799 stack = this.item.method_46651(splitCount);
            this.count -= splitCount;
            return stack;
        }

        public class_1799 splitMaxStack() {
            return this.split(this.item.method_7914());
        }

        public class_1799 asItemStack() {
            return this.item.method_46651(this.count);
        }
    }
}

