/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public record Chain(List<Segment> segments) {
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_PITCH = "pitch";
    private static final String TAG_YAW = "yaw";
    private static final String TAG_SEGMENTS_SIZE = "segments_size";
    private static final String TAG_SEGMENT = "segment";

    public Chain(class_243 position, int numSegments, float segmentLength) {
        this(new ArrayList<Segment>());
        for (int i = 0; i < numSegments; ++i) {
            this.segments().add(new Segment(position.method_1031(0.0, (double)(numSegments - i - 1), 0.0), segmentLength));
        }
    }

    public void update(class_243 targetPos, class_243 attachPos, float rotationSpeed) {
        class_243 rotationTarget = targetPos;
        class_243 lastLowerPos = targetPos;
        for (int i = 0; i < this.segments().size(); ++i) {
            Segment segment = this.segments().get(i);
            segment.rotateTowards(rotationTarget, rotationSpeed);
            segment.setUpperPosition(lastLowerPos);
            rotationTarget = segment.getUpperPosition();
            lastLowerPos = segment.getLowerPosition();
        }
        if (attachPos != null) {
            class_243 offset = attachPos.method_1020(lastLowerPos);
            for (Segment segment : this.segments()) {
                segment.setLowerPosition(segment.getLowerPosition().method_1019(offset));
            }
        }
    }

    public Optional<class_243> getEndPos() {
        return this.segments().isEmpty() ? Optional.empty() : Optional.of(this.segments().getFirst().getUpperPosition());
    }

    public void save(class_2487 tag) {
        tag.method_10569(TAG_SEGMENTS_SIZE, this.segments().size());
        for (int i = 0; i < this.segments().size(); ++i) {
            Segment segment = this.segments().get(i);
            class_2487 segmentTag = new class_2487();
            segment.save(segmentTag);
            tag.method_10566(TAG_SEGMENT + i, (class_2520)segmentTag);
        }
    }

    public static Chain load(class_2487 tag) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int segmentsSize = tag.method_10550(TAG_SEGMENTS_SIZE);
        for (int i = 0; i < segmentsSize; ++i) {
            if (!tag.method_10573(TAG_SEGMENT + i, 10)) continue;
            class_2487 segmentTag = tag.method_10562(TAG_SEGMENT + i);
            Segment segment = Segment.load(segmentTag);
            segments.add(segment);
        }
        return new Chain(segments);
    }

    public static class Segment {
        private final float length;
        private class_243 position;
        private float pitch;
        private float yaw;

        public float getLength() {
            return this.length;
        }

        public class_243 getLowerPosition() {
            return this.position;
        }

        public class_243 getMiddlePosition() {
            return ESMathUtil.rotationToPosition(this.position, this.length / 2.0f, this.pitch, this.yaw);
        }

        public class_243 getUpperPosition() {
            return ESMathUtil.rotationToPosition(this.position, this.length, this.pitch, this.yaw);
        }

        public void setLowerPosition(class_243 position) {
            this.position = position;
        }

        public void setUpperPosition(class_243 position) {
            this.position = position.method_1019(this.getLowerPosition()).method_1020(this.getUpperPosition());
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public Segment(class_243 position, float length) {
            this.position = position;
            this.length = length;
        }

        public Segment(class_243 position, float length, float pitch, float yaw) {
            this(position, length);
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public void rotateTowards(class_243 target, float maxSpeed) {
            float wantedPitch = ESMathUtil.positionToPitch(this.position, target);
            float wantedYaw = ESMathUtil.positionToYaw(this.position, target);
            this.setPitch(class_3532.method_15388((float)this.pitch, (float)wantedPitch, (float)maxSpeed));
            this.setYaw(class_3532.method_15388((float)this.yaw, (float)wantedYaw, (float)maxSpeed));
        }

        public void save(class_2487 tag) {
            tag.method_10548(Chain.TAG_X, (float)this.getLowerPosition().field_1352);
            tag.method_10548(Chain.TAG_Y, (float)this.getLowerPosition().field_1351);
            tag.method_10548(Chain.TAG_Z, (float)this.getLowerPosition().field_1350);
            tag.method_10548(Chain.TAG_LENGTH, this.getLength());
            tag.method_10548(Chain.TAG_PITCH, this.getPitch());
            tag.method_10548(Chain.TAG_YAW, this.getYaw());
        }

        public static Segment load(class_2487 tag) {
            class_243 pos = new class_243((double)tag.method_10583(Chain.TAG_X), (double)tag.method_10583(Chain.TAG_Y), (double)tag.method_10583(Chain.TAG_Z));
            float length = tag.method_10583(Chain.TAG_LENGTH);
            float pitch = tag.method_10583(Chain.TAG_PITCH);
            float yaw = tag.method_10583(Chain.TAG_YAW);
            return new Segment(pos, length, pitch, yaw);
        }
    }
}

