/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_2952;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class DisplayBookComponent
extends BookComponent<Config> {
    public DisplayBookComponent() {
        super(Config.CODEC);
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        int totalHeight = config.totalHeight();
        for (TextDisplay display : config.textDisplays()) {
            totalHeight = Math.max(totalHeight, display.getLeastComponentHeight(context));
        }
        return totalHeight;
    }

    @Override
    public void render(Config config, BookContext context, class_332 graphics, int x, int y) {
        for (ImageDisplay imageDisplay : config.imageDisplays()) {
            graphics.method_25290(imageDisplay.location(), x + imageDisplay.x(), y + imageDisplay.y(), 0.0f, 0.0f, imageDisplay.width(), imageDisplay.height(), imageDisplay.width(), imageDisplay.height());
        }
        for (EntityDisplay entityDisplay : config.entityDisplays()) {
            class_1309 entity = entityDisplay.getEntity();
            if (entity == null) continue;
            class_490.method_48472((class_332)graphics, (float)(x + entityDisplay.x), (float)(y + entityDisplay.y), (float)entityDisplay.scale, (Vector3f)new Vector3f(), (Quaternionf)entityDisplay.rotation, null, (class_1309)entity);
        }
        for (ItemDisplay itemDisplay : config.itemDisplays()) {
            class_1799 stack = itemDisplay.getItemStack();
            graphics.method_51427(stack, x + itemDisplay.x, y + itemDisplay.y);
        }
        for (ItemTagDisplay itemTagDisplay : config.itemTagDisplays()) {
            List<class_1792> items = StreamSupport.stream(class_7923.field_41178.method_40286(itemTagDisplay.tag()).spliterator(), false).map(class_6880::comp_349).toList();
            if (items.isEmpty()) continue;
            class_1799 stack = items.get(class_3532.method_15357((double)((double)context.getTickCount() / 30.0)) % items.size()).method_7854();
            graphics.method_51427(stack, x + itemTagDisplay.x(), y + itemTagDisplay.y());
        }
        for (CraftingRecipeDisplay craftingRecipeDisplay : config.craftingRecipeDisplays) {
            class_1856[][] ingredients = craftingRecipeDisplay.getIngredients();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    class_1856 ingredient = ingredients[i][j];
                    if (ingredient == null) continue;
                    class_1799[] items = ingredient.method_8105();
                    class_1799 stack = items.length == 0 ? class_1799.field_8037 : items[class_3532.method_15357((double)((double)context.getTickCount() / 30.0)) % items.length];
                    graphics.method_51427(stack, x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2, y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2);
                }
            }
        }
        for (TextDisplay textDisplay : config.textDisplays()) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)(x + textDisplay.x), (float)(y + textDisplay.y), 0.0f);
            List<class_5481> lines = textDisplay.getLines(context);
            graphics.method_51448().method_22905(textDisplay.scale, textDisplay.scale, 1.0f);
            for (int i = 0; i < lines.size(); ++i) {
                class_5481 text = lines.get(i);
                graphics.method_51430(context.getFont(), text, textDisplay.centered ? -context.getFont().method_30880(text) / 2 : 0, i * textDisplay.lineHeight, 0, true);
            }
            graphics.method_51448().method_22909();
        }
    }

    @Override
    public void renderDelayed(Config config, BookContext context, class_332 graphics, int x, int y) {
        for (ItemDisplay itemDisplay : config.itemDisplays()) {
            class_1799 stack = itemDisplay.getItemStack();
            if (context.getMouseX() < x + itemDisplay.x || context.getMouseX() > x + itemDisplay.x + 16 || context.getMouseY() < Math.max(y + itemDisplay.y, context.getContentY()) || context.getMouseY() > Math.min(y + itemDisplay.y + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904(0.0, 0.0, 790.0);
            graphics.method_51437(context.getFont(), class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack), stack.method_32347(), context.getMouseX(), context.getMouseY());
            graphics.method_51448().method_22909();
        }
        for (ItemTagDisplay itemTagDisplay : config.itemTagDisplays()) {
            List<class_1792> items = StreamSupport.stream(class_7923.field_41178.method_40286(itemTagDisplay.tag()).spliterator(), false).map(class_6880::comp_349).toList();
            if (items.isEmpty()) continue;
            class_1799 stack = items.get(class_3532.method_15357((double)((double)context.getTickCount() / 30.0)) % items.size()).method_7854();
            if (context.getMouseX() < x + itemTagDisplay.x() || context.getMouseX() > x + itemTagDisplay.x() + 16 || context.getMouseY() < Math.max(y + itemTagDisplay.y(), context.getContentY()) || context.getMouseY() > Math.min(y + itemTagDisplay.y() + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904(0.0, 0.0, 790.0);
            graphics.method_51437(context.getFont(), class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack), stack.method_32347(), context.getMouseX(), context.getMouseY());
            graphics.method_51448().method_22909();
        }
        for (CraftingRecipeDisplay craftingRecipeDisplay : config.craftingRecipeDisplays) {
            class_1856[][] ingredients = craftingRecipeDisplay.getIngredients();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    class_1799 stack;
                    class_1856 ingredient = ingredients[i][j];
                    if (ingredient == null) continue;
                    class_1799[] items = ingredient.method_8105();
                    class_1799 class_17992 = stack = items.length == 0 ? class_1799.field_8037 : items[class_3532.method_15357((double)((double)context.getTickCount() / 30.0)) % items.length];
                    if (stack.method_7960() || context.getMouseX() <= x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2 || context.getMouseX() >= x + craftingRecipeDisplay.x + i * craftingRecipeDisplay.slotWidth + (craftingRecipeDisplay.slotWidth - 16) / 2 + 16 || context.getMouseY() <= Math.max(y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2, context.getContentY()) || context.getMouseY() >= Math.min(y + craftingRecipeDisplay.y + j * craftingRecipeDisplay.slotHeight + (craftingRecipeDisplay.slotHeight - 16) / 2 + 16, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) continue;
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_22904(0.0, 0.0, 790.0);
                    graphics.method_51437(context.getFont(), class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack), stack.method_32347(), context.getMouseX(), context.getMouseY());
                    graphics.method_51448().method_22909();
                }
            }
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        for (TextDisplay display : config.textDisplays()) {
            class_2558 event;
            class_2583 style;
            int trueLineHeight = (int)((float)display.lineHeight * display.scale);
            List<class_5481> list = display.getLines(context);
            int line = (context.getMouseY() - (y + display.y)) / trueLineHeight;
            if (context.getMouseY() < y + display.y || line < 0 || line >= list.size()) continue;
            class_5481 charSequence = list.get(line);
            int width = (int)((float)context.getFont().method_30880(charSequence) * display.scale);
            int startX = x + display.x - (display.centered ? width / 2 : 0);
            int endX = x + display.x + (display.centered ? width / 2 : width);
            if (context.getMouseX() < startX || context.getMouseX() > endX || (style = context.getFont().method_27527().method_30876(charSequence, (int)((float)(context.getMouseX() - startX) / display.scale))) == null || (event = style.method_10970()) == null || event.method_10845() != class_2558.class_2559.field_11748) continue;
            context.jumpToComponent(class_2960.method_60654((String)event.method_10844()));
        }
    }

    public record Config(class_2960 id, HashSet<HashSet<class_2960>> unlockConditions, int totalHeight, List<TextDisplay> textDisplays, List<EntityDisplay> entityDisplays, List<ItemDisplay> itemDisplays, List<ItemTagDisplay> itemTagDisplays, List<CraftingRecipeDisplay> craftingRecipeDisplays, List<ImageDisplay> imageDisplays) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(Config::id), (App)class_2960.field_25139.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)Codec.INT.fieldOf("total_height").forGetter(Config::totalHeight), (App)TextDisplay.CODEC.listOf().fieldOf("text_displays").forGetter(Config::textDisplays), (App)EntityDisplay.CODEC.listOf().fieldOf("entity_displays").forGetter(Config::entityDisplays), (App)ItemDisplay.CODEC.listOf().fieldOf("item_displays").forGetter(Config::itemDisplays), (App)ItemTagDisplay.CODEC.listOf().fieldOf("item_tag_displays").forGetter(Config::itemTagDisplays), (App)CraftingRecipeDisplay.CODEC.listOf().fieldOf("crafting_recipe_displays").forGetter(Config::craftingRecipeDisplays), (App)ImageDisplay.CODEC.listOf().fieldOf("image_displays").forGetter(Config::imageDisplays)).apply((Applicative)instance, Config::new));

        public Config(class_2960 id, HashSet<HashSet<class_2960>> unlockConditions, int totalHeight) {
            this(id, unlockConditions, totalHeight, new ArrayList<TextDisplay>(), new ArrayList<EntityDisplay>(), new ArrayList<ItemDisplay>(), new ArrayList<ItemTagDisplay>(), new ArrayList<CraftingRecipeDisplay>(), new ArrayList<ImageDisplay>());
        }

        public Config textDisplay(BookContent text, boolean centered, int x, int y, int width, int lineHeight, int minDistanceToBottom, float scale) {
            this.textDisplays.add(new TextDisplay(text, centered, x, y, width, lineHeight, minDistanceToBottom, scale));
            return this;
        }

        public Config entityDisplay(class_2487 tag, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
            this.entityDisplays.add(new EntityDisplay(tag, x, y, xRot, yRot, scale, rotation));
            return this;
        }

        public Config itemDisplay(class_2487 tag, int x, int y) {
            this.itemDisplays.add(new ItemDisplay(tag, x, y));
            return this;
        }

        public Config itemTagDisplay(class_6862<class_1792> tag, int x, int y) {
            this.itemTagDisplays.add(new ItemTagDisplay(tag, x, y));
            return this;
        }

        public Config craftingRecipeDisplay(class_2960 recipe, int x, int y, int slotWidth, int slotHeight) {
            this.craftingRecipeDisplays.add(new CraftingRecipeDisplay(recipe, x, y, slotWidth, slotHeight));
            return this;
        }

        public Config imageDisplay(class_2960 location, int x, int y, int width, int height) {
            this.imageDisplays.add(new ImageDisplay(location, x, y, width, height));
            return this;
        }
    }

    private static class TextDisplay {
        public static final Codec<TextDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookContent.CODEC.fieldOf("text").forGetter(o -> o.text), (App)Codec.BOOL.fieldOf("centered").forGetter(o -> o.centered), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.INT.fieldOf("width").forGetter(o -> o.width), (App)Codec.INT.fieldOf("line_height").forGetter(o -> o.lineHeight), (App)Codec.INT.fieldOf("min_distance_to_bottom").forGetter(o -> o.minDistanceToBottom), (App)Codec.FLOAT.fieldOf("scale").forGetter(o -> Float.valueOf(o.scale))).apply((Applicative)instance, TextDisplay::new));
        private final BookContent text;
        private final List<class_5481> cachedText = new ArrayList<class_5481>();
        private final boolean centered;
        private final int x;
        private final int y;
        private final int width;
        private final int lineHeight;
        private final int minDistanceToBottom;
        private final float scale;

        public TextDisplay(BookContent text, boolean centered, int x, int y, int width, int lineHeight, int minDistanceToBottom, float scale) {
            this.text = text;
            this.centered = centered;
            this.x = x;
            this.y = y;
            this.width = width;
            this.lineHeight = lineHeight;
            this.minDistanceToBottom = minDistanceToBottom;
            this.scale = scale;
        }

        public List<class_5481> getLines(BookContext context) {
            if (this.cachedText.isEmpty()) {
                this.cachedText.addAll(context.getFont().method_1728((class_5348)this.text.toComponent(), (int)((float)this.width / this.scale)));
            }
            return this.cachedText;
        }

        public int getLeastComponentHeight(BookContext context) {
            return (int)((float)this.y + (float)(this.getLines(context).size() * this.lineHeight) * this.scale + (float)this.minDistanceToBottom);
        }
    }

    private record ImageDisplay(class_2960 location, int x, int y, int width, int height) {
        public static final Codec<ImageDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("location").forGetter(ImageDisplay::location), (App)Codec.INT.fieldOf("x").forGetter(ImageDisplay::x), (App)Codec.INT.fieldOf("y").forGetter(ImageDisplay::y), (App)Codec.INT.fieldOf("width").forGetter(ImageDisplay::width), (App)Codec.INT.fieldOf("height").forGetter(ImageDisplay::height)).apply((Applicative)instance, ImageDisplay::new));
    }

    private static class EntityDisplay {
        public static final Codec<EntityDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2487.field_25128.fieldOf("entity").forGetter(o -> o.entityTag), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.FLOAT.fieldOf("x_rot").forGetter(o -> Float.valueOf(o.xRot)), (App)Codec.FLOAT.fieldOf("y_rot").forGetter(o -> Float.valueOf(o.yRot)), (App)Codec.FLOAT.fieldOf("scale").forGetter(o -> Float.valueOf(o.scale)), (App)class_5699.field_42267.fieldOf("rotation").forGetter(o -> o.rotation)).apply((Applicative)instance, EntityDisplay::new));
        private class_1309 cachedEntity;
        private final class_2487 entityTag;
        private final int x;
        private final int y;
        private final float xRot;
        private final float yRot;
        private final float scale;
        private final Quaternionf rotation;

        public EntityDisplay(class_2487 entity, int x, int y, float xRot, float yRot, float scale, Quaternionf rotation) {
            this.entityTag = entity;
            this.x = x;
            this.y = y;
            this.xRot = xRot;
            this.yRot = yRot;
            this.scale = scale;
            this.rotation = rotation;
        }

        public class_1309 getEntity() {
            class_1297 class_12972;
            if (this.cachedEntity == null && class_310.method_1551().field_1687 != null && (class_12972 = class_1299.method_17842((class_2487)this.entityTag, (class_1937)class_310.method_1551().field_1687, e -> e)) instanceof class_1309) {
                class_1309 entity;
                this.cachedEntity = entity = (class_1309)class_12972;
                this.cachedEntity.field_6283 = this.yRot;
                this.cachedEntity.method_36457(this.xRot);
                this.cachedEntity.method_36456(this.yRot);
                this.cachedEntity.field_6241 = this.cachedEntity.method_36454();
                this.cachedEntity.field_6259 = this.cachedEntity.method_36454();
            }
            return this.cachedEntity;
        }
    }

    private static class ItemDisplay {
        public static final Codec<ItemDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2487.field_25128.fieldOf("item").forGetter(o -> o.itemStackTag), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y)).apply((Applicative)instance, ItemDisplay::new));
        private class_1799 cachedStack = null;
        private final class_2487 itemStackTag;
        private final int x;
        private final int y;

        public ItemDisplay(class_2487 itemStack, int x, int y) {
            this.itemStackTag = itemStack;
            this.x = x;
            this.y = y;
        }

        public class_1799 getItemStack() {
            if (this.cachedStack == null && class_310.method_1551().field_1687 != null) {
                this.cachedStack = class_1799.method_57359((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), (class_2487)this.itemStackTag);
            }
            return this.cachedStack == null ? class_1799.field_8037 : this.cachedStack;
        }
    }

    private record ItemTagDisplay(class_6862<class_1792> tag, int x, int y) {
        public static final Codec<ItemTagDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("item_tag").forGetter(ItemTagDisplay::tag), (App)Codec.INT.fieldOf("x").forGetter(ItemTagDisplay::x), (App)Codec.INT.fieldOf("y").forGetter(ItemTagDisplay::y)).apply((Applicative)instance, ItemTagDisplay::new));
    }

    private static class CraftingRecipeDisplay {
        public static final Codec<CraftingRecipeDisplay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("recipe").forGetter(o -> o.recipeId), (App)Codec.INT.fieldOf("x").forGetter(o -> o.x), (App)Codec.INT.fieldOf("y").forGetter(o -> o.y), (App)Codec.INT.fieldOf("slot_width").forGetter(o -> o.slotWidth), (App)Codec.INT.fieldOf("slot_height").forGetter(o -> o.slotHeight)).apply((Applicative)instance, CraftingRecipeDisplay::new));
        private final class_1856[][] ingredients = new class_1856[3][3];
        private final class_2960 recipeId;
        private class_8786<?> recipe;
        private final int x;
        private final int y;
        private final int slotWidth;
        private final int slotHeight;
        private boolean recipePlaced = false;

        public CraftingRecipeDisplay(class_2960 recipe, int x, int y, int slotWidth, int slotHeight) {
            this.recipeId = recipe;
            this.x = x;
            this.y = y;
            this.slotWidth = slotWidth;
            this.slotHeight = slotHeight;
        }

        public class_1856[][] getIngredients() {
            if (this.recipe == null && class_310.method_1551().field_1687 != null) {
                this.recipe = class_310.method_1551().field_1687.method_8433().method_8130(this.recipeId).orElse(null);
            }
            if (!this.recipePlaced && this.recipe != null && this.recipe.comp_1933().method_17716() == class_3956.field_17545) {
                this.recipePlaced = true;
                class_2952 placeRecipe = (ingredient, slot, maxAmount, x, y) -> {
                    this.ingredients[x][y] = ingredient;
                };
                placeRecipe.method_12816(3, 3, -1, this.recipe, this.recipe.comp_1933().method_8117().iterator(), 0);
            }
            return this.ingredients;
        }
    }
}

