/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class IndexBookComponent
extends BookComponent<Config> {
    public IndexBookComponent() {
        super(Config.CODEC);
    }

    private List<Entry> filterEnabledEntries(Config config, BookContext context) {
        ArrayList<Entry> filtered = new ArrayList<Entry>(config.entries());
        filtered.removeIf(entry -> !context.isComponentEnabled(entry.jumpTo));
        return filtered;
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        int totalHeight = config.offset() + config.extraHeight();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            totalHeight += entry.getHeight(config, context);
        }
        return totalHeight;
    }

    @Override
    public void render(Config config, BookContext context, class_332 graphics, int x, int y) {
        int startHeight = config.offset();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            entry.render(config, context, graphics, x, y + startHeight);
            startHeight += entry.getHeight(config, context);
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        int startHeight = y + config.offset();
        for (Entry entry : this.filterEnabledEntries(config, context)) {
            int currentHeight = entry.getHeight(config, context);
            if (context.getMouseY() > startHeight && context.getMouseY() < startHeight + currentHeight) {
                context.jumpToComponent(entry.jumpTo);
                break;
            }
            startHeight += currentHeight;
        }
    }

    public record Config(class_2960 id, HashSet<HashSet<class_2960>> unlockConditions, List<Entry> entries, int offset, int extraHeight, int width, int lineHeight) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(Config::id), (App)class_2960.field_25139.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(Config::entries), (App)Codec.INT.fieldOf("offset").forGetter(Config::offset), (App)Codec.INT.fieldOf("extra_height").forGetter(Config::extraHeight), (App)Codec.INT.fieldOf("width").forGetter(Config::width), (App)Codec.INT.fieldOf("line_height").forGetter(Config::lineHeight)).apply((Applicative)instance, Config::new));
    }

    public static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookContent.CODEC.fieldOf("text").forGetter(o -> o.text), (App)class_2960.field_25139.fieldOf("jump_to").forGetter(o -> o.jumpTo), (App)class_2960.field_25139.listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("listening").forGetter(o -> o.listening), (App)Codec.INT.fieldOf("icon_frame_width").forGetter(o -> o.iconFrameWidth), (App)Codec.INT.fieldOf("icon_frame_height").forGetter(o -> o.iconFrameHeight), (App)class_2960.field_25139.fieldOf("icon_frame").forGetter(o -> o.iconFrame), (App)class_2487.field_25128.fieldOf("icon").forGetter(o -> o.icon)).apply((Applicative)instance, Entry::new));
        private final BookContent text;
        private final class_2960 jumpTo;
        private final HashSet<class_2960> listening;
        private final int iconFrameWidth;
        private final int iconFrameHeight;
        private final class_2960 iconFrame;
        private final class_2487 icon;
        private class_1799 cachedIcon;

        public Entry(BookContent text, class_2960 jumpTo, HashSet<class_2960> listening, int iconFrameWidth, int iconFrameHeight, class_2960 iconFrame, class_2487 icon) {
            this.text = text;
            this.jumpTo = jumpTo;
            this.listening = listening;
            this.iconFrameWidth = iconFrameWidth;
            this.iconFrameHeight = iconFrameHeight;
            this.iconFrame = iconFrame;
            this.icon = icon;
        }

        public class_2960 getJumpToId() {
            return this.jumpTo;
        }

        public HashSet<class_2960> getListeningIds() {
            return this.listening;
        }

        public class_2561 getText() {
            return this.text.toComponent();
        }

        public class_1799 getIcon() {
            if (this.cachedIcon == null && class_310.method_1551().field_1687 != null) {
                this.cachedIcon = class_1799.method_57359((class_7225.class_7874)class_310.method_1551().field_1687.method_30349(), (class_2487)this.icon);
            }
            return this.cachedIcon == null ? class_1799.field_8037 : this.cachedIcon;
        }

        private List<class_5481> splitText(Config config, BookContext context, class_2561 component) {
            return context.getFont().method_1728((class_5348)component, config.width() - this.iconFrameWidth - 5);
        }

        public int getHeight(Config config, BookContext context) {
            int n = (this.splitText(config, context, this.getText()).size() - 1) * config.lineHeight();
            Objects.requireNonNull(context.getFont());
            return Math.max(n + 9 / 2 + this.iconFrameHeight / 2, this.iconFrameHeight);
        }

        public void render(Config config, BookContext context, class_332 graphics, int x, int y) {
            graphics.method_25290(this.iconFrame, x, y, 0.0f, 0.0f, this.iconFrameWidth, this.iconFrameHeight, this.iconFrameWidth, this.iconFrameHeight);
            graphics.method_51427(this.getIcon(), x + this.iconFrameWidth / 2 - 8, y + this.iconFrameHeight / 2 - 8);
            boolean selected = context.getMouseX() >= context.getContentX() && context.getMouseX() <= context.getContentX() + context.getBookDefinition().width() - 2 * context.getBookDefinition().frameWidth() && context.getMouseY() > y && context.getMouseY() < y + this.getHeight(config, context);
            List<class_5481> list = this.splitText(config, context, (class_2561)(selected ? this.getText().method_27661().method_27692(class_124.field_1073) : this.getText()));
            for (int i = 0; i < list.size(); ++i) {
                class_327 class_3272 = context.getFont();
                int n = y + this.iconFrameHeight / 2;
                Objects.requireNonNull(context.getFont());
                graphics.method_51430(class_3272, list.get(i), x + this.iconFrameWidth + 5, n - 9 / 2 + i * config.lineHeight(), -1, true);
            }
        }
    }
}

