/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.text;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public record BookText(boolean translation, String content) {
    public static final Codec<BookText> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("translation").forGetter(BookText::translation), (App)Codec.STRING.fieldOf("content").forGetter(BookText::content)).apply((Applicative)instance, BookText::new));
    public static final Codec<List<BookText>> LIST_CODEC = CODEC.listOf();

    public String getString() {
        if (this.translation) {
            class_2477 language = class_2477.method_10517();
            return language.method_48307(this.content);
        }
        return this.content;
    }

    public static List<class_2561> parse(String input) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        StringBuilder currentText = new StringBuilder();
        FormatState currentState = new FormatState();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '$' && i + 1 < input.length() && input.charAt(i + 1) == '{') {
                int endIndex;
                if (!currentText.isEmpty()) {
                    result.add(BookText.createText(currentText.toString(), currentState));
                    currentText.setLength(0);
                }
                if ((endIndex = input.indexOf(125, i + 2)) == -1) {
                    currentText.append("${");
                    i += 2;
                    continue;
                }
                String command = input.substring(i + 2, endIndex);
                BookText.processCommand(command, currentState);
                i = endIndex + 1;
                continue;
            }
            currentText.append(c);
            ++i;
        }
        if (!currentText.isEmpty()) {
            result.add(BookText.createText(currentText.toString(), currentState));
        }
        return result;
    }

    private static void processCommand(String command, FormatState state) {
        String style;
        String color;
        if (command.equals("r")) {
            state.color = null;
            state.style = null;
            state.link = null;
        }
        if (command.startsWith("color:") && (color = command.substring(6).trim()).startsWith("#")) {
            try {
                state.color = Integer.parseInt(color.substring(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (command.startsWith("style:") && (style = command.substring(6).trim()).length() == 1) {
            state.style = class_124.method_544((char)style.charAt(0));
        }
        if (command.startsWith("link:")) {
            state.link = command.substring(5).trim();
        }
    }

    private static class_2561 createText(String content, FormatState state) {
        class_5250 text = class_2561.method_43470((String)content);
        if (state.color != null) {
            text.method_54663(state.color.intValue());
        }
        if (state.style != null) {
            text.method_27692(state.style);
        }
        if (state.link != null) {
            text.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11748, state.link)));
        }
        return text;
    }

    private static class FormatState {
        Integer color = null;
        class_124 style = null;
        String link = null;

        private FormatState() {
        }
    }
}

