/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import cn.leolezury.eternalstarlight.common.client.book.component.ConfiguredBookComponent;
import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.BookHistoryButton;
import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.BookProgressButton;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class BookScreen
extends class_437 {
    public static final int OVERLAY_Z_OFFSET = 770;
    public static final int BUTTON_Z_OFFSET = 780;
    public static final int TOOLTIP_Z_OFFSET = 790;
    private final BookDefinition book;
    private final BookContext context;
    private final List<List<ConfiguredBookComponent<?, ?>>> unlockedComponents;
    private final List<ConfiguredBookComponent<?, ?>> currentComponents = new ArrayList();
    private BookProgressButton upButton;
    private BookProgressButton downButton;
    private BookHistoryButton leftButton;
    private BookHistoryButton rightButton;
    private int tickCount = 0;
    private int totalHeight = 0;
    private int scrollProgress = 0;
    private boolean scrolling = false;
    private int mouseOffset;
    private int mouseX;
    private int mouseY;
    private final List<Stamp> stamps = new ArrayList<Stamp>();
    private int currentIndex = 0;

    public BookScreen(final BookDefinition book, Set<class_2960> unlocked) {
        super((class_2561)class_2561.method_43473());
        this.book = book;
        this.unlockedComponents = new ArrayList();
        for (List<ConfiguredBookComponent<?, ?>> innerList : book.components()) {
            this.unlockedComponents.add(new ArrayList(innerList));
        }
        this.unlockedComponents.forEach(list -> list.removeIf(component -> !component.isEnabled(unlocked)));
        this.unlockedComponents.removeIf(List::isEmpty);
        if (!this.unlockedComponents.isEmpty()) {
            this.currentComponents.addAll((Collection)this.unlockedComponents.getFirst());
            if (!this.currentComponents.isEmpty()) {
                this.stamps.add(new Stamp(this.currentComponents.getFirst().config().id(), 0));
            }
        }
        this.context = new BookContext(){

            @Override
            public int getMouseX() {
                return BookScreen.this.mouseX;
            }

            @Override
            public int getMouseY() {
                return BookScreen.this.mouseY;
            }

            @Override
            public class_327 getFont() {
                return BookScreen.this.field_22793;
            }

            @Override
            public BookDefinition getBookDefinition() {
                return book;
            }

            @Override
            public int getContentX() {
                return BookScreen.this.getContentX();
            }

            @Override
            public int getContentY() {
                return BookScreen.this.getContentY();
            }

            @Override
            public int getTickCount() {
                return BookScreen.this.tickCount;
            }

            @Override
            public boolean isComponentEnabled(class_2960 id) {
                return BookScreen.this.unlockedComponents.stream().flatMap(Collection::stream).anyMatch(component -> component.config().id().equals((Object)id));
            }

            @Override
            public void jumpToComponent(class_2960 id) {
                BookScreen.this.jumpToComponent(id, true);
            }
        };
    }

    protected void method_25426() {
        this.totalHeight = 0;
        for (ConfiguredBookComponent<?, ?> component : this.currentComponents) {
            this.totalHeight += component.getTotalHeight(this.context);
        }
        this.upButton = (BookProgressButton)this.method_37063((class_364)new BookProgressButton(this.getBaseX() + this.book.width() - this.book.buttons().upDownButtonWidth() - this.book.buttons().upDownButtonDistanceFromRight(), this.getBaseY() + this.book.buttons().upButtonOffset(), this.book, false, button -> {
            Objects.requireNonNull(this.field_22793);
            this.setScrollProgress(this.scrollProgress - 9);
        }));
        this.downButton = (BookProgressButton)this.method_37063((class_364)new BookProgressButton(this.getBaseX() + this.book.width() - this.book.buttons().upDownButtonWidth() - this.book.buttons().upDownButtonDistanceFromRight(), this.getBaseY() + this.book.buttons().downButtonOffset(), this.book, true, button -> {
            Objects.requireNonNull(this.field_22793);
            this.setScrollProgress(this.scrollProgress + 9);
        }));
        this.leftButton = (BookHistoryButton)this.method_37063((class_364)new BookHistoryButton(this.getBaseX() + this.book.buttons().leftButtonOffset(), this.getBaseY() + this.book.buttons().leftRightButtonDistanceFromTop(), this.book, true, button -> {
            if (this.currentIndex - 1 >= 0 && this.currentIndex - 1 < this.stamps.size()) {
                Stamp stamp = this.stamps.get(this.currentIndex - 1);
                this.jumpToComponent(stamp.id(), false);
                this.setScrollProgress(stamp.progress());
                --this.currentIndex;
            }
        }));
        this.rightButton = (BookHistoryButton)this.method_37063((class_364)new BookHistoryButton(this.getBaseX() + this.book.buttons().rightButtonOffset(), this.getBaseY() + this.book.buttons().leftRightButtonDistanceFromTop(), this.book, false, button -> {
            if (this.currentIndex + 1 >= 0 && this.currentIndex + 1 < this.stamps.size()) {
                Stamp stamp = this.stamps.get(this.currentIndex + 1);
                this.jumpToComponent(stamp.id(), false);
                this.setScrollProgress(stamp.progress());
                ++this.currentIndex;
            }
        }));
        this.updateButtonVisibility();
    }

    public void jumpToComponent(class_2960 id, boolean leaveStamp) {
        if (this.currentIndex >= 0 && this.currentIndex < this.stamps.size()) {
            this.stamps.set(this.currentIndex, new Stamp(this.stamps.get(this.currentIndex).id(), this.scrollProgress));
        }
        block0: for (List<ConfiguredBookComponent<?, ?>> list : this.unlockedComponents) {
            int currentHeight = 0;
            for (ConfiguredBookComponent<?, ?> component : list) {
                if (component.config().id().equals((Object)id)) {
                    this.currentComponents.clear();
                    this.currentComponents.addAll(list);
                    this.setScrollProgress(currentHeight);
                    if (leaveStamp) {
                        ArrayList<Stamp> toRemove = new ArrayList<Stamp>();
                        for (int i = this.currentIndex + 1; i < this.stamps.size(); ++i) {
                            toRemove.add(this.stamps.get(i));
                        }
                        this.stamps.removeIf(toRemove::contains);
                        this.stamps.add(new Stamp(id, this.scrollProgress));
                        this.currentIndex = this.stamps.size() - 1;
                    }
                    this.method_41843();
                    continue block0;
                }
                currentHeight += component.getTotalHeight(this.context);
            }
        }
    }

    public void method_16014(double x, double y) {
        super.method_16014(x, y);
        this.mouseX = (int)x;
        this.mouseY = (int)y;
    }

    public boolean method_25402(double x, double y, int button) {
        boolean result = super.method_25402(x, y, button);
        if (!result) {
            boolean scrollArea;
            if (x >= (double)this.getContentX() && x <= (double)(this.getContentX() + this.book.width() - 2 * this.book.frameWidth()) && y >= (double)this.getContentY() && y <= (double)(this.getContentY() + this.book.height() - 2 * this.book.frameWidth())) {
                int startHeight = 0;
                for (ConfiguredBookComponent<?, ?> component : new ArrayList(this.currentComponents)) {
                    int currentY = this.getContentY() - this.scrollProgress + startHeight;
                    if (y >= (double)currentY && y <= (double)(currentY + component.getTotalHeight(this.context))) {
                        component.onClick(this.context, this.getContentX(), this.getContentY() - this.scrollProgress + startHeight);
                    }
                    startHeight += component.getTotalHeight(this.context);
                }
            }
            boolean bl = scrollArea = x >= (double)(this.getBaseX() + this.book.scrollbar().scrollbarXOffset()) && x <= (double)(this.getBaseX() + this.book.scrollbar().scrollbarXOffset() + this.book.scrollbar().scrollbarWidth()) && y >= (double)(this.getBaseY() + this.book.scrollbar().scrollbarYOffset()) && y <= (double)(this.getBaseY() + this.book.scrollbar().scrollbarYOffset() + this.book.scrollbar().scrollbarHeight());
            if (scrollArea && button == 0) {
                this.scrolling = true;
                this.mouseOffset = class_3532.method_15340((int)((int)(y - (double)(this.getBaseY() + this.book.scrollbar().scrollbarYOffset() + (int)((double)this.getMaxScroll() * ((double)this.scrollProgress / (double)(this.totalHeight - this.book.height() + 2 * this.book.frameWidth())))))), (int)0, (int)this.getScrollButtonHeight());
                return true;
            }
        }
        return result;
    }

    public boolean method_25406(double x, double y, int button) {
        if (button == 0) {
            this.scrolling = false;
            this.mouseOffset = 0;
        }
        return super.method_25406(x, y, button);
    }

    public boolean method_25403(double x, double y, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.setScrollProgress((int)((y - (double)this.mouseOffset - (double)this.getBaseY() - (double)this.book.scrollbar().scrollbarYOffset()) * (double)(this.totalHeight - this.book.height() + 2 * this.book.frameWidth()) / (double)this.getMaxScroll()));
            return true;
        }
        return false;
    }

    public boolean method_25401(double x, double y, double scrollX, double scrollY) {
        Objects.requireNonNull(this.field_22793);
        this.setScrollProgress(this.scrollProgress - (int)(scrollY * 9.0));
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean down;
        boolean up = keyCode == 265;
        boolean bl = down = keyCode == 264;
        if (up || down) {
            int n = up ? -1 : 1;
            Objects.requireNonNull(this.field_22793);
            this.setScrollProgress(this.scrollProgress + n * 9);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25393() {
        ++this.tickCount;
        int startHeight = 0;
        for (ConfiguredBookComponent<?, ?> component : new ArrayList(this.currentComponents)) {
            component.tick(this.context, this.getContentX(), this.getContentY() - this.scrollProgress + startHeight);
            startHeight += component.getTotalHeight(this.context);
        }
        this.currentIndex = this.stamps.isEmpty() ? 0 : class_3532.method_15340((int)this.currentIndex, (int)0, (int)(this.stamps.size() - 1));
        this.updateButtonVisibility();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(this.book.textures().background(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width(), this.book.height(), this.book.width(), this.book.height());
        guiGraphics.method_44379(this.getContentX(), this.getContentY(), this.getContentX() + this.book.width() - 2 * this.book.frameWidth(), this.getContentY() + this.book.height() - 2 * this.book.frameWidth());
        int startHeight = 0;
        for (ConfiguredBookComponent<?, ?> component : new ArrayList(this.currentComponents)) {
            if (this.getContentY() - this.scrollProgress + startHeight < this.getContentY() + this.book.height() - 2 * this.book.frameWidth() && this.getContentY() - this.scrollProgress + startHeight + component.getTotalHeight(this.context) > this.getContentY()) {
                component.render(this.context, guiGraphics, this.getContentX(), this.getContentY() - this.scrollProgress + startHeight);
            }
            startHeight += component.getTotalHeight(this.context);
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(0.0, 0.0, 770.0);
        guiGraphics.method_44380();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        guiGraphics.method_25290(this.book.textures().overlay(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width(), this.book.height(), this.book.width(), this.book.height());
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_51448().method_22909();
        if (this.getScrollButtonHeight() < this.book.scrollbar().scrollbarHeight()) {
            int scrollButtonX = this.getBaseX() + this.book.scrollbar().scrollbarXOffset() + (this.book.scrollbar().scrollbarWidth() - this.book.scrollbar().scrollButtonWidth()) / 2;
            int scrollButtonY = this.getBaseY() + this.book.scrollbar().scrollbarYOffset() + (int)((double)this.getMaxScroll() * ((double)this.scrollProgress / (double)(this.totalHeight - this.book.height() + 2 * this.book.frameWidth())));
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22904(0.0, 0.0, 780.0);
            guiGraphics.method_25294(scrollButtonX, scrollButtonY, scrollButtonX + this.book.scrollbar().scrollButtonWidth(), scrollButtonY + this.getScrollButtonHeight(), this.book.scrollbar().scrollButtonColor());
            guiGraphics.method_51448().method_22909();
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int startHeight = 0;
        for (ConfiguredBookComponent<?, ?> component : new ArrayList(this.currentComponents)) {
            if (this.getContentY() - this.scrollProgress + startHeight < this.getContentY() + this.book.height() - 2 * this.book.frameWidth() && this.getContentY() - this.scrollProgress + startHeight + component.getTotalHeight(this.context) > this.getContentY()) {
                component.renderDelayed(this.context, guiGraphics, this.getContentX(), this.getContentY() - this.scrollProgress + startHeight);
            }
            startHeight += component.getTotalHeight(this.context);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private void updateButtonVisibility() {
        this.upButton.field_22764 = this.scrollProgress > 0;
        boolean bl = this.downButton.field_22764 = this.scrollProgress < this.totalHeight - this.book.height() + 2 * this.book.frameWidth();
        if (this.totalHeight <= this.book.height() - 2 * this.book.frameWidth()) {
            this.upButton.field_22764 = false;
            this.downButton.field_22764 = false;
        }
        this.leftButton.field_22764 = this.currentIndex - 1 >= 0 && this.currentIndex - 1 < this.stamps.size();
        this.rightButton.field_22764 = this.currentIndex + 1 >= 0 && this.currentIndex + 1 < this.stamps.size();
    }

    private int getBaseX() {
        return (this.field_22789 - this.book.width()) / 2;
    }

    private int getContentX() {
        return this.getBaseX() + this.book.frameWidth();
    }

    private int getBaseY() {
        return (this.field_22790 - this.book.height()) / 2;
    }

    private int getContentY() {
        return this.getBaseY() + this.book.frameWidth();
    }

    private void setScrollProgress(int progress) {
        this.scrollProgress = class_3532.method_15340((int)progress, (int)0, (int)Math.max(this.totalHeight - this.book.height() + 2 * this.book.frameWidth(), 0));
    }

    private int getMaxScroll() {
        return this.book.scrollbar().scrollbarHeight() - this.getScrollButtonHeight();
    }

    private int getScrollButtonHeight() {
        return Math.clamp((long)((int)((double)this.book.scrollbar().scrollbarHeight() * (double)(this.book.height() - 2 * this.book.frameWidth()) / (double)this.totalHeight)), this.book.scrollbar().scrollButtonWidth(), this.book.scrollbar().scrollbarHeight());
    }

    private record Stamp(class_2960 id, int progress) {
    }
}

