/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.handler.ClientSetupHandlers;
import cn.leolezury.eternalstarlight.common.client.resource.BookLoader;
import cn.leolezury.eternalstarlight.common.client.shader.ESShaders;
import cn.leolezury.eternalstarlight.common.client.sound.BossMusicSoundInstance;
import cn.leolezury.eternalstarlight.common.client.visual.DelayedMultiBufferSource;
import cn.leolezury.eternalstarlight.common.client.visual.ScreenShake;
import cn.leolezury.eternalstarlight.common.client.visual.WorldVisualEffect;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESFluids;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESGuiUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1113;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4061;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5636;
import net.minecraft.class_5944;
import net.minecraft.class_6854;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_758;
import net.minecraft.class_9797;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ClientHandlers {
    public static BookLoader books;
    public static final Set<class_1308> BOSSES;
    public static final List<WorldVisualEffect> VISUAL_EFFECTS;
    public static final List<ScreenShake> SCREEN_SHAKES;
    private static final class_2960[] BAR_BACKGROUND_SPRITES;
    private static final class_2960[] BAR_PROGRESS_SPRITES;
    private static final class_2960[] OVERLAY_BACKGROUND_SPRITES;
    private static final class_2960[] OVERLAY_PROGRESS_SPRITES;
    private static final class_2960 ETHER_EROSION_OVERLAY;
    private static final class_2960 ETHER_ARMOR_EMPTY;
    private static final class_2960 ETHER_ARMOR_HALF;
    private static final class_2960 ETHER_ARMOR_FULL;
    private static final class_2960 ORB_OF_PROPHECY_USE;
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE;
    private static final class_2960 LUNARIS_CACTUS_BLUR_LOCATION;
    public static final class_2960 WIP_LOCATION;
    private static final Map<class_5321<Crest>, GuiCrest> GUI_CRESTS;
    private static final List<DreamCatcherText> DREAM_CATCHER_TEXTS;
    public static int clientTickCount;
    public static BossMusicSoundInstance bossMusicInstance;
    private static float oldPortalTicks;
    private static float portalTicks;
    private static float oldAuroraIntensity;
    private static float auroraIntensity;
    public static int resetCameraIn;
    public static float fogStartDecrement;
    public static float fogEndDecrement;
    public static float oldAbyssalFogModifier;
    public static float abyssalFogModifier;
    public static boolean oldTearyEffect;
    public static boolean tearyEffect;
    public static int oldSeedsLauncherAnimTicks;
    public static int seedsLauncherAnimTicks;
    public static final class_4597.class_4598 DELAYED_BUFFER_SOURCE;
    private static Matrix4f modelViewMatrix;
    public static boolean isHalloween;

    public static void onClientTick() {
        if (class_310.method_1551().field_1687 == null) {
            ClientHandlers.clearWorldSpecificVars();
        }
        class_746 player = class_310.method_1551().field_1724;
        ClientWeatherState.tickRainLevel();
        ArrayList<WorldVisualEffect> effectsToRemove = new ArrayList<WorldVisualEffect>();
        ArrayList<ScreenShake> screenShakesToRemove = new ArrayList<ScreenShake>();
        if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()) {
            if (!class_310.method_1551().method_1493()) {
                if (++clientTickCount % 1000 == 5) {
                    Calendar calendar = Calendar.getInstance();
                    isHalloween = calendar.get(2) == 10 && calendar.get(5) == 1;
                }
                oldSeedsLauncherAnimTicks = seedsLauncherAnimTicks;
                if (seedsLauncherAnimTicks > 0) {
                    --seedsLauncherAnimTicks;
                }
            }
            for (WorldVisualEffect worldVisualEffect : VISUAL_EFFECTS) {
                if (worldVisualEffect.shouldRemove()) {
                    effectsToRemove.add(worldVisualEffect);
                    continue;
                }
                if (class_310.method_1551().method_1493()) continue;
                worldVisualEffect.worldTick();
            }
            for (WorldVisualEffect worldVisualEffect : effectsToRemove) {
                VISUAL_EFFECTS.remove(worldVisualEffect);
            }
            for (ScreenShake screenShake : SCREEN_SHAKES) {
                if (screenShake.shouldRemove()) {
                    screenShakesToRemove.add(screenShake);
                    continue;
                }
                if (class_310.method_1551().method_1493()) continue;
                screenShake.tick();
            }
            for (ScreenShake screenShake : screenShakesToRemove) {
                SCREEN_SHAKES.remove(screenShake);
            }
            if (!class_310.method_1551().method_1493() && ClientWeatherState.weather != null && class_310.method_1551().field_1687.method_27983().method_29177().equals((Object)ESDimensions.STARLIGHT_KEY.method_29177())) {
                ClientWeatherState.weather.clientTick();
            }
            if (player != null) {
                if (player.field_6012 % 20 == 0) {
                    if (bossMusicInstance == null) {
                        List<ESBoss> bosses = class_310.method_1551().field_1687.method_18467(ESBoss.class, player.method_5829().method_1014(50.0));
                        bosses.sort(Comparator.comparingDouble(b -> b.method_5739((class_1297)player)));
                        bosses = bosses.stream().filter(ESBoss::shouldPlayBossMusic).filter(b -> b.field_6012 > 20 && player.method_6057((class_1297)b)).toList();
                        if (!bosses.isEmpty()) {
                            ESBoss eSBoss = bosses.getFirst();
                            bossMusicInstance = new BossMusicSoundInstance(eSBoss.getBossMusic(), eSBoss);
                        }
                    } else if (bossMusicInstance.shouldStopMusic(player)) {
                        class_310.method_1551().method_1483().method_4870((class_1113)bossMusicInstance);
                        bossMusicInstance.stopMusic();
                        bossMusicInstance = null;
                    }
                    if (bossMusicInstance != null && !class_310.method_1551().method_1483().method_4877((class_1113)bossMusicInstance)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)bossMusicInstance);
                    }
                }
            } else if (bossMusicInstance != null) {
                class_310.method_1551().method_1483().method_4870((class_1113)bossMusicInstance);
                bossMusicInstance.stopMusic();
                bossMusicInstance = null;
            }
        }
        if (class_310.method_1551().field_1687 != null) {
            for (ClientSetupHandlers.WorldVisualEffectSpawnFunction worldVisualEffectSpawnFunction : ClientSetupHandlers.VISUAL_EFFECT_SPAWN_FUNCTIONS) {
                worldVisualEffectSpawnFunction.clientTick(class_310.method_1551().field_1687, VISUAL_EFFECTS);
            }
        }
        if (player != null) {
            class_2378 registry;
            Optional key;
            oldPortalTicks = portalTicks;
            if (player.field_51994 != null && player.field_51994.method_60703((class_9797)ESBlocks.STARLIGHT_PORTAL.get()) && player.field_51994.method_60709()) {
                portalTicks += 1.0f;
                player.field_51994.method_60705(false);
            } else {
                portalTicks -= 2.0f;
            }
            portalTicks = class_3532.method_15363((float)portalTicks, (float)0.0f, (float)80.0f);
            oldAuroraIntensity = auroraIntensity;
            if (player.method_37908().method_27983() == ESDimensions.STARLIGHT_KEY) {
                auroraIntensity = ClientWeatherState.weather == ESWeathers.AURORA.get() ? (auroraIntensity += 0.05f) : (auroraIntensity -= 0.05f);
            } else {
                oldAuroraIntensity = 0.0f;
                auroraIntensity = 0.0f;
            }
            auroraIntensity = class_3532.method_15363((float)auroraIntensity, (float)0.0f, (float)1.0f);
            ArrayList<class_5321<Crest>> crestsToRemove = new ArrayList<class_5321<Crest>>();
            for (class_5321<Crest> class_53212 : GUI_CRESTS.keySet()) {
                GuiCrest crest = GUI_CRESTS.get(class_53212);
                if (!((double)Math.abs(crest.angle + 135.0f) < 0.1) || crest.shouldShow) continue;
                crestsToRemove.add(class_53212);
            }
            for (class_5321 class_53213 : crestsToRemove) {
                GUI_CRESTS.remove(class_53213);
            }
            for (Map.Entry<class_5321<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().tick();
            }
            class_1799 class_17992 = player.method_6047();
            class_1799 class_17993 = player.method_6079();
            class_6880 component = null;
            if (class_17992.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                component = (class_6880)class_17992.method_57824(ESDataComponents.CURRENT_CREST.get());
            } else if (class_17993.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                component = (class_6880)class_17993.method_57824(ESDataComponents.CURRENT_CREST.get());
            }
            for (Map.Entry<class_5321<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                entry.getValue().shouldShow = false;
            }
            if (component != null && component.method_40227() && (key = (registry = player.method_56673().method_30530(ESRegistries.CREST)).method_29113((Object)((Crest)component.comp_349()))).isPresent()) {
                if (!GUI_CRESTS.containsKey(key.get())) {
                    GUI_CRESTS.put((class_5321<Crest>)((class_5321)key.get()), new GuiCrest());
                }
                ClientHandlers.GUI_CRESTS.get(key.get()).shouldShow = true;
            }
            if (ClientSetupHandlers.KEY_MAPPINGS.get(EternalStarlight.id("switch_crest")).method_1436()) {
                ESPlatform.INSTANCE.sendToServer(new NoParametersPacket("switch_crest"));
            }
            if (resetCameraIn > 0) {
                class_310.method_1551().field_1690.field_1842 = true;
                if (--resetCameraIn <= 0) {
                    class_310.method_1551().method_1504((class_1297)player);
                    class_310.method_1551().field_1690.field_1842 = false;
                    resetCameraIn = 0;
                }
            } else if (class_310.method_1551().method_1560() instanceof SoulitSpectator) {
                class_310.method_1551().method_1504((class_1297)player);
                class_310.method_1551().field_1690.field_1842 = false;
            }
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            fogStartDecrement -= 0.5f;
            fogEndDecrement -= 0.5f;
            class_6880 biomeHolder = player.method_37908().method_23753(player.method_24515());
            if (camera.method_19334() == class_5636.field_27888 && player.method_37908().method_8320(camera.method_19328()).method_26227().method_15769() && biomeHolder.method_40225(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                fogStartDecrement += 1.25f;
                fogEndDecrement += 1.0f;
                fogEndDecrement = class_3532.method_15363((float)fogEndDecrement, (float)0.0f, (float)80.0f);
            }
            fogStartDecrement = class_3532.method_15363((float)fogStartDecrement, (float)0.0f, (float)100.0f);
            fogEndDecrement = class_3532.method_15363((float)fogEndDecrement, (float)0.0f, (float)100.0f);
            oldAbyssalFogModifier = abyssalFogModifier;
            abyssalFogModifier = biomeHolder.method_40225(ESBiomes.THE_ABYSS) ? (abyssalFogModifier -= 0.02f) : (abyssalFogModifier += 0.02f);
            abyssalFogModifier = class_3532.method_15363((float)abyssalFogModifier, (float)0.0f, (float)1.0f);
            oldTearyEffect = tearyEffect;
            tearyEffect = player.method_6059(ESMobEffects.TEARY.asHolder());
            if (player.method_6059(ESMobEffects.DREAM_CATCHER.asHolder())) {
                ArrayList<DreamCatcherText> textsToRemove = new ArrayList<DreamCatcherText>();
                for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                    text.updatePosition();
                    int width = class_310.method_1551().field_1772.method_27525((class_5348)text.getText());
                    Objects.requireNonNull(class_310.method_1551().field_1772);
                    int height = 9;
                    if (text.getX() - width / 2 <= class_310.method_1551().method_22683().method_4486() && text.getY() - height / 2 <= class_310.method_1551().method_22683().method_4502()) continue;
                    textsToRemove.add(text);
                }
                for (DreamCatcherText text : textsToRemove) {
                    DREAM_CATCHER_TEXTS.remove(text);
                }
                if (player.method_59922().method_43048(40) == 0 && DREAM_CATCHER_TEXTS.size() < 20) {
                    class_5250 dreamCatcherText = class_2561.method_43471((String)("message.eternal_starlight.dream_catcher_" + player.method_59922().method_43048(7)));
                    DREAM_CATCHER_TEXTS.add(new DreamCatcherText((class_2561)dreamCatcherText, (int)(player.method_59922().method_43057() * 5.0f + 1.0f), -class_310.method_1551().field_1772.method_27525((class_5348)dreamCatcherText) / 2, player.method_59922().method_43048(class_310.method_1551().method_22683().method_4502())));
                }
            } else {
                DREAM_CATCHER_TEXTS.clear();
            }
        } else {
            DREAM_CATCHER_TEXTS.clear();
            tearyEffect = false;
        }
        if (oldTearyEffect != tearyEffect) {
            class_310.method_1551().field_1773.method_3167(class_310.method_1551().field_1719);
        }
    }

    private static void clearWorldSpecificVars() {
        BOSSES.clear();
        VISUAL_EFFECTS.clear();
        SCREEN_SHAKES.clear();
        GUI_CRESTS.clear();
        DREAM_CATCHER_TEXTS.clear();
        if (bossMusicInstance != null) {
            class_310.method_1551().method_1483().method_4870((class_1113)bossMusicInstance);
            bossMusicInstance.stopMusic();
            bossMusicInstance = null;
        }
        oldPortalTicks = 0.0f;
        portalTicks = 0.0f;
        oldAuroraIntensity = 0.0f;
        auroraIntensity = 0.0f;
        resetCameraIn = 0;
        fogStartDecrement = 0.0f;
        fogEndDecrement = 0.0f;
        oldAbyssalFogModifier = 1.0f;
        abyssalFogModifier = 1.0f;
        oldTearyEffect = false;
        tearyEffect = false;
        oldSeedsLauncherAnimTicks = 0;
        seedsLauncherAnimTicks = 0;
    }

    public static float getScreenShakeYawOffset() {
        if (!ESConfig.INSTANCE.enableScreenShake) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getYawOffset();
        }
        return sum;
    }

    public static float getScreenShakePitchOffset() {
        if (!ESConfig.INSTANCE.enableScreenShake) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (ScreenShake screenShake : SCREEN_SHAKES) {
            sum += screenShake.getPitchOffset();
        }
        return sum;
    }

    public static void onAfterRenderEntities(class_4597 source, class_4587 stack, float partialTicks) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        stack.method_22903();
        stack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        for (WorldVisualEffect effect : VISUAL_EFFECTS) {
            if (effect.shouldRemove()) continue;
            effect.render(source, stack, partialTicks);
        }
        stack.method_22909();
    }

    public static void onAfterRenderParticles() {
        modelViewMatrix = RenderSystem.getModelViewMatrix();
    }

    public static void onAfterRenderWeather(float partialTicks) {
        float aurora;
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        if (class_310.method_29611()) {
            class_310.method_1551().method_1522().method_1235(false);
        }
        DELAYED_BUFFER_SOURCE.method_22993();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)matrix4f);
        if (class_310.method_29611() && class_310.method_1551().field_1769.method_29364() != null) {
            class_310.method_1551().field_1769.method_29364().method_1235(false);
        }
        if ((aurora = class_3532.method_16439((float)partialTicks, (float)oldAuroraIntensity, (float)auroraIntensity)) > 0.0f && class_310.method_1551().field_1687 != null) {
            ClientHandlers.renderSkyShader(ESShaders.getAurora(), aurora);
        }
    }

    private static void renderSkyShader(class_5944 shader, float intensity) {
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float scale = 2048.0f * (class_310.method_1551().field_1773.method_3193() / 32.0f);
        class_243 pos = class_310.method_1551().field_1773.method_19418().method_19326();
        float height = (float)(pos.method_10214() + 128.0);
        float cloud = class_310.method_1551().field_1687.method_28103().method_28108() + 64.0f;
        float y = (float)((double)Math.max(height, cloud) - pos.method_10214());
        buffer.method_22912(-scale, y, scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22912(-scale, y, -scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22912(scale, y, -scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22912(scale, y, scale).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)intensity);
        class_5944 last = RenderSystem.getShader();
        RenderSystem.setShader(() -> shader);
        shader.method_34586();
        class_286.method_43433((class_9801)buffer.method_60800());
        shader.method_34585();
        RenderSystem.setShader(() -> last);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static class_243 computeCameraAngles(class_243 angles) {
        return angles.method_1031(class_3532.method_15350((double)ClientHandlers.getScreenShakePitchOffset(), (double)-0.5, (double)0.5), class_3532.method_15350((double)ClientHandlers.getScreenShakeYawOffset(), (double)-0.5, (double)0.5), 0.0);
    }

    public static OptionalDouble modifyFov(float original) {
        float portal;
        class_1799 itemStack;
        float modified = original;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_6115() && ((itemStack = player.method_6030()).method_31574(ESItems.STARFALL_LONGBOW.get()) || itemStack.method_31574(ESItems.FLOWGLAZE_BOW.get()) || itemStack.method_31574(ESItems.MOONRING_BOW.get()) || itemStack.method_31574(ESItems.BOW_OF_BLOOD.get()))) {
            float f = (float)player.method_6048() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            modified = (float)class_3532.method_16436((double)((Double)class_310.method_1551().field_1690.method_42454().method_41753()), (double)1.0, (double)(modified * (1.0f - f * 0.15f)));
        }
        if ((portal = class_3532.method_16439((float)class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()), (float)oldPortalTicks, (float)portalTicks) / 80.0f) > 0.0f) {
            modified = (float)class_3532.method_16436((double)((Double)class_310.method_1551().field_1690.method_42454().method_41753()), (double)1.0, (double)(modified * (1.0f - portal)));
        }
        return modified == original ? OptionalDouble.empty() : OptionalDouble.of(modified);
    }

    public static void onRenderFog(class_4184 camera, class_758.class_4596 fogMode) {
        class_3610 fluidState;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (ESPlatform.INSTANCE.getLoader() == ESPlatform.Loader.FABRIC && ((fluidState = camera.method_19331().method_37908().method_8316(camera.method_19328())).method_39360((class_3611)ESFluids.ETHER_STILL.get()) || fluidState.method_39360((class_3611)ESFluids.ETHER_FLOWING.get())) && camera.method_19326().field_1351 < (double)((float)camera.method_19328().method_10264() + fluidState.method_15763((class_1922)camera.method_19331().method_37908(), camera.method_19328()))) {
            RenderSystem.setShaderFogStart((float)0.0f);
            RenderSystem.setShaderFogEnd((float)3.0f);
            RenderSystem.setShaderFogColor((float)0.9098039f, (float)1.0f, (float)0.87058824f);
            RenderSystem.setShaderFogShape((class_6854)class_6854.field_36350);
        }
        if (player.method_37908().method_27983() == ESDimensions.STARLIGHT_KEY && camera.method_19334() == class_5636.field_27888 && player.method_37908().method_8320(camera.method_19328()).method_26227().method_15769() && fogMode == class_758.class_4596.field_20946) {
            RenderSystem.setShaderFogStart((float)(RenderSystem.getShaderFogStart() - class_3532.method_15363((float)fogStartDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogStart() + 5.0f))));
            RenderSystem.setShaderFogEnd((float)(RenderSystem.getShaderFogEnd() - class_3532.method_15363((float)fogEndDecrement, (float)0.0f, (float)(RenderSystem.getShaderFogEnd() - 50.0f))));
            class_6880 biomeHolder = player.method_37908().method_23753(player.method_24515());
            if (biomeHolder.method_40225(ESBiomes.STARLIGHT_PERMAFROST_FOREST)) {
                RenderSystem.setShaderFogShape((class_6854)class_6854.field_36350);
            }
        }
    }

    public static boolean renderBossBar(class_332 guiGraphics, class_345 bossEvent, int x, int y) {
        class_2960 barLocation;
        class_1308 boss = null;
        if (BOSSES.isEmpty()) {
            return false;
        }
        for (class_1308 mob : BOSSES) {
            if (!mob.method_5667().equals(bossEvent.method_5407())) continue;
            boss = mob;
            break;
        }
        Iterator<class_1308> iterator = boss;
        int mob = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TheGatekeeper.class, StarlightGolem.class, LunarMonstrosity.class}, iterator, mob)) {
            case 0: {
                TheGatekeeper theGatekeeper = (TheGatekeeper)((Object)iterator);
                barLocation = class_2960.method_60655((String)"eternal_starlight", (String)"textures/gui/bars/the_gatekeeper.png");
                break;
            }
            case 1: {
                StarlightGolem starlightGolem = (StarlightGolem)((Object)iterator);
                barLocation = class_2960.method_60655((String)"eternal_starlight", (String)"textures/gui/bars/starlight_golem.png");
                break;
            }
            case 2: {
                LunarMonstrosity lunarMonstrosity = (LunarMonstrosity)((Object)iterator);
                barLocation = class_2960.method_60655((String)"eternal_starlight", (String)("textures/gui/bars/lunar_monstrosity" + (lunarMonstrosity.getPhase() > 0 ? "_soul.png" : ".png")));
                break;
            }
            default: {
                return false;
            }
        }
        ClientHandlers.drawBar(guiGraphics, x, y, (class_1259)bossEvent, barLocation);
        class_2561 component = bossEvent.method_5414();
        int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)component);
        int textX = class_310.method_1551().method_22683().method_4486() / 2 - textWidth / 2;
        int textY = y - 9;
        guiGraphics.method_27535(class_310.method_1551().field_1772, component, textX, textY, 0xFFFFFF);
        return true;
    }

    public static void drawBar(class_332 guiGraphics, int x, int y, class_1259 event, class_2960 barLocation) {
        ClientHandlers.drawBar(guiGraphics, x, y, event, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
        int k = class_3532.method_53063((float)event.method_5412(), (int)0, (int)182);
        if (k > 0) {
            ClientHandlers.drawBar(guiGraphics, x, y, event, k, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
        }
        guiGraphics.method_25290(barLocation, x - 1, y - 5, 0.0f, 0.0f, 184, 16, 184, 16);
    }

    private static void drawBar(class_332 guiGraphics, int x, int y, class_1259 bossEvent, int progress, class_2960[] bars, class_2960[] overlays) {
        guiGraphics.method_52708(bars[bossEvent.method_5420().ordinal()], 182, 5, 0, 0, x, y, progress, 5);
        if (bossEvent.method_5415() != class_1259.class_1261.field_5795) {
            RenderSystem.enableBlend();
            guiGraphics.method_52708(overlays[bossEvent.method_5415().ordinal() - 1], 182, 5, 0, 0, x, y, progress, 5);
            RenderSystem.disableBlend();
        }
    }

    public static void renderTextureOverlay(class_332 guiGraphics, class_2960 resourceLocation, float f) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, f);
        guiGraphics.method_25291(resourceLocation, 0, 0, -90, 0.0f, 0.0f, guiGraphics.method_51421(), guiGraphics.method_51443(), guiGraphics.method_51421(), guiGraphics.method_51443());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderPortalOverlay(class_332 guiGraphics) {
        float alpha = class_3532.method_16439((float)class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()), (float)oldPortalTicks, (float)portalTicks) / 120.0f;
        if (alpha <= 0.0f) {
            return;
        }
        if (alpha < 1.0f) {
            alpha *= alpha;
            alpha *= alpha;
            alpha = alpha * 0.8f + 0.2f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
        class_1058 textureatlassprite = class_310.method_1551().method_1541().method_3351().method_3339(ESBlocks.STARLIGHT_PORTAL.get().method_9564());
        guiGraphics.method_25298(0, 0, -90, guiGraphics.method_51421(), guiGraphics.method_51443(), textureatlassprite);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderSpellCrosshair(class_332 guiGraphics, int screenWidth, int screenHeight) {
        class_746 player;
        class_315 options = class_310.method_1551().field_1690;
        if (options.method_31044().method_31034() && (player = class_310.method_1551().field_1724) instanceof SpellCaster && ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).hasSpell()) {
            SpellCastData data = ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player);
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            if (class_310.method_1551().field_1690.method_42565().method_41753() == class_4061.field_18152) {
                float f = Math.min(1.0f, (float)data.castTicks() / (float)data.spell().spellProperties().preparationTicks());
                if (data.castTicks() > data.spell().spellProperties().preparationTicks()) {
                    f = Math.max(0.0f, 1.0f - (float)(data.castTicks() - data.spell().spellProperties().preparationTicks()) / (float)data.spell().spellProperties().spellTicks());
                }
                int j = screenHeight / 2 - 7 + 16;
                int k = screenWidth / 2 - 8;
                int l = (int)(f * 17.0f);
                guiGraphics.method_52706(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, k, j, 16, 4);
                guiGraphics.method_52708(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, k, j, l, 4);
            }
            RenderSystem.defaultBlendFunc();
        }
    }

    public static void renderEtherErosion(class_332 guiGraphics) {
        float erosionProgress = (float)ESDataAttachments.IN_ETHER_TICKS.getData((class_1297)class_310.method_1551().field_1724).intValue() / 140.0f;
        if (erosionProgress > 0.0f) {
            ClientHandlers.renderTextureOverlay(guiGraphics, ETHER_EROSION_OVERLAY, erosionProgress);
        }
    }

    public static void renderEtherArmor(class_332 guiGraphics, int screenWidth, int screenHeight) {
        class_310 minecraft = class_310.method_1551();
        if (ESBlockUtil.isEntityInBlock((class_1297)minecraft.field_1724, (class_2248)ESBlocks.ETHER.get())) {
            minecraft.method_16011().method_15396("armor");
            int initialX = screenWidth / 2 - 91;
            int initialY = screenHeight - 39;
            float maxHealth = (float)Math.max(minecraft.field_1724.method_45325(class_5134.field_23716), (double)class_3532.method_15386((float)minecraft.field_1724.method_6032()));
            int absorptionAmount = class_3532.method_15386((float)minecraft.field_1724.method_6067());
            int q = class_3532.method_15386((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
            int r = Math.max(10 - (q - 2), 3);
            int armorValue = minecraft.field_1724.method_6096();
            int y = initialY - (q - 1) * r - 10;
            for (int i = 0; i < 10; ++i) {
                if (armorValue <= 0) continue;
                int x = initialX + i * 8;
                if (i * 2 + 1 < armorValue) {
                    guiGraphics.method_25290(ETHER_ARMOR_FULL, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 == armorValue) {
                    guiGraphics.method_25290(ETHER_ARMOR_HALF, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (i * 2 + 1 <= armorValue) continue;
                guiGraphics.method_25290(ETHER_ARMOR_EMPTY, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            }
        }
    }

    public static void renderOrbOfProphecyUse(class_332 guiGraphics) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_6115() && player.method_6030().method_31574(ESItems.ORB_OF_PROPHECY.get()) && !player.method_6030().method_57826(ESDataComponents.CURRENT_CREST.get())) {
            int usingTicks = player.method_6048();
            float ticks = Math.min((float)usingTicks + class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()), 150.0f);
            float progress = Math.min(ticks, 150.0f) / 150.0f;
            if (usingTicks < 150) {
                ClientHandlers.renderTextureOverlay(guiGraphics, ORB_OF_PROPHECY_USE, progress);
            }
        }
    }

    public static void renderCurrentCrest(class_332 guiGraphics) {
        if (class_310.method_1551().field_1724 != null) {
            class_2378 registry = class_310.method_1551().field_1724.method_56673().method_30530(ESRegistries.CREST);
            float partialTicks = class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751());
            for (Map.Entry<class_5321<Crest>, GuiCrest> entry : GUI_CRESTS.entrySet()) {
                GuiCrest guiCrest = entry.getValue();
                Crest crest = (Crest)registry.method_29107(entry.getKey());
                if (crest == null) continue;
                ESGuiUtil.blitFloat(guiGraphics, crest.texture(), guiCrest.getX(partialTicks), guiCrest.getY(partialTicks), 72.0f, 72.0f, 72.0f, 72.0f);
            }
        }
    }

    public static void renderCarvedLunarisCactusFruitBlur(class_332 guiGraphics) {
        class_1799 itemStack;
        if (class_310.method_1551().field_1690.method_31044().method_31034() && class_310.method_1551().field_1724 != null && (itemStack = class_310.method_1551().field_1724.method_31548().method_7372(3)).method_31574(ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get().method_8389())) {
            ClientHandlers.renderTextureOverlay(guiGraphics, LUNARIS_CACTUS_BLUR_LOCATION, 1.0f);
        }
    }

    public static void renderDreamCatcher(class_332 guiGraphics) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_6059(ESMobEffects.DREAM_CATCHER.asHolder())) {
            for (DreamCatcherText text : DREAM_CATCHER_TEXTS) {
                guiGraphics.method_27534(class_310.method_1551().field_1772, text.getText(), text.getX(), text.getY(), 5343172);
            }
        }
    }

    public static void setAirBubbleColor() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_37908().method_23753(player.method_24515()).method_40225(ESBiomes.THE_ABYSS)) {
            RenderSystem.setShaderColor((float)1.0f, (float)((float)class_3532.method_15350((double)(1.0 + player.method_23318() / 64.0), (double)0.0, (double)1.0)), (float)1.0f, (float)1.0f);
        }
    }

    public static int getAirBubbleYOffset() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_37908().method_23753(player.method_24515()).method_40225(ESBiomes.THE_ABYSS) && player.method_23318() < 0.0) {
            return player.method_59922().method_43048(2);
        }
        return 0;
    }

    static {
        BOSSES = Collections.newSetFromMap(new WeakHashMap());
        VISUAL_EFFECTS = new ArrayList<WorldVisualEffect>();
        SCREEN_SHAKES = new ArrayList<ScreenShake>();
        BAR_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_background"), class_2960.method_60656((String)"boss_bar/blue_background"), class_2960.method_60656((String)"boss_bar/red_background"), class_2960.method_60656((String)"boss_bar/green_background"), class_2960.method_60656((String)"boss_bar/yellow_background"), class_2960.method_60656((String)"boss_bar/purple_background"), class_2960.method_60656((String)"boss_bar/white_background")};
        BAR_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_progress"), class_2960.method_60656((String)"boss_bar/blue_progress"), class_2960.method_60656((String)"boss_bar/red_progress"), class_2960.method_60656((String)"boss_bar/green_progress"), class_2960.method_60656((String)"boss_bar/yellow_progress"), class_2960.method_60656((String)"boss_bar/purple_progress"), class_2960.method_60656((String)"boss_bar/white_progress")};
        OVERLAY_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_background"), class_2960.method_60656((String)"boss_bar/notched_10_background"), class_2960.method_60656((String)"boss_bar/notched_12_background"), class_2960.method_60656((String)"boss_bar/notched_20_background")};
        OVERLAY_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_progress"), class_2960.method_60656((String)"boss_bar/notched_10_progress"), class_2960.method_60656((String)"boss_bar/notched_12_progress"), class_2960.method_60656((String)"boss_bar/notched_20_progress")};
        ETHER_EROSION_OVERLAY = EternalStarlight.id("textures/misc/ether_erosion.png");
        ETHER_ARMOR_EMPTY = EternalStarlight.id("textures/gui/hud/ether_armor_empty.png");
        ETHER_ARMOR_HALF = EternalStarlight.id("textures/gui/hud/ether_armor_half.png");
        ETHER_ARMOR_FULL = EternalStarlight.id("textures/gui/hud/ether_armor_full.png");
        ORB_OF_PROPHECY_USE = EternalStarlight.id("textures/misc/orb_of_prophecy_use.png");
        CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_background");
        CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_progress");
        LUNARIS_CACTUS_BLUR_LOCATION = EternalStarlight.id("textures/misc/lunaris_cactus_blur.png");
        WIP_LOCATION = EternalStarlight.id("textures/gui/wip.png");
        GUI_CRESTS = new HashMap<class_5321<Crest>, GuiCrest>();
        DREAM_CATCHER_TEXTS = new ArrayList<DreamCatcherText>();
        clientTickCount = 0;
        bossMusicInstance = null;
        oldAbyssalFogModifier = 1.0f;
        abyssalFogModifier = 1.0f;
        DELAYED_BUFFER_SOURCE = new DelayedMultiBufferSource(new class_9799(1536));
        modelViewMatrix = new Matrix4f();
    }

    private static class GuiCrest {
        private boolean shouldShow = false;
        private float prevAngle = -135.0f;
        private float angle = -135.0f;

        private GuiCrest() {
        }

        public void tick() {
            this.prevAngle = this.angle;
            this.angle = class_3532.method_15388((float)this.angle, (float)(this.shouldShow ? 45.0f : -135.0f), (float)15.0f);
        }

        public float getX(float partialTicks) {
            return (float)Math.cos(class_3532.method_16439((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * class_3532.field_15724 - 36.0f;
        }

        public float getY(float partialTicks) {
            return (float)Math.sin(class_3532.method_16439((float)partialTicks, (float)this.prevAngle, (float)this.angle) * ((float)Math.PI / 180)) * 36.0f * class_3532.field_15724 - 36.0f;
        }
    }

    private static class DreamCatcherText {
        private final class_2561 text;
        private final int speed;
        private int x;
        private final int y;

        public DreamCatcherText(class_2561 component, int speed, int x, int y) {
            this.text = component;
            this.speed = speed;
            this.x = x;
            this.y = y;
        }

        public class_2561 getText() {
            return this.text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void updatePosition() {
            this.x += this.speed;
        }
    }
}

