/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.animation;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7184;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class PlayerAnimator {
    public static final HashMap<AnimationTrigger, AnimationStateFunction> ANIMATIONS = new HashMap();
    public static boolean renderingFirstPersonPlayer = false;

    public static void register(AnimationTrigger trigger, AnimationStateFunction function) {
        ANIMATIONS.put(trigger, function);
    }

    public record PlayerAnimationState(class_7184 definition, class_7184 firstPersonDefinition, List<AnimationTransformer> transformers, boolean renderLeftArm, boolean renderRightArm, boolean resetLeftArmBeforeAnimation, boolean resetRightArmBeforeAnimation) {
        public class_7184 chooseDefinition() {
            return renderingFirstPersonPlayer ? this.firstPersonDefinition() : this.definition();
        }
    }

    public static interface AnimationTransformer {
        public boolean shouldApply(PlayerAnimationState var1, class_742 var2, class_591<?> var3);

        public void preAnimate(PlayerAnimationState var1, class_742 var2, class_591<?> var3);

        public void postAnimate(PlayerAnimationState var1, class_742 var2, class_591<?> var3);

        public Optional<class_630> modifyModelPart(PlayerAnimationState var1, class_742 var2, class_591<?> var3, String var4);

        public float modifyTicks(PlayerAnimationState var1, class_742 var2, class_591<?> var3, float var4);

        public float modifyScale(PlayerAnimationState var1, class_742 var2, class_591<?> var3, float var4);
    }

    public static class CastSpellHandAnimationTransformer
    extends UseItemHandAnimationTransformer {
        @Override
        public boolean shouldApply(PlayerAnimationState state, class_742 player, class_591<?> model) {
            return player instanceof SpellCaster && ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).offhand();
        }
    }

    public static class UseItemHandAnimationTransformer
    implements AnimationTransformer {
        private class_243 hatOriginalPos;
        private class_243 hatOriginalRot;
        private class_243 headOriginalPos;
        private class_243 headOriginalRot;
        private class_243 bodyOriginalPos;
        private class_243 bodyOriginalRot;
        private class_243 jacketOriginalPos;
        private class_243 jacketOriginalRot;
        private class_243 rightArmOriginalPos;
        private class_243 rightArmOriginalRot;
        private class_243 rightSleeveOriginalPos;
        private class_243 rightSleeveOriginalRot;
        private class_243 leftArmOriginalPos;
        private class_243 leftArmOriginalRot;
        private class_243 leftSleeveOriginalPos;
        private class_243 leftSleeveOriginalRot;
        private class_243 rightLegOriginalPos;
        private class_243 rightLegOriginalRot;
        private class_243 rightPantsOriginalPos;
        private class_243 rightPantsOriginalRot;
        private class_243 leftLegOriginalPos;
        private class_243 leftLegOriginalRot;
        private class_243 leftPantsOriginalPos;
        private class_243 leftPantsOriginalRot;

        @Override
        public boolean shouldApply(PlayerAnimationState state, class_742 player, class_591<?> model) {
            return player.method_6058() == class_1268.field_5810;
        }

        @Override
        public void preAnimate(PlayerAnimationState state, class_742 player, class_591<?> model) {
            this.hatOriginalPos = this.makeModelPartPos(model.field_3394);
            this.hatOriginalRot = this.makeModelPartRot(model.field_3394);
            this.headOriginalPos = this.makeModelPartPos(model.field_3398);
            this.headOriginalRot = this.makeModelPartRot(model.field_3398);
            this.bodyOriginalPos = this.makeModelPartPos(model.field_3391);
            this.bodyOriginalRot = this.makeModelPartRot(model.field_3391);
            this.jacketOriginalPos = this.makeModelPartPos(model.field_3483);
            this.jacketOriginalRot = this.makeModelPartRot(model.field_3483);
            this.rightArmOriginalPos = this.makeModelPartPos(model.field_3401);
            this.rightArmOriginalRot = this.makeModelPartRot(model.field_3401);
            this.rightSleeveOriginalPos = this.makeModelPartPos(model.field_3486);
            this.rightSleeveOriginalRot = this.makeModelPartRot(model.field_3486);
            this.leftArmOriginalPos = this.makeModelPartPos(model.field_27433);
            this.leftArmOriginalRot = this.makeModelPartRot(model.field_27433);
            this.leftSleeveOriginalPos = this.makeModelPartPos(model.field_3484);
            this.leftSleeveOriginalRot = this.makeModelPartRot(model.field_3484);
            this.rightLegOriginalPos = this.makeModelPartPos(model.field_3392);
            this.rightLegOriginalRot = this.makeModelPartRot(model.field_3392);
            this.rightPantsOriginalPos = this.makeModelPartPos(model.field_3479);
            this.rightPantsOriginalRot = this.makeModelPartRot(model.field_3479);
            this.leftLegOriginalPos = this.makeModelPartPos(model.field_3397);
            this.leftLegOriginalRot = this.makeModelPartRot(model.field_3397);
            this.leftPantsOriginalPos = this.makeModelPartPos(model.field_3482);
            this.leftPantsOriginalRot = this.makeModelPartRot(model.field_3482);
        }

        @Override
        public void postAnimate(PlayerAnimationState state, class_742 player, class_591<?> model) {
            this.transformModelPart(model.field_3394, this.hatOriginalPos, this.hatOriginalRot);
            this.transformModelPart(model.field_3398, this.headOriginalPos, this.headOriginalRot);
            this.transformModelPart(model.field_3391, this.bodyOriginalPos, this.bodyOriginalRot);
            this.transformModelPart(model.field_3483, this.jacketOriginalPos, this.jacketOriginalRot);
            this.transformModelPartLeftAndRight(model.field_27433, model.field_3401, this.leftArmOriginalPos, this.leftArmOriginalRot, this.rightArmOriginalPos, this.rightArmOriginalRot);
            this.transformModelPartLeftAndRight(model.field_3484, model.field_3486, this.leftSleeveOriginalPos, this.leftSleeveOriginalRot, this.rightSleeveOriginalPos, this.rightSleeveOriginalRot);
            this.transformModelPartLeftAndRight(model.field_3397, model.field_3392, this.leftLegOriginalPos, this.leftLegOriginalRot, this.rightLegOriginalPos, this.rightLegOriginalRot);
            this.transformModelPartLeftAndRight(model.field_3482, model.field_3479, this.leftPantsOriginalPos, this.leftPantsOriginalRot, this.rightPantsOriginalPos, this.rightPantsOriginalRot);
        }

        @Override
        public Optional<class_630> modifyModelPart(PlayerAnimationState state, class_742 player, class_591<?> model, String original) {
            switch (original) {
                case "hat": {
                    return Optional.of(model.field_3394);
                }
                case "head": {
                    return Optional.of(model.field_3398);
                }
                case "body": {
                    return Optional.of(model.field_3391);
                }
                case "jacket": {
                    return Optional.of(model.field_3483);
                }
                case "right_arm": {
                    return Optional.of(model.field_27433);
                }
                case "right_sleeve": {
                    return Optional.of(model.field_3484);
                }
                case "left_arm": {
                    return Optional.of(model.field_3401);
                }
                case "left_sleeve": {
                    return Optional.of(model.field_3486);
                }
                case "right_leg": {
                    return Optional.of(model.field_3397);
                }
                case "right_pants": {
                    return Optional.of(model.field_3482);
                }
                case "left_leg": {
                    return Optional.of(model.field_3392);
                }
                case "left_pants": {
                    return Optional.of(model.field_3479);
                }
            }
            return Optional.empty();
        }

        @Override
        public float modifyTicks(PlayerAnimationState state, class_742 player, class_591<?> model, float original) {
            return original;
        }

        @Override
        public float modifyScale(PlayerAnimationState state, class_742 player, class_591<?> model, float original) {
            return original;
        }

        private void transformModelPart(class_630 part, class_243 originalPos, class_243 originalRot) {
            part.field_3657 = (float)((double)part.field_3657 - 2.0 * ((double)part.field_3657 - originalPos.field_1352));
            part.field_3675 = (float)((double)part.field_3675 - 2.0 * ((double)part.field_3675 - originalRot.field_1351));
            part.field_3674 = (float)((double)part.field_3674 - 2.0 * ((double)part.field_3674 - originalRot.field_1350));
        }

        private void transformModelPartLeftAndRight(class_630 left, class_630 right, class_243 leftOriginalPos, class_243 leftOriginalRot, class_243 rightOriginalPos, class_243 rightOriginalRot) {
            this.transformModelPart(left, leftOriginalPos, leftOriginalRot);
            this.transformModelPart(right, rightOriginalPos, rightOriginalRot);
        }

        private class_243 makeModelPartPos(class_630 part) {
            return new class_243((double)part.field_3657, (double)part.field_3656, (double)part.field_3655);
        }

        private class_243 makeModelPartRot(class_630 part) {
            return new class_243((double)part.field_3654, (double)part.field_3675, (double)part.field_3674);
        }
    }

    public static class CopyOuterLayerAnimationTransformer
    implements AnimationTransformer {
        @Override
        public boolean shouldApply(PlayerAnimationState state, class_742 player, class_591<?> model) {
            return true;
        }

        @Override
        public void preAnimate(PlayerAnimationState state, class_742 player, class_591<?> model) {
        }

        @Override
        public void postAnimate(PlayerAnimationState state, class_742 player, class_591<?> model) {
            model.field_3394.method_17138(model.field_3398);
            model.field_3483.method_17138(model.field_3391);
            model.field_3484.method_17138(model.field_27433);
            model.field_3486.method_17138(model.field_3401);
            model.field_3482.method_17138(model.field_3397);
            model.field_3479.method_17138(model.field_3392);
        }

        @Override
        public Optional<class_630> modifyModelPart(PlayerAnimationState state, class_742 player, class_591<?> model, String original) {
            return Optional.empty();
        }

        @Override
        public float modifyTicks(PlayerAnimationState state, class_742 player, class_591<?> model, float original) {
            return original;
        }

        @Override
        public float modifyScale(PlayerAnimationState state, class_742 player, class_591<?> model, float original) {
            return original;
        }
    }

    public static interface AnimationStateFunction {
        public PlayerAnimationState get(class_742 var1);
    }

    public static interface AnimationTrigger {
        public boolean shouldPlay(class_742 var1);

        public float animateTicks(class_742 var1, float var2);
    }

    public record CastSpellAnimationTrigger(Supplier<? extends AbstractSpell> spellSupplier) implements AnimationTrigger
    {
        @Override
        public boolean shouldPlay(class_742 player) {
            return player instanceof SpellCaster && ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).hasSpell() && ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).spell() == this.spellSupplier.get();
        }

        @Override
        public float animateTicks(class_742 player, float ageInTicks) {
            if (player instanceof SpellCaster) {
                return Math.min((float)ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).spell().spellProperties().totalTicks(), (float)ESDataAttachments.SPELL_CAST_DATA.getData((class_1297)player).castTicks() + class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()));
            }
            return 0.0f;
        }
    }

    public record UseItemAnimationTrigger(Supplier<? extends class_1792> itemSupplier) implements AnimationTrigger
    {
        @Override
        public boolean shouldPlay(class_742 player) {
            return player.method_6115() && player.method_5998(player.method_6058()).method_31574(this.itemSupplier.get());
        }

        @Override
        public float animateTicks(class_742 player, float ageInTicks) {
            return Math.min((float)player.method_6030().method_7935((class_1309)player), (float)player.method_6048() + class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()));
        }
    }
}

