/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.effect;

import cn.leolezury.eternalstarlight.common.util.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class BoltEffect {
    private final Random random = new Random();
    private final BoltRenderInfo renderInfo;
    private final class_243 start;
    private final class_243 end;
    private final int segments;
    private int count = 1;
    private float size = 0.1f;
    private int lifespan = 30;
    private SpawnFunction spawnFunction = SpawnFunction.delay(60.0f);
    private FadeFunction fadeFunction = FadeFunction.fade(0.5f);

    public BoltEffect(class_243 start, class_243 end) {
        this(BoltRenderInfo.DEFAULT, start, end, (int)Math.sqrt(start.method_1022(end) * 100.0));
    }

    public BoltEffect(BoltRenderInfo info, class_243 start, class_243 end, int segments) {
        this.renderInfo = info;
        this.start = start;
        this.end = end;
        this.segments = segments;
    }

    public BoltEffect count(int count) {
        this.count = count;
        return this;
    }

    public BoltEffect size(float size) {
        this.size = size;
        return this;
    }

    public BoltEffect spawn(SpawnFunction spawnFunction) {
        this.spawnFunction = spawnFunction;
        return this;
    }

    public BoltEffect fade(FadeFunction fadeFunction) {
        this.fadeFunction = fadeFunction;
        return this;
    }

    public BoltEffect lifespan(int lifespan) {
        this.lifespan = lifespan;
        return this;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public SpawnFunction getSpawnFunction() {
        return this.spawnFunction;
    }

    public FadeFunction getFadeFunction() {
        return this.fadeFunction;
    }

    public Color getColor() {
        return this.renderInfo.color;
    }

    public List<BoltQuads> generate() {
        ArrayList<BoltQuads> quads = new ArrayList<BoltQuads>();
        class_243 diff = this.end.method_1020(this.start);
        float totalDistance = (float)diff.method_1033();
        block0: for (int i = 0; i < this.count; ++i) {
            LinkedList<BoltInstructions> drawQueue = new LinkedList<BoltInstructions>();
            drawQueue.add(new BoltInstructions(this.start, 0.0f, new class_243(0.0, 0.0, 0.0), null, false));
            while (!drawQueue.isEmpty()) {
                class_243 segmentEnd;
                BoltInstructions data = (BoltInstructions)drawQueue.poll();
                class_243 perpendicularDist = data.perpendicularDist;
                float progress = data.progress + 1.0f / (float)this.segments * (1.0f - this.renderInfo.parallelNoise + this.random.nextFloat() * this.renderInfo.parallelNoise * 2.0f);
                float segmentDiffScale = this.renderInfo.spreadFunction.getMaxSpread(progress);
                if (progress >= 1.0f && segmentDiffScale <= 0.0f) {
                    segmentEnd = this.end;
                } else {
                    float maxDiff = this.renderInfo.spreadFactor * segmentDiffScale * totalDistance;
                    class_243 randVec = BoltEffect.findRandomOrthogonalVector(diff, this.random);
                    double rand = this.renderInfo.randomFunction.getRandom(this.random);
                    perpendicularDist = this.renderInfo.segmentSpreader.getSegmentAdd(perpendicularDist, randVec, maxDiff, segmentDiffScale, progress, rand);
                    segmentEnd = this.start.method_1019(diff.method_1021((double)progress)).method_1019(perpendicularDist);
                }
                float boltSize = this.size * (0.5f + (1.0f - progress) * 0.5f);
                BoltQuadData quadData = this.createQuads(data.cache, data.start, segmentEnd, boltSize);
                quads.add(quadData.quads());
                if (progress >= 1.0f) continue block0;
                if (!data.isBranch) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), false));
                } else if (this.random.nextFloat() < this.renderInfo.branchContinuationFactor) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), true));
                }
                while (this.random.nextFloat() < this.renderInfo.branchInitiationFactor * (1.0f - progress)) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), true));
                }
            }
        }
        return quads;
    }

    private static class_243 findRandomOrthogonalVector(class_243 vec, Random rand) {
        class_243 newVec = new class_243(-0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
        return vec.method_1036(newVec).method_1029();
    }

    private BoltQuadData createQuads(QuadCache cache, class_243 startPos, class_243 end, float size) {
        class_243 diff = end.method_1020(startPos);
        class_243 rightAdd = diff.method_1036(new class_243(0.5, 0.5, 0.5)).method_1029().method_1021((double)size);
        class_243 backAdd = diff.method_1036(rightAdd).method_1029().method_1021((double)size);
        class_243 rightAddSplit = rightAdd.method_1021(0.5);
        class_243 start = cache == null ? startPos : cache.prevEnd;
        class_243 startRight = cache == null ? start.method_1019(rightAdd) : cache.prevEndRight;
        class_243 startBack = cache == null ? start.method_1019(rightAddSplit).method_1019(backAdd) : cache.prevEndBack;
        class_243 endRight = end.method_1019(rightAdd);
        class_243 endBack = end.method_1019(rightAddSplit).method_1019(backAdd);
        BoltQuads quads = new BoltQuads();
        quads.addQuad(start, end, endRight, startRight);
        quads.addQuad(startRight, endRight, end, start);
        quads.addQuad(startRight, endRight, endBack, startBack);
        quads.addQuad(startBack, endBack, endRight, startRight);
        return new BoltQuadData(quads, new QuadCache(end, endRight, endBack));
    }

    public static class BoltRenderInfo {
        public static final BoltRenderInfo DEFAULT = new BoltRenderInfo();
        public static final BoltRenderInfo ELECTRICITY = BoltRenderInfo.electricity();
        private float parallelNoise = 0.1f;
        private float spreadFactor = 0.1f;
        private float branchInitiationFactor = 0.0f;
        private float branchContinuationFactor = 0.0f;
        private Color color = Color.rgbad(0.45f, 0.45f, 0.5, 0.8f);
        private RandomFunction randomFunction = RandomFunction.GAUSSIAN;
        private SpreadFunction spreadFunction = SpreadFunction.SINE;
        private SegmentSpreader segmentSpreader = SegmentSpreader.NO_MEMORY;

        public static BoltRenderInfo electricity() {
            return new BoltRenderInfo().color(Color.rgbad(0.54f, 0.91f, 1.0, 0.8f)).noise(0.2f, 0.2f).branching(0.1f, 0.6f).spreader(SegmentSpreader.memory(0.9f));
        }

        public BoltRenderInfo noise(float parallelNoise, float spreadFactor) {
            this.parallelNoise = parallelNoise;
            this.spreadFactor = spreadFactor;
            return this;
        }

        public BoltRenderInfo branching(float branchInitiationFactor, float branchContinuationFactor) {
            this.branchInitiationFactor = branchInitiationFactor;
            this.branchContinuationFactor = branchContinuationFactor;
            return this;
        }

        public BoltRenderInfo spreader(SegmentSpreader segmentSpreader) {
            this.segmentSpreader = segmentSpreader;
            return this;
        }

        public BoltRenderInfo randomFunction(RandomFunction randomFunction) {
            this.randomFunction = randomFunction;
            return this;
        }

        public BoltRenderInfo spreadFunction(SpreadFunction spreadFunction) {
            this.spreadFunction = spreadFunction;
            return this;
        }

        public BoltRenderInfo color(Color color) {
            this.color = color;
            return this;
        }
    }

    public static interface SpawnFunction {
        public static final SpawnFunction NO_DELAY = rand -> new SpawnDelayBounds(0.0f, 0.0f);
        public static final SpawnFunction CONSECUTIVE = new SpawnFunction(){

            @Override
            public SpawnDelayBounds getSpawnDelayBounds(Random rand) {
                return new SpawnDelayBounds(0.0f, 0.0f);
            }

            @Override
            public boolean isConsecutive() {
                return true;
            }
        };

        public static SpawnFunction delay(float delay) {
            return rand -> new SpawnDelayBounds(delay, delay);
        }

        public static SpawnFunction noise(float delay, float noise) {
            return rand -> new SpawnDelayBounds(delay - noise, delay + noise);
        }

        public SpawnDelayBounds getSpawnDelayBounds(Random var1);

        default public float getSpawnDelay(Random rand) {
            SpawnDelayBounds bounds = this.getSpawnDelayBounds(rand);
            return class_3532.method_16439((float)rand.nextFloat(), (float)bounds.start(), (float)bounds.end());
        }

        default public boolean isConsecutive() {
            return false;
        }

        public record SpawnDelayBounds(float start, float end) {
        }
    }

    public static interface FadeFunction {
        public static final FadeFunction NONE = (totalBolts, lifeScale) -> new RenderBounds(0, totalBolts);

        public static FadeFunction fade(float fade) {
            return (totalBolts, lifeScale) -> {
                int start = lifeScale > 1.0f - fade ? (int)((float)totalBolts * (lifeScale - (1.0f - fade)) / fade) : 0;
                int end = lifeScale < fade ? (int)((float)totalBolts * (lifeScale / fade)) : totalBolts;
                return new RenderBounds(start, end);
            };
        }

        public RenderBounds getRenderBounds(int var1, float var2);

        public record RenderBounds(int start, int end) {
        }
    }

    protected record BoltInstructions(class_243 start, float progress, class_243 perpendicularDist, QuadCache cache, boolean isBranch) {
    }

    private record QuadCache(class_243 prevEnd, class_243 prevEndRight, class_243 prevEndBack) {
    }

    public static interface SpreadFunction {
        public static final SpreadFunction LINEAR_ASCENT = progress -> progress;
        public static final SpreadFunction LINEAR_ASCENT_DESCENT = progress -> (progress - Math.max(0.0f, 2.0f * progress - 1.0f)) / 0.5f;
        public static final SpreadFunction SINE = progress -> (float)Math.sin(Math.PI * (double)progress);

        public float getMaxSpread(float var1);
    }

    public static interface RandomFunction {
        public static final RandomFunction UNIFORM = Random::nextFloat;
        public static final RandomFunction GAUSSIAN = rand -> (float)rand.nextGaussian();

        public float getRandom(Random var1);
    }

    public static interface SegmentSpreader {
        public static final SegmentSpreader NO_MEMORY = (perpendicularDist, randVec, maxDiff, scale, progress, rand) -> randVec.method_1021((double)maxDiff * rand);

        public static SegmentSpreader memory(float memoryFactor) {
            return (perpendicularDist, randVec, maxDiff, spreadScale, progress, rand) -> {
                double nextDiff = (double)(maxDiff * (1.0f - memoryFactor)) * rand;
                class_243 cur = randVec.method_1021(nextDiff);
                double length = (perpendicularDist = perpendicularDist.method_1019(cur)).method_1033();
                if (length > (double)maxDiff) {
                    perpendicularDist = perpendicularDist.method_1021((double)maxDiff / length);
                }
                return perpendicularDist.method_1019(cur);
            };
        }

        public class_243 getSegmentAdd(class_243 var1, class_243 var2, float var3, float var4, float var5, double var6);
    }

    private record BoltQuadData(BoltQuads quads, QuadCache cache) {
    }

    public static class BoltQuads {
        private final List<class_243> vecs = new ArrayList<class_243>();

        protected void addQuad(class_243 ... quadVecs) {
            Collections.addAll(this.vecs, quadVecs);
        }

        public List<class_243> getVecs() {
            return this.vecs;
        }
    }
}

