/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.StarlightGolemModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemEyesLayer;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemGlowLayer;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemHalloweenLayer;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.util.Easing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class StarlightGolemRenderer<T extends StarlightGolem>
extends class_927<T, StarlightGolemModel<T>> {
    private static final class_2960 ENTITY_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem.png");
    private static final class_2960 CRACKED_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem_cracked.png");

    public StarlightGolemRenderer(class_5617.class_5618 context) {
        super(context, new StarlightGolemModel(context.method_32167(StarlightGolemModel.LAYER_LOCATION)), 0.5f);
        this.method_4046(new StarlightGolemHalloweenLayer(this, context.method_32170()));
        this.method_4046(new StarlightGolemGlowLayer(this, context.method_32170()));
        this.method_4046((class_3887)new StarlightGolemEyesLayer(this));
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        float deathProgress = class_3532.method_15363((float)(class_3532.method_16439((float)partialTicks, (float)((StarlightGolem)entity).oldDeathAnimationTime, (float)((StarlightGolem)entity).deathAnimationTime) / 110.0f), (float)0.0f, (float)1.0f);
        if (deathProgress > 0.0f) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, entity.method_17682() / 4.0f, 0.0f);
            poseStack.method_22905(deathProgress + class_3532.method_15362((float)(((float)((StarlightGolem)entity).field_6012 + partialTicks) * 4.0f)) * 0.2f * deathProgress, deathProgress + class_3532.method_15362((float)(((float)((StarlightGolem)entity).field_6012 + partialTicks) * 4.0f)) * 0.2f * deathProgress, deathProgress + class_3532.method_15362((float)(((float)((StarlightGolem)entity).field_6012 + partialTicks) * 4.0f)) * 0.2f * deathProgress);
            poseStack.method_22907(new Quaternionf((Quaternionfc)this.field_4676.method_24197()).rotateY((float)Math.PI));
            class_4587.class_4665 pose = poseStack.method_23760();
            class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_61046());
            for (int i = 0; i < 5; ++i) {
                vertexConsumer.method_56824(pose, 0.0f, 0.0f, 0.0f).method_39415(class_5253.class_5254.method_59554((float)Easing.IN_OUT_SINE.interpolate(deathProgress, 0.5f, 1.0f), (float)1.0f, (float)1.0f, (float)1.0f));
                float angle = (float)i * ((float)Math.PI * 2) / 5.0f + deathProgress * (float)Math.PI * 1.5f;
                vertexConsumer.method_56824(pose, class_3532.method_15374((float)angle) * entity.method_17682() * 3.0f, class_3532.method_15362((float)angle) * entity.method_17682() * 3.0f, 0.0f).method_39415(class_5253.class_5254.method_27764((int)0, (int)64, (int)106, (int)125));
                float largerAngle = angle + deathProgress * ((float)Math.PI * 2) / 8.0f;
                vertexConsumer.method_56824(pose, class_3532.method_15374((float)largerAngle) * entity.method_17682() * 3.0f, class_3532.method_15362((float)largerAngle) * entity.method_17682() * 3.0f, 0.0f).method_39415(class_5253.class_5254.method_27764((int)0, (int)64, (int)106, (int)125));
            }
            poseStack.method_22909();
        }
        super.method_4054(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected float getFlipDegrees(T entity) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(T entity, float partialTicks) {
        float deathProgress = class_3532.method_16439((float)partialTicks, (float)((StarlightGolem)entity).oldDeathAnimationTime, (float)((StarlightGolem)entity).deathAnimationTime) / 100.0f;
        if (deathProgress <= 0.0f) {
            return 0.0f;
        }
        return (int)((double)deathProgress * 45.0) % 2 == 0 ? 0.0f : class_3532.method_15363((float)deathProgress, (float)0.2f, (float)1.0f);
    }

    public class_2960 getTextureLocation(T entity) {
        return ((ESBoss)entity).getPhase() == 0 ? ENTITY_TEXTURE : CRACKED_TEXTURE;
    }

    public boolean shouldRender(T entity, class_4604 frustum, double x, double y, double z) {
        boolean oCull = ((StarlightGolem)entity).field_5985;
        if (((ESBoss)entity).getBehaviorState() == 5) {
            ((StarlightGolem)entity).field_5985 = true;
        }
        boolean shouldRender = super.method_3933(entity, frustum, x, y, z);
        ((StarlightGolem)entity).field_5985 = oCull;
        return shouldRender;
    }
}

