/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.entity.projectile.EnergySpark;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8946;

public class StarlightGolemSmashPhase
extends BehaviorPhase<StarlightGolem> {
    public static final int ID = 3;
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{15, 20, 25, 30, 35, 40}));
    private class_2338 shockwavePos = class_2338.field_10980;
    private float pitch;
    private float yaw;
    private final List<class_2338> visited = new ArrayList<class_2338>();
    private final List<class_2338> lavaVisited = new ArrayList<class_2338>();

    public StarlightGolemSmashPhase() {
        super(3, 2, 70, 250);
    }

    @Override
    public boolean canStart(StarlightGolem entity, boolean cooldownOver) {
        return (cooldownOver || entity.getPhase() == 1 && entity.method_24828() && entity.getBehaviorManager().getCooldowns().getOrDefault(3, 0) < 150) && entity.method_5968() != null && (entity.getPhase() == 1 || entity.getAttackEnergy() >= 0);
    }

    @Override
    public void onStart(StarlightGolem entity) {
        entity.setAttackEnergy(Math.max(entity.getAttackEnergy() - 16, 0));
        this.visited.clear();
        this.lavaVisited.clear();
    }

    @Override
    public void tick(StarlightGolem entity) {
        class_1937 i3;
        class_1309 target = entity.method_5968();
        if (entity.getBehaviorTicks() == 30) {
            this.pitch = target != null ? ESMathUtil.positionToPitch(entity.method_19538(), target.method_19538()) : 0.0f;
            this.yaw = entity.method_5791() + 90.0f;
            if (target != null) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    EnergySpark spark = new EnergySpark(entity.method_37908(), (class_1309)entity);
                    spark.method_33574(entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 3.0f), 0.0));
                    spark.setTarget(target);
                    class_243 movement = ESMathUtil.rotationToPosition(1.0f, this.pitch, this.yaw - 30.0f + (float)(15 * i2));
                    spark.method_7485(movement.field_1352, movement.field_1351, movement.field_1350, 0.1f, 0.0f);
                    entity.method_37908().method_8649((class_1297)spark);
                }
            }
            this.shockwavePos = entity.method_24515();
        }
        if (entity.getBehaviorTicks() == 37 && entity.getPhase() == 1 && target != null) {
            Iterator i2 = class_156.method_43027(ALLOWED_ANGLES, (class_5819)entity.method_59922()).iterator();
            while (i2.hasNext()) {
                int i3 = (Integer)i2.next();
                Optional optional = class_8946.method_54990((class_1308)entity, (class_243)ESMathUtil.rotationToPosition(entity.method_19538(), 1.0f, this.pitch, this.yaw), (float)0.75f, (int)i3, (boolean)false);
                if (!optional.isPresent()) continue;
                entity.field_6037 = true;
                entity.method_45319((class_243)optional.get());
            }
        }
        if (entity.getBehaviorTicks() == 40 && (i3 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)i3;
            ScreenShakeVfx.createInstance((class_5321<class_1937>)entity.method_37908().method_27983(), entity.method_19538(), 40.0f, 50, 0.24f, 0.5f, 3.0f, 5.5f).send(serverLevel);
        }
        if (entity.getBehaviorTicks() >= 30) {
            entity.method_5702(class_2183.class_2184.field_9851, ESMathUtil.rotationToPosition(entity.method_19538(), entity.method_17681() * 10.0f, this.pitch, this.yaw));
        }
        if (entity.getBehaviorTicks() >= 40) {
            int radius = (int)(((float)entity.getBehaviorTicks() - 30.0f) / 3.0f);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        class_2338 pos = this.shockwavePos.method_10069(x, y, z);
                        if (entity.method_37908().method_8320(pos).method_27852(class_2246.field_10164)) {
                            if (this.lavaVisited.contains(pos)) continue;
                            this.lavaVisited.add(pos);
                            if (entity.method_59922().method_43048(25) != 0 || !ESPlatform.INSTANCE.postEntityDestroyBlockEvent(entity.method_37908(), pos, (class_1297)entity)) continue;
                            entity.method_37908().method_8501(pos, class_2246.field_10092.method_9564());
                            if (entity.method_37908().field_9236) continue;
                            ((class_3218)entity.method_37908()).method_14199((class_2394)ESExplosionParticleOptions.LAVA, pos.method_46558().field_1352, pos.method_46558().field_1351 + 0.6, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        float blockPitch = ESMathUtil.positionToPitch(this.shockwavePos.method_61082(), pos.method_46558());
                        float blockYaw = ESMathUtil.positionToYaw(this.shockwavePos.method_61082(), pos.method_46558());
                        if (this.visited.contains(pos) || entity.method_37908().method_8320(pos).method_26215() || !(Math.abs(class_3532.method_15393((float)(this.pitch - blockPitch))) < 75.0f) || !(Math.abs(class_3532.method_15393((float)(this.yaw - blockYaw))) < 30.0f) || !(pos.method_46558().method_1022(this.shockwavePos.method_61082()) <= (double)radius) || !(pos.method_46558().method_1022(this.shockwavePos.method_61082()) >= (double)(radius - 1))) continue;
                        boolean above = entity.method_37908().method_8320(pos.method_10084()).method_26215();
                        boolean below = entity.method_37908().method_8320(pos.method_10074()).method_26215();
                        if (!above && !below) continue;
                        this.visited.add(pos);
                        boolean flag = true;
                        if (!above) {
                            boolean bl = flag = entity.method_59922().method_43048(6) == 0;
                        }
                        if (!flag) continue;
                        ESFallingBlock fallingBlock = new ESFallingBlock(entity.method_37908(), (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f, entity.method_37908().method_8320(pos), 100);
                        fallingBlock.method_5762(0.0, (double)(above ? 1 : -1) * entity.method_59922().method_43058() / 6.0 + 0.25, 0.0);
                        entity.method_37908().method_8649((class_1297)fallingBlock);
                        for (class_1309 living : entity.method_37908().method_18467(class_1309.class, new class_238(pos).method_1014(1.0))) {
                            if (living == entity) continue;
                            living.method_5643(ESDamageTypes.getDamageSource(entity.method_37908(), ESDamageTypes.GROUND_SMASH), 4.0f);
                        }
                        if (entity.method_37908().field_9236) continue;
                        ((class_3218)entity.method_37908()).method_14199((class_2394)ESExplosionParticleOptions.ENERGY, pos.method_46558().field_1352, pos.method_46558().field_1351, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                        if (entity.method_59922().method_43048(5) != 0) continue;
                        ((class_3218)entity.method_37908()).method_14199((class_2394)class_2398.field_17430, pos.method_46558().field_1352, pos.method_46558().field_1351 + 0.5, pos.method_46558().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(StarlightGolem entity) {
        return true;
    }

    @Override
    public void onStop(StarlightGolem entity) {
    }
}

