/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityBitePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityDigPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityEmergePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySneakPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySoulPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrositySporePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityStunPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityThornPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosityToxicBreathPhase;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class LunarMonstrosity
extends ESBoss
implements RayAttackUser {
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.method_5667(), class_1259.class_1260.field_5783, false);
    private final BehaviorManager<LunarMonstrosity> behaviorManager = new BehaviorManager<LunarMonstrosity>(this, List.of(new LunarMonstrosityToxicBreathPhase(), new LunarMonstrositySporePhase(), new LunarMonstrosityThornPhase(), new LunarMonstrosityBitePhase(), new LunarMonstrosityDigPhase(), new LunarMonstrositySneakPhase(), new LunarMonstrosityEmergePhase(), new LunarMonstrositySoulPhase(), new LunarMonstrosityStunPhase()));
    public class_7094 toxicBreathAnimationState = new class_7094();
    public class_7094 sporeAnimationState = new class_7094();
    public class_7094 thornAnimationState = new class_7094();
    public class_7094 biteAnimationState = new class_7094();
    public class_7094 digAnimationState = new class_7094();
    public class_7094 sneakAnimationState = new class_7094();
    public class_7094 emergeAnimationState = new class_7094();
    public class_7094 switchPhaseAnimationState = new class_7094();
    public class_7094 deathAnimationState = new class_7094();
    public class_243 headPos = class_243.field_1353;
    public int fleeFromLavaCooldown = 0;

    public LunarMonstrosity(class_1299<? extends LunarMonstrosity> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.bossEvent.setId(this.method_5667());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LunarMonstrosityMeleeAttackGoal((class_1314)this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new MonstrosityLookAtTargetGoal());
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{LunarMonstrosity.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    @Override
    public boolean isRayFollowingHeadRotation() {
        return false;
    }

    @Override
    public class_243 getRayRotationTarget() {
        return this.method_5968() == null ? this.method_19538().method_1031((double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f)), (double)(this.method_17682() * this.method_59922().method_43057()), (double)(this.method_17681() * (this.method_59922().method_43057() - 0.5f))) : this.method_5968().method_19538().method_1031((double)(this.method_5968().method_17681() * (this.method_59922().method_43057() - 0.5f)), (double)(this.method_5968().method_17682() * this.method_59922().method_43057()), (double)(this.method_5968().method_17681() * (this.method_59922().method_43057() - 0.5f)));
    }

    @Override
    public void updateRayEnd(class_243 endPos) {
        this.method_5702(class_2183.class_2184.field_9851, endPos);
    }

    public static class_5132.class_5133 createAttributes() {
        return LunarMonstrosity.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.armor()).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.followRange()).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_6108() {
        if (this.field_6213 == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.method_41322(this.field_6012);
            this.setBehaviorState(0);
        }
        ++this.field_6213;
        if (this.field_6213 == 75 && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void stopAllAnimStates() {
        this.toxicBreathAnimationState.method_41325();
        this.sporeAnimationState.method_41325();
        this.thornAnimationState.method_41325();
        this.biteAnimationState.method_41325();
        this.digAnimationState.method_41325();
        this.sneakAnimationState.method_41325();
        this.emergeAnimationState.method_41325();
        this.switchPhaseAnimationState.method_41325();
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    this.toxicBreathAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 2: {
                    this.sporeAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 3: {
                    this.thornAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 4: {
                    this.biteAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 5: {
                    this.digAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 6: {
                    this.sneakAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 7: {
                    this.emergeAnimationState.method_41322(this.field_6012);
                    break;
                }
                case 8: {
                    this.switchPhaseAnimationState.method_41322(this.field_6012);
                }
            }
        }
        super.method_5674(accessor);
    }

    protected void method_6060(class_1309 blocker) {
        if (this.getBehaviorState() == 4 && blocker == this.method_5968()) {
            this.setBehaviorState(-1);
        }
        super.method_6060(blocker);
    }

    public boolean method_6121(class_1297 target) {
        if (this.getBehaviorState() == 6) {
            this.setBehaviorState(7);
            this.setBehaviorTicks(0);
        }
        return super.method_6121(target);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!source.method_48789(class_8103.field_42242) && (this.getBehaviorState() == 6 || source.method_5529() != null && source.method_5529().method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS))) {
            return false;
        }
        if (this.getPhase() == 0 && (double)(this.method_6032() / this.method_6063()) < 0.5) {
            this.setPhase(1);
            this.setBehaviorState(8);
            this.setBehaviorTicks(0);
        }
        if (source.method_5529() != null && this.method_5968() != null && this.getBehaviorState() == 4 && source.method_5529() == this.method_5968() && amount >= 6.0f) {
            this.setBehaviorState(-1);
            this.setBehaviorTicks(0);
        }
        float actualAmount = source.method_48789(class_8103.field_42242) || this.method_5809() || this.method_6059(ESMobEffects.STARFIRE.asHolder()) || this.getBehaviorState() == -1 ? amount : Math.min(3.0f, amount);
        boolean success = super.method_5643(source, actualAmount);
        if (this.getPhase() == 0 && (double)(this.method_6032() / this.method_6063()) < 0.5) {
            this.setPhase(1);
            this.setBehaviorState(8);
            this.setBehaviorTicks(0);
        }
        return success;
    }

    public boolean method_37222(class_1293 instance, @Nullable class_1297 entity) {
        if (instance.method_5579().method_55838(class_1294.field_5899)) {
            return false;
        }
        return super.method_37222(instance, entity);
    }

    public boolean method_5722(class_1297 entity) {
        return super.method_5722(entity) || entity.method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(ESTags.Items.LUNAR_MONSTROSITY_IGNITERS)) {
            class_3414 soundEvent = itemStack.method_7963() ? class_3417.field_15145 : class_3417.field_15013;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.method_20803(Math.max(this.method_20802(), this.getPhase() == 0 ? 100 : 20));
                if (!itemStack.method_7963()) {
                    itemStack.method_57008(1, (class_1309)player);
                } else {
                    itemStack.method_7970(1, (class_1309)player, LunarMonstrosity.method_56079((class_1268)hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.getBehaviorState() == 6 ? super.method_55694(pose).method_18383(0.1f) : super.method_55694(pose);
    }

    public class_238 getNormalStateBoundingBox() {
        return super.method_55694(this.method_18376()).method_30757(this.method_19538());
    }

    public boolean method_5862() {
        return this.getBehaviorState() != 6 && super.method_5862();
    }

    @Override
    public class_3414 getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_LUNAR_MONSTROSITY.get();
    }

    public boolean canBite() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return false;
        }
        for (class_1309 livingEntity : this.method_37908().method_18466(class_1309.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1014(3.0))) {
            class_243 vec3 = livingEntity.method_19538().method_1035(this.method_19538()).method_1029();
            vec3 = new class_243(vec3.field_1352, 0.0, vec3.field_1350);
            if (!(vec3.method_1026(this.method_5828(1.0f)) < 0.0) || target != livingEntity) continue;
            return true;
        }
        return false;
    }

    public void doBiteDamage(float damage) {
        for (class_1309 livingEntity : this.method_37908().method_18466(class_1309.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1014(3.0))) {
            class_243 vec3 = livingEntity.method_19538().method_1035(this.method_19538()).method_1029();
            vec3 = new class_243(vec3.field_1352, 0.0, vec3.field_1350);
            if (!(vec3.method_1026(this.method_5828(1.0f)) < 0.0)) continue;
            livingEntity.method_5643(ESDamageTypes.getEntityDamageSource(this.method_37908(), ESDamageTypes.BITE, (class_1297)this), damage);
        }
    }

    public void knockbackNearbyEntities(float radius, float strength, boolean damage) {
        for (class_1309 living : this.method_37908().method_18466(class_1309.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1009((double)radius, 0.0, (double)radius))) {
            if (living.method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS)) continue;
            class_243 motion = living.method_19538().method_1020(this.method_19538()).method_1029().method_1021((double)strength);
            living.field_6037 = true;
            living.method_18799(living.method_18798().method_1019(motion));
            if (!damage) continue;
            living.method_5643(this.method_48923().method_48812((class_1309)this), strength * 3.0f);
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.LUNAR, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.2, 0.0));
        }
    }

    public boolean method_5659(class_1927 explosion) {
        class_1309 cause = explosion.method_8347();
        return cause != null && cause.method_5864().method_20210(ESTags.EntityTypes.LUNAR_MONSTROSITY_ALLYS);
    }

    public void method_6007() {
        super.method_6007();
        this.bossEvent.update();
        this.method_18382();
        if (!this.method_37908().field_9236) {
            if (this.method_5968() != null && !this.method_5968().method_5805()) {
                this.method_5980(null);
            }
            if (!this.method_5987() && this.method_5805()) {
                this.behaviorManager.tick();
            }
            if (this.getBehaviorState() != 6) {
                this.method_5942().method_6340();
            }
            if (this.fleeFromLavaCooldown > 0) {
                --this.fleeFromLavaCooldown;
            }
        } else {
            this.method_37908().method_8406((class_2394)ESSmokeParticleOptions.LUNAR_SHORT, this.method_23317() + (this.method_59922().method_43058() - 0.5) * 3.0, this.method_23318() + 1.0 + (this.method_59922().method_43058() - 0.5) * 3.0, this.method_23321() + (this.method_59922().method_43058() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            if (this.field_6213 <= 0) {
                if (this.getBehaviorState() == 6) {
                    class_5819 randomsource = this.method_59922();
                    class_2680 blockstate = this.method_25936();
                    if (blockstate.method_26217() != class_2464.field_11455) {
                        for (int i = 0; i < 30; ++i) {
                            double d0 = this.method_23317() + (double)class_3532.method_32750((class_5819)randomsource, (float)-0.7f, (float)0.7f);
                            double d1 = this.method_23318();
                            double d2 = this.method_23321() + (double)class_3532.method_32750((class_5819)randomsource, (float)-0.7f, (float)0.7f);
                            this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (this.getBehaviorState() == -1 && this.headPos.method_1022(this.method_19538()) < (double)(this.method_17682() * 2.0f)) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11205, this.headPos.field_1352 + this.method_59922().method_43058() - 0.5, this.headPos.field_1351, this.headPos.field_1350 + this.method_59922().method_43058() - 0.5, this.method_59922().method_43058() / 10.0, 0.8, this.method_59922().method_43058() / 10.0);
                }
            }
        }
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.LUNAR_MONSTROSITY_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.LUNAR_MONSTROSITY_DEATH.get();
    }

    private static class LunarMonstrosityMeleeAttackGoal
    extends class_1366 {
        private LunarMonstrosityMeleeAttackGoal(class_1314 mob, double speed, boolean followingTargetEvenIfNotSeen) {
            super(mob, speed, followingTargetEvenIfNotSeen);
        }

        public boolean method_6264() {
            boolean canUse = true;
            class_1314 class_13142 = this.field_6503;
            if (class_13142 instanceof LunarMonstrosity) {
                LunarMonstrosity boss = (LunarMonstrosity)class_13142;
                canUse = boss.getBehaviorState() == 6;
            }
            return super.method_6264() && canUse;
        }

        public boolean method_6266() {
            boolean canUse = true;
            class_1314 class_13142 = this.field_6503;
            if (class_13142 instanceof LunarMonstrosity) {
                LunarMonstrosity boss = (LunarMonstrosity)class_13142;
                canUse = boss.getBehaviorState() == 6;
            }
            return super.method_6266() && canUse;
        }
    }

    private class MonstrosityLookAtTargetGoal
    extends LookAtTargetGoal {
        public MonstrosityLookAtTargetGoal() {
            super((class_1308)LunarMonstrosity.this);
        }

        @Override
        public void method_6268() {
            if (LunarMonstrosity.this.getBehaviorState() != 1) {
                super.method_6268();
            }
        }
    }
}

