/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.phase;

import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;

public class BehaviorManager<T extends class_1309> {
    private final T entity;
    private final List<BehaviorPhase<T>> phaseList = new ArrayList<BehaviorPhase<T>>();
    private final Int2ObjectArrayMap<List<BehaviorPhase<T>>> phases = new Int2ObjectArrayMap();
    private final IntArrayList priorities = new IntArrayList();
    private final Int2IntArrayMap cooldowns = new Int2IntArrayMap();

    public Int2IntArrayMap getCooldowns() {
        return this.cooldowns;
    }

    public BehaviorManager(T entity, List<BehaviorPhase<T>> phaseList) {
        this.entity = entity;
        this.phaseList.addAll(phaseList);
        for (BehaviorPhase<T> phase : phaseList) {
            if (!this.phases.containsKey(phase.getPriority())) {
                this.phases.put(phase.getPriority(), new ArrayList());
            }
            if (!this.priorities.contains(phase.getPriority())) {
                this.priorities.add(phase.getPriority());
            }
            ((List)this.phases.get(phase.getPriority())).add(phase);
        }
        this.priorities.sort((i1, i2) -> i1 - i2);
    }

    public void tick() {
        if (((MultiBehaviorUser)this.entity).getBehaviorState() == 0) {
            this.selectPhase().ifPresent(p -> {
                p.start(this.entity);
                this.cooldowns.put(p.getId(), p.getCooldown());
            });
        } else {
            this.getActivePhase().ifPresent(p -> {
                if (!this.canContinue((BehaviorPhase<T>)p)) {
                    p.stop(this.entity, this.phaseList);
                } else {
                    p.tick(this.entity);
                    ((MultiBehaviorUser)this.entity).setBehaviorTicks(((MultiBehaviorUser)this.entity).getBehaviorTicks() + 1);
                }
            });
        }
        IntIterator intIterator = this.cooldowns.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            this.cooldowns.put(id, Math.max(0, this.cooldowns.get(id) - 1));
        }
    }

    private Optional<BehaviorPhase<T>> selectPhase() {
        IntListIterator intListIterator = this.priorities.iterator();
        while (intListIterator.hasNext()) {
            int priority = (Integer)intListIterator.next();
            List<BehaviorPhase> phasesForPriority = ((List)this.phases.get(priority)).stream().filter(p -> p.canStart(this.entity, this.cooldowns.getOrDefault(p.getId(), 0) <= 0)).toList();
            if (phasesForPriority.isEmpty()) continue;
            return Optional.ofNullable(phasesForPriority.get(this.entity.method_59922().method_43048(phasesForPriority.size())));
        }
        return Optional.empty();
    }

    private Optional<BehaviorPhase<T>> getActivePhase() {
        return this.phaseList.stream().filter(p -> ((MultiBehaviorUser)this.entity).getBehaviorState() == p.getId()).findFirst();
    }

    private boolean canContinue(BehaviorPhase<T> phase) {
        return phase.canContinue(this.entity) && ((MultiBehaviorUser)this.entity).getBehaviorTicks() <= phase.getDuration();
    }
}

