/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class AetherstrikeRocketEntity
extends class_1676
implements class_3856 {
    private final String TAG_LIFE = "life";
    private final String TAG_LIFETIME = "lifetime";
    private final String TAG_ITEM = "item";
    private final String TAG_SHOT_AT_ANGLE = "shot_at_angle";
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(AetherstrikeRocketEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> SHOT_AT_ANGLE = class_2945.method_12791(AetherstrikeRocketEntity.class, (class_2941)class_2943.field_13323);
    private int life;
    private int lifetime;

    public AetherstrikeRocketEntity(class_1299<? extends AetherstrikeRocketEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public AetherstrikeRocketEntity(class_1937 level, double x, double y, double z, class_1799 stack) {
        super(ESEntities.AETHERSTRIKE_ROCKET.get(), level);
        this.life = 0;
        this.method_5814(x, y, z);
        this.field_6011.method_12778(ITEM, (Object)stack.method_7972());
        this.method_18800(this.field_5974.method_43385(0.0, 0.002297), 0.05, this.field_5974.method_43385(0.0, 0.002297));
        this.lifetime = 25 + this.field_5974.method_43048(6) + this.field_5974.method_43048(7);
    }

    public AetherstrikeRocketEntity(class_1937 level, @Nullable class_1297 shooter, double x, double y, double z, class_1799 stack) {
        this(level, x, y, z, stack);
        this.method_7432(shooter);
    }

    public AetherstrikeRocketEntity(class_1937 level, class_1799 stack, double x, double y, double z, boolean shotAtAngle) {
        this(level, x, y, z, stack);
        this.field_6011.method_12778(SHOT_AT_ANGLE, (Object)shotAtAngle);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ITEM, (Object)AetherstrikeRocketEntity.getDefaultItem()).method_56912(SHOT_AT_ANGLE, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.isShotAtAngle()) {
            double horizontal = this.field_5976 ? 1.0 : 1.15;
            this.method_18799(this.method_18798().method_18805(horizontal, 1.0, horizontal).method_1031(0.0, 0.04, 0.0));
        }
        class_243 movement = this.method_18798();
        this.method_5784(class_1313.field_6308, movement);
        this.method_18799(movement);
        class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        if (!this.field_5960) {
            this.method_59860(hitResult);
            this.field_6007 = true;
        }
        this.method_26962();
        if (this.life == 0 && !this.method_5701()) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14702, class_3419.field_15256, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.method_37908().field_9236 && this.life % 2 == 0) {
            this.method_37908().method_8406((class_2394)ESExplosionParticleOptions.AETHERSENT, this.method_23317() - movement.field_1352, this.method_23318() - movement.field_1351, this.method_23321() - movement.field_1350, this.field_5974.method_43059() * 0.05, -this.method_18798().field_1351 * 0.5, this.field_5974.method_43059() * 0.05);
        }
        if (!this.method_37908().field_9236 && this.life > this.lifetime) {
            this.explode();
        }
    }

    private void explode() {
        class_3218 serverLevel;
        this.method_32875((class_6880)class_5712.field_28178, this.method_24921());
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15188, class_3419.field_15256, 25.0f, 0.95f + this.field_5974.method_43057() * 0.1f);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_27983().method_29177().equals((Object)ESDimensions.STARLIGHT_KEY.method_29177())) {
            int i;
            for (i = 0; i < 4; ++i) {
                class_243 vec3 = this.method_19538().method_49272(this.method_59922(), 1.5f);
                for (int s = 0; s < serverLevel.method_18456().size(); ++s) {
                    class_3222 serverPlayer = (class_3222)serverLevel.method_18456().get(s);
                    serverLevel.method_14166(serverPlayer, (class_2394)ESExplosionParticleOptions.AETHERSENT, true, vec3.field_1352, vec3.field_1351, vec3.field_1350, 3, 0.0, 0.0, 0.0, 0.0);
                }
            }
            for (i = 0; i < 30; ++i) {
                class_243 speed = new class_243((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)).method_1029();
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.method_33571().field_1352 + speed.field_1352 * 1.2, this.method_33571().field_1351 + speed.field_1351 * 1.2, this.method_33571().field_1350 + speed.field_1350 * 1.2, speed.field_1352, speed.field_1351, speed.field_1350));
            }
            if ((double)this.method_59922().method_43057() < 0.6 && this.method_37908().method_8311(this.method_24515())) {
                ESWeatherUtil.getOrCreateWeathers(serverLevel).setActiveWeather(ESWeathers.METEOR_SHOWER.get(), ESWeathers.METEOR_SHOWER.get().weatherProperties().duration().method_35008(serverLevel.method_8409()));
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    player.method_7357().method_7906(this.method_7495().method_7909(), 2400);
                }
            }
        }
        this.method_31472();
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        if (!this.method_37908().field_9236) {
            this.explode();
        }
    }

    protected void method_24920(class_3965 result) {
        class_2338 blockpos = new class_2338((class_2382)result.method_17777());
        this.method_37908().method_8320(blockpos).method_26178(this.method_37908(), blockpos, (class_1297)this);
        if (!this.method_37908().method_8608()) {
            this.explode();
        }
        super.method_24920(result);
    }

    public boolean isShotAtAngle() {
        return (Boolean)this.field_6011.method_12789(SHOT_AT_ANGLE);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("life", this.life);
        compound.method_10569("lifetime", this.lifetime);
        compound.method_10566("item", this.method_7495().method_57358((class_7225.class_7874)this.method_56673()));
        compound.method_10556("shot_at_angle", ((Boolean)this.field_6011.method_12789(SHOT_AT_ANGLE)).booleanValue());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.life = compound.method_10550("life");
        this.lifetime = compound.method_10550("lifetime");
        if (compound.method_10573("item", 10)) {
            this.field_6011.method_12778(ITEM, (Object)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compound.method_10562("item")).orElseGet(AetherstrikeRocketEntity::getDefaultItem));
        } else {
            this.field_6011.method_12778(ITEM, (Object)AetherstrikeRocketEntity.getDefaultItem());
        }
        if (compound.method_10545("shot_at_angle")) {
            this.field_6011.method_12778(SHOT_AT_ANGLE, (Object)compound.method_10577("shot_at_angle"));
        }
    }

    public class_1799 method_7495() {
        return (class_1799)this.field_6011.method_12789(ITEM);
    }

    public boolean method_5732() {
        return false;
    }

    private static class_1799 getDefaultItem() {
        return new class_1799((class_1935)ESItems.AETHERSTRIKE_ROCKET.get());
    }
}

