/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.joml.Vector4f;

public class BallLightning
extends class_1682
implements TrailOwner {
    private static final class_2960 TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    protected static final class_2940<Integer> SPAWNED_TICKS = class_2945.method_12791(BallLightning.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> TARGET_ID = class_2945.method_12791(BallLightning.class, (class_2941)class_2943.field_13327);
    private class_1297 target;
    private UUID targetId;

    public int getSpawnedTicks() {
        return (Integer)this.method_5841().method_12789(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.method_5841().method_12778(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    public void setTargetId(int targetId) {
        this.method_5841().method_12778(TARGET_ID, (Object)targetId);
    }

    public int getTargetId() {
        return (Integer)this.method_5841().method_12789(TARGET_ID);
    }

    public BallLightning(class_1299<? extends BallLightning> entityType, class_1937 level) {
        super(entityType, level);
    }

    public BallLightning(class_1937 level, class_1309 livingEntity) {
        super(ESEntities.BALL_LIGHTNING.get(), livingEntity, level);
    }

    public BallLightning(class_1937 level, double x, double y, double z) {
        super(ESEntities.BALL_LIGHTNING.get(), x, y, z, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SPAWNED_TICKS, (Object)0).method_56912(TARGET_ID, (Object)-1);
    }

    public class_1297 getTarget() {
        return this.target;
    }

    public void setTarget(class_1297 target) {
        this.targetId = target.method_5667();
        this.target = target;
        if (!this.method_37908().field_9236) {
            this.setTargetId(target.method_5628());
        }
    }

    public void method_5773() {
        class_243 movement = this.method_18798();
        super.method_5773();
        this.method_18799(this.method_18798().method_1029().method_1021(movement.method_1033()));
        if (!this.method_37908().field_9236) {
            Object object;
            class_1297 owner = this.method_24921();
            if (owner != null && owner.method_5739((class_1297)this) > 32.0f) {
                this.explodeAndDiscard();
                this.method_31472();
            }
            if (this.target != null && this.target.method_5739((class_1297)this) > 16.0f) {
                this.target = null;
                this.targetId = null;
            }
            if (this.target == null && this.targetId != null && (object = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)object;
                class_1297 entity = serverLevel.method_14190(this.targetId);
                if (entity != null) {
                    this.target = entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target != null) {
                this.setTargetId(this.target.method_5628());
                ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((class_1936)this.method_37908(), class_3726.method_16195((class_1297)this), this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0), this.target.method_19538().method_1031(0.0, (double)(this.target.method_17682() / 2.0f), 0.0));
                for (class_1297 entity : result.entities()) {
                    if (!(entity instanceof class_1309) || !ESEntityUtil.shouldHarm(this.method_24921(), entity) || !entity.method_5643(ESDamageTypes.getIndirectEntityDamageSource(this.method_37908(), ESDamageTypes.ELECTRIC_SHOCK, (class_1297)this, this.method_24921()), 8.0f)) continue;
                    entity.method_5639(2.0f);
                }
            }
            if (this.getSpawnedTicks() > 600) {
                this.explodeAndDiscard();
                this.method_31472();
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
        } else {
            this.field_5985 = true;
        }
    }

    public boolean method_5727(double x, double y, double z) {
        return this.method_5640(this.method_5649(x, y, z) / 16.0);
    }

    protected void method_56990() {
    }

    protected void method_24920(class_3965 hitResult) {
        super.method_24920(hitResult);
        switch (hitResult.method_17780().method_10166()) {
            case field_11048: {
                this.method_18799(this.method_18798().method_18805(-1.0, 1.0, 1.0));
                break;
            }
            case field_11052: {
                this.method_18799(this.method_18798().method_18805(1.0, -1.0, 1.0));
                break;
            }
            case field_11051: {
                this.method_18799(this.method_18798().method_18805(1.0, 1.0, -1.0));
            }
        }
    }

    private void explodeAndDiscard() {
        this.method_43077((class_3414)class_3417.field_15152.comp_349());
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)ESExplosionParticleOptions.ENERGY, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), 20, (double)(this.method_17681() / 2.0f), (double)(this.method_17682() / 2.0f), (double)(this.method_17681() / 2.0f), 0.0);
            for (int i = 0; i < 20; ++i) {
                class_243 speed = new class_243((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)).method_1029();
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.ENERGY, this.method_19538().field_1352 + speed.field_1352 * 1.2, this.method_19538().field_1351 + speed.field_1351 * 1.2, this.method_19538().field_1350 + speed.field_1350 * 1.2, speed.field_1352, speed.field_1351, speed.field_1350));
            }
        }
        for (class_1309 entity : this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(2.0))) {
            if (!ESEntityUtil.shouldHarm(this.method_24921(), (class_1297)entity)) continue;
            if (this.method_24921() instanceof class_1657) {
                entity.field_6008 = 0;
            }
            entity.method_5643(ESDamageTypes.getIndirectEntityDamageSource(this.method_37908(), ESDamageTypes.ENERGIZED_FLAME, (class_1297)this, this.method_24921()), 8.0f);
        }
        this.method_31472();
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_25928(TAG_TARGET)) {
            this.targetId = compoundTag.method_25926(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.method_10550(TAG_SPAWNED_TICKS));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.target != null) {
            compoundTag.method_25927(TAG_TARGET, this.target.method_5667());
        }
        compoundTag.method_10569(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.125f, 10);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        class_243 oldPos = new class_243(this.field_6038, this.field_5971, this.field_5989);
        effect.update(oldPos.method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
        if (this.method_31481()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5019608f, 1.0f, 1.0f, 2.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1921 getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

