/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class EnergySpark
extends class_1682
implements TrailOwner {
    private static final class_2960 TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    public float oSpin;
    public float spin;
    protected static final class_2940<Integer> SPAWNED_TICKS = class_2945.method_12791(EnergySpark.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1309 target;
    @Nullable
    private UUID targetId;

    public int getSpawnedTicks() {
        return (Integer)this.method_5841().method_12789(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.method_5841().method_12778(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    public EnergySpark(class_1299<? extends EnergySpark> entityType, class_1937 level) {
        super(entityType, level);
    }

    public EnergySpark(class_1937 level, class_1309 livingEntity) {
        super(ESEntities.ENERGY_SPARK.get(), livingEntity, level);
    }

    public EnergySpark(class_1937 level, double x, double y, double z) {
        super(ESEntities.ENERGY_SPARK.get(), x, y, z, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SPAWNED_TICKS, (Object)0);
    }

    public class_1309 getTarget() {
        return this.target;
    }

    public void setTarget(class_1309 target) {
        this.targetId = target.method_5667();
        this.target = target;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_243 delta;
            class_243 targetPos;
            class_1937 class_19372;
            if (this.target == null && this.targetId != null && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_1297 class_12972 = serverLevel.method_14190(this.targetId);
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity;
                    this.target = livingEntity = (class_1309)class_12972;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target != null && !this.target.method_5805()) {
                this.target = null;
                this.targetId = null;
            }
            class_243 class_2432 = targetPos = this.method_24921() instanceof class_1657 ? this.method_19538().method_1031((double)this.method_59922().method_43051(-10, 11), (double)this.method_59922().method_43051(-10, 11), (double)this.method_59922().method_43051(-10, 11)) : this.method_19538().method_1019(this.method_18798().method_1029());
            if (this.target != null && (this.method_24921() instanceof class_1657 || this.field_6012 < 80)) {
                targetPos = this.target.method_19538().method_1031(0.0, (double)(this.target.method_17682() / 2.0f), 0.0);
            }
            if (this.getSpawnedTicks() <= 40 && this.field_6012 % 2 == 0 && this.method_24921() instanceof class_1657) {
                delta = new class_243((double)this.method_59922().method_43057() - 0.5, (double)this.method_59922().method_43057() - 0.5, (double)this.method_59922().method_43057() - 0.5);
                double length = this.method_18798().method_1033();
                this.method_18799(this.method_18798().method_1019(delta.method_1029().method_1021(Math.max(length * 0.05, 0.005))).method_1029().method_1021(length));
            }
            if (this.getSpawnedTicks() > 40) {
                delta = targetPos.method_1020(this.method_19538());
                double lengthSqr = delta.method_1027();
                if (lengthSqr < 100.0) {
                    double e = 1.0 - Math.sqrt(lengthSqr) / 10.0;
                    this.method_18799(this.method_18798().method_1019(delta.method_1029().method_1021(e * e * 0.03)));
                } else {
                    this.method_18799(this.method_18798().method_1019(delta.method_1029().method_1021(0.05)));
                }
                if (this.target != null && this.target.method_5829().method_994(this.method_5829())) {
                    this.hurtTarget((class_1297)this.target);
                }
            }
            if (this.getSpawnedTicks() > (this.method_24921() instanceof class_1657 ? 600 : 120)) {
                this.method_31472();
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
        }
        this.oSpin = this.spin;
        this.spin += 0.18849556f * ((float)this.getSpawnedTicks() / 100.0f);
    }

    protected void method_56990() {
    }

    protected void method_24920(class_3965 hitResult) {
        super.method_24920(hitResult);
        switch (hitResult.method_17780().method_10166()) {
            case field_11048: {
                this.method_18799(this.method_18798().method_18805(-1.0, 1.0, 1.0));
                break;
            }
            case field_11052: {
                this.method_18799(this.method_18798().method_18805(1.0, -1.0, 1.0));
                break;
            }
            case field_11051: {
                this.method_18799(this.method_18798().method_18805(1.0, 1.0, -1.0));
            }
        }
    }

    protected void method_7454(class_3966 hitResult) {
        super.method_7454(hitResult);
        this.hurtTarget(hitResult.method_17782());
    }

    private void hurtTarget(class_1297 entity) {
        if ((this.getTarget() == null || entity == this.getTarget()) && entity != this.method_24921()) {
            entity.field_6008 = 0;
            entity.method_5643(ESDamageTypes.getIndirectEntityDamageSource(this.method_37908(), ESDamageTypes.ENERGIZED_FLAME, (class_1297)this, this.method_24921()), 3.0f);
        }
        this.method_31472();
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_25928(TAG_TARGET)) {
            this.targetId = compoundTag.method_25926(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.method_10550(TAG_SPAWNED_TICKS));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.target != null) {
            compoundTag.method_25927(TAG_TARGET, this.target.method_5667());
        }
        compoundTag.method_10569(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.125f, 3);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        class_243 oldPos = new class_243(this.field_6038, this.field_5971, this.field_5989);
        effect.update(oldPos.method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
        if (this.method_31481()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5019608f, 1.0f, 1.0f, 2.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1921 getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

